/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.FuncSpec;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StreamToPig;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.CastUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POCast
extends ExpressionOperator {
    private FuncSpec funcSpec = null;
    private transient LoadCaster caster;
    private transient Log log = LogFactory.getLog(this.getClass());
    private boolean castNotNeeded = false;
    private Byte realType = null;
    private transient List<ExpressionOperator> child;
    private ResourceSchema.ResourceFieldSchema fieldSchema = null;
    private static final long serialVersionUID = 1L;

    public POCast(OperatorKey k) {
        super(k);
    }

    public POCast(OperatorKey k, int rp) {
        super(k, rp);
    }

    private void instantiateFunc() throws IOException {
        if (this.caster != null) {
            return;
        }
        if (this.funcSpec != null) {
            Object obj = PigContext.instantiateFuncFromSpec(this.funcSpec);
            if (obj instanceof LoadFunc) {
                this.caster = ((LoadFunc)obj).getLoadCaster();
            } else if (obj instanceof StreamToPig) {
                this.caster = ((StreamToPig)obj).getLoadCaster();
            } else {
                throw new IOException("Invalid class type " + this.funcSpec.getClassName());
            }
        }
    }

    public void setFuncSpec(FuncSpec lf) throws IOException {
        this.funcSpec = lf;
        this.instantiateFunc();
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitCast(this);
    }

    @Override
    public String name() {
        if (this.resultType == 120 || this.resultType == 110) {
            return "Cast[" + DataType.findTypeName(this.resultType) + ":" + this.fieldSchema.calcCastString() + "]" + " - " + this.mKey.toString();
        }
        return "Cast[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public Result getNext(Integer i) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 120: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 110: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus == 0 && res.result != null) {
                    try {
                        dba = (DataByteArray)res.result;
                    }
                    catch (ClassCastException e) {
                        if (this.realType == null) {
                            this.realType = DataType.findType(res.result);
                        }
                        try {
                            res.result = DataType.toInteger(res.result, this.realType);
                        }
                        catch (ClassCastException cce) {
                            this.realType = DataType.findType(res.result);
                            res.result = DataType.toInteger(res.result, this.realType);
                        }
                        return res;
                    }
                    try {
                        if (null == this.caster) {
                            int errCode = 1075;
                            String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to int.";
                            throw new ExecException(msg, errCode, 2);
                        }
                        res.result = this.caster.bytesToInteger(dba.get());
                    }
                    catch (ExecException ee) {
                        throw ee;
                    }
                    catch (IOException e) {
                        this.log.error((Object)"Error while casting from ByteArray to Integer");
                    }
                }
                return res;
            }
            case 100: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 5: {
                Boolean b = null;
                Result res = in.getNext(b);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = (Boolean)res.result == true ? Integer.valueOf(1) : Integer.valueOf(0);
                }
                return res;
            }
            case 10: {
                Result res = in.getNext(i);
                return res;
            }
            case 25: {
                Double d = null;
                Result res = in.getNext(d);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Double)res.result).intValue();
                }
                return res;
            }
            case 15: {
                Long l = null;
                Result res = in.getNext(l);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Long)res.result).intValue();
                }
                return res;
            }
            case 20: {
                Float f = null;
                Result res = in.getNext(f);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Float)res.result).intValue();
                }
                return res;
            }
            case 55: {
                String str = null;
                Result res = in.getNext(str);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = CastUtils.stringToInteger((String)res.result);
                }
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    @Override
    public Result getNext(Long l) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 120: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 110: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 100: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus == 0 && res.result != null) {
                    try {
                        dba = (DataByteArray)res.result;
                    }
                    catch (ClassCastException e) {
                        if (this.realType == null) {
                            this.realType = DataType.findType(res.result);
                        }
                        try {
                            res.result = DataType.toLong(res.result, this.realType);
                        }
                        catch (ClassCastException cce) {
                            this.realType = DataType.findType(res.result);
                            res.result = DataType.toLong(res.result, this.realType);
                        }
                        return res;
                    }
                    try {
                        if (null == this.caster) {
                            int errCode = 1075;
                            String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to long.";
                            throw new ExecException(msg, errCode, 2);
                        }
                        res.result = this.caster.bytesToLong(dba.get());
                    }
                    catch (ExecException ee) {
                        throw ee;
                    }
                    catch (IOException e) {
                        this.log.error((Object)"Error while casting from ByteArray to Long");
                    }
                }
                return res;
            }
            case 5: {
                Boolean b = null;
                Result res = in.getNext(b);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = (Boolean)res.result == true ? Long.valueOf(1L) : Long.valueOf(0L);
                }
                return res;
            }
            case 10: {
                Integer dummyI = null;
                Result res = in.getNext(dummyI);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Integer)res.result).longValue();
                }
                return res;
            }
            case 25: {
                Double d = null;
                Result res = in.getNext(d);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Double)res.result).longValue();
                }
                return res;
            }
            case 15: {
                Result res = in.getNext(l);
                return res;
            }
            case 20: {
                Float f = null;
                Result res = in.getNext(f);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Float)res.result).longValue();
                }
                return res;
            }
            case 55: {
                String str = null;
                Result res = in.getNext(str);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = CastUtils.stringToLong((String)res.result);
                }
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    @Override
    public Result getNext(Double d) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 120: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 110: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 100: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus == 0 && res.result != null) {
                    try {
                        dba = (DataByteArray)res.result;
                    }
                    catch (ClassCastException e) {
                        if (this.realType == null) {
                            this.realType = DataType.findType(res.result);
                        }
                        try {
                            res.result = DataType.toDouble(res.result, this.realType);
                        }
                        catch (ClassCastException cce) {
                            this.realType = DataType.findType(res.result);
                            res.result = DataType.toDouble(res.result, this.realType);
                        }
                        return res;
                    }
                    try {
                        if (null == this.caster) {
                            int errCode = 1075;
                            String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to double.";
                            throw new ExecException(msg, errCode, 2);
                        }
                        res.result = this.caster.bytesToDouble(dba.get());
                    }
                    catch (ExecException ee) {
                        throw ee;
                    }
                    catch (IOException e) {
                        this.log.error((Object)"Error while casting from ByteArray to Double");
                    }
                }
                return res;
            }
            case 5: {
                Boolean b = null;
                Result res = in.getNext(b);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = (Boolean)res.result == true ? new Double(1.0) : new Double(0.0);
                }
                return res;
            }
            case 10: {
                Integer dummyI = null;
                Result res = in.getNext(dummyI);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = new Double(((Integer)res.result).doubleValue());
                }
                return res;
            }
            case 25: {
                Result res = in.getNext(d);
                return res;
            }
            case 15: {
                Long l = null;
                Result res = in.getNext(l);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = new Double(((Long)res.result).doubleValue());
                }
                return res;
            }
            case 20: {
                Float f = null;
                Result res = in.getNext(f);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = new Double(((Float)res.result).doubleValue());
                }
                return res;
            }
            case 55: {
                String str = null;
                Result res = in.getNext(str);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = CastUtils.stringToDouble((String)res.result);
                }
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    @Override
    public Result getNext(Float f) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 120: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 110: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 100: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus == 0 && res.result != null) {
                    try {
                        dba = (DataByteArray)res.result;
                    }
                    catch (ClassCastException e) {
                        if (this.realType == null) {
                            this.realType = DataType.findType(res.result);
                        }
                        try {
                            res.result = DataType.toFloat(res.result, this.realType);
                        }
                        catch (ClassCastException cce) {
                            this.realType = DataType.findType(res.result);
                            res.result = DataType.toFloat(res.result, this.realType);
                        }
                        return res;
                    }
                    try {
                        if (null == this.caster) {
                            int errCode = 1075;
                            String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to float.";
                            throw new ExecException(msg, errCode, 2);
                        }
                        res.result = this.caster.bytesToFloat(dba.get());
                    }
                    catch (ExecException ee) {
                        throw ee;
                    }
                    catch (IOException e) {
                        this.log.error((Object)"Error while casting from ByteArray to Float");
                    }
                }
                return res;
            }
            case 5: {
                Boolean b = null;
                Result res = in.getNext(b);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = (Boolean)res.result == true ? new Float(1.0f) : new Float(0.0f);
                }
                return res;
            }
            case 10: {
                Integer dummyI = null;
                Result res = in.getNext(dummyI);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = new Float(((Integer)res.result).floatValue());
                }
                return res;
            }
            case 25: {
                Double d = null;
                Result res = in.getNext(d);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = new Float(((Double)res.result).floatValue());
                }
                return res;
            }
            case 15: {
                Long l = null;
                Result res = in.getNext(l);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = new Float(((Long)res.result).floatValue());
                }
                return res;
            }
            case 20: {
                Result res = in.getNext(f);
                return res;
            }
            case 55: {
                String str = null;
                Result res = in.getNext(str);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = CastUtils.stringToFloat((String)res.result);
                }
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    @Override
    public Result getNext(String str) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 120: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 110: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 100: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus == 0 && res.result != null) {
                    try {
                        dba = (DataByteArray)res.result;
                    }
                    catch (ClassCastException e) {
                        if (this.realType == null) {
                            this.realType = DataType.findType(res.result);
                        }
                        try {
                            res.result = DataType.toString(res.result, this.realType);
                        }
                        catch (ClassCastException cce) {
                            this.realType = DataType.findType(res.result);
                            res.result = DataType.toString(res.result, this.realType);
                        }
                        return res;
                    }
                    try {
                        if (null == this.caster) {
                            int errCode = 1075;
                            String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to string.";
                            throw new ExecException(msg, errCode, 2);
                        }
                        res.result = this.caster.bytesToCharArray(dba.get());
                    }
                    catch (ExecException ee) {
                        throw ee;
                    }
                    catch (IOException e) {
                        this.log.error((Object)"Error while casting from ByteArray to CharArray");
                    }
                }
                return res;
            }
            case 5: {
                Boolean b = null;
                Result res = in.getNext(b);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = (Boolean)res.result == true ? "1" : "0";
                }
                return res;
            }
            case 10: {
                Integer dummyI = null;
                Result res = in.getNext(dummyI);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Integer)res.result).toString();
                }
                return res;
            }
            case 25: {
                Double d = null;
                Result res = in.getNext(d);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Double)res.result).toString();
                }
                return res;
            }
            case 15: {
                Long l = null;
                Result res = in.getNext(l);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Long)res.result).toString();
                }
                return res;
            }
            case 20: {
                Float f = null;
                Result res = in.getNext(f);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Float)res.result).toString();
                }
                return res;
            }
            case 55: {
                Result res = in.getNext(str);
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte castToType = 110;
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 110: {
                Result res = in.getNext(t);
                return res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus == 0 && res.result != null) {
                    if (this.castNotNeeded) {
                        return res;
                    }
                    try {
                        dba = (DataByteArray)res.result;
                    }
                    catch (ClassCastException e) {
                        if (DataType.findType(res.result) == castToType) {
                            this.castNotNeeded = true;
                            return res;
                        }
                        int errCode = 1081;
                        String msg = "Cannot cast to tuple. Expected bytearray but received: " + DataType.findTypeName(res.result);
                        throw new ExecException(msg, errCode, 2, e);
                    }
                    try {
                        if (null == this.caster) {
                            int errCode = 1075;
                            String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to tuple.";
                            throw new ExecException(msg, errCode, 2);
                        }
                        res.result = this.caster.bytesToTuple(dba.get(), this.fieldSchema);
                    }
                    catch (ExecException ee) {
                        throw ee;
                    }
                    catch (IOException e) {
                        this.log.error((Object)"Error while casting from ByteArray to Tuple");
                    }
                }
                return res;
            }
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 55: 
            case 100: 
            case 120: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    @Override
    public Result getNext(DataBag bag) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte castToType = 120;
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 120: {
                Result res = in.getNext(bag);
                return res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus == 0 && res.result != null) {
                    if (this.castNotNeeded) {
                        return res;
                    }
                    try {
                        dba = (DataByteArray)res.result;
                    }
                    catch (ClassCastException e) {
                        if (DataType.findType(res.result) == castToType) {
                            this.castNotNeeded = true;
                            return res;
                        }
                        int errCode = 1081;
                        String msg = "Cannot cast to bag. Expected bytearray but received: " + DataType.findTypeName(res.result);
                        throw new ExecException(msg, errCode, 2, e);
                    }
                    try {
                        if (null == this.caster) {
                            int errCode = 1075;
                            String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to bag.";
                            throw new ExecException(msg, errCode, 2);
                        }
                        res.result = this.caster.bytesToBag(dba.get(), this.fieldSchema);
                    }
                    catch (ExecException ee) {
                        throw ee;
                    }
                    catch (IOException e) {
                        this.log.error((Object)"Error while casting from ByteArray to DataBag");
                    }
                }
                return res;
            }
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 55: 
            case 100: 
            case 110: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    @Override
    public Result getNext(Map m) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte castToType = 100;
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 100: {
                Result res = in.getNext(m);
                return res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus == 0 && res.result != null) {
                    if (this.castNotNeeded) {
                        return res;
                    }
                    try {
                        dba = (DataByteArray)res.result;
                    }
                    catch (ClassCastException e) {
                        if (DataType.findType(res.result) == castToType) {
                            this.castNotNeeded = true;
                            return res;
                        }
                        int errCode = 1081;
                        String msg = "Cannot cast to map. Expected bytearray but received: " + DataType.findTypeName(res.result);
                        throw new ExecException(msg, errCode, 2, e);
                    }
                    try {
                        if (null == this.caster) {
                            int errCode = 1075;
                            String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to map.";
                            throw new ExecException(msg, errCode, 2);
                        }
                        res.result = this.caster.bytesToMap(dba.get());
                    }
                    catch (ExecException ee) {
                        throw ee;
                    }
                    catch (IOException e) {
                        this.log.error((Object)"Error while casting from ByteArray to Map");
                    }
                }
                return res;
            }
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 55: 
            case 110: 
            case 120: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.instantiateFunc();
    }

    @Override
    public POCast clone() throws CloneNotSupportedException {
        POCast clone = new POCast(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        clone.funcSpec = this.funcSpec;
        clone.fieldSchema = this.fieldSchema;
        try {
            clone.instantiateFunc();
        }
        catch (IOException e) {
            CloneNotSupportedException cnse = new CloneNotSupportedException();
            cnse.initCause(e);
            throw cnse;
        }
        return clone;
    }

    @Override
    public List<ExpressionOperator> getChildExpressions() {
        if (this.child == null) {
            this.child = new ArrayList<ExpressionOperator>();
            if (this.inputs.get(0) instanceof ExpressionOperator) {
                this.child.add((ExpressionOperator)this.inputs.get(0));
            }
        }
        return this.child;
    }

    public void setFieldSchema(ResourceSchema.ResourceFieldSchema s) {
        this.fieldSchema = s;
    }

    public FuncSpec getFuncSpec() {
        return this.funcSpec;
    }
}

