/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pig.PigWarning;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.SingleTupleBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POProject
extends ExpressionOperator {
    private static final long serialVersionUID = 1L;
    private static TupleFactory tupleFactory = TupleFactory.getInstance();
    protected static final BagFactory bagFactory = BagFactory.getInstance();
    private boolean resultSingleTupleBag = false;
    protected ArrayList<Integer> columns;
    boolean processingBagOfTuples = false;
    transient Iterator<Tuple> bagIterator = null;
    boolean overloaded = false;
    boolean star = false;

    public POProject(OperatorKey k) {
        this(k, -1, 0);
    }

    public POProject(OperatorKey k, int rp) {
        this(k, rp, 0);
    }

    public POProject(OperatorKey k, int rp, int col) {
        super(k, rp);
        this.columns = new ArrayList();
        this.columns.add(col);
    }

    public POProject(OperatorKey k, int rp, ArrayList<Integer> cols) {
        super(k, rp);
        this.columns = cols;
    }

    @Override
    public String name() {
        return "Project[" + DataType.findTypeName(this.resultType) + "]" + (this.star ? "[*]" : this.columns) + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitProject(this);
    }

    @Override
    public void attachInput(Tuple t) {
        super.attachInput(t);
        this.processingBagOfTuples = false;
    }

    public Result getNext() throws ExecException {
        Object ret;
        Result res = this.processInput();
        Tuple inpValue = (Tuple)res.result;
        if (res.returnStatus != 0) {
            return res;
        }
        if (this.star) {
            return res;
        }
        if (this.columns.size() == 1) {
            try {
                ret = inpValue.get(this.columns.get(0));
            }
            catch (IndexOutOfBoundsException ie) {
                if (pigLogger != null) {
                    pigLogger.warn(this, "Attempt to access field which was not found in the input", PigWarning.ACCESSING_NON_EXISTENT_FIELD);
                }
                res.returnStatus = 0;
                ret = null;
            }
            catch (NullPointerException npe) {
                res.returnStatus = 0;
                ret = null;
            }
        } else {
            ArrayList<Object> objList = new ArrayList<Object>(this.columns.size());
            for (int i : this.columns) {
                try {
                    objList.add(inpValue.get(i));
                }
                catch (IndexOutOfBoundsException ie) {
                    if (pigLogger != null) {
                        pigLogger.warn(this, "Attempt to access field " + i + " which was not found in the input", PigWarning.ACCESSING_NON_EXISTENT_FIELD);
                    }
                    objList.add(null);
                }
                catch (NullPointerException npe) {
                    objList.add(null);
                }
            }
            ret = tupleFactory.newTuple(objList);
        }
        res.result = ret;
        return res;
    }

    @Override
    public Result getNext(DataBag db) throws ExecException {
        Result res = this.processInputBag();
        if (res.returnStatus != 0) {
            return res;
        }
        return this.consumeInputBag(res);
    }

    protected Result consumeInputBag(Result input) throws ExecException {
        if (this.isInputAttached() || this.isStar()) {
            Result retVal = new Result();
            retVal.result = input.result;
            retVal.returnStatus = 0;
            this.detachInput();
            return retVal;
        }
        if (input.result instanceof DataBag) {
            DataBag outBag;
            DataBag inpBag = (DataBag)input.result;
            Result retVal = new Result();
            if (this.resultSingleTupleBag) {
                Tuple tuple = inpBag.iterator().next();
                Tuple tmpTuple = tupleFactory.newTuple(this.columns.size());
                for (int i = 0; i < this.columns.size(); ++i) {
                    try {
                        tmpTuple.set(i, tuple.get(this.columns.get(i)));
                        continue;
                    }
                    catch (IndexOutOfBoundsException ie) {
                        if (pigLogger != null) {
                            pigLogger.warn(this, "Attempt to access field which was not found in the input", PigWarning.ACCESSING_NON_EXISTENT_FIELD);
                        }
                        tmpTuple.set(i, null);
                        continue;
                    }
                    catch (NullPointerException npe) {
                        tmpTuple.set(i, null);
                    }
                }
                outBag = new SingleTupleBag(tmpTuple);
            } else {
                outBag = bagFactory.newDefaultBag();
                for (Tuple tuple : inpBag) {
                    Tuple tmpTuple = tupleFactory.newTuple(this.columns.size());
                    for (int i = 0; i < this.columns.size(); ++i) {
                        try {
                            tmpTuple.set(i, tuple.get(this.columns.get(i)));
                            continue;
                        }
                        catch (IndexOutOfBoundsException ie) {
                            if (pigLogger != null) {
                                pigLogger.warn(this, "Attempt to access field which was not found in the input", PigWarning.ACCESSING_NON_EXISTENT_FIELD);
                            }
                            tmpTuple.set(i, null);
                            continue;
                        }
                        catch (NullPointerException npe) {
                            tmpTuple.set(i, null);
                        }
                    }
                    outBag.add(tmpTuple);
                }
            }
            retVal.result = outBag;
            retVal.returnStatus = 0;
            return retVal;
        }
        if (input.result instanceof Tuple) {
            Result retVal = new Result();
            retVal.result = ((Tuple)input.result).get(this.columns.get(0));
            retVal.returnStatus = 0;
            return retVal;
        }
        if (input.result == null) {
            Result retVal = new Result();
            retVal.result = null;
            retVal.returnStatus = 1;
            return retVal;
        }
        throw new ExecException("Cannot dereference a bag from " + input.result.getClass().getName(), 1129);
    }

    @Override
    public Result getNext(DataByteArray ba) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(Double d) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(Float f) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(Integer i) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(Long l) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(Boolean b) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(Map m) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(String s) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        Result res = new Result();
        if (!this.processingBagOfTuples) {
            Object ret;
            Tuple inpValue = null;
            res = this.processInput();
            if (res.returnStatus != 0) {
                return res;
            }
            if (this.star) {
                return res;
            }
            inpValue = (Tuple)res.result;
            res.result = null;
            if (this.columns.size() == 1) {
                try {
                    ret = inpValue.get(this.columns.get(0));
                }
                catch (IndexOutOfBoundsException ie) {
                    if (pigLogger != null) {
                        pigLogger.warn(this, "Attempt to access field which was not found in the input", PigWarning.ACCESSING_NON_EXISTENT_FIELD);
                    }
                    ret = null;
                }
                catch (NullPointerException npe) {
                    ret = null;
                }
            } else {
                ArrayList<Object> objList = new ArrayList<Object>(this.columns.size());
                for (int i : this.columns) {
                    try {
                        objList.add(inpValue.get(i));
                    }
                    catch (IndexOutOfBoundsException ie) {
                        if (pigLogger != null) {
                            pigLogger.warn(this, "Attempt to access field which was not found in the input", PigWarning.ACCESSING_NON_EXISTENT_FIELD);
                        }
                        objList.add(null);
                    }
                    catch (NullPointerException npe) {
                        objList.add(null);
                    }
                }
                Tuple ret2 = tupleFactory.newTuple(objList);
                res.result = ret2;
                return res;
            }
            if (this.overloaded) {
                DataBag retBag = (DataBag)ret;
                this.bagIterator = retBag.iterator();
                if (this.bagIterator.hasNext()) {
                    this.processingBagOfTuples = true;
                    res.result = this.bagIterator.next();
                }
                if (!this.processingBagOfTuples) {
                    res.returnStatus = (byte)3;
                }
            } else {
                res.result = (Tuple)ret;
            }
            return res;
        }
        if (this.bagIterator.hasNext()) {
            res.result = this.bagIterator.next();
            res.returnStatus = 0;
            return res;
        }
        this.processingBagOfTuples = false;
        return this.getNext(t);
    }

    public ArrayList<Integer> getColumns() {
        return this.columns;
    }

    public int getColumn() throws ExecException {
        if (this.columns.size() != 1) {
            int errCode = 2068;
            String msg = "Internal error. Improper use of method getColumn() in " + POProject.class.getSimpleName();
            throw new ExecException(msg, errCode, 4);
        }
        return this.columns.get(0);
    }

    public void setColumns(ArrayList<Integer> cols) {
        this.columns = cols;
    }

    public void setColumn(int col) {
        if (null == this.columns) {
            this.columns = new ArrayList();
        } else {
            this.columns.clear();
        }
        this.columns.add(col);
    }

    public boolean isOverloaded() {
        return this.overloaded;
    }

    public void setOverloaded(boolean overloaded) {
        this.overloaded = overloaded;
    }

    public boolean isStar() {
        return this.star;
    }

    public void setStar(boolean star) {
        this.star = star;
    }

    @Override
    public POProject clone() throws CloneNotSupportedException {
        ArrayList<Integer> cols = new ArrayList<Integer>(this.columns.size());
        for (Integer i : this.columns) {
            cols.add(i);
        }
        POProject clone = new POProject(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)), this.requestedParallelism, cols);
        clone.cloneHelper(this);
        clone.star = this.star;
        clone.overloaded = this.overloaded;
        return clone;
    }

    protected Result processInputBag() throws ExecException {
        Result res = new Result();
        if (this.input == null && (this.inputs == null || this.inputs.size() == 0)) {
            res.returnStatus = (byte)3;
            return res;
        }
        if (reporter != null) {
            reporter.progress();
        }
        if (!this.isInputAttached()) {
            if (((PhysicalOperator)this.inputs.get(0)).getResultType() == 120) {
                return ((PhysicalOperator)this.inputs.get(0)).getNext(dummyBag);
            }
            return ((PhysicalOperator)this.inputs.get(0)).getNext(dummyTuple);
        }
        res.result = (DataBag)this.input.get(this.columns.get(0));
        res.returnStatus = 0;
        return res;
    }

    public void setResultSingleTupleBag(boolean resultSingleTupleBag) {
        this.resultSingleTupleBag = resultSingleTupleBag;
    }

    @Override
    public List<ExpressionOperator> getChildExpressions() {
        return null;
    }
}

