/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POOptimizedForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.InternalCachedBag;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POJoinPackage
extends POPackage {
    private static final long serialVersionUID = 1L;
    private POOptimizedForEach forEach;
    private boolean newKey = true;
    private Tuple res = null;
    private boolean lastInputTuple = false;
    private static final Tuple t1 = null;
    private static final Result eopResult = new Result(3, null);
    private boolean firstTime = true;
    private boolean useDefaultBag = false;
    public static final String DEFAULT_CHUNK_SIZE = "1000";
    private long chunkSize = Long.parseLong("1000");
    private Result forEachResult;
    private DataBag[] dbs = null;
    private int lastBagIndex;

    public POJoinPackage(OperatorKey k, int rp, POPackage p, POForEach f) {
        super(k, rp);
        String scope = this.getOperatorKey().getScope();
        NodeIdGenerator nig = NodeIdGenerator.getGenerator();
        this.forEach = new POOptimizedForEach(new OperatorKey(scope, nig.getNextNodeId(scope)));
        if (p != null) {
            this.setKeyType(p.getKeyType());
            this.setNumInps(p.getNumInps());
            this.lastBagIndex = this.numInputs - 1;
            this.setInner(p.getInner());
            this.setKeyInfo(p.getKeyInfo());
            this.isKeyTuple = p.isKeyTuple;
        }
        if (f != null) {
            this.setInputPlans(f.getInputPlans());
            this.setToBeFlattened(f.getToBeFlattened());
        }
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitJoinPackage(this);
    }

    @Override
    public String name() {
        String fString = this.forEach.getFlatStr();
        return "POJoinPackage(" + fString + ")" + "[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        Result forEachResult;
        if (this.firstTime) {
            String bagType;
            this.firstTime = false;
            if (PigMapReduce.sJobConfInternal.get() != null && (bagType = PigMapReduce.sJobConfInternal.get().get("pig.cachedbag.type")) != null && bagType.equalsIgnoreCase("default")) {
                this.useDefaultBag = true;
            }
        }
        if (this.forEach.processingPlan) {
            this.forEachResult = this.forEach.getNext(t1);
            switch (this.forEachResult.returnStatus) {
                case 0: 
                case 1: 
                case 2: {
                    return this.forEachResult;
                }
            }
        }
        NullableTuple it = null;
        if (this.newKey) {
            int i;
            this.lastInputTuple = false;
            this.dbs = new DataBag[this.numInputs];
            for (i = 0; i < this.numInputs - 1; ++i) {
                this.dbs[i] = this.useDefaultBag ? BagFactory.getInstance().newDefaultBag() : new InternalCachedBag(this.numInputs - 1);
            }
            this.dbs[this.lastBagIndex] = new NonSpillableDataBag((int)this.chunkSize);
            while (this.tupIter.hasNext()) {
                it = (NullableTuple)this.tupIter.next();
                byte itIndex = it.getIndex();
                if (itIndex == this.numInputs - 1) {
                    this.lastInputTuple = true;
                    break;
                }
                this.dbs[itIndex].add(this.getValueTuple(it, itIndex));
                if (reporter == null) continue;
                reporter.progress();
            }
            if (!this.lastInputTuple) {
                this.newKey = true;
                return eopResult;
            }
            this.res = mTupleFactory.newTuple(this.numInputs + 1);
            for (i = 0; i < this.dbs.length; ++i) {
                this.res.set(i + 1, this.dbs[i]);
            }
            this.res.set(0, this.key);
            for (i = 0; i < this.dbs.length - 1; ++i) {
                if (!this.inner[i] || this.dbs[i].size() != 0L) continue;
                this.detachInput();
                return eopResult;
            }
            this.newKey = false;
            this.dbs[this.lastBagIndex].add(this.getValueTuple(it, it.getIndex()));
            i = 0;
            while ((long)i < this.chunkSize - 1L && this.tupIter.hasNext()) {
                it = (NullableTuple)this.tupIter.next();
                this.dbs[this.lastBagIndex].add(this.getValueTuple(it, it.getIndex()));
                ++i;
            }
            this.forEach.attachInput(this.res);
            forEachResult = this.forEach.getNext(t1);
            switch (forEachResult.returnStatus) {
                case 0: 
                case 1: 
                case 2: {
                    return forEachResult;
                }
            }
        }
        while (true) {
            if (this.tupIter.hasNext()) {
                this.dbs[this.lastBagIndex].clear();
                int i = 0;
                while ((long)i < this.chunkSize && this.tupIter.hasNext()) {
                    it = (NullableTuple)this.tupIter.next();
                    this.dbs[this.lastBagIndex].add(this.getValueTuple(it, it.getIndex()));
                    ++i;
                }
            } else {
                this.detachInput();
                this.newKey = true;
                return eopResult;
            }
            this.forEach.attachInput(this.res);
            forEachResult = this.forEach.getNext(t1);
            switch (forEachResult.returnStatus) {
                case 0: 
                case 1: 
                case 2: {
                    return forEachResult;
                }
            }
        }
    }

    public List<PhysicalPlan> getInputPlans() {
        return this.forEach.getInputPlans();
    }

    public void setInputPlans(List<PhysicalPlan> plans) {
        this.forEach.setInputPlans(plans);
    }

    public void setToBeFlattened(List<Boolean> flattens) {
        this.forEach.setToBeFlattened(flattens);
    }

    public POOptimizedForEach getForEach() {
        return this.forEach;
    }

    public void setChunkSize(long chunkSize) {
        this.chunkSize = chunkSize;
    }
}

