/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.BitSet;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.util.ExampleTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POUnion
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    BitSet done;
    boolean nextReturnEOP = false;
    private static Result eopResult = new Result(3, null);
    int lastInd = 0;

    public POUnion(OperatorKey k) {
        this(k, -1, null);
    }

    public POUnion(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POUnion(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public POUnion(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    @Override
    public void setInputs(List<PhysicalOperator> inputs) {
        super.setInputs(inputs);
        this.done = inputs != null ? new BitSet(inputs.size()) : new BitSet(0);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitUnion(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "Union" + "[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    public void clearDone() {
        this.done.clear();
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        if (this.nextReturnEOP) {
            this.nextReturnEOP = false;
            return eopResult;
        }
        if (!this.isInputAttached()) {
            if (this.inputs == null || this.inputs.size() == 0) {
                return eopResult;
            }
            while (true) {
                Result res;
                if (this.done.nextClearBit(0) >= this.inputs.size()) {
                    this.clearDone();
                    return eopResult;
                }
                if (this.lastInd >= this.inputs.size() || this.done.nextClearBit(this.lastInd) >= this.inputs.size()) {
                    this.lastInd = 0;
                }
                int ind = this.done.nextClearBit(this.lastInd);
                do {
                    if (reporter != null) {
                        reporter.progress();
                    }
                    res = ((PhysicalOperator)this.inputs.get(ind)).getNext(t);
                    this.lastInd = ind + 1;
                    if (res.returnStatus != 0 && res.returnStatus != 1 && res.returnStatus != 2) continue;
                    return res;
                } while (res.returnStatus != 3);
                this.done.set(ind);
            }
        }
        this.res.result = this.input;
        this.res.returnStatus = 0;
        this.detachInput();
        this.nextReturnEOP = true;
        if (this.lineageTracer != null) {
            ExampleTuple tOut = (ExampleTuple)this.res.result;
            this.lineageTracer.insert(tOut);
            this.lineageTracer.union(tOut, tOut);
        }
        return this.res;
    }
}

