/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoker<T> {
    private static final Log LOG = LogFactory.getLog(Invoker.class);
    private static final Class<?> DOUBLE_ARRAY_CLASS = new double[0].getClass();
    private static final Class<?> INT_ARRAY_CLASS = new int[0].getClass();
    private static final Class<?> FLOAT_ARRAY_CLASS = new float[0].getClass();
    private static final Class<?> STRING_ARRAY_CLASS = new String[0].getClass();
    private static final Class<?> LONG_ARRAY_CLASS = new long[0].getClass();
    private static final Set<Class<?>> ARRAY_CLASSES = Sets.newHashSet((Object[])new Class[]{DOUBLE_ARRAY_CLASS, INT_ARRAY_CLASS, FLOAT_ARRAY_CLASS, STRING_ARRAY_CLASS, LONG_ARRAY_CLASS});
    private Method method_;
    private Class<?>[] paramClasses_;
    private boolean isStatic_;
    private Class<?> selfClass_;
    private Type returnType_;

    public Invoker(String fullName, String paramSpecsStr) throws ClassNotFoundException, FrontendException, SecurityException, NoSuchMethodException {
        this(fullName, paramSpecsStr, "true");
    }

    public Invoker(String fullName, String paramSpecsStr, String isStatic) throws ClassNotFoundException, FrontendException, SecurityException, NoSuchMethodException {
        String className = fullName.substring(0, fullName.lastIndexOf(46));
        String methodName = fullName.substring(fullName.lastIndexOf(46) + 1);
        Class<?> klazz = Class.forName(className);
        String[] paramSpecs = "".equals(paramSpecsStr) ? new String[]{} : paramSpecsStr.split(" ");
        this.isStatic_ = "static".equalsIgnoreCase(isStatic) || "true".equals(isStatic);
        this.paramClasses_ = new Class[paramSpecs.length];
        for (int i = 0; i < paramSpecs.length; ++i) {
            this.paramClasses_[i] = Invoker.stringToClass(paramSpecs[i]);
        }
        if (!this.isStatic_) {
            this.selfClass_ = this.paramClasses_[0];
        }
        this.method_ = klazz.getMethod(methodName, this.isStatic_ ? this.paramClasses_ : Invoker.dropFirstClass(this.paramClasses_));
        this.returnType_ = this.method_.getGenericReturnType();
    }

    public Type getReturnType() {
        return Invoker.unPrimitivize((Class)this.returnType_);
    }

    private static Class<?>[] dropFirstClass(Class<?>[] original) {
        if (original.length < 2) {
            return new Class[0];
        }
        return Arrays.copyOfRange(original, 1, original.length - 1);
    }

    private static Object[] dropFirstObject(Object[] original) {
        if (original.length < 2) {
            return new Object[0];
        }
        return Arrays.copyOfRange(original, 1, original.length - 1);
    }

    private static Class<?> stringToClass(String klass) throws FrontendException {
        if ("string".equalsIgnoreCase(klass)) {
            return String.class;
        }
        if ("int".equalsIgnoreCase(klass)) {
            return Integer.TYPE;
        }
        if ("double".equalsIgnoreCase(klass)) {
            return Double.TYPE;
        }
        if ("float".equalsIgnoreCase(klass)) {
            return Float.TYPE;
        }
        if ("long".equalsIgnoreCase(klass)) {
            return Long.TYPE;
        }
        if ("double[]".equalsIgnoreCase(klass)) {
            return DOUBLE_ARRAY_CLASS;
        }
        if ("int[]".equalsIgnoreCase(klass)) {
            return INT_ARRAY_CLASS;
        }
        if ("long[]".equalsIgnoreCase(klass)) {
            return LONG_ARRAY_CLASS;
        }
        if ("float[]".equalsIgnoreCase(klass)) {
            return FLOAT_ARRAY_CLASS;
        }
        if ("string[]".equalsIgnoreCase(klass)) {
            return STRING_ARRAY_CLASS;
        }
        throw new FrontendException("unable to find matching class for " + klass);
    }

    private static Class<?> unPrimitivize(Class<?> klass) {
        if (klass.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (klass.equals(Long.TYPE)) {
            return Long.class;
        }
        if (klass.equals(Float.TYPE)) {
            return Float.class;
        }
        if (klass.equals(Double.TYPE)) {
            return Double.class;
        }
        return klass;
    }

    private static <T> T convertToExpectedArg(Class<T> klass, Object obj) throws ExecException {
        if (ARRAY_CLASSES.contains(klass)) {
            DataBag dbag = (DataBag)obj;
            if (STRING_ARRAY_CLASS.equals(klass)) {
                ArrayList dataList = Lists.newArrayList();
                for (Tuple t : dbag) {
                    dataList.add((String)t.get(0));
                }
                String[] dataArray = new String[dataList.size()];
                for (int i = 0; i < dataList.size(); ++i) {
                    dataArray[i] = (String)dataList.get(i);
                }
                obj = dataArray;
            } else {
                List<Number> dataList = Invoker.bagToNumberList(dbag);
                if (DOUBLE_ARRAY_CLASS.equals(klass)) {
                    double[] dataArray = new double[dataList.size()];
                    for (int i = 0; i < dataList.size(); ++i) {
                        dataArray[i] = dataList.get(i).doubleValue();
                    }
                    obj = dataArray;
                } else if (INT_ARRAY_CLASS.equals(klass)) {
                    int[] dataArray = new int[dataList.size()];
                    for (int i = 0; i < dataList.size(); ++i) {
                        dataArray[i] = dataList.get(i).intValue();
                    }
                    obj = dataArray;
                } else if (FLOAT_ARRAY_CLASS.equals(klass)) {
                    float[] dataArray = new float[dataList.size()];
                    for (int i = 0; i < dataList.size(); ++i) {
                        dataArray[i] = dataList.get(i).floatValue();
                    }
                    obj = dataArray;
                } else if (LONG_ARRAY_CLASS.equals(klass)) {
                    long[] dataArray = new long[dataList.size()];
                    for (int i = 0; i < dataList.size(); ++i) {
                        dataArray[i] = dataList.get(i).longValue();
                    }
                    obj = dataArray;
                }
            }
        }
        try {
            return klass.cast(obj);
        }
        catch (ClassCastException e) {
            LOG.error((Object)("Error in dynamic argument processing. Casting to: " + klass + " from: " + obj.getClass()), (Throwable)e);
            throw new ExecException(e);
        }
    }

    private static List<Number> bagToNumberList(DataBag dbag) throws ExecException {
        ArrayList dataList = Lists.newArrayList();
        for (Tuple t : dbag) {
            dataList.add((Number)t.get(0));
        }
        return dataList;
    }

    private Object[] tupleToArgs(Tuple t) throws ExecException {
        if (t == null && (this.paramClasses_ != null || this.paramClasses_.length != 0) || t != null && t.size() < this.paramClasses_.length) {
            throw new ExecException("unable to match function arguments to declared signature.");
        }
        if (t == null) {
            return null;
        }
        Object[] args = new Object[this.paramClasses_.length];
        for (int i = 0; i < this.paramClasses_.length; ++i) {
            args[i] = Invoker.convertToExpectedArg(Invoker.unPrimitivize(this.paramClasses_[i]), t.get(i));
        }
        return args;
    }

    public T invoke(Tuple input) throws IOException {
        Object[] args = this.tupleToArgs(input);
        try {
            if (!this.isStatic_) {
                return (T)this.method_.invoke(this.selfClass_.cast(args[0]), Invoker.dropFirstObject(args));
            }
            return (T)this.method_.invoke(null, args);
        }
        catch (IllegalArgumentException e) {
            throw new ExecException(e);
        }
        catch (IllegalAccessException e) {
            throw new ExecException(e);
        }
        catch (InvocationTargetException e) {
            throw new ExecException(e);
        }
    }
}

