/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.builtin;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.EvalFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.InterStorage;
import org.apache.pig.impl.io.ReadToEndLoader;
import org.apache.pig.impl.util.UDFContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadScalars
extends EvalFunc<Object> {
    private String scalarfilename = null;
    private Object value = null;

    @Override
    public Object exec(Tuple input) throws IOException {
        if (this.value == null) {
            ReadToEndLoader loader;
            int pos;
            if (input == null || input.size() == 0) {
                return null;
            }
            try {
                pos = DataType.toInteger(input.get(0));
                this.scalarfilename = DataType.toString(input.get(1));
                Configuration conf = UDFContext.getUDFContext().getJobConf();
                if (System.getenv("HADOOP_TOKEN_FILE_LOCATION") != null) {
                    conf.set("mapreduce.job.credentials.binary", System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
                }
                loader = new ReadToEndLoader((LoadFunc)new InterStorage(), conf, this.scalarfilename, 0);
            }
            catch (Exception e) {
                throw new ExecException("Failed to open file '" + this.scalarfilename + "'; error = " + e.getMessage());
            }
            try {
                Tuple t1 = loader.getNext();
                if (t1 == null) {
                    this.log.warn((Object)"No scalar field to read, returning null");
                    return null;
                }
                this.value = t1.get(pos);
                Tuple t2 = loader.getNext();
                if (t2 != null) {
                    String msg = "Scalar has more than one row in the output. 1st : " + t1 + ", 2nd :" + t2;
                    throw new ExecException(msg);
                }
            }
            catch (Exception e) {
                throw new ExecException(e.getMessage());
            }
        }
        return this.value;
    }
}

