/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOGenerate;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.DotPlanDumper;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotLOPrinter
extends DotPlanDumper<LogicalOperator, LogicalPlan, LogicalOperator, LogicalPlan> {
    public DotLOPrinter(LogicalPlan plan, PrintStream ps) {
        this(plan, ps, false, (Set<Operator>)new HashSet<Operator>(), (Set<Operator>)new HashSet<Operator>(), (Set<Operator>)new HashSet<Operator>());
    }

    private DotLOPrinter(LogicalPlan plan, PrintStream ps, boolean isSubGraph, Set<Operator> subgraphs, Set<Operator> multiInSubgraphs, Set<Operator> multiOutSubgraphs) {
        super(plan, ps, isSubGraph, subgraphs, multiInSubgraphs, multiOutSubgraphs);
    }

    protected DotPlanDumper makeDumper(LogicalPlan plan, PrintStream ps) {
        return new DotLOPrinter(plan, ps, true, (Set<Operator>)this.mSubgraphs, (Set<Operator>)this.mMultiInputSubgraphs, (Set<Operator>)this.mMultiOutputSubgraphs);
    }

    @Override
    protected String getName(LogicalOperator op) {
        String info = op.name().split("\\d+-\\d+")[0];
        if (op instanceof LOProject) {
            LOProject pr = (LOProject)op;
            info = info + (pr.isStar() ? " [*]" : pr.getProjection());
        }
        return info;
    }

    @Override
    protected String[] getAttributes(LogicalOperator op) {
        if (op instanceof LOStore || op instanceof LOLoad) {
            String[] attributes = new String[]{"label=\"" + this.getName(op).replace(":", ",\\n") + "\"", "style=\"filled\"", "fillcolor=\"gray\""};
            return attributes;
        }
        return super.getAttributes(op);
    }

    @Override
    protected MultiMap<LogicalOperator, LogicalPlan> getMultiInputNestedPlans(LogicalOperator op) {
        if (op instanceof LOCogroup) {
            return ((LOCogroup)op).getGroupByPlans();
        }
        if (op instanceof LOJoin) {
            return ((LOJoin)op).getJoinPlans();
        }
        if (op instanceof LOJoin) {
            return ((LOJoin)op).getJoinPlans();
        }
        return new MultiMap<LogicalOperator, LogicalPlan>();
    }

    @Override
    protected Collection<LogicalPlan> getNestedPlans(LogicalOperator op) {
        LinkedList<LogicalPlan> plans = new LinkedList<LogicalPlan>();
        if (op instanceof LOFilter) {
            plans.add(((LOFilter)op).getComparisonPlan());
        } else if (op instanceof LOForEach) {
            plans.addAll(((LOForEach)op).getForEachPlans());
        } else if (op instanceof LOGenerate) {
            plans.addAll(((LOGenerate)op).getGeneratePlans());
        } else if (op instanceof LOSort) {
            plans.addAll(((LOSort)op).getSortColPlans());
        } else if (op instanceof LOSplitOutput) {
            plans.add(((LOSplitOutput)op).getConditionPlan());
        }
        return plans;
    }
}

