/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.LogicalPlanCloneHelper;
import org.apache.pig.impl.logicalLayer.ProjectFixerUpper;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.logicalLayer.TopLevelProjectFinder;
import org.apache.pig.impl.logicalLayer.optimizer.SchemaRemover;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOJoin
extends RelationalOperator {
    private static final long serialVersionUID = 2L;
    private static Log log = LogFactory.getLog(LOJoin.class);
    private MultiMap<LogicalOperator, LogicalPlan> mJoinPlans;
    private boolean[] mInnerFlags;
    private JOINTYPE mJoinType;
    private List<LogicalOperator> mSchemaInputMapping = new ArrayList<LogicalOperator>();
    public static final Integer OPTION_JOIN = 1;

    public LOJoin(LogicalPlan plan, OperatorKey k, MultiMap<LogicalOperator, LogicalPlan> joinPlans, JOINTYPE jt, boolean[] isInner) {
        super(plan, k);
        this.mJoinPlans = joinPlans;
        this.mJoinType = jt;
        this.mInnerFlags = this.getCopy(isInner);
    }

    private boolean[] getCopy(boolean[] flags) {
        boolean[] retVal = new boolean[flags.length];
        for (int i = 0; i < flags.length; ++i) {
            retVal[i] = flags[i];
        }
        return retVal;
    }

    public List<LogicalOperator> getInputs() {
        return this.mPlan.getPredecessors(this);
    }

    public MultiMap<LogicalOperator, LogicalPlan> getJoinPlans() {
        return this.mJoinPlans;
    }

    public void setJoinPlans(MultiMap<LogicalOperator, LogicalPlan> joinPlans) {
        this.mJoinPlans = joinPlans;
    }

    public JOINTYPE getJoinType() {
        return this.mJoinType;
    }

    @Override
    public String name() {
        return this.getAliasString() + "LOJoin " + this.mKey.scope + "-" + this.mKey.id;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public Schema getSchema() throws FrontendException {
        List<LOJoin> inputs = this.mPlan.getPredecessors(this);
        this.mType = (byte)120;
        Hashtable<String, Integer> nonDuplicates = new Hashtable<String, Integer>();
        if (!this.mIsSchemaComputed) {
            ArrayList<Schema.FieldSchema> fss = new ArrayList<Schema.FieldSchema>();
            this.mSchemaInputMapping = new ArrayList<LogicalOperator>();
            int i = -1;
            boolean seeUnknown = false;
            for (LogicalOperator logicalOperator : inputs) {
                try {
                    Schema cSchema = logicalOperator.getSchema();
                    if (cSchema != null) {
                        for (Schema.FieldSchema schema : cSchema.getFields()) {
                            ++i;
                            Schema.FieldSchema newFS = null;
                            if (schema.alias != null) {
                                if (nonDuplicates.containsKey(schema.alias)) {
                                    if ((Integer)nonDuplicates.get(schema.alias) != -1) {
                                        nonDuplicates.remove(schema.alias);
                                        nonDuplicates.put(schema.alias, -1);
                                    }
                                } else {
                                    nonDuplicates.put(schema.alias, i);
                                }
                                newFS = new Schema.FieldSchema(logicalOperator.getAlias() + "::" + schema.alias, schema.schema, schema.type);
                            } else {
                                newFS = new Schema.FieldSchema(null, schema.type);
                            }
                            newFS.setParent(schema.canonicalName, logicalOperator);
                            fss.add(newFS);
                            this.mSchemaInputMapping.add(logicalOperator);
                        }
                        continue;
                    }
                    seeUnknown = true;
                }
                catch (FrontendException ioe) {
                    this.mIsSchemaComputed = false;
                    this.mSchema = null;
                    throw ioe;
                }
            }
            this.mIsSchemaComputed = true;
            this.mSchema = null;
            if (!seeUnknown) {
                this.mSchema = new Schema(fss);
                for (Map.Entry entry : nonDuplicates.entrySet()) {
                    int ind = (Integer)entry.getValue();
                    if (ind == -1) continue;
                    Schema.FieldSchema prevSch = (Schema.FieldSchema)fss.get(ind);
                    this.mSchema.addAlias((String)entry.getKey(), prevSch);
                }
            }
        }
        return this.mSchema;
    }

    public boolean isTupleJoinCol() {
        List<LOJoin> inputs = this.mPlan.getPredecessors(this);
        if (inputs == null || inputs.size() == 0) {
            throw new AssertionError((Object)"LOJoin.isTupleJoinCol() can only becalled after it has an input ");
        }
        return this.mJoinPlans.get(inputs.get(0)).size() > 1;
    }

    @Override
    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    public void switchJoinColPlanOp(LogicalOperator oldOp, LogicalOperator newOp) {
        Collection<LogicalPlan> innerPlans = this.mJoinPlans.removeKey(oldOp);
        this.mJoinPlans.put(newOp, innerPlans);
    }

    @Override
    public void unsetSchema() throws VisitorException {
        for (LogicalOperator input : this.getInputs()) {
            Collection<LogicalPlan> joinPlans = this.mJoinPlans.get(input);
            if (joinPlans == null) continue;
            for (LogicalPlan plan : joinPlans) {
                SchemaRemover sr = new SchemaRemover(plan);
                sr.visit();
            }
        }
        super.unsetSchema();
    }

    public byte getAtomicJoinColType() throws FrontendException {
        if (this.isTupleJoinCol()) {
            int errCode = 1010;
            String msg = "getAtomicJoinColType is used only when dealing with atomic group col";
            throw new FrontendException(msg, errCode, 2, false, null);
        }
        byte groupType = 50;
        for (int i = 0; i < this.getInputs().size(); ++i) {
            LogicalOperator input = this.getInputs().get(i);
            ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>(this.getJoinPlans().get(input));
            if (innerPlans.size() != 1) {
                int errCode = 1012;
                String msg = "Each COGroup input has to have the same number of inner plans";
                throw new FrontendException(msg, errCode, 2, false, null);
            }
            byte innerType = ((LogicalPlan)innerPlans.get(0)).getSingleLeafPlanOutputType();
            if ((groupType = DataType.mergeType(groupType, innerType)) != -1) continue;
            int errCode = 1107;
            String msg = "Cannot merge join keys, incompatible types";
            throw new FrontendException(msg, errCode, 2);
        }
        return groupType;
    }

    public Schema getTupleJoinSchema() throws FrontendException {
        int i;
        if (!this.isTupleJoinCol()) {
            int errCode = 1011;
            String msg = "getTupleJoinSchema is used only when dealing with tuple join col";
            throw new FrontendException(msg, errCode, 2, false, null);
        }
        ArrayList<Schema.FieldSchema> fsList = new ArrayList<Schema.FieldSchema>();
        int outputSchemaSize = this.getJoinPlans().get(this.getInputs().get(0)).size();
        for (i = 0; i < outputSchemaSize; ++i) {
            fsList.add(new Schema.FieldSchema(null, 50));
        }
        for (i = 0; i < this.getInputs().size(); ++i) {
            LogicalOperator input = this.getInputs().get(i);
            ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>(this.getJoinPlans().get(input));
            boolean seenProjectStar = false;
            for (int j = 0; j < innerPlans.size(); ++j) {
                byte innerType = ((LogicalPlan)innerPlans.get(j)).getSingleLeafPlanOutputType();
                ExpressionOperator eOp = (ExpressionOperator)((LogicalPlan)innerPlans.get(j)).getSingleLeafPlanOutputOp();
                if (eOp instanceof LOProject && ((LOProject)eOp).isStar()) {
                    seenProjectStar = true;
                }
                Schema.FieldSchema groupFs = (Schema.FieldSchema)fsList.get(j);
                groupFs.type = DataType.mergeType(groupFs.type, innerType);
                Schema.FieldSchema fs = eOp.getFieldSchema();
                if (null != fs) {
                    groupFs.setParent(eOp.getFieldSchema().canonicalName, eOp);
                    continue;
                }
                groupFs.setParent(null, eOp);
            }
            if (!seenProjectStar) continue;
            int errCode = 1013;
            String msg = "Grouping attributes can either be star (*) or a list of expressions, but not both.";
            throw new FrontendException(msg, errCode, 2, false, null);
        }
        return new Schema(fsList);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        LOJoin joinClone = (LOJoin)super.clone();
        joinClone.mJoinPlans = new MultiMap();
        for (LogicalOperator relOp : this.mJoinPlans.keySet()) {
            Collection<LogicalPlan> values = this.mJoinPlans.get(relOp);
            Iterator<LogicalPlan> planIterator = values.iterator();
            while (planIterator.hasNext()) {
                LogicalPlanCloneHelper lpCloneHelper = new LogicalPlanCloneHelper(planIterator.next());
                joinClone.mJoinPlans.put(relOp, lpCloneHelper.getClonedPlan());
            }
        }
        return joinClone;
    }

    @Override
    public ProjectionMap getProjectionMap() {
        Schema outputSchema;
        if (this.mIsProjectionMapComputed) {
            return this.mProjectionMap;
        }
        this.mIsProjectionMapComputed = true;
        try {
            outputSchema = this.getSchema();
        }
        catch (FrontendException fee) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        if (outputSchema == null) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        ArrayList predecessors = (ArrayList)this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        MultiMap<Integer, ProjectionMap.Column> mapFields = new MultiMap<Integer, ProjectionMap.Column>();
        ArrayList<Integer> addedFields = new ArrayList<Integer>();
        boolean[] unknownSchema = new boolean[predecessors.size()];
        boolean anyUnknownInputSchema = false;
        int outputColumnNum = 0;
        for (int inputNum = 0; inputNum < predecessors.size(); ++inputNum) {
            LogicalOperator predecessor = (LogicalOperator)predecessors.get(inputNum);
            Schema inputSchema = null;
            try {
                inputSchema = predecessor.getSchema();
            }
            catch (FrontendException fee) {
                this.mProjectionMap = null;
                return this.mProjectionMap;
            }
            if (inputSchema == null) {
                unknownSchema[inputNum] = true;
                ++outputColumnNum;
                addedFields.add(inputNum);
                anyUnknownInputSchema = true;
                continue;
            }
            unknownSchema[inputNum] = false;
            for (int inputColumn = 0; inputColumn < inputSchema.size(); ++inputColumn) {
                mapFields.put((Integer)outputColumnNum++, new ProjectionMap.Column(new Pair<Integer, Integer>(inputNum, inputColumn)));
            }
        }
        if (anyUnknownInputSchema) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        if (addedFields.size() == 0) {
            addedFields = null;
        }
        this.mProjectionMap = new ProjectionMap(mapFields, null, addedFields);
        return this.mProjectionMap;
    }

    @Override
    public List<RequiredFields> getRequiredFields() {
        List<LOJoin> predecessors = this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            return null;
        }
        ArrayList<RequiredFields> requiredFields = new ArrayList<RequiredFields>();
        for (int inputNum = 0; inputNum < predecessors.size(); ++inputNum) {
            HashSet<Pair<Integer, Integer>> fields = new HashSet<Pair<Integer, Integer>>();
            HashSet<LOProject> projectSet = new HashSet<LOProject>();
            boolean groupByStar = false;
            for (LogicalPlan plan : this.mJoinPlans.get(predecessors.get(inputNum))) {
                TopLevelProjectFinder projectFinder = new TopLevelProjectFinder(plan);
                try {
                    projectFinder.visit();
                }
                catch (VisitorException ve) {
                    requiredFields.clear();
                    requiredFields.add(null);
                    return requiredFields;
                }
                projectSet.addAll(projectFinder.getProjectSet());
                if (projectFinder.getProjectStarSet() == null) continue;
                groupByStar = true;
            }
            if (groupByStar) {
                requiredFields.add(new RequiredFields(true));
                continue;
            }
            for (LOProject project : projectSet) {
                for (int inputColumn : project.getProjection()) {
                    fields.add(new Pair<Integer, Integer>(inputNum, inputColumn));
                }
            }
            if (fields.size() == 0) {
                requiredFields.add(new RequiredFields(false, true));
                continue;
            }
            requiredFields.add(new RequiredFields(new ArrayList<Pair<Integer, Integer>>(fields)));
        }
        return requiredFields.size() == 0 ? null : requiredFields;
    }

    @Override
    public void rewire(Operator oldPred, int oldPredIndex, Operator newPred, boolean useOldPred) throws PlanException {
        super.rewire(oldPred, oldPredIndex, newPred, useOldPred);
        LogicalOperator previous = (LogicalOperator)oldPred;
        LogicalOperator current = (LogicalOperator)newPred;
        HashSet<LogicalOperator> joinInputs = new HashSet<LogicalOperator>(this.mJoinPlans.keySet());
        for (LogicalOperator input : joinInputs) {
            if (!input.equals(previous)) continue;
            for (LogicalPlan plan : this.mJoinPlans.get(input)) {
                try {
                    ProjectFixerUpper projectFixer = new ProjectFixerUpper(plan, previous, oldPredIndex, current, useOldPred, this);
                    projectFixer.visit();
                }
                catch (VisitorException ve) {
                    int errCode = 2144;
                    String msg = "Problem while fixing project inputs during rewiring.";
                    throw new PlanException(msg, errCode, 4, ve);
                }
            }
            List plans = (List)this.mJoinPlans.get(previous);
            this.mJoinPlans.removeKey(previous);
            this.mJoinPlans.put(current, plans);
        }
    }

    @Override
    public List<RequiredFields> getRelevantInputs(int output, int column) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (output != 0) {
            return null;
        }
        if (column < 0) {
            return null;
        }
        if (this.mSchema == null) {
            return null;
        }
        if (this.mSchemaInputMapping == null || this.mSchemaInputMapping.size() == 0 || this.mSchema.size() != this.mSchemaInputMapping.size()) {
            return null;
        }
        if (column > this.mSchema.size() - 1) {
            return null;
        }
        ArrayList predecessors = (ArrayList)this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            return null;
        }
        ArrayList<RequiredFields> result = new ArrayList<RequiredFields>();
        for (int i = 0; i < predecessors.size(); ++i) {
            result.add(null);
        }
        int inputNum = -1;
        int inputColumn = 0;
        LogicalOperator op = null;
        for (int i = 0; i <= column; ++i) {
            if (this.mSchemaInputMapping.get(i) != op) {
                ++inputNum;
                inputColumn = 0;
                op = this.mSchemaInputMapping.get(i);
                continue;
            }
            ++inputColumn;
        }
        ArrayList<Pair<Integer, Integer>> inputList = new ArrayList<Pair<Integer, Integer>>();
        inputList.add(new Pair<Integer, Integer>(inputNum, inputColumn));
        RequiredFields requiredFields = new RequiredFields(inputList);
        result.set(inputNum, requiredFields);
        return result;
    }

    public boolean[] getInnerFlags() {
        return this.getCopy(this.mInnerFlags);
    }

    @Override
    public boolean pruneColumns(List<Pair<Integer, Integer>> columns) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (this.mSchema == null) {
            log.warn((Object)"Cannot prune columns in cogroup, no schema information found");
            return false;
        }
        List<LOJoin> predecessors = this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            int errCode = 2190;
            throw new FrontendException("Cannot find predecessors for join", errCode, 4);
        }
        for (int i = columns.size() - 1; i >= 0; --i) {
            Pair<Integer, Integer> column = columns.get(i);
            if ((Integer)column.first < 0 || (Integer)column.first > predecessors.size()) {
                int errCode = 2191;
                throw new FrontendException("No input " + column.first + " to prune in join", errCode, 4);
            }
            if ((Integer)column.second < 0) {
                int errCode = 2192;
                throw new FrontendException("column to prune does not exist", errCode, 4);
            }
            for (LogicalPlan plan : this.mJoinPlans.get(predecessors.get((Integer)column.first))) {
                this.pruneColumnInPlan(plan, (Integer)column.second);
            }
        }
        super.pruneColumns(columns);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JOINTYPE {
        HASH,
        REPLICATED,
        SKEWED,
        MERGE;

    }
}

