/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.LogicalPlanCloneHelper;
import org.apache.pig.impl.logicalLayer.ProjectFixerUpper;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.logicalLayer.TopLevelProjectFinder;
import org.apache.pig.impl.logicalLayer.optimizer.SchemaRemover;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOSplitOutput
extends RelationalOperator {
    private static final long serialVersionUID = 2L;
    protected int mIndex;
    private LogicalPlan mCondPlan;
    private static Log log = LogFactory.getLog(LOSplitOutput.class);

    public LOSplitOutput(LogicalPlan plan, OperatorKey key, int index, LogicalPlan condPlan) {
        super(plan, key);
        this.mIndex = index;
        this.mCondPlan = condPlan;
    }

    public LogicalPlan getConditionPlan() {
        return this.mCondPlan;
    }

    @Override
    public String name() {
        return this.getAliasString() + "SplitOutput[" + this.getAlias() + "] " + this.mKey.scope + "-" + this.mKey.id;
    }

    @Override
    public Schema getSchema() throws FrontendException {
        if (!this.mIsSchemaComputed) {
            try {
                LogicalOperator input = this.mPlan.getPredecessors(this).get(0);
                if (null == input) {
                    int errCode = 1006;
                    String msg = "Could not find operator in plan";
                    throw new FrontendException(msg, errCode, 2, false, null);
                }
                this.mSchema = input.getSchema() != null ? Schema.copyAndLink(input.getSchema(), input) : null;
                this.mIsSchemaComputed = true;
            }
            catch (FrontendException fe) {
                this.mSchema = null;
                this.mIsSchemaComputed = false;
                throw fe;
            }
        }
        return this.mSchema;
    }

    @Override
    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    public int getReadFrom() {
        return this.mIndex;
    }

    @Override
    public byte getType() {
        return 120;
    }

    @Override
    public void unsetSchema() throws VisitorException {
        SchemaRemover sr = new SchemaRemover(this.mCondPlan);
        sr.visit();
        super.unsetSchema();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        LOSplitOutput splitOutputClone = (LOSplitOutput)super.clone();
        LogicalPlanCloneHelper lpCloner = new LogicalPlanCloneHelper(this.mCondPlan);
        splitOutputClone.mCondPlan = lpCloner.getClonedPlan();
        return splitOutputClone;
    }

    @Override
    public ProjectionMap getProjectionMap() {
        Schema outputSchema;
        if (this.mIsProjectionMapComputed) {
            return this.mProjectionMap;
        }
        this.mIsProjectionMapComputed = true;
        try {
            outputSchema = this.getSchema();
        }
        catch (FrontendException fee) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        Schema inputSchema = null;
        ArrayList predecessors = (ArrayList)this.mPlan.getPredecessors(this);
        if (predecessors != null) {
            try {
                inputSchema = ((LogicalOperator)predecessors.get(0)).getSchema();
            }
            catch (FrontendException fee) {
                this.mProjectionMap = null;
                return this.mProjectionMap;
            }
        } else {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        if (Schema.equals(inputSchema, outputSchema, false, true)) {
            this.mProjectionMap = new ProjectionMap(false);
            return this.mProjectionMap;
        }
        this.mProjectionMap = null;
        return this.mProjectionMap;
    }

    @Override
    public List<RequiredFields> getRequiredFields() {
        ArrayList<RequiredFields> requiredFields = new ArrayList<RequiredFields>();
        HashSet<Pair<Integer, Integer>> fields = new HashSet<Pair<Integer, Integer>>();
        TopLevelProjectFinder projectFinder = new TopLevelProjectFinder(this.mCondPlan);
        try {
            projectFinder.visit();
        }
        catch (VisitorException ve) {
            requiredFields.clear();
            requiredFields.add(null);
            return requiredFields;
        }
        Set<LOProject> projectStarSet = projectFinder.getProjectStarSet();
        if (projectStarSet != null) {
            requiredFields.add(new RequiredFields(true));
            return requiredFields;
        }
        for (LOProject project : projectFinder.getProjectSet()) {
            for (int inputColumn : project.getProjection()) {
                fields.add(new Pair<Integer, Integer>(0, inputColumn));
            }
        }
        if (fields.size() == 0) {
            requiredFields.add(new RequiredFields(false, true));
        } else {
            requiredFields.add(new RequiredFields(new ArrayList<Pair<Integer, Integer>>(fields)));
        }
        return requiredFields.size() == 0 ? null : requiredFields;
    }

    @Override
    public void rewire(Operator<LOVisitor> oldPred, int oldPredIndex, Operator<LOVisitor> newPred, boolean useOldPred) throws PlanException {
        super.rewire(oldPred, oldPredIndex, newPred, useOldPred);
        LogicalOperator previous = (LogicalOperator)oldPred;
        LogicalOperator current = (LogicalOperator)newPred;
        try {
            ProjectFixerUpper projectFixer = new ProjectFixerUpper(this.mCondPlan, previous, oldPredIndex, current, useOldPred, this);
            projectFixer.visit();
        }
        catch (VisitorException ve) {
            int errCode = 2144;
            String msg = "Problem while fixing project inputs during rewiring.";
            throw new PlanException(msg, errCode, 4, ve);
        }
    }

    @Override
    public List<RequiredFields> getRelevantInputs(int output, int column) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (output != 0) {
            return null;
        }
        if (column < 0) {
            return null;
        }
        if (this.mSchema != null && column >= this.mSchema.size()) {
            return null;
        }
        ArrayList<Pair<Integer, Integer>> inputList = new ArrayList<Pair<Integer, Integer>>();
        inputList.add(new Pair<Integer, Integer>(0, column));
        ArrayList<RequiredFields> result = new ArrayList<RequiredFields>();
        result.add(new RequiredFields(inputList));
        return result;
    }

    @Override
    public boolean pruneColumns(List<Pair<Integer, Integer>> columns) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (this.mSchema == null) {
            log.warn((Object)"Cannot prune columns in splitoutput, no schema information found");
            return false;
        }
        for (int i = columns.size() - 1; i >= 0; --i) {
            Pair<Integer, Integer> column = columns.get(i);
            if ((Integer)column.first != 0) {
                int errCode = 2191;
                throw new FrontendException("Splitoutput only take 1 input, cannot prune input with index " + column.first, errCode, 4);
            }
            if ((Integer)column.second < 0) {
                int errCode = 2192;
                throw new FrontendException("Column to prune does not exist", errCode, 4);
            }
            this.pruneColumnInPlan(this.mCondPlan, (Integer)column.second);
        }
        super.pruneColumns(columns);
        return true;
    }
}

