/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.FuncSpec;
import org.apache.pig.SortInfo;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOStore
extends RelationalOperator {
    private static final long serialVersionUID = 2L;
    private FileSpec mOutputFile;
    private FileSpec mInputSpec;
    private String signature;
    private transient StoreFuncInterface mStoreFunc;
    private static Log log = LogFactory.getLog(LOStore.class);
    private boolean isTmpStore;
    private SortInfo sortInfo;

    public boolean isTmpStore() {
        return this.isTmpStore;
    }

    public void setTmpStore(boolean isTmpStore) {
        this.isTmpStore = isTmpStore;
    }

    public SortInfo getSortInfo() {
        return this.sortInfo;
    }

    public void setSortInfo(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    public LOStore(LogicalPlan plan, OperatorKey key, FileSpec outputFileSpec, String alias) throws IOException {
        super(plan, key);
        this.mOutputFile = outputFileSpec;
        this.isTmpStore = false;
        try {
            this.mStoreFunc = (StoreFuncInterface)PigContext.instantiateFuncFromSpec(outputFileSpec.getFuncSpec());
            this.mAlias = alias;
            this.signature = LOStore.constructSignature(this.mAlias, outputFileSpec.getFileName(), this.mOutputFile.getFuncSpec());
            this.mStoreFunc.setStoreFuncUDFContextSignature(this.signature);
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    public static String constructSignature(String alias, String filename, FuncSpec funcSpec) {
        return alias + "_" + filename + "_" + funcSpec.toString();
    }

    public FileSpec getOutputFile() {
        return this.mOutputFile;
    }

    public void setOutputFile(FileSpec outputFileSpec) throws IOException {
        try {
            this.mStoreFunc = (StoreFuncInterface)PigContext.instantiateFuncFromSpec(outputFileSpec.getFuncSpec());
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
        this.mOutputFile = outputFileSpec;
    }

    public StoreFuncInterface getStoreFunc() {
        return this.mStoreFunc;
    }

    @Override
    public String name() {
        return this.getAliasString() + "Store " + this.mKey.scope + "-" + this.mKey.id;
    }

    @Override
    public Schema getSchema() throws FrontendException {
        return ((LogicalOperator)this.mPlan.getPredecessors(this).get(0)).getSchema();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return true;
    }

    @Override
    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    public void setInputSpec(FileSpec in) {
        this.mInputSpec = in;
    }

    public FileSpec getInputSpec() {
        return this.mInputSpec;
    }

    @Override
    public ProjectionMap getProjectionMap() {
        Schema outputSchema;
        if (this.mIsProjectionMapComputed) {
            return this.mProjectionMap;
        }
        this.mIsProjectionMapComputed = true;
        try {
            outputSchema = this.getSchema();
        }
        catch (FrontendException fee) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        Schema inputSchema = null;
        ArrayList predecessors = (ArrayList)this.mPlan.getPredecessors(this);
        if (predecessors != null) {
            try {
                inputSchema = ((LogicalOperator)predecessors.get(0)).getSchema();
            }
            catch (FrontendException fee) {
                this.mProjectionMap = null;
                return this.mProjectionMap;
            }
        }
        if (Schema.equals(inputSchema, outputSchema, false, true)) {
            this.mProjectionMap = new ProjectionMap(false);
            return this.mProjectionMap;
        }
        this.mProjectionMap = null;
        return this.mProjectionMap;
    }

    @Override
    public List<RequiredFields> getRequiredFields() {
        ArrayList<RequiredFields> requiredFields = new ArrayList<RequiredFields>();
        requiredFields.add(new RequiredFields(false, true));
        return requiredFields;
    }

    @Override
    public List<RequiredFields> getRelevantInputs(int output, int column) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (output != 0) {
            return null;
        }
        if (column < 0) {
            return null;
        }
        if (this.mSchema != null && column >= this.mSchema.size()) {
            return null;
        }
        ArrayList<RequiredFields> result = new ArrayList<RequiredFields>();
        result.add(new RequiredFields(true));
        return result;
    }

    @Override
    public void setAlias(String newAlias) {
        super.setAlias(newAlias);
        this.signature = LOStore.constructSignature(this.mAlias, this.mOutputFile.getFileName(), this.mOutputFile.getFuncSpec());
        this.mStoreFunc.setStoreFuncUDFContextSignature(this.signature);
    }

    public String getSignature() {
        return this.signature;
    }
}

