/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.streaming.ExecutableManager;
import org.apache.pig.impl.streaming.StreamingCommand;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOStream
extends RelationalOperator {
    private static final long serialVersionUID = 2L;
    private StreamingCommand command;
    private transient ExecutableManager executableManager;
    private boolean isParentSet = false;

    public LOStream(LogicalPlan plan, OperatorKey k, LogicalOperator input, ExecutableManager exeManager, StreamingCommand cmd) {
        super(plan, k);
        this.command = cmd;
        this.executableManager = exeManager;
    }

    public StreamingCommand getStreamingCommand() {
        return this.command;
    }

    @Override
    public Schema getSchema() throws FrontendException {
        if (this.mSchema == null) {
            return null;
        }
        if (!this.isParentSet) {
            this.setParent(this.mSchema);
            this.isParentSet = true;
        }
        return this.mSchema;
    }

    public void setOptimizedSpec(StreamingCommand.Handle handle, String spec) {
        StreamingCommand optimizedCommand = (StreamingCommand)this.command.clone();
        if (handle == StreamingCommand.Handle.INPUT) {
            StreamingCommand.HandleSpec streamInputSpec = optimizedCommand.getInputSpec();
            streamInputSpec.setSpec(spec);
        } else if (handle == StreamingCommand.Handle.OUTPUT) {
            StreamingCommand.HandleSpec streamOutputSpec = optimizedCommand.getOutputSpec();
            streamOutputSpec.setSpec(spec);
        }
        this.command = optimizedCommand;
    }

    @Override
    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "Stream (" + this.command.toString() + ") " + this.mKey.scope + "-" + this.mKey.id;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    public ExecutableManager getExecutableManager() {
        return this.executableManager;
    }

    @Override
    public ProjectionMap getProjectionMap() {
        int i;
        Schema outputSchema;
        if (this.mIsProjectionMapComputed) {
            return this.mProjectionMap;
        }
        this.mIsProjectionMapComputed = true;
        try {
            outputSchema = this.getSchema();
        }
        catch (FrontendException fee) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        if (outputSchema == null) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        Schema inputSchema = null;
        ArrayList predecessors = (ArrayList)this.mPlan.getPredecessors(this);
        if (predecessors != null) {
            try {
                inputSchema = ((LogicalOperator)predecessors.get(0)).getSchema();
            }
            catch (FrontendException fee) {
                this.mProjectionMap = null;
                return this.mProjectionMap;
            }
        } else {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        ArrayList<Integer> addedFields = new ArrayList<Integer>();
        ArrayList<Pair<Integer, Integer>> removedFields = new ArrayList<Pair<Integer, Integer>>();
        for (i = 0; i < outputSchema.size(); ++i) {
            addedFields.add(i);
        }
        if (inputSchema != null) {
            for (i = 0; i < inputSchema.size(); ++i) {
                removedFields.add(new Pair<Integer, Integer>(0, i));
            }
        }
        this.mProjectionMap = new ProjectionMap(null, removedFields.size() == 0 ? null : removedFields, addedFields);
        return this.mProjectionMap;
    }

    @Override
    public List<RequiredFields> getRequiredFields() {
        ArrayList<RequiredFields> requiredFields = new ArrayList<RequiredFields>();
        requiredFields.add(new RequiredFields(true, false));
        return requiredFields;
    }

    @Override
    public List<RequiredFields> getRelevantInputs(int output, int column) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (output != 0) {
            return null;
        }
        if (column < 0) {
            return null;
        }
        if (this.mSchema != null && column >= this.mSchema.size()) {
            return null;
        }
        ArrayList<RequiredFields> result = new ArrayList<RequiredFields>();
        result.add(new RequiredFields(true));
        return result;
    }
}

