/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.logicalLayer.CanonicalNamer;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LogicalOperator
extends Operator<LOVisitor> {
    private static final long serialVersionUID = 2L;
    protected Schema mSchema = null;
    protected boolean mIsSchemaComputed = false;
    protected byte mType = 0;
    protected int mRequestedParallelism;
    protected String mAlias;
    protected LogicalPlan mPlan;
    protected ProjectionMap mProjectionMap;
    protected boolean mIsProjectionMapComputed = false;
    protected HashSet<Integer> mPinnedOptions = new HashSet();
    protected String mCustomPartitioner = null;
    private static Log log = LogFactory.getLog(LogicalOperator.class);

    public String getCustomPartitioner() {
        return this.mCustomPartitioner;
    }

    public void setCustomPartitioner(String customPartitioner) {
        this.mCustomPartitioner = customPartitioner;
    }

    public LogicalOperator(LogicalPlan plan, OperatorKey k) {
        this(plan, k, -1);
    }

    public LogicalOperator(LogicalPlan plan, OperatorKey k, int rp) {
        super(k);
        this.mPlan = plan;
        this.mRequestedParallelism = rp;
    }

    @Override
    public OperatorKey getOperatorKey() {
        return this.mKey;
    }

    public void setSchema(Schema schema) throws FrontendException {
        try {
            this.getSchema();
        }
        catch (FrontendException frontendException) {
            // empty catch block
        }
        if (this.mSchema == null) {
            this.mSchema = schema;
        } else {
            this.mSchema.reconcile(schema);
        }
    }

    protected final void setParent(Schema schema) {
        if (schema == null) {
            return;
        }
        for (Schema.FieldSchema fs : schema.getFields()) {
            fs.setParent(null, this);
            this.setParent(fs.schema);
        }
    }

    public void forceSchema(Schema schema) {
        this.mSchema = schema;
    }

    public void unsetSchema() throws VisitorException {
        this.mIsSchemaComputed = false;
        this.mSchema = null;
    }

    public Schema regenerateSchema() throws FrontendException, VisitorException {
        this.unsetSchema();
        return this.getSchema();
    }

    public void setCanonicalNames() {
        for (Schema.FieldSchema fs : this.mSchema.getFields()) {
            fs.canonicalName = CanonicalNamer.getNewName();
        }
    }

    public abstract Schema getSchema() throws FrontendException;

    public final void setType(byte t) {
        this.mType = t;
    }

    public byte getType() {
        return this.mType;
    }

    public String getAlias() {
        return this.mAlias;
    }

    public String getAliasString() {
        return this.mAlias == null ? "" : this.mAlias + ": ";
    }

    public void setAlias(String newAlias) {
        this.mAlias = newAlias;
    }

    public int getRequestedParallelism() {
        return this.mRequestedParallelism;
    }

    public void setRequestedParallelism(int newRequestedParallelism) {
        this.mRequestedParallelism = newRequestedParallelism;
    }

    public void pinOption(Integer opt) {
        this.mPinnedOptions.add(opt);
    }

    public boolean isPinnedOption(Integer opt) {
        return this.mPinnedOptions.contains(opt);
    }

    @Override
    public String toString() {
        StringBuffer msg = new StringBuffer();
        msg.append("(Name: " + this.name() + " Operator Key: " + this.mKey + ")");
        return msg.toString();
    }

    protected void reconcileSchema(Schema schema) throws ParseException {
        if (this.mSchema == null) {
            this.mSchema = schema;
            return;
        }
    }

    @Override
    public abstract void visit(LOVisitor var1) throws VisitorException;

    public LogicalPlan getPlan() {
        return this.mPlan;
    }

    public void setPlan(LogicalPlan plan) {
        this.mPlan = plan;
    }

    public void setSchemaComputed(boolean computed) {
        this.mIsSchemaComputed = computed;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return true;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        LogicalOperator loClone = (LogicalOperator)super.clone();
        if (this.mSchema != null) {
            loClone.mSchema = this.mSchema.clone();
        }
        return loClone;
    }
}

