/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.logicalLayer.DotLOPrinter;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOPrinter;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlanCloneHelper;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalPlan
extends OperatorPlan<LogicalOperator> {
    private static final long serialVersionUID = 2L;

    public LogicalOperator getSingleLeafPlanOutputOp() {
        List list = this.getLeaves();
        if (list.size() != 1) {
            throw new AssertionError((Object)"The plan has more than one leaf node");
        }
        return (LogicalOperator)list.get(0);
    }

    public byte getSingleLeafPlanOutputType() {
        return this.getSingleLeafPlanOutputOp().getType();
    }

    @Override
    public void explain(OutputStream out, PrintStream ps) throws VisitorException, IOException {
        LOPrinter lpp = new LOPrinter(ps, this);
        lpp.print(out);
    }

    public void explain(PrintStream ps, String format, boolean verbose) throws VisitorException, IOException {
        ps.println("#-----------------------------------------------");
        ps.println("# Logical Plan:");
        ps.println("#-----------------------------------------------");
        if (format.equals("text")) {
            LOPrinter lpp = new LOPrinter(ps, this);
            lpp.setVerbose(verbose);
            lpp.visit();
        } else if (format.equals("dot")) {
            DotLOPrinter lpp = new DotLOPrinter(this, ps);
            lpp.setVerbose(verbose);
            lpp.dump();
            ps.println("");
        }
    }

    public LogicalPlan clone() throws CloneNotSupportedException {
        LogicalPlan clone = new LogicalPlan();
        Map<LogicalOperator, LogicalOperator> matches = LogicalPlanCloneHelper.mOpToCloneMap;
        for (LogicalOperator op : this.mOps.keySet()) {
            try {
                LogicalOperator c = (LogicalOperator)op.clone();
                clone.add(c);
                matches.put(op, c);
            }
            catch (CloneNotSupportedException cnse) {
                cnse.printStackTrace();
                throw cnse;
            }
        }
        for (LogicalOperator op : this.mToEdges.keySet()) {
            LogicalOperator cloneTo = matches.get(op);
            if (cloneTo == null) {
                String msg = "Unable to find clone for op " + op.name();
                log.error((Object)msg);
                throw new RuntimeException(msg);
            }
            Collection fromOps = this.mToEdges.get(op);
            for (LogicalOperator fromOp : fromOps) {
                LogicalOperator cloneFrom = matches.get(fromOp);
                if (cloneFrom == null) {
                    String msg = "Unable to find clone for op " + fromOp.name();
                    log.error((Object)msg);
                    throw new RuntimeException(msg);
                }
                try {
                    clone.connect(cloneFrom, cloneTo);
                }
                catch (PlanException pe) {
                    throw new RuntimeException(pe);
                }
            }
        }
        return clone;
    }

    public static Pair<LOProject, LOCast> chainOfProjects(LogicalPlan plan) {
        LOProject topProject = null;
        LOCast cast = null;
        if (plan == null) {
            return null;
        }
        List leaves = plan.getLeaves();
        if (leaves == null) {
            return null;
        }
        if (leaves.size() > 1) {
            return null;
        }
        LogicalOperator node = (LogicalOperator)leaves.get(0);
        while (node != null) {
            if (node instanceof LOProject) {
                topProject = (LOProject)node;
            } else if (node instanceof LOCast) {
                cast = (LOCast)node;
            } else {
                return null;
            }
            List<LogicalOperator> predecessors = plan.getPredecessors(node);
            if (predecessors == null) {
                return new Pair<LOProject, LOCast>(topProject, cast);
            }
            if (predecessors.size() > 1) {
                return null;
            }
            node = predecessors.get(0);
        }
        return null;
    }
}

