/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.HashMap;
import java.util.Map;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOUserFunc;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarFinder
extends LOVisitor {
    private LogicalOperator currentOp;
    private boolean inOp = false;
    Map<LOUserFunc, Pair<LogicalPlan, LogicalOperator>> mScalarMap = new HashMap<LOUserFunc, Pair<LogicalPlan, LogicalOperator>>();

    public ScalarFinder(LogicalPlan plan) {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DepthFirstWalker<LogicalOperator, LogicalPlan>(plan));
    }

    @Override
    protected void visit(LOUserFunc scalar) throws VisitorException {
        if (scalar.getImplicitReferencedOperator() != null) {
            this.mScalarMap.put(scalar, new Pair(this.mCurrentWalker.getPlan(), this.currentOp));
        }
    }

    @Override
    protected void visit(LOFilter op) throws VisitorException {
        if (!this.inOp) {
            this.inOp = true;
            this.currentOp = op;
        }
        super.visit(op);
        this.inOp = false;
    }

    @Override
    protected void visit(LOForEach op) throws VisitorException {
        if (!this.inOp) {
            this.inOp = true;
            this.currentOp = op;
        }
        super.visit(op);
        this.inOp = false;
    }

    @Override
    protected void visit(LOSplitOutput op) throws VisitorException {
        if (!this.inOp) {
            this.inOp = true;
            this.currentOp = op;
        }
        super.visit(op);
        this.inOp = false;
    }

    @Override
    protected void visit(LOCogroup op) throws VisitorException {
        if (!this.inOp) {
            this.inOp = true;
            this.currentOp = op;
        }
        super.visit(op);
        this.inOp = false;
    }

    @Override
    protected void visit(LOJoin op) throws VisitorException {
        if (!this.inOp) {
            this.inOp = true;
            this.currentOp = op;
        }
        super.visit(op);
        this.inOp = false;
    }

    public Map<LOUserFunc, Pair<LogicalPlan, LogicalOperator>> getScalarMap() {
        return this.mScalarMap;
    }
}

