/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.optimizer;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.pig.ExecType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.logicalLayer.optimizer.ImplicitSplitInserter;
import org.apache.pig.impl.logicalLayer.optimizer.LogicalTransformer;
import org.apache.pig.impl.logicalLayer.optimizer.OpLimitOptimizer;
import org.apache.pig.impl.logicalLayer.optimizer.PartitionFilterOptimizer;
import org.apache.pig.impl.logicalLayer.optimizer.PruneColumns;
import org.apache.pig.impl.logicalLayer.optimizer.PushDownForeachFlatten;
import org.apache.pig.impl.logicalLayer.optimizer.PushUpFilter;
import org.apache.pig.impl.logicalLayer.optimizer.TypeCastInserter;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.impl.plan.optimizer.PlanOptimizer;
import org.apache.pig.impl.plan.optimizer.Rule;
import org.apache.pig.impl.plan.optimizer.RuleMatcher;
import org.apache.pig.impl.plan.optimizer.RuleOperator;
import org.apache.pig.impl.plan.optimizer.RulePlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalOptimizer
extends PlanOptimizer<LogicalOperator, LogicalPlan> {
    private static final String SCOPE = "RULE";
    private static NodeIdGenerator nodeIdGen = NodeIdGenerator.getGenerator();
    private Set<String> mRulesOff = null;
    private Rule<LogicalOperator, LogicalPlan> pruneRule;

    public LogicalOptimizer(LogicalPlan plan) {
        this(plan, ExecType.MAPREDUCE);
    }

    public LogicalOptimizer(LogicalPlan plan, ExecType mode) {
        super(plan);
        this.runOptimizations(plan, mode);
    }

    public LogicalOptimizer(LogicalPlan plan, ExecType mode, Set<String> turnOffRules) {
        super(plan);
        this.mRulesOff = turnOffRules;
        this.runOptimizations(plan, mode);
    }

    private void runOptimizations(LogicalPlan plan, ExecType mode) {
        boolean turnAllRulesOff = false;
        if (this.mRulesOff != null) {
            for (String rule : this.mRulesOff) {
                if (!"all".equalsIgnoreCase(rule)) continue;
                turnAllRulesOff = true;
                break;
            }
        }
        RulePlan rulePlan = new RulePlan();
        RuleOperator anyLogicalOperator = new RuleOperator(LogicalOperator.class, RuleOperator.NodeType.ANY_NODE, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add(anyLogicalOperator);
        this.mRules.add(new Rule<LogicalOperator, LogicalPlan>(rulePlan, new ImplicitSplitInserter(plan), "ImplicitSplitInserter"));
        rulePlan = new RulePlan();
        RuleOperator loLoad = new RuleOperator(LOLoad.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add(loLoad);
        this.mRules.add(new Rule<LogicalOperator, LogicalPlan>(rulePlan, new PartitionFilterOptimizer(plan), "LoadPartitionFilterOptimizer"));
        rulePlan = new RulePlan();
        loLoad = new RuleOperator(LOLoad.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add(loLoad);
        this.mRules.add(new Rule<LogicalOperator, LogicalPlan>(rulePlan, new TypeCastInserter(plan, LOLoad.class.getName()), "LoadTypeCastInserter"));
        rulePlan = new RulePlan();
        RuleOperator loStream = new RuleOperator(LOStream.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add(loStream);
        this.mRules.add(new Rule<LogicalOperator, LogicalPlan>(rulePlan, new TypeCastInserter(plan, LOStream.class.getName()), "StreamTypeCastInserter"));
        if (!turnAllRulesOff) {
            rulePlan = new RulePlan();
            RuleOperator loLimit = new RuleOperator(LOLimit.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
            rulePlan.add(loLimit);
            Rule<LogicalOperator, LogicalPlan> rule = new Rule<LogicalOperator, LogicalPlan>(rulePlan, new OpLimitOptimizer(plan, mode), "LimitOptimizer");
            this.checkAndAddRule(rule);
            rulePlan = new RulePlan();
            RuleOperator loFilter = new RuleOperator(LOFilter.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
            rulePlan.add(loFilter);
            rule = new Rule<LogicalOperator, LogicalPlan>(rulePlan, new PushUpFilter(plan), "PushUpFilter");
            this.checkAndAddRule(rule);
            rulePlan = new RulePlan();
            RuleOperator loForeach = new RuleOperator(LOForEach.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
            rulePlan.add(loForeach);
            rule = new Rule<LogicalOperator, LogicalPlan>(rulePlan, new PushDownForeachFlatten(plan), "PushDownForeachFlatten");
            this.checkAndAddRule(rule);
            rulePlan = new RulePlan();
            RuleOperator rulePruneColumnsOperator = new RuleOperator(RelationalOperator.class, RuleOperator.NodeType.ANY_NODE, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
            rulePlan.add(rulePruneColumnsOperator);
            this.pruneRule = new Rule<LogicalOperator, LogicalPlan>(rulePlan, new PruneColumns(plan), "PruneColumns", Rule.WalkerAlgo.ReverseDependencyOrderWalker);
        }
    }

    private boolean ruleEnabled(Rule<LogicalOperator, LogicalPlan> rule) {
        if (this.mRulesOff != null && rule != null) {
            for (String ruleOff : this.mRulesOff) {
                String ruleName = rule.getRuleName();
                if (ruleName == null || !ruleName.equalsIgnoreCase(ruleOff)) continue;
                return false;
            }
        }
        this.mRules.add(rule);
        return true;
    }

    private void checkAndAddRule(Rule<LogicalOperator, LogicalPlan> rule) {
        if (this.ruleEnabled(rule)) {
            this.mRules.add(rule);
        }
    }

    @Override
    public final int optimize() throws OptimizerException {
        RuleMatcher<LogicalOperator, LogicalPlan> matcher;
        boolean sawMatch = false;
        boolean initialized = false;
        int numIterations = 0;
        do {
            sawMatch = false;
            Iterator i$ = this.mRules.iterator();
            while (i$.hasNext()) {
                RuleMatcher matcher2 = new RuleMatcher();
                Rule rule = (Rule)i$.next();
                if (!matcher2.match(rule)) continue;
                List matches = matcher2.getAllMatches();
                for (List match : matches) {
                    if (rule.getTransformer().check(match)) {
                        try {
                            sawMatch = true;
                            if (!initialized) {
                                ((LogicalTransformer)rule.getTransformer()).rebuildSchemas();
                                ((LogicalTransformer)rule.getTransformer()).rebuildProjectionMaps();
                                initialized = true;
                            }
                            rule.getTransformer().transform(match);
                            ((LogicalTransformer)rule.getTransformer()).rebuildSchemas();
                            ((LogicalTransformer)rule.getTransformer()).rebuildProjectionMaps();
                        }
                        catch (FrontendException fee) {
                            int errCode = 2145;
                            String msg = "Problem while rebuilding projection map or schema in logical optimizer.";
                            throw new OptimizerException(msg, errCode, 4, fee);
                        }
                    }
                    rule.getTransformer().reset();
                }
            }
        } while (sawMatch && ++numIterations < this.mMaxIterations);
        if (this.pruneRule != null && this.ruleEnabled(this.pruneRule) && (matcher = new RuleMatcher<LogicalOperator, LogicalPlan>()).match(this.pruneRule)) {
            List matches = matcher.getAllMatches();
            for (List match : matches) {
                if (!this.pruneRule.getTransformer().check(match)) continue;
                this.pruneRule.getTransformer().transform(match);
            }
            ((PruneColumns)this.pruneRule.getTransformer()).prune();
        }
        return numIterations;
    }
}

