/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.optimizer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.ProjectFixerUpper;
import org.apache.pig.impl.logicalLayer.ProjectionMapCalculator;
import org.apache.pig.impl.logicalLayer.ProjectionMapRemover;
import org.apache.pig.impl.logicalLayer.optimizer.SchemaCalculator;
import org.apache.pig.impl.logicalLayer.optimizer.SchemaRemover;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LogicalTransformer
extends Transformer<LogicalOperator, LogicalPlan> {
    private final Log log = LogFactory.getLog(this.getClass());

    protected LogicalTransformer(LogicalPlan plan) {
        super(plan);
    }

    protected void rebuildSchemas() throws VisitorException, FrontendException {
        SchemaRemover sr = new SchemaRemover((LogicalPlan)this.mPlan);
        sr.visit();
        SchemaCalculator sc = new SchemaCalculator((LogicalPlan)this.mPlan);
        sc.visit();
    }

    protected void rebuildProjectionMaps() throws VisitorException {
        ProjectionMapRemover pMapRemover = new ProjectionMapRemover((LogicalPlan)this.mPlan);
        pMapRemover.visit();
        ProjectionMapCalculator pMapCalculator = new ProjectionMapCalculator((LogicalPlan)this.mPlan);
        pMapCalculator.visit();
    }

    protected void insertBetween(LogicalOperator after, LogicalOperator newNode, LogicalOperator before, Map<Integer, Integer> projectionMapping) throws VisitorException, FrontendException {
        ((LogicalPlan)this.mPlan).add(newNode);
        ((LogicalPlan)this.mPlan).insertBetween(after, newNode, before);
    }

    protected void fixUpContainedPlans(LogicalOperator after, LogicalOperator newNode, LogicalOperator before, Map<Integer, Integer> projectionMapping) throws VisitorException, FrontendException {
        LOJoin frj;
        if (before instanceof LOCogroup) {
            LOCogroup cg = (LOCogroup)before;
            cg.switchGroupByPlanOp(after, newNode);
        }
        if (before instanceof LOJoin) {
            frj = (LOJoin)before;
            frj.switchJoinColPlanOp(after, newNode);
        }
        if (before instanceof LOJoin) {
            frj = (LOJoin)before;
            frj.switchJoinColPlanOp(after, newNode);
        }
        ArrayList<LogicalPlan> plans = new ArrayList<LogicalPlan>();
        if (before instanceof LOCogroup) {
            plans.addAll(((LOCogroup)before).getGroupByPlans().values());
        } else if (before instanceof LOJoin) {
            plans.addAll(((LOJoin)before).getJoinPlans().values());
        } else if (before instanceof LOJoin) {
            plans.addAll(((LOJoin)before).getJoinPlans().values());
        } else if (before instanceof LOSort) {
            plans.addAll(((LOSort)before).getSortColPlans());
        } else if (before instanceof LOFilter) {
            plans.add(((LOFilter)before).getComparisonPlan());
        } else if (before instanceof LOSplit) {
            List<LogicalOperator> splitOutputs = ((LogicalPlan)this.mPlan).getSuccessors(before);
            for (LogicalOperator so : splitOutputs) {
                if (!(so instanceof LOSplitOutput)) {
                    String msg = "Found an LOSplit with an operator other than LOSplitOutput after it!";
                    this.log.error((Object)msg);
                    throw new VisitorException(msg);
                }
                plans.add(((LOSplitOutput)so).getConditionPlan());
            }
        } else if (before instanceof LOForEach) {
            plans.addAll(((LOForEach)before).getForEachPlans());
        }
        for (LogicalPlan lp : plans) {
            ProjectFixerUpper pfu = new ProjectFixerUpper(lp, after, newNode, projectionMapping);
            pfu.visit();
        }
    }

    protected void insertAfter(LogicalOperator after, LogicalOperator newNode, Map<Integer, Integer> projectionMapping) throws VisitorException, FrontendException {
        List<LogicalOperator> successors = ((LogicalPlan)this.mPlan).getSuccessors(after);
        if (successors == null) {
            ((LogicalPlan)this.mPlan).addAsLeaf(newNode);
            return;
        }
        if (successors.size() != 1) {
            throw new RuntimeException("insertAfter only valid to insert after a node with single output.");
        }
        this.insertBetween(after, newNode, successors.get(0), projectionMapping);
    }

    @Override
    public void reset() {
    }
}

