/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.pig.EvalFunc;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.LoadFunc;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.datastorage.ContainerDescriptor;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.datastorage.ElementDescriptor;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.builtin.PigStreaming;
import org.apache.pig.builtin.RANDOM;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.builtin.GFAny;
import org.apache.pig.impl.builtin.ReadScalars;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.BinaryExpressionOperator;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOAdd;
import org.apache.pig.impl.logicalLayer.LOAnd;
import org.apache.pig.impl.logicalLayer.LOBinCond;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODefine;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LODivide;
import org.apache.pig.impl.logicalLayer.LOEqual;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOGenerate;
import org.apache.pig.impl.logicalLayer.LOGreaterThan;
import org.apache.pig.impl.logicalLayer.LOGreaterThanEqual;
import org.apache.pig.impl.logicalLayer.LOIsNull;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOLesserThan;
import org.apache.pig.impl.logicalLayer.LOLesserThanEqual;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOMapLookup;
import org.apache.pig.impl.logicalLayer.LOMod;
import org.apache.pig.impl.logicalLayer.LOMultiply;
import org.apache.pig.impl.logicalLayer.LONative;
import org.apache.pig.impl.logicalLayer.LONegative;
import org.apache.pig.impl.logicalLayer.LONot;
import org.apache.pig.impl.logicalLayer.LONotEqual;
import org.apache.pig.impl.logicalLayer.LOOr;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LORegexp;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LOSubtract;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LOUserFunc;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.LogicalPlanCloner;
import org.apache.pig.impl.logicalLayer.ProjectStarTranslator;
import org.apache.pig.impl.logicalLayer.RemoveRedundantOperators;
import org.apache.pig.impl.logicalLayer.UnaryExpressionOperator;
import org.apache.pig.impl.logicalLayer.parser.ClassType;
import org.apache.pig.impl.logicalLayer.parser.FunctionType;
import org.apache.pig.impl.logicalLayer.parser.JJTQueryParserState;
import org.apache.pig.impl.logicalLayer.parser.JavaCharStream;
import org.apache.pig.impl.logicalLayer.parser.Node;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.impl.logicalLayer.parser.QueryParserConstants;
import org.apache.pig.impl.logicalLayer.parser.QueryParserTokenManager;
import org.apache.pig.impl.logicalLayer.parser.QueryParserTreeConstants;
import org.apache.pig.impl.logicalLayer.parser.SimpleNode;
import org.apache.pig.impl.logicalLayer.parser.Token;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.streaming.StreamingCommand;
import org.apache.pig.impl.util.LinkedMultiMap;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryParser
implements QueryParserTreeConstants,
QueryParserConstants {
    protected JJTQueryParserState jjtree = new JJTQueryParserState();
    private PigContext pigContext;
    private Map<LogicalOperator, LogicalPlan> aliases;
    private Map<OperatorKey, LogicalOperator> opTable;
    private String scope;
    private NodeIdGenerator nodeIdGen;
    private Map<String, LogicalOperator> mapAliasOp;
    private static Log log = LogFactory.getLog(QueryParser.class);
    private boolean bracketed = false;
    private boolean scalarFound = false;
    private Map<String, String> fileNameMap;
    private static final String PERL = "perl";
    private static final String PYTHON = "python";
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private boolean insideGenerate = false;
    private List<LogicalOperator> generateInputs = new ArrayList<LogicalOperator>();
    private static Map<String, Byte> nameToTypeMap = DataType.genNameToTypeMap();
    public QueryParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private boolean jj_lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[151];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[36];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private long getNextId() {
        return this.nodeIdGen.getNextNodeId(this.scope);
    }

    public QueryParser(InputStream in, PigContext pigContext, String scope, Map<LogicalOperator, LogicalPlan> aliases, Map<OperatorKey, LogicalOperator> opTable, Map<String, LogicalOperator> aliasOp, Map<String, String> fileNameMap) {
        this(in);
        this.pigContext = pigContext;
        this.aliases = aliases;
        this.opTable = opTable;
        this.scope = scope;
        this.nodeIdGen = NodeIdGenerator.getGenerator();
        this.mapAliasOp = aliasOp;
        this.fileNameMap = fileNameMap;
    }

    public QueryParser(InputStream in, PigContext pigContext, String scope, Map<LogicalOperator, LogicalPlan> aliases, Map<OperatorKey, LogicalOperator> opTable, Map<String, LogicalOperator> aliasOp, int start, Map<String, String> fileNameMap) {
        this(in, pigContext, scope, aliases, opTable, aliasOp, fileNameMap);
        this.token_source.input_stream.line = start;
    }

    private static String removeQuotes(String str) {
        if (str.startsWith("'") && str.endsWith("'")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static LogicalPlan generateStorePlan(String scope, LogicalPlan readFrom, String fileName, String func, LogicalOperator input, String alias, PigContext pigContext) throws FrontendException {
        LOStore store;
        if (func == null) {
            func = PigStorage.class.getName();
        }
        fileName = QueryParser.removeQuotes(fileName);
        long storeNodeId = NodeIdGenerator.getGenerator().getNextNodeId(scope);
        LogicalPlan storePlan = new LogicalPlan();
        FuncSpec funcSpec = new FuncSpec(func);
        FileSpec fileSpec = new FileSpec(fileName, funcSpec);
        try {
            store = new LOStore(storePlan, new OperatorKey(scope, storeNodeId), fileSpec, alias);
        }
        catch (IOException ioe) {
            throw new FrontendException(ioe.getMessage(), ioe);
        }
        Object obj = PigContext.instantiateFuncFromSpec(funcSpec);
        StoreFuncInterface stoFunc = (StoreFuncInterface)obj;
        stoFunc.setStoreFuncUDFContextSignature(LOStore.constructSignature(alias, fileName, funcSpec));
        try {
            stoFunc.relToAbsPathForStoreLocation(fileName, QueryParser.getCurrentDir(pigContext));
        }
        catch (IOException ioe) {
            FrontendException e = new FrontendException(ioe.getMessage(), ioe);
            throw e;
        }
        try {
            storePlan.add(store);
            storePlan.add(input);
            storePlan.connect(input, store);
            QueryParser.attachPlan(storePlan, input, readFrom, new HashMap<LogicalOperator, Boolean>());
        }
        catch (ParseException pe) {
            throw new FrontendException(pe.getMessage(), pe);
        }
        if (storePlan.getRoots().size() == 0) {
            throw new RuntimeException("Store plan has no roots!");
        }
        return storePlan;
    }

    static String unquote(String s) {
        return StringUtils.unescapeInputString(s.substring(1, s.length() - 1));
    }

    static int undollar(String s) {
        return Integer.parseInt(s.substring(1, s.length()));
    }

    static Path getCurrentDir(PigContext pigContext) throws IOException {
        DataStorage dfs = pigContext.getDfs();
        ContainerDescriptor desc = dfs.getActiveContainer();
        ElementDescriptor el = dfs.asElement(desc);
        return new Path(el.toString());
    }

    LogicalOperator parseCogroup(ArrayList<CogroupInput> gis, LogicalPlan lp, LOCogroup.GROUPTYPE type) throws ParseException, PlanException {
        log.trace((Object)"Entering parseCogroup");
        log.debug((Object)("LogicalPlan: " + lp));
        int n = gis.size();
        log.debug((Object)("Number of cogroup inputs = " + n));
        ArrayList<LogicalOperator> los = new ArrayList<LogicalOperator>();
        ArrayList<ArrayList<LogicalPlan>> plans = new ArrayList<ArrayList<LogicalPlan>>();
        MultiMap<LogicalOperator, LogicalPlan> groupByPlans = new MultiMap<LogicalOperator, LogicalPlan>();
        boolean[] isInner = new boolean[n];
        int arity = gis.get((int)0).plans.size();
        for (int i = 0; i < n; ++i) {
            CogroupInput gi = gis.get(i);
            los.add(gi.op);
            ArrayList<LogicalPlan> planList = gi.plans;
            plans.add(gi.plans);
            int numGrpByOps = planList.size();
            log.debug((Object)("Number of group by operators = " + numGrpByOps));
            if (arity != numGrpByOps) {
                throw new ParseException("The arity of the group by columns do not match.");
            }
            for (int j = 0; j < numGrpByOps; ++j) {
                groupByPlans.put(gi.op, planList.get(j));
                for (LogicalOperator root : planList.get(j).getRoots()) {
                    log.debug((Object)("Cogroup input plan root: " + root));
                }
            }
            isInner[i] = gi.isInner;
        }
        LOCogroup cogroup = new LOCogroup(lp, new OperatorKey(this.scope, this.getNextId()), groupByPlans, type, isInner);
        lp.add(cogroup);
        log.debug((Object)("Added operator " + cogroup.getClass().getName() + " object " + cogroup + " to the logical plan " + lp));
        for (LogicalOperator op : los) {
            lp.connect(op, cogroup);
            log.debug((Object)("Connected operator " + op.getClass().getName() + " to " + cogroup.getClass().getName() + " in the logical plan"));
        }
        log.trace((Object)"Exiting parseCogroup");
        return cogroup;
    }

    private LogicalOperator parseUsingForGroupBy(String modifier, ArrayList<CogroupInput> gis, LogicalPlan lp) throws ParseException, PlanException {
        if (modifier.equalsIgnoreCase("collected")) {
            if (gis.size() != 1) {
                throw new ParseException("Collected group is only supported for single input");
            }
            if (!this.isColumnProjectionsOrStar(gis.get(0))) {
                throw new ParseException("Collected group is only supported for columns or star projection");
            }
            LogicalOperator cogroup = this.parseCogroup(gis, lp, LOCogroup.GROUPTYPE.COLLECTED);
            cogroup.pinOption(LOCogroup.OPTION_GROUPTYPE);
            return cogroup;
        }
        if (modifier.equalsIgnoreCase("regular")) {
            LogicalOperator cogroup = this.parseCogroup(gis, lp, LOCogroup.GROUPTYPE.REGULAR);
            cogroup.pinOption(LOCogroup.OPTION_GROUPTYPE);
            return cogroup;
        }
        if (modifier.equalsIgnoreCase("merge")) {
            LogicalOperator cogroup = this.parseCogroup(gis, lp, LOCogroup.GROUPTYPE.MERGE);
            cogroup.pinOption(LOCogroup.OPTION_GROUPTYPE);
            return cogroup;
        }
        throw new ParseException("Only COLLECTED, REGULAR or MERGE are valid GROUP modifiers.");
    }

    LogicalOperator parseJoin(ArrayList<CogroupInput> gis, LogicalPlan lp, LOJoin.JOINTYPE jt) throws ParseException, PlanException {
        log.trace((Object)"Entering parseJoin");
        int n = gis.size();
        if (jt == LOJoin.JOINTYPE.SKEWED && n != 2) {
            throw new ParseException("Skewed join can only be applied for 2-way joins");
        }
        if (jt == LOJoin.JOINTYPE.MERGE && n != 2) {
            throw new ParseException("Merge join can only be applied for 2-way joins");
        }
        ArrayList<LogicalOperator> los = new ArrayList<LogicalOperator>();
        ArrayList<ArrayList<LogicalPlan>> plans = new ArrayList<ArrayList<LogicalPlan>>();
        LinkedMultiMap<LogicalOperator, LogicalPlan> joinPlans = new LinkedMultiMap<LogicalOperator, LogicalPlan>();
        boolean[] isInner = new boolean[n];
        int arity = gis.get((int)0).plans.size();
        for (int i = 0; i < n; ++i) {
            CogroupInput gi = gis.get(i);
            los.add(gi.op);
            ArrayList<LogicalPlan> planList = gi.plans;
            plans.add(gi.plans);
            int numJoinOps = planList.size();
            log.debug((Object)("Number of join operators = " + numJoinOps));
            if (arity != numJoinOps) {
                throw new ParseException("The arity of the join columns do not match.");
            }
            for (int j = 0; j < numJoinOps; ++j) {
                joinPlans.put(gi.op, planList.get(j));
                for (LogicalOperator root : planList.get(j).getRoots()) {
                    log.debug((Object)("Join input plan root: " + root));
                }
            }
            isInner[i] = gi.isInner;
        }
        LOJoin loj = new LOJoin(lp, new OperatorKey(this.scope, this.getNextId()), joinPlans, jt, isInner);
        lp.add(loj);
        log.debug((Object)("Added operator " + loj.getClass().getName() + " object " + loj + " to the logical plan " + lp));
        for (LogicalOperator op : los) {
            lp.connect(op, loj);
            log.debug((Object)("Connected operator " + op.getClass().getName() + " to " + loj.getClass().getName() + " in the logical plan"));
        }
        log.trace((Object)"Exiting parseJoin");
        return loj;
    }

    LogicalOperator rewriteJoin(ArrayList<CogroupInput> gis, LogicalPlan lp) throws ParseException, PlanException {
        log.trace((Object)"Entering rewriteJoin");
        log.debug((Object)("LogicalPlan: " + lp));
        int n = gis.size();
        ArrayList<LOProject> flattenedColumns = new ArrayList<LOProject>();
        ArrayList<LogicalPlan> generatePlans = new ArrayList<LogicalPlan>();
        ArrayList<Boolean> flattenList = new ArrayList<Boolean>();
        for (int i = 0; i < n; ++i) {
            gis.get((int)i).isInner = true;
        }
        LogicalOperator cogroup = this.parseCogroup(gis, lp, LOCogroup.GROUPTYPE.REGULAR);
        lp.add(cogroup);
        log.debug((Object)("Added operator " + cogroup.getClass().getName() + " to the logical plan"));
        for (int i = 0; i < n; ++i) {
            LogicalPlan projectPlan = new LogicalPlan();
            LogicalOperator projectInput = cogroup;
            LOProject column = new LOProject(projectPlan, new OperatorKey(this.scope, this.getNextId()), projectInput, i + 1);
            flattenList.add(true);
            flattenedColumns.add(column);
            projectPlan.add(column);
            if (projectInput instanceof ExpressionOperator) {
                projectPlan.add(projectInput);
                projectPlan.connect(projectInput, column);
            }
            log.debug((Object)("parseCogroup: Added operator " + column.getClass().getName() + " " + column + " to logical plan " + projectPlan));
            generatePlans.add(projectPlan);
        }
        LOForEach foreach = new LOForEach(lp, new OperatorKey(this.scope, this.getNextId()), generatePlans, flattenList);
        lp.add(foreach);
        log.debug((Object)("Added operator " + foreach.getClass().getName() + " to the logical plan"));
        lp.connect(cogroup, foreach);
        log.debug((Object)("Connected operator " + cogroup.getClass().getName() + " to opeator " + foreach.getClass().getName() + " in the logical plan " + lp));
        log.trace((Object)"Exiting rewriteJoin");
        return foreach;
    }

    private LogicalOperator parseUsingForJoin(String modifier, ArrayList<CogroupInput> gis, LogicalPlan lp, boolean isFullOuter, boolean isRightOuter, boolean isOuter) throws ParseException, PlanException {
        if (modifier.equalsIgnoreCase("repl") || modifier.equalsIgnoreCase("replicated")) {
            if (isFullOuter || isRightOuter) {
                throw new ParseException("Replicated join does not support (right|full) outer joins");
            }
            LogicalOperator joinOp = this.parseJoin(gis, lp, LOJoin.JOINTYPE.REPLICATED);
            joinOp.pinOption(LOJoin.OPTION_JOIN);
            return joinOp;
        }
        if (modifier.equalsIgnoreCase("hash") || modifier.equalsIgnoreCase("default")) {
            LogicalOperator joinOp = this.parseJoin(gis, lp, LOJoin.JOINTYPE.HASH);
            joinOp.pinOption(LOJoin.OPTION_JOIN);
            return joinOp;
        }
        if (modifier.equalsIgnoreCase("skewed")) {
            LogicalOperator joinOp = this.parseJoin(gis, lp, LOJoin.JOINTYPE.SKEWED);
            joinOp.pinOption(LOJoin.OPTION_JOIN);
            return joinOp;
        }
        if (modifier.equalsIgnoreCase("merge")) {
            LogicalOperator joinOp = this.parseJoin(gis, lp, LOJoin.JOINTYPE.MERGE);
            joinOp.pinOption(LOJoin.OPTION_JOIN);
            return joinOp;
        }
        throw new ParseException("Only REPL, REPLICATED, HASH, SKEWED and MERGE are vaild JOIN modifiers.");
    }

    void assertAtomic(LogicalOperator spec, boolean desiredAtomic) throws ParseException {
        Boolean isAtomic = null;
        if (spec instanceof LOConst || spec instanceof LOUserFunc && DataType.isAtomic(((LOUserFunc)spec).getType())) {
            isAtomic = true;
        } else if (spec instanceof LOUserFunc) {
            isAtomic = false;
        }
        if (isAtomic != null && isAtomic != desiredAtomic) {
            if (desiredAtomic) {
                throw new ParseException("Atomic field expected but found non-atomic field");
            }
            throw new ParseException("Non-atomic field expected but found atomic field");
        }
    }

    void addSplitOutput(LogicalPlan lp, LOSplit splitOp, String alias, LogicalPlan condPlan, int index) throws PlanException {
        LOSplitOutput splitOutput = new LOSplitOutput(lp, new OperatorKey(this.scope, this.getNextId()), index, condPlan);
        splitOp.addOutput(splitOutput);
        this.addAlias(alias, splitOutput);
        splitOutput.setAlias(alias);
        this.addLogicalPlan(splitOutput, lp);
        lp.add(splitOutput);
        log.debug((Object)("Added alias: " + splitOutput.getAlias() + " class: " + splitOutput.getClass().getName() + " to the logical plan"));
        lp.connect(splitOp, splitOutput);
        log.debug((Object)("Connected " + splitOp.getClass().getName() + " to class: " + splitOutput.getClass().getName() + " in the logical plan"));
    }

    void addAlias(String alias, LogicalOperator lOp) {
        this.mapAliasOp.put(alias, lOp);
    }

    LogicalOperator getOp(String alias) {
        return this.mapAliasOp.get(alias);
    }

    Set<String> getRemoteHosts(String absolutePath, String defaultHost) {
        String[] fnames;
        String HAR_PREFIX = "hdfs-";
        HashSet<String> result = new HashSet<String>();
        for (String fname : fnames = absolutePath.split(",")) {
            String scheme;
            Path p = new Path(fname = fname.trim());
            URI uri = p.toUri();
            if (!uri.isAbsolute() || ((scheme = uri.getScheme()) == null || !scheme.toLowerCase().equals("hdfs")) && !scheme.toLowerCase().equals("har") || uri.getHost() == null) continue;
            String thisHost = uri.getHost().toLowerCase();
            if (scheme.toLowerCase().equals("har") && thisHost.startsWith(HAR_PREFIX)) {
                thisHost = thisHost.substring(HAR_PREFIX.length());
            }
            if (uri.getHost().isEmpty() || thisHost.equals(defaultHost)) continue;
            if (uri.getPort() != -1) {
                result.add("hdfs://" + thisHost + ":" + uri.getPort());
                continue;
            }
            result.add("hdfs://" + thisHost);
        }
        return result;
    }

    void setHdfsServers(String absolutePath, PigContext pigContext) throws URISyntaxException {
        String defaultFS = (String)pigContext.getProperties().get("fs.default.name");
        URI defaultFSURI = new URI(defaultFS);
        String defaultHost = defaultFSURI.getHost();
        if (defaultHost == null) {
            defaultHost = "";
        }
        defaultHost = defaultHost.toLowerCase();
        Set<String> remoteHosts = this.getRemoteHosts(absolutePath, defaultHost);
        String hdfsServersString = (String)pigContext.getProperties().get("mapreduce.job.hdfs-servers");
        if (hdfsServersString == null) {
            hdfsServersString = "";
        }
        String[] hdfsServers = hdfsServersString.split(",");
        for (String remoteHost : remoteHosts) {
            boolean existing = false;
            for (String hdfsServer : hdfsServers) {
                if (!hdfsServer.equals(remoteHost)) continue;
                existing = true;
            }
            if (existing) continue;
            if (!hdfsServersString.isEmpty()) {
                hdfsServersString = hdfsServersString + ",";
            }
            hdfsServersString = hdfsServersString + remoteHost;
        }
        if (!hdfsServersString.isEmpty()) {
            pigContext.getProperties().setProperty("mapreduce.job.hdfs-servers", hdfsServersString);
        }
    }

    private void checkAutoShipSpecs(StreamingCommand command, String[] argv) throws ParseException {
        String arg0 = argv[0];
        if (arg0.equalsIgnoreCase(PERL) || arg0.equalsIgnoreCase(PYTHON)) {
            for (int i = 1; i < argv.length; ++i) {
                if (argv[i].startsWith("-") || this.isQuotedString(argv[i])) continue;
                this.checkAndShip(command, argv[i]);
                break;
            }
        } else {
            this.checkAndShip(command, arg0);
        }
    }

    private void checkAndShip(StreamingCommand command, String arg) throws ParseException {
        if (arg.startsWith("/")) {
            return;
        }
        String argPath = QueryParser.which(arg);
        if (argPath != null && !this.inSkipPaths(argPath)) {
            try {
                command.addPathToShip(argPath);
            }
            catch (IOException e) {
                ParseException pe = new ParseException(e.getMessage());
                pe.initCause(e);
                throw pe;
            }
        }
    }

    private boolean isQuotedString(String s) {
        return s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'';
    }

    private boolean inSkipPaths(String file) {
        for (String skipPath : this.pigContext.getPathsToSkip()) {
            if (!file.startsWith(skipPath)) continue;
            return true;
        }
        return false;
    }

    private static String which(String file) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("which", file);
            Process process = processBuilder.start();
            BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String fullPath = stdout.readLine();
            return process.waitFor() == 0 ? fullPath : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String[] splitArgs(String command) throws ParseException {
        ArrayList<String> argv = new ArrayList<String>();
        int beginIndex = 0;
        while (beginIndex < command.length()) {
            int endIndex;
            while (Character.isWhitespace(command.charAt(beginIndex))) {
                ++beginIndex;
            }
            char delim = ' ';
            char charAtIndex = command.charAt(beginIndex);
            if (charAtIndex == '\'' || charAtIndex == '\"') {
                delim = charAtIndex;
            }
            if ((endIndex = command.indexOf(delim, beginIndex + 1)) == -1) {
                if (Character.isWhitespace(delim)) {
                    argv.add(command.substring(beginIndex));
                    break;
                }
                throw new ParseException("Illegal command: " + command);
            }
            if (Character.isWhitespace(delim)) {
                argv.add(command.substring(beginIndex, endIndex));
            } else {
                argv.add(command.substring(beginIndex, endIndex + 1));
            }
            beginIndex = endIndex + 1;
        }
        return argv.toArray(new String[argv.size()]);
    }

    boolean insideGenerate() {
        return this.insideGenerate;
    }

    void setInsideGenerate(boolean b) {
        this.insideGenerate = b;
    }

    List<LogicalOperator> getGenerateInputs() {
        return this.generateInputs;
    }

    void resetGenerateInputs() {
        this.generateInputs.clear();
    }

    void addGenerateInput(LogicalOperator op) {
        this.generateInputs.add(op);
    }

    void resetGenerateState() {
        this.insideGenerate = false;
        this.resetGenerateInputs();
    }

    boolean checkGenerateInput(LogicalOperator in) {
        if (null == this.generateInputs) {
            return false;
        }
        for (LogicalOperator op : this.generateInputs) {
            if (op != in) continue;
            return true;
        }
        return false;
    }

    public void addLogicalPlan(LogicalOperator op, LogicalPlan plan) {
        this.aliases.put(op, plan);
    }

    public LogicalPlan getLogicalPlan(LogicalOperator op) {
        return this.aliases.get(op);
    }

    public static void attachPlan(LogicalPlan lp, LogicalOperator root, LogicalPlan rootPlan, Map<LogicalOperator, Boolean> rootProcessed) throws ParseException {
        log.trace((Object)"Entering attachPlan");
        if (null == rootProcessed) {
            rootProcessed = new HashMap<LogicalOperator, Boolean>();
        }
        if (rootProcessed.get(root) != null && rootProcessed.get(root).booleanValue()) {
            log.trace((Object)"Root has been processed");
            log.trace((Object)"Exiting attachPlan");
            return;
        }
        lp.add(root);
        log.debug((Object)("Added operator " + root + " to the logical plan " + lp));
        if (null == rootPlan.getPredecessors(root)) {
            log.trace((Object)"Exiting attachPlan");
            return;
        }
        for (LogicalOperator rootPred : rootPlan.getPredecessors(root)) {
            QueryParser.attachPlan(lp, rootPred, rootPlan, rootProcessed);
            rootProcessed.put(rootPred, true);
            try {
                lp.connect(rootPred, root);
                log.debug((Object)("Connected operator " + rootPred + " to " + root + " in the logical plan " + lp));
            }
            catch (FrontendException fee) {
                ParseException pe = new ParseException(fee.getMessage());
                pe.initCause(fee);
                throw pe;
            }
        }
        log.trace((Object)"Exiting attachPlan");
    }

    boolean isColumnProjectionsOrStar(CogroupInput cgi) {
        if (cgi == null || cgi.plans == null || cgi.plans.size() == 0) {
            return false;
        }
        for (LogicalPlan keyPlan : cgi.plans) {
            for (LogicalOperator op : keyPlan) {
                if (op instanceof LOProject) continue;
                return false;
            }
        }
        return true;
    }

    static String constructFileNameSignature(String fileName, FuncSpec funcSpec) {
        return fileName + "_" + funcSpec.toString();
    }

    ExpressionOperator attachColPosToReadScalar(LogicalPlan lp, ExpressionOperator expr, int colNum, Schema over) throws PlanException, FrontendException {
        this.scalarFound = false;
        LOConst rconst = new LOConst(lp, new OperatorKey(this.scope, this.getNextId()), (Object)colNum);
        rconst.setType((byte)10);
        lp.add(rconst);
        lp.connect(rconst, expr);
        return expr;
    }

    public final LogicalPlan Parse() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(0);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        LogicalOperator root = null;
        LogicalPlan lp = new LogicalPlan();
        log.trace((Object)"Entering Parse");
        try {
            if (this.jj_2_1(3)) {
                Token t1 = this.jj_consume_token(76);
                this.jj_consume_token(86);
                Token t2 = this.jj_consume_token(76);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        this.jj_consume_token(27);
                        this.jj_consume_token(87);
                        this.TupleSchema();
                        this.jj_consume_token(88);
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                    }
                }
                this.jj_consume_token(89);
                throw new ParseException("Currently PIG does not support assigning an existing relation (" + t1.image + ") to another alias (" + t2.image + ")");
            }
            if (this.jj_2_2(2)) {
                Token t1 = this.jj_consume_token(76);
                this.jj_consume_token(86);
                root = this.Expr(lp);
                this.jj_consume_token(89);
                root.setAlias(t1.image);
                this.addAlias(t1.image, root);
                this.pigContext.setLastAlias(t1.image);
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 36: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 67: 
                    case 68: 
                    case 76: 
                    case 87: {
                        root = this.Expr(lp);
                        this.jj_consume_token(89);
                        break;
                    }
                    case 22: {
                        this.jj_consume_token(22);
                        root = this.SplitClause(lp);
                        this.jj_consume_token(89);
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if (null != root) {
                try {
                    log.debug((Object)("Adding " + root.getAlias() + " " + root + " to the lookup table " + this.aliases));
                    ProjectStarTranslator translate = new ProjectStarTranslator(lp);
                    translate.visit();
                    this.addLogicalPlan(root, lp);
                    log.debug((Object)("Root: " + root.getClass().getName() + " schema: " + root.getSchema()));
                }
                catch (FrontendException fee) {
                    ParseException pe = new ParseException(fee.getMessage());
                    pe.initCause(fee);
                    throw pe;
                }
            }
            ArrayList<LogicalOperator> roots = new ArrayList<LogicalOperator>(lp.getRoots().size());
            for (LogicalOperator op : lp.getRoots()) {
                roots.add(op);
            }
            HashMap<LogicalOperator, Boolean> rootProcessed = new HashMap<LogicalOperator, Boolean>();
            for (LogicalOperator op : roots) {
                LogicalPlan rootPlan = this.aliases.get(op);
                if (null == rootPlan) continue;
                QueryParser.attachPlan(lp, op, rootPlan, rootProcessed);
                rootProcessed.put(op, true);
            }
            log.trace((Object)"Exiting Parse");
            LogicalPlan logicalPlan = lp;
            return logicalPlan;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator SplitClause(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(1);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        int index = 0;
        log.trace((Object)"Entering SplitClause");
        try {
            LogicalOperator input = this.NestedExpr(lp);
            this.jj_consume_token(23);
            LOSplit splitOp = new LOSplit(lp, input.getOperatorKey(), new ArrayList<LogicalOperator>());
            lp.add(splitOp);
            log.debug((Object)("Adding operator " + splitOp.getClass().getName() + " to the logical plan"));
            lp.connect(input, splitOp);
            log.debug((Object)("Connected alias: " + input.getAlias() + " operator " + input.getClass().getName() + " to operator " + splitOp.getClass().getName()));
            Token alias = this.jj_consume_token(76);
            this.jj_consume_token(24);
            LogicalPlan condPlan = new LogicalPlan();
            ExpressionOperator cond = this.PCond(input.getSchema(), null, condPlan, input);
            this.addSplitOutput(lp, splitOp, alias.image, condPlan, index);
            ++index;
            log.debug((Object)"Added splitoutput");
            block8: while (true) {
                this.jj_consume_token(90);
                alias = this.jj_consume_token(76);
                this.jj_consume_token(24);
                condPlan = new LogicalPlan();
                cond = this.PCond(input.getSchema(), null, condPlan, input);
                this.addSplitOutput(lp, splitOp, alias.image, condPlan, index);
                ++index;
                log.debug((Object)"Added splitoutput");
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 90: {
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[2] = this.jj_gen;
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting SplitClause");
            LOSplit lOSplit = splitOp;
            return lOSplit;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator Expr(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(2);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Schema schema = null;
        log.trace((Object)"Entering Expr");
        try {
            LogicalOperator op;
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 76: 
                case 87: {
                    op = this.NestedExpr(lp);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: {
                            this.jj_consume_token(27);
                            this.jj_consume_token(87);
                            schema = this.TupleSchema();
                            this.jj_consume_token(88);
                            Schema.setSchemaDefaultType(schema, (byte)50);
                            op.setSchema(schema);
                            break block2;
                        }
                    }
                    this.jj_la1[3] = this.jj_gen;
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 36: 
                case 56: 
                case 58: 
                case 59: 
                case 67: 
                case 68: {
                    op = this.BaseExpr(lp);
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting Expr");
            LogicalOperator logicalOperator = op;
            return logicalOperator;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator NestedExpr(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(3);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Object specs = null;
        log.trace((Object)"Entering NestedExpr");
        try {
            LogicalOperator op;
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 76: {
                    op = this.Alias(lp);
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    if (this.jj_2_3(2)) {
                        this.jj_consume_token(87);
                        op = this.NestedExpr(lp);
                        this.jj_consume_token(88);
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 87: {
                            this.jj_consume_token(87);
                            op = this.BaseExpr(lp);
                            this.jj_consume_token(88);
                            break block2;
                        }
                    }
                    this.jj_la1[6] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting NestedExpr");
            LogicalOperator logicalOperator = op;
            return logicalOperator;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Token IdentifierOrReserved() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(4);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering IdentifierOrReserved");
        try {
            Token t1;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: {
                    t1 = this.jj_consume_token(9);
                    break;
                }
                case 10: {
                    t1 = this.jj_consume_token(10);
                    break;
                }
                case 11: {
                    t1 = this.jj_consume_token(11);
                    break;
                }
                case 12: {
                    t1 = this.jj_consume_token(12);
                    break;
                }
                case 13: {
                    t1 = this.jj_consume_token(13);
                    break;
                }
                case 14: {
                    t1 = this.jj_consume_token(14);
                    break;
                }
                case 15: {
                    t1 = this.jj_consume_token(15);
                    break;
                }
                case 16: {
                    t1 = this.jj_consume_token(16);
                    break;
                }
                case 17: {
                    t1 = this.jj_consume_token(17);
                    break;
                }
                case 18: {
                    t1 = this.jj_consume_token(18);
                    break;
                }
                case 19: {
                    t1 = this.jj_consume_token(19);
                    break;
                }
                case 20: {
                    t1 = this.jj_consume_token(20);
                    break;
                }
                case 21: {
                    t1 = this.jj_consume_token(21);
                    break;
                }
                case 22: {
                    t1 = this.jj_consume_token(22);
                    break;
                }
                case 23: {
                    t1 = this.jj_consume_token(23);
                    break;
                }
                case 24: {
                    t1 = this.jj_consume_token(24);
                    break;
                }
                case 25: {
                    t1 = this.jj_consume_token(25);
                    break;
                }
                case 26: {
                    t1 = this.jj_consume_token(26);
                    break;
                }
                case 27: {
                    t1 = this.jj_consume_token(27);
                    break;
                }
                case 28: {
                    t1 = this.jj_consume_token(28);
                    break;
                }
                case 29: {
                    t1 = this.jj_consume_token(29);
                    break;
                }
                case 30: {
                    t1 = this.jj_consume_token(30);
                    break;
                }
                case 31: {
                    t1 = this.jj_consume_token(31);
                    break;
                }
                case 34: {
                    t1 = this.jj_consume_token(34);
                    break;
                }
                case 35: {
                    t1 = this.jj_consume_token(35);
                    break;
                }
                case 36: {
                    t1 = this.jj_consume_token(36);
                    break;
                }
                case 37: {
                    t1 = this.jj_consume_token(37);
                    break;
                }
                case 38: {
                    t1 = this.jj_consume_token(38);
                    break;
                }
                case 39: {
                    t1 = this.jj_consume_token(39);
                    break;
                }
                case 40: {
                    t1 = this.jj_consume_token(40);
                    break;
                }
                case 41: {
                    t1 = this.jj_consume_token(41);
                    break;
                }
                case 42: {
                    t1 = this.jj_consume_token(42);
                    break;
                }
                case 43: {
                    t1 = this.jj_consume_token(43);
                    break;
                }
                case 44: {
                    t1 = this.jj_consume_token(44);
                    break;
                }
                case 45: {
                    t1 = this.jj_consume_token(45);
                    break;
                }
                case 46: {
                    t1 = this.jj_consume_token(46);
                    break;
                }
                case 47: {
                    t1 = this.jj_consume_token(47);
                    break;
                }
                case 48: {
                    t1 = this.jj_consume_token(48);
                    break;
                }
                case 49: {
                    t1 = this.jj_consume_token(49);
                    break;
                }
                case 50: {
                    t1 = this.jj_consume_token(50);
                    break;
                }
                case 51: {
                    t1 = this.jj_consume_token(51);
                    break;
                }
                case 52: {
                    t1 = this.jj_consume_token(52);
                    break;
                }
                case 53: {
                    t1 = this.jj_consume_token(53);
                    break;
                }
                case 54: {
                    t1 = this.jj_consume_token(54);
                    break;
                }
                case 55: {
                    t1 = this.jj_consume_token(55);
                    break;
                }
                case 56: {
                    t1 = this.jj_consume_token(56);
                    break;
                }
                case 57: {
                    t1 = this.jj_consume_token(57);
                    break;
                }
                case 58: {
                    t1 = this.jj_consume_token(58);
                    break;
                }
                case 59: {
                    t1 = this.jj_consume_token(59);
                    break;
                }
                case 60: {
                    t1 = this.jj_consume_token(60);
                    break;
                }
                case 61: {
                    t1 = this.jj_consume_token(61);
                    break;
                }
                case 62: {
                    t1 = this.jj_consume_token(62);
                    break;
                }
                case 63: {
                    t1 = this.jj_consume_token(63);
                    break;
                }
                case 64: {
                    t1 = this.jj_consume_token(64);
                    break;
                }
                case 65: {
                    t1 = this.jj_consume_token(65);
                    break;
                }
                case 66: {
                    t1 = this.jj_consume_token(66);
                    break;
                }
                case 67: {
                    t1 = this.jj_consume_token(67);
                    break;
                }
                case 68: {
                    t1 = this.jj_consume_token(68);
                    break;
                }
                case 69: {
                    t1 = this.jj_consume_token(69);
                    break;
                }
                case 70: {
                    t1 = this.jj_consume_token(70);
                    break;
                }
                case 71: {
                    t1 = this.jj_consume_token(71);
                    break;
                }
                case 76: {
                    t1 = this.jj_consume_token(76);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            Token token = t1;
            return token;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogicalOperator Alias(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(5);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering Alias");
        try {
            Token t1 = this.jj_consume_token(76);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            String alias = t1.image;
            LogicalOperator aliasOp = this.getOp(alias);
            if (aliasOp == null) {
                throw new ParseException("Unrecognized alias " + alias);
            }
            this.addAlias(alias, aliasOp);
            log.debug((Object)("Added " + alias + " to aliasOp"));
            lp.add(aliasOp);
            log.debug((Object)("Added operator: " + aliasOp.getClass().getName() + " to the logical plan " + lp));
            log.trace((Object)"Exiting Alias");
            LogicalOperator logicalOperator = aliasOp;
            return logicalOperator;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator BaseExpr(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(6);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering BaseExpr");
        String partitioner = null;
        try {
            LogicalOperator distinct;
            LogicalOperator op;
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    this.jj_consume_token(10);
                    op = this.DefineClause(lp);
                    break;
                }
                case 11: {
                    this.jj_consume_token(11);
                    op = this.LoadClause(lp);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: {
                            this.jj_consume_token(27);
                            if (this.jj_2_4(2)) {
                                this.jj_consume_token(87);
                                Schema schema = this.TupleSchema();
                                this.jj_consume_token(88);
                                Schema.setSchemaDefaultType(schema, (byte)50);
                                op.setSchema(schema);
                                log.debug((Object)("Load as schema" + schema));
                                break block2;
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 76: {
                                    Schema.FieldSchema fs = this.AtomSchema();
                                    Schema schema = new Schema(fs);
                                    op.setSchema(schema);
                                    log.debug((Object)("Load as atomschema" + schema));
                                    break block2;
                                }
                            }
                            this.jj_la1[8] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_la1[9] = this.jj_gen;
                    break;
                }
                case 18: 
                case 36: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 36: {
                            this.jj_consume_token(36);
                            break;
                        }
                        case 18: {
                            this.jj_consume_token(18);
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    op = this.CogroupClause(lp);
                    break;
                }
                case 12: {
                    this.jj_consume_token(12);
                    op = this.FilterClause(lp);
                    break;
                }
                case 67: {
                    this.jj_consume_token(67);
                    op = this.LimitClause(lp);
                    break;
                }
                case 68: {
                    this.jj_consume_token(68);
                    op = this.SampleClause(lp);
                    break;
                }
                case 15: {
                    this.jj_consume_token(15);
                    op = this.OrderClause(lp);
                    break;
                }
                case 17: {
                    this.jj_consume_token(17);
                    op = this.NestedExpr(lp);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            this.jj_consume_token(35);
                            this.jj_consume_token(28);
                            partitioner = this.EvalClass((byte)2);
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                        }
                    }
                    distinct = new LODistinct(lp, new OperatorKey(this.scope, this.getNextId()));
                    lp.add(distinct);
                    distinct.setCustomPartitioner(partitioner);
                    log.debug((Object)("Added operator: " + distinct.getClass().getName() + " to the logical plan"));
                    lp.connect(op, distinct);
                    log.debug((Object)("Connected alias: " + op.getAlias() + " operator " + op.getClass().getName() + " to operator " + distinct.getClass().getName()));
                    op = distinct;
                    break;
                }
                case 20: {
                    this.jj_consume_token(20);
                    op = this.CrossClause(lp);
                    break;
                }
                case 19: {
                    this.jj_consume_token(19);
                    op = this.JoinClause(lp);
                    break;
                }
                case 21: {
                    this.jj_consume_token(21);
                    op = this.UnionClause(lp);
                    break;
                }
                case 13: {
                    this.jj_consume_token(13);
                    op = this.ForEachClause(lp);
                    break;
                }
                case 56: {
                    this.jj_consume_token(56);
                    op = this.StreamClause(lp);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: {
                            this.jj_consume_token(27);
                            if (this.jj_2_5(2)) {
                                this.jj_consume_token(87);
                                Schema schema = this.TupleSchema();
                                this.jj_consume_token(88);
                                Schema.setSchemaDefaultType(schema, (byte)50);
                                op.setSchema(schema);
                                log.debug((Object)("Stream as schema()" + schema));
                                break block2;
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 76: {
                                    Schema.FieldSchema fs = this.AtomSchema();
                                    Schema schema = new Schema(fs);
                                    op.setSchema(schema);
                                    log.debug((Object)("Stream as atomschema()" + schema));
                                    break block2;
                                }
                            }
                            this.jj_la1[12] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_la1[13] = this.jj_gen;
                    break;
                }
                case 58: {
                    this.jj_consume_token(58);
                    op = this.StoreClause(lp);
                    String inputAlias = ((LOStore)op).getAlias();
                    LogicalOperator input = this.mapAliasOp.get(inputAlias);
                    if (input == null) {
                        throw new ParseException("Unable to find alias " + inputAlias);
                    }
                    lp.add(input);
                    lp.connect(input, op);
                    break;
                }
                case 59: {
                    this.jj_consume_token(59);
                    op = this.MapReduceClause(lp);
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 34: {
                    this.jj_consume_token(34);
                    Token t2 = this.jj_consume_token(78);
                    if (this.pigContext.getExecType() == ExecType.LOCAL) {
                        op.setRequestedParallelism(1);
                        break;
                    }
                    op.setRequestedParallelism(Integer.parseInt(t2.image));
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting BaseExpr");
            distinct = op;
            return distinct;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator LoadClause(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(7);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Object funcArgs = null;
        FuncSpec funcSpec = null;
        String funcSpecAsString = null;
        LOLoad lo = null;
        boolean splittable = true;
        log.trace((Object)"Entering LoadClause");
        try {
            String filename = this.FileName();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    this.jj_consume_token(29);
                    funcSpec = this.NonEvalFuncSpec((byte)8);
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if (funcSpec == null) {
                funcSpecAsString = PigStorage.class.getName();
                funcSpec = new FuncSpec(funcSpecAsString);
                log.debug((Object)("LoadClause: funcSpec = " + funcSpec));
            }
            Object obj = PigContext.instantiateFuncFromSpec(funcSpec);
            LoadFunc loFunc = (LoadFunc)obj;
            try {
                String absolutePath = this.fileNameMap.get(QueryParser.constructFileNameSignature(filename, funcSpec));
                if (absolutePath == null) {
                    absolutePath = loFunc.relativeToAbsolutePath(filename, QueryParser.getCurrentDir(this.pigContext));
                    if (absolutePath != null) {
                        this.setHdfsServers(absolutePath, this.pigContext);
                    }
                    this.fileNameMap.put(QueryParser.constructFileNameSignature(filename, funcSpec), absolutePath);
                }
                lo = new LOLoad(lp, new OperatorKey(this.scope, this.getNextId()), new FileSpec(absolutePath, funcSpec), ConfigurationUtil.toConfiguration(this.pigContext.getProperties()));
            }
            catch (IOException ioe) {
                Error e = new Error(ioe);
                throw e;
            }
            lp.add(lo);
            log.debug((Object)("Added operator " + lo.getClass().getName() + " to the logical plan"));
            log.trace((Object)"Exiting LoadClause");
            LOLoad lOLoad = lo;
            return lOLoad;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String StringList() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(8);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        StringBuilder sb = new StringBuilder();
        try {
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 82: {
                    Token t = this.jj_consume_token(82);
                    sb.append(StringUtils.unescapeInputString(t.image));
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 90: {
                                break;
                            }
                            default: {
                                this.jj_la1[17] = this.jj_gen;
                                break block1;
                            }
                        }
                        this.jj_consume_token(90);
                        t = this.jj_consume_token(82);
                        sb.append(",");
                        sb.append(StringUtils.unescapeInputString(t.image));
                    }
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.debug((Object)("StringList: " + sb.toString()));
            String string = sb.toString();
            return string;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String FunctionArgs() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(9);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        StringBuilder sb = new StringBuilder();
        try {
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 82: 
                case 83: {
                    Token t;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 83: {
                            t = this.jj_consume_token(83);
                            sb.append(StringUtils.unescapeInputString(t.image));
                            break;
                        }
                        case 82: {
                            t = this.jj_consume_token(82);
                            sb.append(StringUtils.unescapeInputString(t.image));
                            break;
                        }
                        default: {
                            this.jj_la1[19] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    block17: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 90: {
                                break;
                            }
                            default: {
                                this.jj_la1[20] = this.jj_gen;
                                break block1;
                            }
                        }
                        this.jj_consume_token(90);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 83: {
                                t = this.jj_consume_token(83);
                                sb.append(",");
                                sb.append(StringUtils.unescapeInputString(t.image));
                                continue block17;
                            }
                            case 82: {
                                t = this.jj_consume_token(82);
                                sb.append(",");
                                sb.append(StringUtils.unescapeInputString(t.image));
                                continue block17;
                            }
                        }
                        break;
                    }
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.debug((Object)("FuncArgs: " + sb.toString()));
            String string = sb.toString();
            return string;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator MapReduceClause(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(10);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        String[] params = null;
        try {
            Token t1 = this.jj_consume_token(82);
            String nativeMRJar = QueryParser.unquote(t1.image);
            this.pigContext.addJar(nativeMRJar);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    String[] paths;
                    this.jj_consume_token(87);
                    for (String path : paths = this.PathList()) {
                        this.pigContext.addJar(path);
                    }
                    this.jj_consume_token(88);
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                }
            }
            this.jj_consume_token(58);
            LogicalOperator loStore = this.StoreClause(lp);
            ((LOStore)loStore).setTmpStore(true);
            String inputAlias = ((LOStore)loStore).getAlias();
            LogicalOperator input = this.mapAliasOp.get(inputAlias);
            if (input == null) {
                throw new ParseException("Unable to find alias " + inputAlias);
            }
            lp.add(input);
            lp.connect(input, loStore);
            this.jj_consume_token(11);
            LogicalOperator loLoad = this.LoadClause(lp);
            block5 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: {
                    this.jj_consume_token(27);
                    if (this.jj_2_6(2)) {
                        this.jj_consume_token(87);
                        Schema schema = this.TupleSchema();
                        this.jj_consume_token(88);
                        Schema.setSchemaDefaultType(schema, (byte)50);
                        loLoad.setSchema(schema);
                        log.debug((Object)("Load as schema" + schema));
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 76: {
                            Schema.FieldSchema fs = this.AtomSchema();
                            Schema schema = new Schema(fs);
                            loLoad.setSchema(schema);
                            log.debug((Object)("Load as atomschema" + schema));
                            break block5;
                        }
                    }
                    this.jj_la1[24] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 84: {
                    Token t2 = this.jj_consume_token(84);
                    params = QueryParser.splitArgs(QueryParser.unquote(t2.image));
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            LONative loNative = new LONative(lp, new OperatorKey(this.scope, this.getNextId()), nativeMRJar, params);
            lp.add(loNative);
            lp.connect(loStore, loNative);
            lp.connect(loNative, loLoad);
            LogicalOperator logicalOperator = loLoad;
            return logicalOperator;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String FileName() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(11);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            Token t = this.jj_consume_token(82);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.debug((Object)("FileName: " + QueryParser.unquote(t.image)));
            String string = QueryParser.unquote(t.image);
            return string;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator FilterClause(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(12);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        LogicalPlan conditionPlan = new LogicalPlan();
        log.trace((Object)"Entering FilterClause");
        try {
            LogicalOperator input = this.NestedExpr(lp);
            log.debug((Object)("Filter input: " + input));
            this.jj_consume_token(28);
            ExpressionOperator cond = this.PCond(input.getSchema(), null, conditionPlan, input);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            LOFilter filter = new LOFilter(lp, new OperatorKey(this.scope, this.getNextId()), conditionPlan);
            this.addAlias(input.getAlias(), input);
            lp.add(filter);
            log.debug((Object)("Added operator " + filter.getClass().getName() + " to the logical plan"));
            lp.connect(input, filter);
            log.debug((Object)("Connected alias " + input.getAlias() + " operator " + input.getClass().getName() + " to operator " + filter.getClass().getName() + " in the logical plan"));
            log.trace((Object)"Exiting FilterClause");
            LOFilter lOFilter = filter;
            return lOFilter;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator SampleClause(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(13);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        LogicalPlan conditionPlan = new LogicalPlan();
        log.trace((Object)"Entering SampleClause");
        try {
            LogicalOperator input = this.NestedExpr(lp);
            log.debug((Object)("Filter input: " + input));
            Token t = this.jj_consume_token(80);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            LOUserFunc rand = new LOUserFunc(conditionPlan, new OperatorKey(this.scope, this.getNextId()), new FuncSpec(RANDOM.class.getName()), 25);
            conditionPlan.add(rand);
            double l = Double.parseDouble(t.image);
            LOConst prob = new LOConst(conditionPlan, new OperatorKey(this.scope, this.getNextId()), l);
            conditionPlan.add(prob);
            LOLesserThanEqual cond = new LOLesserThanEqual(conditionPlan, new OperatorKey(this.scope, this.getNextId()));
            conditionPlan.add(cond);
            conditionPlan.connect(rand, cond);
            conditionPlan.connect(prob, cond);
            LOFilter filter = new LOFilter(lp, new OperatorKey(this.scope, this.getNextId()), conditionPlan);
            this.addAlias(input.getAlias(), input);
            lp.add(filter);
            log.debug((Object)("Added operator " + filter.getClass().getName() + " to the logical plan"));
            lp.connect(input, filter);
            log.debug((Object)("Connected alias " + input.getAlias() + " operator " + input.getClass().getName() + " to operator " + filter.getClass().getName() + " in the logical plan"));
            log.trace((Object)"Exiting SampleClause");
            LOFilter lOFilter = filter;
            return lOFilter;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator LimitClause(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(14);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering LimitClause");
        try {
            long l;
            LogicalOperator input = this.NestedExpr(lp);
            log.debug((Object)("Limit input: " + input));
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 78: {
                    Token t = this.jj_consume_token(78);
                    l = Long.parseLong(t.image);
                    break;
                }
                case 79: {
                    Token t = this.jj_consume_token(79);
                    l = Long.parseLong(t.image.substring(0, t.image.length() - 1));
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            LOLimit limit = new LOLimit(lp, new OperatorKey(this.scope, this.getNextId()), l);
            this.addAlias(input.getAlias(), input);
            lp.add(limit);
            log.debug((Object)("Added operator " + limit.getClass().getName() + " to the logical plan"));
            lp.connect(input, limit);
            log.debug((Object)("Connected alias " + input.getAlias() + " operator " + input.getClass().getName() + " to operator " + limit.getClass().getName() + " in the logical plan"));
            log.trace((Object)"Exiting LimitClause");
            LOLimit lOLimit = limit;
            return lOLimit;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator PCond(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(15);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        ExpressionOperator cond = null;
        log.trace((Object)"Entering PCond");
        log.debug((Object)("PCond Input: " + input));
        try {
            cond = this.POrCond(over, specs, lp, input);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting PCond");
            ExpressionOperator expressionOperator = cond;
            return expressionOperator;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator POrCond(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(16);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering POrCond");
        log.debug((Object)("POrCond Input: " + input));
        try {
            ExpressionOperator exprOp;
            ExpressionOperator lhsCond = this.PAndCond(over, specs, lp, input);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 38: {
                        break;
                    }
                    default: {
                        this.jj_la1[28] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(38);
                ExpressionOperator rhsCond = this.PAndCond(over, specs, lp, input);
                exprOp = new LOOr(lp, new OperatorKey(this.scope, this.getNextId()));
                lp.add(exprOp);
                log.debug((Object)("POrCond: Added operator " + exprOp.getClass().getName() + " " + exprOp + " to logical plan " + lp));
                lp.connect(lhsCond, exprOp);
                log.debug((Object)("POrCond: Connected operator " + lhsCond.getClass().getName() + " " + lhsCond + " to " + exprOp + " logical plan " + lp));
                lp.connect(rhsCond, exprOp);
                log.debug((Object)("POrCond: Connected operator " + rhsCond.getClass().getName() + " " + rhsCond + " to " + exprOp + " logical plan " + lp));
                lhsCond = exprOp;
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting POrCond");
            exprOp = lhsCond;
            return exprOp;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator PAndCond(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(17);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering PAndCond");
        log.debug((Object)("PAndCond Input: " + input));
        try {
            ExpressionOperator exprOp;
            ExpressionOperator lhsCond = this.PUnaryCond(over, specs, lp, input);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 37: {
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(37);
                ExpressionOperator rhsCond = this.PUnaryCond(over, specs, lp, input);
                exprOp = new LOAnd(lp, new OperatorKey(this.scope, this.getNextId()));
                lp.add(exprOp);
                log.debug((Object)("PAndCond: Added operator " + exprOp.getClass().getName() + " " + exprOp + " to logical plan " + lp));
                lp.connect(lhsCond, exprOp);
                log.debug((Object)("PAndCond: Connected operator " + lhsCond.getClass().getName() + " " + lhsCond + " to " + exprOp + " logical plan " + lp));
                lp.connect(rhsCond, exprOp);
                log.debug((Object)("PAndCond: Connected operator " + rhsCond.getClass().getName() + " " + rhsCond + " to " + exprOp + " logical plan " + lp));
                lhsCond = exprOp;
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting PAndCond");
            exprOp = lhsCond;
            return exprOp;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator PUnaryCond(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(18);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        ExpressionOperator cond = null;
        Object evalFunc = null;
        log.trace((Object)"Entering PUnaryCond");
        try {
            ExpressionOperator rconst;
            if (this.jj_2_7(Integer.MAX_VALUE)) {
                this.jj_consume_token(87);
                cond = this.PCond(over, specs, lp, input);
                this.jj_consume_token(88);
            } else if (this.jj_2_8(Integer.MAX_VALUE)) {
                ExpressionOperator lhs = this.InfixExpr(over, specs, lp, input);
                Token t1 = this.jj_consume_token(9);
                ExpressionOperator rhs = this.InfixExpr(over, specs, lp, input);
                String op = t1.image;
                op = op.toLowerCase();
                char op1 = op.charAt(0);
                int op2 = op.length() >= 2 ? (int)op.charAt(1) : 48;
                int op3 = op.length() == 3 ? (int)op.charAt(2) : 48;
                switch (op1) {
                    case '=': {
                        if (op2 == 61) {
                            cond = new LOEqual(lp, new OperatorKey(this.scope, this.getNextId()));
                            break;
                        }
                        throw new ParseException("Internal error: Invalid filter operator: " + op);
                    }
                    case '<': {
                        if (op2 == 61) {
                            cond = new LOLesserThanEqual(lp, new OperatorKey(this.scope, this.getNextId()));
                            break;
                        }
                        cond = new LOLesserThan(lp, new OperatorKey(this.scope, this.getNextId()));
                        break;
                    }
                    case '>': {
                        if (op2 == 61) {
                            cond = new LOGreaterThanEqual(lp, new OperatorKey(this.scope, this.getNextId()));
                            break;
                        }
                        cond = new LOGreaterThan(lp, new OperatorKey(this.scope, this.getNextId()));
                        break;
                    }
                    case '!': {
                        if (op2 == 61) {
                            cond = new LONotEqual(lp, new OperatorKey(this.scope, this.getNextId()));
                            break;
                        }
                        throw new ParseException("Internal error: Invalid filter operator: " + op);
                    }
                    case 'e': {
                        if (op2 == 113) {
                            cond = new LOEqual(lp, new OperatorKey(this.scope, this.getNextId()));
                            break;
                        }
                        throw new ParseException("Internal error: Invalid filter operator: " + op);
                    }
                    case 'l': {
                        if (op2 == 116 && op3 == 101) {
                            cond = new LOLesserThanEqual(lp, new OperatorKey(this.scope, this.getNextId()));
                            break;
                        }
                        cond = new LOLesserThan(lp, new OperatorKey(this.scope, this.getNextId()));
                        break;
                    }
                    case 'g': {
                        if (op2 == 116 && op3 == 101) {
                            cond = new LOGreaterThanEqual(lp, new OperatorKey(this.scope, this.getNextId()));
                            break;
                        }
                        cond = new LOGreaterThan(lp, new OperatorKey(this.scope, this.getNextId()));
                        break;
                    }
                    case 'n': {
                        if (op2 == 101 && op3 == 113) {
                            cond = new LONotEqual(lp, new OperatorKey(this.scope, this.getNextId()));
                            break;
                        }
                        throw new ParseException("Internal error: Invalid filter operator: " + op);
                    }
                    default: {
                        throw new ParseException("Internal error: Invalid filter operator: " + op);
                    }
                }
                lp.add(cond);
                log.debug((Object)("PUnaryCond: Added operator " + cond.getClass().getName() + " " + cond + " to logical plan " + lp));
                lp.connect(lhs, cond);
                log.debug((Object)("PUnaryCond: Connected operator " + lhs.getClass().getName() + " " + lhs + " to " + cond + " logical plan " + lp));
                lp.connect(rhs, cond);
                log.debug((Object)("PUnaryCond: Connected operator " + rhs.getClass().getName() + " " + rhs + " to " + cond + " logical plan " + lp));
            } else if (this.jj_2_9(Integer.MAX_VALUE)) {
                ExpressionOperator lhs = this.InfixExpr(over, specs, lp, input);
                this.jj_consume_token(14);
                Token t1 = this.jj_consume_token(82);
                rconst = new LOConst(lp, new OperatorKey(this.scope, this.getNextId()), QueryParser.unquote(t1.image));
                rconst.setType((byte)55);
                cond = new LORegexp(lp, new OperatorKey(this.scope, this.getNextId()));
                lp.add(rconst);
                lp.add(cond);
                log.debug((Object)("PUnaryCond: Added operator " + cond.getClass().getName() + " " + cond + " to logical plan " + lp));
                lp.connect(lhs, cond);
                lp.connect(rconst, cond);
                log.debug((Object)("PUnaryCond: Connected operator " + cond.getClass().getName() + " " + cond + " to " + lhs + " logical plan " + lp));
            } else if (this.jj_2_10(Integer.MAX_VALUE)) {
                cond = this.EvalFuncSpec(over, specs, lp, input, (byte)2);
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 36: 
                    case 55: 
                    case 76: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 85: 
                    case 87: 
                    case 99: 
                    case 103: 
                    case 109: {
                        cond = this.PNullCond(over, specs, lp, input);
                        break;
                    }
                    case 39: {
                        cond = this.PNotCond(over, specs, lp, input);
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting PUnaryCond");
            rconst = cond;
            return rconst;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator PNotCond(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(19);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering PNotCond");
        try {
            this.jj_consume_token(39);
            ExpressionOperator c1 = this.PUnaryCond(over, specs, lp, input);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            LONot eOp = new LONot(lp, new OperatorKey(this.scope, this.getNextId()));
            lp.add(eOp);
            log.debug((Object)("PNotCond: Added operator " + eOp.getClass().getName() + " " + eOp + " to logical plan " + lp));
            lp.connect(c1, eOp);
            log.debug((Object)("PNotCond: Connected operator " + eOp.getClass().getName() + " " + eOp + " to " + c1 + " logical plan " + lp));
            log.trace((Object)"Exiting PNotCond");
            LONot lONot = eOp;
            return lONot;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator PNullCond(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(20);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        boolean not = false;
        log.trace((Object)"Entering PNullCond");
        try {
            ExpressionOperator c1 = this.InfixExpr(over, specs, lp, input);
            this.jj_consume_token(54);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 39: {
                    this.jj_consume_token(39);
                    not = true;
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                }
            }
            this.jj_consume_token(55);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            UnaryExpressionOperator eOp = new LOIsNull(lp, new OperatorKey(this.scope, this.getNextId()));
            lp.add(eOp);
            log.debug((Object)("PNullCond: Added operator " + eOp.getClass().getName() + " " + eOp + " to logical plan " + lp));
            lp.connect(c1, eOp);
            log.debug((Object)("PNullCond: Connected operator " + eOp.getClass().getName() + " " + eOp + " to " + c1 + " logical plan " + lp));
            LONot notNull = null;
            if (not) {
                notNull = new LONot(lp, new OperatorKey(this.scope, this.getNextId()));
                lp.add(notNull);
                log.debug((Object)("PNullCond: Added operator " + notNull.getClass().getName() + " " + notNull + " to logical plan " + lp));
                lp.connect(eOp, notNull);
                log.debug((Object)("PNullCond: Connected operator " + notNull.getClass().getName() + " " + notNull + " to " + eOp + " logical plan " + lp));
                eOp = notNull;
            }
            log.trace((Object)"Exiting PNullCond");
            LOIsNull lOIsNull = eOp;
            return lOIsNull;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator CogroupClause(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(21);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        ArrayList<CogroupInput> gis = new ArrayList<CogroupInput>();
        LogicalOperator cogroup = null;
        log.trace((Object)"Entering CoGroupClause");
        String partitioner = null;
        try {
            CogroupInput gi = this.GroupItem(lp);
            gis.add(gi);
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 90: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block21;
                    }
                }
                this.jj_consume_token(90);
                gi = this.GroupItem(lp);
                gis.add(gi);
            }
            block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    this.jj_consume_token(29);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 82: {
                            Token t = this.jj_consume_token(82);
                            cogroup = this.parseUsingForGroupBy(QueryParser.unquote(t.image), gis, lp);
                            break block6;
                        }
                        case 91: {
                            this.jj_consume_token(91);
                            log.info((Object)"[WARN] Use of double-quoted string to specify hint is deprecated. Please specify hint in single quotes.");
                            cogroup = this.parseUsingForGroupBy("collected", gis, lp);
                            break block6;
                        }
                        case 92: {
                            this.jj_consume_token(92);
                            log.info((Object)"[WARN] Use of double-quoted string to specify hint is deprecated. Please specify hint in single quotes.");
                            cogroup = this.parseUsingForGroupBy("regular", gis, lp);
                            break block6;
                        }
                        case 93: {
                            this.jj_consume_token(93);
                            log.info((Object)"[WARN] Use of double-quoted string to specify hint is deprecated. Please specify hint in single quotes.");
                            cogroup = this.parseUsingForGroupBy("merge", gis, lp);
                            break block6;
                        }
                    }
                    this.jj_la1[33] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    this.jj_consume_token(35);
                    this.jj_consume_token(28);
                    partitioner = this.EvalClass((byte)2);
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if (cogroup != null) {
                cogroup.setCustomPartitioner(partitioner);
                log.trace((Object)"Exiting CoGroupClause");
                LogicalOperator logicalOperator = cogroup;
                return logicalOperator;
            }
            cogroup = this.parseCogroup(gis, lp, LOCogroup.GROUPTYPE.REGULAR);
            if (cogroup != null) {
                cogroup.setCustomPartitioner(partitioner);
            }
            log.trace((Object)"Exiting CoGroupClause");
            LogicalOperator logicalOperator = cogroup;
            return logicalOperator;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final CogroupInput JoinItem(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(22);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        boolean isInner = true;
        ArrayList<LogicalPlan> listPlans = new ArrayList<LogicalPlan>();
        ArrayList<Boolean> flattenList = new ArrayList<Boolean>();
        ArrayList<Schema> userDefinedSchemaList = new ArrayList<Schema>();
        log.trace((Object)"Entering JoinItem");
        log.debug((Object)("LogicalPlan: " + lp));
        try {
            LogicalOperator cgOp = this.NestedExpr(lp);
            this.jj_consume_token(28);
            if (this.jj_2_11(Integer.MAX_VALUE)) {
                this.jj_consume_token(87);
                LogicalPlan groupByPlan = new LogicalPlan();
                this.FlattenedGenerateItem(cgOp.getSchema(), null, groupByPlan, cgOp, flattenList, userDefinedSchemaList);
                listPlans.add(groupByPlan);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 90: {
                            break;
                        }
                        default: {
                            this.jj_la1[36] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(90);
                    groupByPlan = new LogicalPlan();
                    this.FlattenedGenerateItem(cgOp.getSchema(), null, groupByPlan, cgOp, flattenList, userDefinedSchemaList);
                    listPlans.add(groupByPlan);
                }
                this.jj_consume_token(88);
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: 
                    case 36: 
                    case 41: 
                    case 55: 
                    case 76: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 85: 
                    case 87: 
                    case 99: 
                    case 103: 
                    case 109: {
                        LogicalPlan groupByPlan = new LogicalPlan();
                        this.FlattenedGenerateItem(cgOp.getSchema(), null, groupByPlan, cgOp, flattenList, userDefinedSchemaList);
                        listPlans.add(groupByPlan);
                        break;
                    }
                    default: {
                        this.jj_la1[37] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            CogroupInput cogroupInput = new CogroupInput();
            cogroupInput.plans = listPlans;
            cogroupInput.op = cgOp;
            cogroupInput.isInner = isInner;
            log.trace((Object)"Exiting GroupItem");
            CogroupInput cogroupInput2 = cogroupInput;
            return cogroupInput2;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final CogroupInput GroupItem(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(23);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        boolean isInner = false;
        ArrayList<LogicalPlan> listPlans = new ArrayList<LogicalPlan>();
        ArrayList<Boolean> flattenList = new ArrayList<Boolean>();
        ArrayList<Schema> userDefinedSchemaList = new ArrayList<Schema>();
        log.trace((Object)"Entering GroupItem");
        log.debug((Object)("LogicalPlan: " + lp));
        try {
            LogicalOperator cgOp = this.NestedExpr(lp);
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 28: {
                    this.jj_consume_token(28);
                    if (this.jj_2_12(Integer.MAX_VALUE)) {
                        this.jj_consume_token(87);
                        LogicalPlan groupByPlan = new LogicalPlan();
                        ExpressionOperator es = this.FlattenedGenerateItem(cgOp.getSchema(), null, groupByPlan, cgOp, flattenList, userDefinedSchemaList);
                        listPlans.add(groupByPlan);
                        block23: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 90: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[38] = this.jj_gen;
                                    break block23;
                                }
                            }
                            this.jj_consume_token(90);
                            groupByPlan = new LogicalPlan();
                            es = this.FlattenedGenerateItem(cgOp.getSchema(), null, groupByPlan, cgOp, flattenList, userDefinedSchemaList);
                            listPlans.add(groupByPlan);
                        }
                        this.jj_consume_token(88);
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 33: 
                        case 36: 
                        case 41: 
                        case 55: 
                        case 76: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 85: 
                        case 87: 
                        case 99: 
                        case 103: 
                        case 109: {
                            LogicalPlan groupByPlan = new LogicalPlan();
                            ExpressionOperator es = this.FlattenedGenerateItem(cgOp.getSchema(), null, groupByPlan, cgOp, flattenList, userDefinedSchemaList);
                            listPlans.add(groupByPlan);
                            break block2;
                        }
                    }
                    this.jj_la1[39] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                case 25: {
                    this.jj_consume_token(25);
                    LogicalPlan groupByPlan = new LogicalPlan();
                    LOConst es = new LOConst(groupByPlan, new OperatorKey(this.scope, this.getNextId()), "all");
                    es.setType((byte)55);
                    groupByPlan.add(es);
                    log.debug((Object)("GroupItem: Added operator " + es.getClass().getName() + " " + es + " to logical plan " + groupByPlan));
                    listPlans.add(groupByPlan);
                    break;
                }
                case 26: {
                    this.jj_consume_token(26);
                    LogicalPlan groupByPlan = new LogicalPlan();
                    LOUserFunc es = new LOUserFunc(groupByPlan, new OperatorKey(this.scope, this.getNextId()), new FuncSpec(GFAny.class.getName()), 10);
                    groupByPlan.add(es);
                    log.debug((Object)("GroupItem: Added operator " + es.getClass().getName() + " " + es + " to logical plan " + groupByPlan));
                    listPlans.add(groupByPlan);
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block13 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: 
                case 31: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 30: {
                            this.jj_consume_token(30);
                            isInner = true;
                            break block13;
                        }
                        case 31: {
                            this.jj_consume_token(31);
                            break block13;
                        }
                    }
                    this.jj_la1[41] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            CogroupInput cogroupInput = new CogroupInput();
            cogroupInput.plans = listPlans;
            cogroupInput.op = cgOp;
            cogroupInput.isInner = isInner;
            log.trace((Object)"Exiting GroupItem");
            CogroupInput cogroupInput2 = cogroupInput;
            return cogroupInput2;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator OrderClause(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(24);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        boolean star = false;
        ArrayList sortCols = new ArrayList();
        ArrayList<LogicalPlan> sortColPlans = new ArrayList<LogicalPlan>();
        ArrayList<Boolean> ascOrder = new ArrayList<Boolean>();
        boolean asc = true;
        Object funcName = null;
        FuncSpec funcSpec = null;
        log.trace((Object)"Entering OrderClause");
        try {
            LogicalOperator op = this.NestedExpr(lp);
            this.jj_consume_token(28);
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: 
                case 76: 
                case 85: 
                case 87: {
                    ExpressionOperator col = this.SortCol(op.getSchema(), lp, op, ascOrder, sortColPlans);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 90: {
                                break;
                            }
                            default: {
                                this.jj_la1[43] = this.jj_gen;
                                break block2;
                            }
                        }
                        this.jj_consume_token(90);
                        col = this.SortCol(op.getSchema(), lp, op, ascOrder, sortColPlans);
                    }
                }
                case 33: {
                    this.jj_consume_token(33);
                    star = true;
                    block9 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 43: 
                        case 44: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 43: {
                                    this.jj_consume_token(43);
                                    break block9;
                                }
                                case 44: {
                                    this.jj_consume_token(44);
                                    asc = false;
                                    break block9;
                                }
                            }
                            this.jj_la1[44] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[45] = this.jj_gen;
                        }
                    }
                    LogicalPlan sortColPlan = new LogicalPlan();
                    LOProject projectStar = new LOProject(sortColPlan, new OperatorKey(this.scope, this.getNextId()), op, -1);
                    projectStar.setStar(true);
                    sortColPlan.add(projectStar);
                    sortColPlans.add(sortColPlan);
                    log.debug((Object)"Set star to true");
                    if (asc) {
                        ascOrder.add(true);
                        break;
                    }
                    ascOrder.add(false);
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    this.jj_consume_token(29);
                    funcSpec = this.NonEvalFuncSpec((byte)4);
                    break;
                }
                default: {
                    this.jj_la1[47] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            LOSort sort = new LOSort(lp, new OperatorKey(this.scope, this.getNextId()), sortColPlans, ascOrder, funcSpec);
            sort.setStar(star);
            sort.setLimit(-1L);
            lp.add(sort);
            log.debug((Object)("Added operator " + sort.getClass().getName() + " to the logical plan"));
            lp.connect(op, sort);
            log.debug((Object)("Connecting sort input alias " + op.getAlias() + " operator " + op.getClass().getName() + " to operator " + sort.getClass().getName() + " in the logical plan"));
            log.trace((Object)"Exiting OrderClause");
            LOSort lOSort = sort;
            return lOSort;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator SortCol(Schema over, LogicalPlan lp, LogicalOperator op, ArrayList<Boolean> ascOrder, ArrayList<LogicalPlan> sortColPlans) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(25);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        boolean asc = true;
        LogicalPlan sortColPlan = new LogicalPlan();
        log.trace((Object)"Entering SortCol");
        try {
            LOProject col;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: 
                case 76: 
                case 85: {
                    int colNum = this.ColNameOrNum(op.getSchema());
                    block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 43: 
                        case 44: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 43: {
                                    this.jj_consume_token(43);
                                    break block6;
                                }
                                case 44: {
                                    this.jj_consume_token(44);
                                    asc = false;
                                    break block6;
                                }
                            }
                            this.jj_la1[48] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[49] = this.jj_gen;
                        }
                    }
                    if (asc) {
                        log.debug((Object)"Ascending");
                        ascOrder.add(true);
                    } else {
                        log.debug((Object)"Descending");
                        ascOrder.add(false);
                    }
                    col = new LOProject(sortColPlan, new OperatorKey(this.scope, this.getNextId()), op, colNum);
                    sortColPlan.add(col);
                    sortColPlans.add(sortColPlan);
                    break;
                }
                case 87: {
                    this.jj_consume_token(87);
                    int colNum = this.ColNameOrNum(op.getSchema());
                    this.jj_consume_token(88);
                    block13 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 43: 
                        case 44: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 43: {
                                    this.jj_consume_token(43);
                                    break block13;
                                }
                                case 44: {
                                    this.jj_consume_token(44);
                                    asc = false;
                                    break block13;
                                }
                            }
                            this.jj_la1[50] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[51] = this.jj_gen;
                        }
                    }
                    if (asc) {
                        log.debug((Object)"Ascending");
                        ascOrder.add(true);
                    } else {
                        log.debug((Object)"Descending");
                        ascOrder.add(false);
                    }
                    col = new LOProject(sortColPlan, new OperatorKey(this.scope, this.getNextId()), op, colNum);
                    sortColPlan.add(col);
                    sortColPlans.add(sortColPlan);
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting SortCol");
            LOProject lOProject = col;
            return lOProject;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final int ColNameOrNum(Schema over) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(26);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering ColNameOrNum");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 85: {
                    Token t = this.jj_consume_token(85);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    int n = QueryParser.undollar(t.image);
                    return n;
                }
                case 76: {
                    int i;
                    Token t = this.jj_consume_token(76);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    try {
                        if (over == null || (i = over.getPosition(t.image)) == -1) {
                            throw new ParseException("Invalid alias: " + t.image + " in " + over);
                        }
                    }
                    catch (FrontendException fee) {
                        ParseException pe = new ParseException(fee.getMessage());
                        pe.initCause(fee);
                        throw pe;
                    }
                    log.trace((Object)"Exiting ColNameOrNum");
                    int fee = i;
                    return fee;
                }
                case 36: {
                    int i;
                    Token t = this.jj_consume_token(36);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    try {
                        if (over == null || (i = over.getPosition(t.image)) == -1) {
                            throw new ParseException("Invalid alias: " + t.image + " in " + over);
                        }
                    }
                    catch (FrontendException fee) {
                        ParseException pe = new ParseException(fee.getMessage());
                        pe.initCause(fee);
                        throw pe;
                    }
                    log.trace((Object)"Exiting ColNameOrNum");
                    int n = i;
                    return n;
                }
            }
            this.jj_la1[53] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator CrossClause(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(27);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        ArrayList<LogicalOperator> inputs = new ArrayList<LogicalOperator>();
        String partitioner = null;
        log.trace((Object)"Entering CrossClause");
        try {
            LogicalOperator op = this.NestedExpr(lp);
            inputs.add(op);
            block11: while (true) {
                this.jj_consume_token(90);
                op = this.NestedExpr(lp);
                inputs.add(op);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 90: {
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[54] = this.jj_gen;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    this.jj_consume_token(35);
                    this.jj_consume_token(28);
                    partitioner = this.EvalClass((byte)2);
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            LOCross cross = new LOCross(lp, new OperatorKey(this.scope, this.getNextId()));
            lp.add(cross);
            cross.setCustomPartitioner(partitioner);
            log.debug((Object)("Added operator " + cross.getClass().getName() + " to the logical plan"));
            for (LogicalOperator lop : inputs) {
                lp.connect(lop, cross);
                log.debug((Object)("Connected operator " + lop.getClass().getName() + " " + lop + " to " + cross + " logical plan " + lp));
            }
            log.debug((Object)"Connected cross inputs to the cross operator");
            log.trace((Object)"Exiting CrossClause");
            LOCross lOCross = cross;
            return lOCross;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator JoinClause(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(28);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        ArrayList<CogroupInput> gis = new ArrayList<CogroupInput>();
        log.trace((Object)"Entering JoinClause");
        log.debug((Object)("LogicalPlan: " + lp));
        LogicalOperator joinOp = null;
        boolean isLeftOuter = false;
        boolean isRightOuter = false;
        boolean isFullOuter = false;
        boolean isOuter = false;
        String partitioner = null;
        try {
            CogroupInput gi = this.JoinItem(lp);
            gis.add(gi);
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 69: 
                case 70: 
                case 71: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 69: {
                            this.jj_consume_token(69);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 31: {
                                    this.jj_consume_token(31);
                                    break;
                                }
                                default: {
                                    this.jj_la1[56] = this.jj_gen;
                                }
                            }
                            isLeftOuter = true;
                            break block2;
                        }
                        case 70: {
                            this.jj_consume_token(70);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 31: {
                                    this.jj_consume_token(31);
                                    break;
                                }
                                default: {
                                    this.jj_la1[57] = this.jj_gen;
                                }
                            }
                            isRightOuter = true;
                            break block2;
                        }
                        case 71: {
                            this.jj_consume_token(71);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 31: {
                                    this.jj_consume_token(31);
                                    break;
                                }
                                default: {
                                    this.jj_la1[58] = this.jj_gen;
                                }
                            }
                            isFullOuter = true;
                            break block2;
                        }
                    }
                    this.jj_la1[59] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                }
            }
            block46: while (true) {
                this.jj_consume_token(90);
                gi = this.JoinItem(lp);
                gis.add(gi);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 90: {
                        continue block46;
                    }
                }
                break;
            }
            this.jj_la1[61] = this.jj_gen;
            boolean bl = isOuter = isLeftOuter || isRightOuter || isFullOuter;
            if (isOuter && gis.size() > 2) {
                throw new ParseException("(left|right|full) outer joins are only supported for two inputs");
            }
            if (isLeftOuter) {
                ((CogroupInput)gis.get((int)1)).isInner = false;
            } else if (isRightOuter) {
                ((CogroupInput)gis.get((int)0)).isInner = false;
            } else if (isFullOuter) {
                ((CogroupInput)gis.get((int)0)).isInner = false;
                ((CogroupInput)gis.get((int)1)).isInner = false;
            }
            block22 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    this.jj_consume_token(29);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 82: {
                            Token t = this.jj_consume_token(82);
                            joinOp = this.parseUsingForJoin(QueryParser.unquote(t.image), gis, lp, isFullOuter, isRightOuter, isOuter);
                            break block22;
                        }
                        case 94: 
                        case 95: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 94: {
                                    this.jj_consume_token(94);
                                    break;
                                }
                                case 95: {
                                    this.jj_consume_token(95);
                                    break;
                                }
                                default: {
                                    this.jj_la1[62] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            log.info((Object)"[WARN] Use of double-quotes for specifying join algorithm is deprecated. Please use single quotes.");
                            joinOp = this.parseUsingForJoin("replicated", gis, lp, isFullOuter, isRightOuter, isOuter);
                            break block22;
                        }
                        case 96: {
                            this.jj_consume_token(96);
                            log.info((Object)"[WARN] Use of double-quotes for specifying join algorithm is deprecated. Please use single quotes.");
                            joinOp = this.parseUsingForJoin("skewed", gis, lp, isFullOuter, isRightOuter, isOuter);
                            break block22;
                        }
                        case 93: {
                            this.jj_consume_token(93);
                            log.info((Object)"[WARN] Use of double-quotes for specifying join algorithm is deprecated. Please use single quotes.");
                            joinOp = this.parseUsingForJoin("merge", gis, lp, isFullOuter, isRightOuter, isOuter);
                            break block22;
                        }
                        case 97: 
                        case 98: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 97: {
                                    this.jj_consume_token(97);
                                    break;
                                }
                                case 98: {
                                    this.jj_consume_token(98);
                                    break;
                                }
                                default: {
                                    this.jj_la1[63] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            log.info((Object)"[WARN] Use of double-quotes for specifying join algorithm is deprecated. Please use single quotes.");
                            joinOp = this.parseUsingForJoin("hash", gis, lp, isFullOuter, isRightOuter, isOuter);
                            break block22;
                        }
                    }
                    this.jj_la1[64] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[65] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    this.jj_consume_token(35);
                    this.jj_consume_token(28);
                    partitioner = this.EvalClass((byte)2);
                    break;
                }
                default: {
                    this.jj_la1[66] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting JoinClause");
            if (joinOp == null) {
                joinOp = this.parseJoin(gis, lp, LOJoin.JOINTYPE.HASH);
            }
            if (partitioner != null) {
                if (((LOJoin)joinOp).getJoinType() == LOJoin.JOINTYPE.SKEWED) {
                    throw new ParseException("Custom Partitioner is not supported for skewed join");
                }
                joinOp.setCustomPartitioner(partitioner);
            }
            LogicalOperator logicalOperator = joinOp;
            return logicalOperator;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator UnionClause(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(29);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        boolean isOnSchema = false;
        ArrayList<LogicalOperator> inputs = new ArrayList<LogicalOperator>();
        log.trace((Object)"Entering UnionClause");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    this.jj_consume_token(32);
                    isOnSchema = true;
                    break;
                }
                default: {
                    this.jj_la1[67] = this.jj_gen;
                }
            }
            LogicalOperator op = this.NestedExpr(lp);
            inputs.add(op);
            block14: while (true) {
                this.jj_consume_token(90);
                op = this.NestedExpr(lp);
                inputs.add(op);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 90: {
                        continue block14;
                    }
                }
                break;
            }
            this.jj_la1[68] = this.jj_gen;
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            try {
                LOUnion union = new LOUnion(lp, new OperatorKey(this.scope, this.getNextId()));
                union.setOnSchema(isOnSchema);
                lp.add(union);
                log.debug((Object)("Added operator " + union.getClass().getName() + " to the logical plan"));
                for (LogicalOperator lop : inputs) {
                    lp.connect(lop, union);
                    log.debug((Object)("Connected union input operator " + lop.getClass().getName() + " to operator " + lop.getClass().getName() + " in the logical plan"));
                }
                log.trace((Object)"Exiting UnionClause");
                LOUnion i$ = union;
                return i$;
            }
            catch (Exception e) {
                try {
                    ParseException pe = new ParseException();
                    pe.initCause(e);
                    throw pe;
                }
                catch (Throwable jjte000) {
                    if (jjtc000) {
                        this.jjtree.clearNodeScope(jjtn000);
                        jjtc000 = false;
                    } else {
                        this.jjtree.popNode();
                    }
                    if (jjte000 instanceof RuntimeException) {
                        throw (RuntimeException)jjte000;
                    }
                    if (jjte000 instanceof ParseException) {
                        throw (ParseException)jjte000;
                    }
                    throw (Error)jjte000;
                }
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator ForEachClause(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(30);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        ArrayList<LogicalOperator> specList = new ArrayList<LogicalOperator>();
        LogicalPlan foreachPlan = new LogicalPlan();
        ArrayList<LogicalPlan> foreachPlans = new ArrayList<LogicalPlan>();
        log.trace((Object)"Entering ForEachClause");
        try {
            LogicalOperator input = this.NestedExpr(lp);
            specList = this.NestedBlock(input.getSchema(), specList, foreachPlan, input);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            LOGenerate generate = (LOGenerate)specList.get(specList.size() - 1);
            List<LogicalPlan> generatePlans = generate.getGeneratePlans();
            List<Boolean> flattenList = generate.getFlatten();
            List<Schema> userDefinedSchemaList = generate.getUserDefinedSchema();
            for (int planCtr = 0; planCtr < generatePlans.size(); ++planCtr) {
                LogicalPlan generatePlanClone;
                LogicalPlan generatePlan = generatePlans.get(planCtr);
                List planRoots = new ArrayList(generatePlan.getRoots());
                boolean needGenerateInput = false;
                boolean needForEachInput = false;
                MultiMap<LogicalOperator, LogicalOperator> mapProjectInputs = null;
                HashMap<LogicalOperator, Boolean> rootProcessed = new HashMap<LogicalOperator, Boolean>();
                for (LogicalOperator root : planRoots) {
                    if (!(root instanceof ExpressionOperator) || !this.checkGenerateInput(root)) continue;
                    needGenerateInput = true;
                    QueryParser.attachPlan(generatePlan, root, foreachPlan, rootProcessed);
                    rootProcessed.put(root, true);
                }
                planRoots = generatePlan.getRoots();
                needGenerateInput = false;
                needForEachInput = false;
                for (LogicalOperator root : planRoots) {
                    if (!(root instanceof LOProject)) continue;
                    LOProject project = (LOProject)root;
                    LogicalOperator projectInput = project.getExpression();
                    if (this.checkGenerateInput(projectInput) || !projectInput.equals(input)) {
                        needGenerateInput = true;
                        if (null == mapProjectInputs) {
                            mapProjectInputs = new MultiMap<LogicalOperator, LogicalOperator>();
                        }
                        mapProjectInputs.put(root, projectInput);
                        continue;
                    }
                    needForEachInput = true;
                }
                if (needGenerateInput) {
                    for (LogicalOperator project : mapProjectInputs.keySet()) {
                        for (LogicalOperator projectInput : mapProjectInputs.get(project)) {
                            generatePlan.add(projectInput);
                            generatePlan.connect(projectInput, project);
                            QueryParser.attachPlan(generatePlan, projectInput, foreachPlan, rootProcessed);
                            rootProcessed.put(projectInput, true);
                        }
                    }
                }
                LogicalPlanCloner lpCloner = new LogicalPlanCloner(generatePlan);
                try {
                    generatePlanClone = lpCloner.getClonedPlan();
                }
                catch (CloneNotSupportedException cnse) {
                    ParseException pe = new ParseException("Not able to clone foreach plan");
                    pe.initCause(cnse);
                    throw pe;
                }
                RemoveRedundantOperators removeOperators = new RemoveRedundantOperators(generatePlanClone);
                try {
                    removeOperators.visit();
                }
                catch (VisitorException ve) {
                    ParseException pe = new ParseException("Could not remove redundant operators in foreach plan.");
                    pe.initCause(ve);
                    throw pe;
                }
                foreachPlans.add(generatePlanClone);
            }
            this.resetGenerateState();
            LOForEach foreach = new LOForEach(lp, new OperatorKey(this.scope, this.getNextId()), foreachPlans, (ArrayList)flattenList, (ArrayList)userDefinedSchemaList);
            try {
                lp.add(foreach);
                log.debug((Object)("Added operator " + foreach.getClass().getName() + " to the logical plan"));
                lp.connect(input, foreach);
                log.debug((Object)("Connected alias " + input.getAlias() + " operator " + input.getClass().getName() + " object " + input + " to operator " + foreach.getClass().getName() + " in the logical plan"));
            }
            catch (PlanException planException) {
                ParseException pe = new ParseException(planException.getMessage());
                pe.initCause(planException);
                throw pe;
            }
            log.trace((Object)"Exiting ForEachClause");
            LOForEach lOForEach = foreach;
            return lOForEach;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator StreamClause(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(31);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            LogicalOperator input = this.NestedExpr(lp);
            this.jj_consume_token(57);
            StreamingCommand command = this.Command();
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            LOStream loStream = new LOStream(lp, new OperatorKey(this.scope, this.getNextId()), input, this.pigContext.createExecutableManager(), command);
            lp.add(loStream);
            lp.connect(input, loStream);
            LOStream lOStream = loStream;
            return lOStream;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final StreamingCommand Command() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(32);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 84: {
                    Token t = this.jj_consume_token(84);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    String[] argv = QueryParser.splitArgs(QueryParser.unquote(t.image));
                    StreamingCommand command = new StreamingCommand(this.pigContext, argv);
                    this.checkAutoShipSpecs(command, argv);
                    StreamingCommand streamingCommand = command;
                    return streamingCommand;
                }
                case 76: {
                    Token t = this.jj_consume_token(76);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    StreamingCommand command = this.pigContext.getCommandForAlias(t.image);
                    if (command == null) {
                        throw new ParseException("Undefined command-alias: " + t.image + " used as stream operator");
                    }
                    StreamingCommand streamingCommand = command;
                    return streamingCommand;
                }
            }
            this.jj_la1[69] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final LogicalOperator DefineClause(LogicalPlan lp) throws ParseException {
        jjtn000 = new SimpleNode(33);
        jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            t = this.jj_consume_token(76);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 84: {
                    cmd = this.jj_consume_token(84);
                    command = new StreamingCommand(this.pigContext, QueryParser.splitArgs(QueryParser.unquote(cmd.image)));
                    block23: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: {
                                break;
                            }
                            default: {
                                this.jj_la1[70] = this.jj_gen;
                                ** GOTO lbl100
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 60: {
                                this.jj_consume_token(60);
                                this.jj_consume_token(87);
                                paths = this.PathList();
                                this.jj_consume_token(88);
                                if (paths.length == 0) {
                                    command.setShipFiles(false);
                                    continue block23;
                                }
                                arr$ = paths;
                                len$ = arr$.length;
                                i$ = 0;
                                while (true) {
                                    if (i$ >= len$) continue block23;
                                    path = arr$[i$];
                                    try {
                                        command.addPathToShip(path);
                                    }
                                    catch (IOException e) {
                                        pe = new ParseException(e.getMessage());
                                        pe.initCause(e);
                                        throw pe;
                                    }
                                    ++i$;
                                }
                            }
                            case 61: {
                                this.jj_consume_token(61);
                                this.jj_consume_token(87);
                                paths = this.PathList();
                                this.jj_consume_token(88);
                                arr$ = paths;
                                len$ = arr$.length;
                                i$ = 0;
                                while (true) {
                                    if (i$ >= len$) continue block23;
                                    path = arr$[i$];
                                    try {
                                        command.addPathToCache(path);
                                    }
                                    catch (IOException e) {
                                        pe = new ParseException(e.getMessage());
                                        pe.initCause(e);
                                        throw pe;
                                    }
                                    ++i$;
                                }
                            }
                            case 62: {
                                this.jj_consume_token(62);
                                this.jj_consume_token(87);
                                this.InputOutputSpec(command, StreamingCommand.Handle.INPUT);
                                this.jj_consume_token(88);
                                continue block23;
                            }
                            case 63: {
                                this.jj_consume_token(63);
                                this.jj_consume_token(87);
                                this.InputOutputSpec(command, StreamingCommand.Handle.OUTPUT);
                                this.jj_consume_token(88);
                                continue block23;
                            }
                            case 64: {
                                this.jj_consume_token(64);
                                this.jj_consume_token(87);
                                this.ErrorSpec(command, t.image);
                                this.jj_consume_token(88);
                                continue block23;
                            }
                        }
                        break;
                    }
                    this.jj_la1[71] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
lbl100:
                    // 1 sources

                    this.pigContext.registerStreamCmd(t.image, command);
                    break;
                }
                case 76: {
                    functionName = this.QualifiedFunction();
                    this.jj_consume_token(87);
                    functionArgs = this.StringList();
                    this.jj_consume_token(88);
                    this.pigContext.registerFunction(t.image, new FuncSpec(functionName + "(" + functionArgs + ")"));
                    break;
                }
                default: {
                    this.jj_la1[72] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            lo = new LODefine(lp, new OperatorKey(this.scope, this.getNextId()));
            lp.add(lo);
            var9_8 = lo;
            return var9_8;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] PathList() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(34);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        ArrayList<String> pathList = new ArrayList<String>();
        try {
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 82: {
                    Token t = this.jj_consume_token(82);
                    pathList.add(QueryParser.unquote(t.image));
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 90: {
                                break;
                            }
                            default: {
                                this.jj_la1[73] = this.jj_gen;
                                break block1;
                            }
                        }
                        this.jj_consume_token(90);
                        t = this.jj_consume_token(82);
                        pathList.add(QueryParser.unquote(t.image));
                    }
                }
                default: {
                    this.jj_la1[74] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            String[] stringArray = pathList.toArray(new String[pathList.size()]);
            return stringArray;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void InputOutputSpec(StreamingCommand command, StreamingCommand.Handle handle) throws ParseException {
        block20: {
            SimpleNode jjtn000 = new SimpleNode(35);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            String functionName = PigStreaming.class.getName();
            String functionArgs = "";
            byte funcType = handle.compareTo(StreamingCommand.Handle.INPUT) == 0 ? (byte)32 : 64;
            FuncSpec funcSpec = null;
            try {
                String stream = this.CommandStream();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        this.jj_consume_token(29);
                        funcSpec = this.NonEvalFuncSpec(funcType);
                        break;
                    }
                    default: {
                        this.jj_la1[75] = this.jj_gen;
                    }
                }
                String deserializer = funcSpec == null ? functionName + "(" + ")" : funcSpec.toString();
                command.addHandleSpec(handle, new StreamingCommand.HandleSpec(stream, deserializer));
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 90: {
                            break;
                        }
                        default: {
                            this.jj_la1[76] = this.jj_gen;
                            break block20;
                        }
                    }
                    this.jj_consume_token(90);
                    stream = this.CommandStream();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            this.jj_consume_token(29);
                            funcSpec = this.NonEvalFuncSpec(funcType);
                            break;
                        }
                        default: {
                            this.jj_la1[77] = this.jj_gen;
                        }
                    }
                    deserializer = funcSpec == null ? functionName + "(" + ")" : funcSpec.toString();
                    command.addHandleSpec(handle, new StreamingCommand.HandleSpec(stream, deserializer));
                }
            }
            catch (Throwable jjte000) {
                if (jjtc000) {
                    this.jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                } else {
                    this.jjtree.popNode();
                }
                if (jjte000 instanceof RuntimeException) {
                    throw (RuntimeException)jjte000;
                }
                if (jjte000 instanceof ParseException) {
                    throw (ParseException)jjte000;
                }
                throw (Error)jjte000;
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                }
            }
        }
    }

    public final String CommandStream() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(36);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    Token t = this.jj_consume_token(65);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    String string = "stdin";
                    return string;
                }
                case 66: {
                    Token t = this.jj_consume_token(66);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    String string = "stdout";
                    return string;
                }
                case 82: {
                    Token t = this.jj_consume_token(82);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    String string = QueryParser.unquote(t.image);
                    return string;
                }
            }
            this.jj_la1[78] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void ErrorSpec(StreamingCommand command, String alias) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(37);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        int limit = 100;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 82: {
                    Token t1 = this.jj_consume_token(82);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 67: {
                            this.jj_consume_token(67);
                            Token t2 = this.jj_consume_token(78);
                            limit = Integer.parseInt(t2.image);
                            break;
                        }
                        default: {
                            this.jj_la1[79] = this.jj_gen;
                        }
                    }
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    command.setLogDir(QueryParser.unquote(t1.image));
                    command.setLogFilesLimit(limit);
                    return;
                }
                default: {
                    this.jj_la1[80] = this.jj_gen;
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    command.setLogDir(alias);
                    return;
                }
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator StoreClause(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(38);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Object functionSpec = null;
        FuncSpec funcSpec = null;
        try {
            Token t = this.jj_consume_token(76);
            this.jj_consume_token(23);
            String fileName = this.FileName();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    this.jj_consume_token(29);
                    funcSpec = this.NonEvalFuncSpec((byte)16);
                    break;
                }
                default: {
                    this.jj_la1[81] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if (funcSpec == null) {
                funcSpec = new FuncSpec(PigStorage.class.getName() + "()");
            }
            Object obj = PigContext.instantiateFuncFromSpec(funcSpec);
            StoreFuncInterface stoFunc = (StoreFuncInterface)obj;
            stoFunc.setStoreFuncUDFContextSignature(LOStore.constructSignature(t.image, fileName, funcSpec));
            String absolutePath = this.fileNameMap.get(QueryParser.constructFileNameSignature(fileName, funcSpec));
            if (absolutePath == null) {
                absolutePath = stoFunc.relToAbsPathForStoreLocation(fileName, QueryParser.getCurrentDir(this.pigContext));
                if (absolutePath != null) {
                    this.setHdfsServers(absolutePath, this.pigContext);
                }
                this.fileNameMap.put(QueryParser.constructFileNameSignature(fileName, funcSpec), absolutePath);
            }
            LOStore store = new LOStore(lp, new OperatorKey(this.scope, this.getNextId()), new FileSpec(absolutePath, funcSpec), t.image);
            lp.add(store);
            LOStore lOStore = store;
            return lOStore;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ArrayList<LogicalOperator> NestedBlock(Schema over, ArrayList<LogicalOperator> specList, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(39);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        HashMap<String, LogicalOperator> specs = new HashMap<String, LogicalOperator>();
        log.trace((Object)"Entering NestedBlock");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 40: {
                    LogicalOperator spec = this.GenerateStatement(over, specs, lp, input);
                    specList.add(spec);
                    break;
                }
                case 99: {
                    this.jj_consume_token(99);
                    block12: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 76: {
                                break;
                            }
                            default: {
                                this.jj_la1[82] = this.jj_gen;
                                break block12;
                            }
                        }
                        this.NestedCommand(over, specs, specList, lp, input);
                        this.jj_consume_token(89);
                    }
                    LogicalOperator spec = this.GenerateStatement(over, specs, lp, input);
                    this.jj_consume_token(89);
                    this.jj_consume_token(100);
                    specList.add(spec);
                    break;
                }
                default: {
                    this.jj_la1[83] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting NestedBlock");
            ArrayList<LogicalOperator> arrayList = specList;
            return arrayList;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void NestedCommand(Schema over, Map<String, LogicalOperator> specs, List<LogicalOperator> specList, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(40);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        LogicalOperator eOp = null;
        log.trace((Object)"Entering NestedCommand");
        try {
            LogicalOperator item;
            Token t = this.jj_consume_token(76);
            this.jj_consume_token(86);
            if (this.jj_2_13(Integer.MAX_VALUE)) {
                item = this.InfixExpr(over, specs, lp, input);
                lp.add(item);
            } else if (this.jj_2_14(Integer.MAX_VALUE)) {
                item = eOp = this.NestedProject(over, specs, lp, input);
                lp.add(eOp);
                log.debug((Object)("Added operator " + eOp.getClass().getName() + " " + eOp + " to the logical plan " + lp));
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 36: 
                    case 55: 
                    case 76: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 85: 
                    case 87: 
                    case 99: 
                    case 103: 
                    case 109: {
                        item = this.InfixExpr(over, specs, lp, input);
                        lp.add(item);
                        break;
                    }
                    case 12: {
                        item = this.NestedFilter(over, specs, lp, input);
                        break;
                    }
                    case 15: 
                    case 16: {
                        item = this.NestedSortOrArrange(over, specs, lp, input);
                        break;
                    }
                    case 17: {
                        item = this.NestedDistinct(over, specs, lp, input);
                        break;
                    }
                    case 67: {
                        item = this.NestedLimit(over, specs, lp, input);
                        break;
                    }
                    default: {
                        this.jj_la1[84] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            String alias = t.image;
            item.setAlias(alias);
            specs.put(alias, item);
            log.debug((Object)("Added " + alias + " to the specs map"));
            specList.add(item);
            log.debug((Object)("Added " + alias + " to the specList"));
            log.trace((Object)"Exiting NestedCommand");
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator NestedProject(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(41);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        ArrayList<Integer> colList = new ArrayList<Integer>();
        int i = -1;
        LogicalOperator foreachInput = null;
        Schema subSchema = null;
        log.trace((Object)"Entering NestedFilter");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 76: {
                    Token t = this.jj_consume_token(76);
                    if (null != specs) {
                        foreachInput = specs.get(t.image);
                    }
                    if (null == foreachInput) {
                        try {
                            if (null == over || (i = over.getPosition(t.image)) == -1) {
                                throw new ParseException("Invalid alias: " + t.image + " in " + over);
                            }
                        }
                        catch (FrontendException fee) {
                            ParseException pe = new ParseException(fee.getMessage());
                            pe.initCause(fee);
                            throw pe;
                        }
                        foreachInput = new LOProject(lp, new OperatorKey(this.scope, this.getNextId()), input, i);
                    }
                    try {
                        lp.add(foreachInput);
                        if (!(input instanceof ExpressionOperator)) break;
                        lp.add(input);
                        lp.connect(input, foreachInput);
                        break;
                    }
                    catch (Exception planException) {
                        ParseException pe = new ParseException(planException.getMessage());
                        pe.initCause(planException);
                        throw pe;
                    }
                }
                case 85: {
                    Token t = this.jj_consume_token(85);
                    foreachInput = new LOProject(lp, new OperatorKey(this.scope, this.getNextId()), input, QueryParser.undollar(t.image));
                    break;
                }
                default: {
                    this.jj_la1[85] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            subSchema = foreachInput instanceof ExpressionOperator ? ((ExpressionOperator)foreachInput).getFieldSchema().schema : foreachInput.getSchema();
            this.jj_consume_token(101);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: 
                case 76: 
                case 85: {
                    i = this.ColNameOrNum(subSchema);
                    colList.add(i);
                    break;
                }
                case 87: {
                    this.jj_consume_token(87);
                    i = this.ColNameOrNum(subSchema);
                    colList.add(i);
                    block20: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 90: {
                                break;
                            }
                            default: {
                                this.jj_la1[86] = this.jj_gen;
                                break block20;
                            }
                        }
                        this.jj_consume_token(90);
                        i = this.ColNameOrNum(subSchema);
                        colList.add(i);
                    }
                    this.jj_consume_token(88);
                    break;
                }
                default: {
                    this.jj_la1[87] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            ArrayList<LogicalPlan> foreachPlans = new ArrayList<LogicalPlan>();
            ArrayList<Boolean> flattenList = new ArrayList<Boolean>();
            Iterator i$ = colList.iterator();
            while (i$.hasNext()) {
                int j = (Integer)i$.next();
                LogicalPlan plan = new LogicalPlan();
                LOProject project = new LOProject(plan, new OperatorKey(this.scope, this.getNextId()), foreachInput, j);
                plan.add(project);
                foreachPlans.add(plan);
                flattenList.add(false);
            }
            LOForEach foreach = new LOForEach(lp, new OperatorKey(this.scope, this.getNextId()), foreachPlans, flattenList);
            lp.add(foreach);
            lp.add(foreachInput);
            lp.connect(foreachInput, foreach);
            LOForEach lOForEach = foreach;
            return lOForEach;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator NestedFilter(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(42);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Schema subSchema = null;
        LogicalPlan conditionPlan = new LogicalPlan();
        log.trace((Object)"Entering NestedFilter");
        try {
            LogicalOperator eOp;
            this.jj_consume_token(12);
            if (this.jj_2_15(Integer.MAX_VALUE)) {
                eOp = this.NestedProject(over, specs, lp, input);
            } else if (null != specs.get(this.getToken((int)1).image)) {
                Token t = this.jj_consume_token(76);
                eOp = specs.get(t.image);
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 36: 
                    case 55: 
                    case 76: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 85: 
                    case 87: 
                    case 99: 
                    case 109: {
                        eOp = this.BaseEvalSpec(over, specs, lp, input);
                        break;
                    }
                    default: {
                        this.jj_la1[88] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            subSchema = eOp.getSchema();
            this.jj_consume_token(28);
            ExpressionOperator cond = this.PCond(subSchema, null, conditionPlan, eOp);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            lp.add(eOp);
            log.debug((Object)("Added " + eOp.getAlias() + " to the logical plan"));
            LOFilter filter = new LOFilter(lp, new OperatorKey(this.scope, this.getNextId()), conditionPlan);
            lp.add(filter);
            log.debug((Object)("Added nested filter operator " + filter.getClass().getName() + " to the logical plan"));
            lp.connect(eOp, filter);
            log.debug((Object)"Connected the filter input to the filter");
            log.trace((Object)"Exiting NestedFilter");
            LOFilter lOFilter = filter;
            return lOFilter;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator NestedSortOrArrange(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(43);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        boolean star = false;
        ArrayList<LogicalPlan> sortColPlans = new ArrayList<LogicalPlan>();
        ArrayList<Boolean> ascOrder = new ArrayList<Boolean>();
        Object funcName = null;
        boolean asc = true;
        FuncSpec funcSpec = null;
        log.trace((Object)"Entering NestedSortOrArrange");
        try {
            LogicalOperator eOp;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: {
                    this.jj_consume_token(15);
                    break;
                }
                case 16: {
                    this.jj_consume_token(16);
                    break;
                }
                default: {
                    this.jj_la1[89] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (this.jj_2_16(Integer.MAX_VALUE)) {
                eOp = this.NestedProject(over, specs, lp, input);
            } else if (null != specs.get(this.getToken((int)1).image)) {
                Token t = this.jj_consume_token(76);
                eOp = specs.get(t.image);
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 36: 
                    case 55: 
                    case 76: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 85: 
                    case 87: 
                    case 99: 
                    case 109: {
                        eOp = this.BaseEvalSpec(over, specs, lp, input);
                        break;
                    }
                    default: {
                        this.jj_la1[90] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            this.jj_consume_token(28);
            block10 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: 
                case 76: 
                case 85: 
                case 87: {
                    ExpressionOperator col = this.SortCol(eOp.getSchema(), lp, eOp, ascOrder, sortColPlans);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 90: {
                                break;
                            }
                            default: {
                                this.jj_la1[91] = this.jj_gen;
                                break block10;
                            }
                        }
                        this.jj_consume_token(90);
                        col = this.SortCol(eOp.getSchema(), lp, eOp, ascOrder, sortColPlans);
                    }
                }
                case 33: {
                    this.jj_consume_token(33);
                    star = true;
                    block17 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 43: 
                        case 44: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 43: {
                                    this.jj_consume_token(43);
                                    break block17;
                                }
                                case 44: {
                                    this.jj_consume_token(44);
                                    asc = false;
                                    break block17;
                                }
                            }
                            this.jj_la1[92] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[93] = this.jj_gen;
                        }
                    }
                    LogicalPlan sortColPlan = new LogicalPlan();
                    LOProject projectStar = new LOProject(sortColPlan, new OperatorKey(this.scope, this.getNextId()), eOp, -1);
                    projectStar.setStar(true);
                    sortColPlan.add(projectStar);
                    sortColPlans.add(sortColPlan);
                    if (asc) {
                        ascOrder.add(true);
                        break;
                    }
                    ascOrder.add(false);
                    break;
                }
                default: {
                    this.jj_la1[94] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    this.jj_consume_token(29);
                    funcSpec = this.NonEvalFuncSpec((byte)4);
                    break;
                }
                default: {
                    this.jj_la1[95] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.debug((Object)"Before creating LOSort");
            LOSort sort = new LOSort(lp, new OperatorKey(this.scope, this.getNextId()), sortColPlans, ascOrder, funcSpec);
            sort.setStar(star);
            log.debug((Object)"After creating LOSort");
            try {
                lp.add(eOp);
                log.debug((Object)("Added " + eOp + " " + eOp.getClass().getName() + " to the logical plan"));
                lp.add(sort);
                log.debug((Object)("Added operator " + sort.getClass().getName() + " to the logical plan"));
                lp.connect(eOp, sort);
                log.debug((Object)("Connected alias " + eOp.getAlias() + " operator " + eOp.getClass().getName() + " to operator " + sort.getClass().getName() + " the logical plan"));
                sort.getSchema();
            }
            catch (PlanException planException) {
                ParseException pe = new ParseException(planException.getMessage());
                pe.initCause(planException);
                throw pe;
            }
            log.trace((Object)"Exiting NestedSortOrArrange");
            LOSort lOSort = sort;
            return lOSort;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator NestedDistinct(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(44);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering NestedDistinct");
        try {
            LogicalOperator eOp;
            this.jj_consume_token(17);
            if (this.jj_2_17(Integer.MAX_VALUE)) {
                eOp = this.NestedProject(over, specs, lp, input);
            } else if (null != specs.get(this.getToken((int)1).image)) {
                Token t = this.jj_consume_token(76);
                eOp = specs.get(t.image);
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 36: 
                    case 55: 
                    case 76: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 85: 
                    case 87: 
                    case 99: 
                    case 109: {
                        eOp = this.BaseEvalSpec(over, specs, lp, input);
                        break;
                    }
                    default: {
                        this.jj_la1[96] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            lp.add(eOp);
            log.debug((Object)("Added " + eOp.getAlias() + " to the logical plan"));
            LODistinct distinct = new LODistinct(lp, new OperatorKey(this.scope, this.getNextId()));
            lp.add(distinct);
            log.debug((Object)("Added operator " + distinct.getClass().getName() + " to the logical plan"));
            lp.connect(eOp, distinct);
            log.debug((Object)("Connected alias " + input.getAlias() + " operator " + input.getClass().getName() + " to operator " + distinct.getClass().getName() + " in the logical plan"));
            log.trace((Object)"Exiting NestedDistinct");
            LODistinct lODistinct = distinct;
            return lODistinct;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator NestedLimit(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(45);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Schema subSchema = null;
        log.trace((Object)"Entering LimitClause");
        try {
            Token t;
            LogicalOperator eOp;
            this.jj_consume_token(67);
            if (this.jj_2_18(Integer.MAX_VALUE)) {
                eOp = this.NestedProject(over, specs, lp, input);
            } else if (null != specs.get(this.getToken((int)1).image)) {
                t = this.jj_consume_token(76);
                eOp = specs.get(t.image);
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 36: 
                    case 55: 
                    case 76: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 85: 
                    case 87: 
                    case 99: 
                    case 109: {
                        eOp = this.BaseEvalSpec(over, specs, lp, input);
                        break;
                    }
                    default: {
                        this.jj_la1[97] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            subSchema = eOp.getSchema();
            t = this.jj_consume_token(78);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            lp.add(eOp);
            log.debug((Object)("Added " + eOp.getAlias() + " to the logical plan"));
            long l = Integer.parseInt(t.image);
            LOLimit limit = new LOLimit(lp, new OperatorKey(this.scope, this.getNextId()), l);
            lp.add(limit);
            log.debug((Object)("Added operator " + limit.getClass().getName() + " to the logical plan"));
            lp.connect(eOp, limit);
            log.debug((Object)"Connected the limit input to the limit");
            log.trace((Object)"Exiting NestedLimit");
            LOLimit lOLimit = limit;
            return lOLimit;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator GenerateStatement(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(46);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        LogicalOperator spec = null;
        this.setInsideGenerate(true);
        log.trace((Object)"Entering GenerateStatement");
        try {
            this.jj_consume_token(40);
            spec = this.FlattenedGenerateItemList(over, specs, lp, input);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.debug((Object)"Connecting generate inputs");
            for (LogicalOperator op : this.getGenerateInputs()) {
                lp.connect(op, spec);
                log.debug((Object)("Connected operator: " + op + " to " + spec + " in logical plan " + lp));
            }
            log.trace((Object)"Exiting GenerateStatement");
            LogicalOperator i$ = spec;
            return i$;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final LogicalOperator FlattenedGenerateItemList(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(47);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        ArrayList<LogicalPlan> generatePlans = new ArrayList<LogicalPlan>();
        ArrayList<Boolean> flattenList = new ArrayList<Boolean>();
        ArrayList<Schema> userDefinedSchemaList = new ArrayList<Schema>();
        log.trace((Object)"Entering FlattenedGenerateItemList");
        try {
            LogicalPlan generatePlan = new LogicalPlan();
            ExpressionOperator item = this.FlattenedGenerateItem(over, specs, generatePlan, input, flattenList, userDefinedSchemaList);
            generatePlans.add(generatePlan);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 90: {
                        break;
                    }
                    default: {
                        this.jj_la1[98] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(90);
                generatePlan = new LogicalPlan();
                item = this.FlattenedGenerateItem(over, specs, generatePlan, input, flattenList, userDefinedSchemaList);
                generatePlans.add(generatePlan);
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            LOGenerate generate = new LOGenerate(lp, new OperatorKey(this.scope, this.getNextId()), generatePlans, flattenList, userDefinedSchemaList);
            lp.add(generate);
            log.debug((Object)("Added operator " + generate.getClass().getName() + " to the logical plan"));
            log.trace((Object)"Exiting FlattenedGenerateItemList");
            LOGenerate lOGenerate = generate;
            return lOGenerate;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator FlattenedGenerateItem(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input, ArrayList<Boolean> flattenList, ArrayList<Schema> userDefinedSchemaList) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(48);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Schema schema = null;
        Schema.FieldSchema fs = null;
        boolean flatten = false;
        log.trace((Object)"Entering FlattenedGenerateItem");
        try {
            ExpressionOperator project;
            ExpressionOperator item;
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 41: {
                    this.jj_consume_token(41);
                    this.jj_consume_token(87);
                    item = this.InfixExpr(over, specs, lp, input);
                    this.jj_consume_token(88);
                    flatten = true;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: {
                            this.jj_consume_token(27);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 87: {
                                    this.jj_consume_token(87);
                                    schema = this.TupleSchema();
                                    this.jj_consume_token(88);
                                    break block2;
                                }
                                case 76: {
                                    fs = this.FieldSchema();
                                    break block2;
                                }
                            }
                            this.jj_la1[99] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_la1[100] = this.jj_gen;
                    break;
                }
                case 33: 
                case 36: 
                case 55: 
                case 76: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 85: 
                case 87: 
                case 99: 
                case 103: 
                case 109: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 36: 
                        case 55: 
                        case 76: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 85: 
                        case 87: 
                        case 99: 
                        case 103: 
                        case 109: {
                            item = this.InfixExpr(over, specs, lp, input);
                            break;
                        }
                        case 33: {
                            this.jj_consume_token(33);
                            project = new LOProject(lp, new OperatorKey(this.scope, this.getNextId()), input, -1);
                            project.setStar(true);
                            item = project;
                            lp.add(project);
                            if (input instanceof ExpressionOperator) {
                                lp.add(input);
                                lp.connect(input, project);
                            }
                            log.debug((Object)("FGItem: Added operator " + project.getClass().getName() + " " + project + " to logical plan " + lp));
                            break;
                        }
                        default: {
                            this.jj_la1[101] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: {
                            this.jj_consume_token(27);
                            fs = this.FieldSchema();
                            break block2;
                        }
                    }
                    this.jj_la1[102] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[103] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.debug((Object)("item: " + item.getClass().getName()));
            if (null != fs) {
                schema = new Schema(fs);
            }
            flattenList.add(flatten);
            userDefinedSchemaList.add(schema);
            log.trace((Object)"Exiting FlattenedGenerateItem");
            project = item;
            return project;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator InfixExpr(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(49);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering InFixExpr");
        try {
            ExpressionOperator expr = this.AdditiveExpr(over, specs, lp, input);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting InFixExpr");
            ExpressionOperator expressionOperator = expr;
            return expressionOperator;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator AdditiveExpr(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(50);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering AdditiveExpr");
        try {
            ExpressionOperator lhs = this.MultiplicativeExpr(over, specs, lp, input);
            block12: while (true) {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 102: 
                    case 103: {
                        break;
                    }
                    default: {
                        this.jj_la1[104] = this.jj_gen;
                        break block12;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 102: {
                        t = this.jj_consume_token(102);
                        break;
                    }
                    case 103: {
                        t = this.jj_consume_token(103);
                        break;
                    }
                    default: {
                        this.jj_la1[105] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                ExpressionOperator rhs = this.MultiplicativeExpr(over, specs, lp, input);
                this.assertAtomic(lhs, true);
                this.assertAtomic(rhs, true);
                BinaryExpressionOperator exprOp = t.image.equals("+") ? new LOAdd(lp, new OperatorKey(this.scope, this.getNextId())) : new LOSubtract(lp, new OperatorKey(this.scope, this.getNextId()));
                lp.add(exprOp);
                log.debug((Object)("AdditiveExpr: Added operator " + exprOp.getClass().getName() + " " + exprOp + " to logical plan " + lp));
                lp.connect(lhs, exprOp);
                log.debug((Object)("AdditiveExpr: Connected operator " + lhs.getClass().getName() + " " + lhs + " to " + exprOp + " logical plan " + lp));
                lp.connect(rhs, exprOp);
                log.debug((Object)("AdditiveExpr: Connected operator " + rhs.getClass().getName() + " " + rhs + " to " + exprOp + " logical plan " + lp));
                lhs = exprOp;
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting AdditiveExpr");
            ExpressionOperator expressionOperator = lhs;
            return expressionOperator;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator MultiplicativeExpr(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(51);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering MultiplicativeExpr");
        try {
            ExpressionOperator lhs = this.CastExpr(over, specs, lp, input);
            block13: while (true) {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: 
                    case 104: 
                    case 105: {
                        break;
                    }
                    default: {
                        this.jj_la1[106] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: {
                        t = this.jj_consume_token(33);
                        break;
                    }
                    case 104: {
                        t = this.jj_consume_token(104);
                        break;
                    }
                    case 105: {
                        t = this.jj_consume_token(105);
                        break;
                    }
                    default: {
                        this.jj_la1[107] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                ExpressionOperator rhs = this.CastExpr(over, specs, lp, input);
                this.assertAtomic(lhs, true);
                this.assertAtomic(rhs, true);
                BinaryExpressionOperator exprOp = t.image.equals("*") ? new LOMultiply(lp, new OperatorKey(this.scope, this.getNextId())) : (t.image.equals("/") ? new LODivide(lp, new OperatorKey(this.scope, this.getNextId())) : new LOMod(lp, new OperatorKey(this.scope, this.getNextId())));
                lp.add(exprOp);
                log.debug((Object)("MultiplicativeExpr: Added operator " + exprOp.getClass().getName() + " " + exprOp + " to logical plan " + lp));
                lp.connect(lhs, exprOp);
                log.debug((Object)("MultiplicativeExpr: Connected operator " + lhs.getClass().getName() + " " + lhs + " to " + exprOp + " logical plan " + lp));
                lp.connect(rhs, exprOp);
                log.debug((Object)("MultiplicativeExpr: Connected operator " + rhs.getClass().getName() + " " + rhs + " to " + exprOp + " logical plan " + lp));
                lhs = exprOp;
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting MultiplicativeExpr");
            ExpressionOperator expressionOperator = lhs;
            return expressionOperator;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator CastExpr(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(52);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        int type = 50;
        Schema.FieldSchema fs = null;
        boolean castRequired = false;
        log.trace((Object)"Entering Cast");
        try {
            if (this.jj_2_19(2)) {
                this.jj_consume_token(87);
                fs = this.TypeFieldSchema();
                castRequired = true;
                this.jj_consume_token(88);
            }
            ExpressionOperator exprOp = this.UnaryExpr(over, specs, lp, input);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if (castRequired) {
                LOCast cast = new LOCast(lp, new OperatorKey(this.scope, this.getNextId()), fs.type);
                fs.alias = exprOp.getFieldSchema().alias;
                exprOp.unsetFieldSchema();
                ((ExpressionOperator)cast).setFieldSchema(fs);
                lp.add(cast);
                log.debug((Object)("Added operator " + cast.getClass().getName() + " " + cast + " to logical plan " + lp));
                lp.connect(exprOp, cast);
                log.debug((Object)("Connected operator " + exprOp.getClass().getName() + " " + exprOp + " to " + cast + " logical plan " + lp));
                log.trace((Object)"Exiting Cast");
                LOCast lOCast = cast;
                return lOCast;
            }
            log.trace((Object)"Exiting Cast");
            ExpressionOperator expressionOperator = exprOp;
            return expressionOperator;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator UnaryExpr(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(53);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering UnaryExpr");
        try {
            ExpressionOperator expr;
            if (this.jj_2_20(Integer.MAX_VALUE)) {
                expr = this.BaseEvalSpec(over, specs, lp, input);
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 87: {
                        this.jj_consume_token(87);
                        expr = this.InfixExpr(over, specs, lp, input);
                        this.jj_consume_token(88);
                        break;
                    }
                    case 103: {
                        expr = this.NegativeExpr(over, specs, lp, input);
                        break;
                    }
                    default: {
                        this.jj_la1[108] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting UnaryExpr");
            ExpressionOperator expressionOperator = expr;
            return expressionOperator;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator NegativeExpr(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(54);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        LogicalPlan exprPlan = new LogicalPlan();
        log.trace((Object)"Entering NegativeExpr");
        try {
            this.jj_consume_token(103);
            ExpressionOperator c1 = this.CastExpr(over, specs, lp, input);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            LONegative eOp = new LONegative(lp, new OperatorKey(this.scope, this.getNextId()));
            lp.add(eOp);
            log.debug((Object)("NegativeExpr: Added operator " + eOp.getClass().getName() + " " + eOp + " to logical plan " + lp));
            lp.connect(c1, eOp);
            log.trace((Object)"Exiting NegativeExpr");
            LONegative lONegative = eOp;
            return lONegative;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator BaseEvalSpec(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(55);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Schema subSchema = null;
        this.scalarFound = false;
        log.trace((Object)"Entering BaseEvalSpec");
        try {
            Cloneable fs;
            ExpressionOperator item;
            if (this.jj_2_22(Integer.MAX_VALUE)) {
                item = this.Const(lp);
            } else {
                block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 36: 
                    case 76: 
                    case 85: 
                    case 87: {
                        if (this.jj_2_21(Integer.MAX_VALUE)) {
                            item = this.EvalFuncSpec(over, specs, lp, input, (byte)2);
                        } else {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 36: 
                                case 76: 
                                case 85: {
                                    item = this.ColOrSpec(over, specs, lp, input);
                                    break;
                                }
                                case 87: {
                                    item = this.BinCond(over, specs, lp, input);
                                    break;
                                }
                                default: {
                                    this.jj_la1[109] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                        }
                        block19: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 101: 
                                case 106: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[110] = this.jj_gen;
                                    break block2;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 101: {
                                    fs = item.getFieldSchema();
                                    if (null != fs) {
                                        subSchema = ((Schema.FieldSchema)fs).schema;
                                    }
                                    if (item instanceof LOUserFunc && ((LOUserFunc)item).getImplicitReferencedOperator() != null) {
                                        subSchema = ((LOUserFunc)item).getImplicitReferencedOperator().getSchema();
                                    }
                                    log.debug((Object)("subSchema: " + subSchema));
                                    this.jj_consume_token(101);
                                    ExpressionOperator projection = this.BracketedSimpleProj(subSchema, lp, item);
                                    if (!(item instanceof LOUserFunc) || ((LOUserFunc)item).getImplicitReferencedOperator() == null) {
                                        this.assertAtomic(item, false);
                                    }
                                    item = projection;
                                    continue block19;
                                }
                                case 106: {
                                    this.jj_consume_token(106);
                                    String key = this.StringDatum();
                                    if (!(item instanceof LOUserFunc) || ((LOUserFunc)item).getImplicitReferencedOperator() == null) {
                                        this.assertAtomic(item, false);
                                    }
                                    LOMapLookup mapLookup = new LOMapLookup(lp, new OperatorKey(this.scope, this.getNextId()), key, 50, null);
                                    lp.add(mapLookup);
                                    log.debug((Object)("BaseEvalSpec: Added operator " + mapLookup.getClass().getName() + " " + mapLookup + " to logical plan " + lp));
                                    lp.connect(item, mapLookup);
                                    item = mapLookup;
                                    log.debug((Object)("BaseEvalSpec: Connected operator " + item.getClass().getName() + " " + item + " to " + mapLookup + " logical plan " + lp));
                                    continue block19;
                                }
                            }
                            break;
                        }
                        this.jj_la1[111] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[112] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting BaseEvalSpec");
            if (this.scalarFound) {
                throw new ParseException("Scalars can be only used with projections");
            }
            fs = item;
            return fs;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator BinCond(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(56);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        LogicalPlan conditionPlan = new LogicalPlan();
        LogicalPlan truePlan = new LogicalPlan();
        LogicalPlan falsePlan = new LogicalPlan();
        log.trace((Object)"Entering BinCond");
        try {
            this.jj_consume_token(87);
            ExpressionOperator cond = this.PCond(over, specs, lp, input);
            this.jj_consume_token(107);
            ExpressionOperator ifTrue = this.InfixExpr(over, specs, lp, input);
            this.jj_consume_token(108);
            ExpressionOperator ifFalse = this.InfixExpr(over, specs, lp, input);
            this.jj_consume_token(88);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            LOBinCond bincond = new LOBinCond(lp, new OperatorKey(this.scope, this.getNextId()));
            lp.add(bincond);
            log.debug((Object)("BinCond: Added operator " + bincond.getClass().getName() + " " + bincond + " to logical plan " + lp));
            lp.connect(cond, bincond);
            lp.connect(ifTrue, bincond);
            lp.connect(ifFalse, bincond);
            log.trace((Object)"Exiting BinCond");
            LOBinCond lOBinCond = bincond;
            return lOBinCond;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator EvalFuncSpec(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input, byte funcType) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(57);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        String funcName = null;
        FuncSpec funcSpec = null;
        boolean registeredFunction = false;
        Object userAliasFunc = null;
        Object func = null;
        log.trace((Object)"Entering EvalFuncSpec");
        try {
            byte type;
            funcName = this.QualifiedFunction();
            try {
                func = this.pigContext.instantiateFuncFromAlias(funcName);
                FunctionType.tryCasting(func, funcType);
            }
            catch (Exception e) {
                ParseException pe = new ParseException(e.getMessage());
                pe.initCause(e);
                throw pe;
            }
            this.jj_consume_token(87);
            List<ExpressionOperator> args = this.EvalArgs(over, specs, lp, input);
            this.jj_consume_token(88);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if (null != func) {
                if (null != this.pigContext.getFuncSpecFromAlias(funcName)) {
                    funcSpec = this.pigContext.getFuncSpecFromAlias(funcName);
                } else {
                    funcName = func.getClass().getName();
                    funcSpec = new FuncSpec(funcName);
                }
                type = 50;
                switch (funcType) {
                    case 2: {
                        Type javaType = ((EvalFunc)func).getReturnType();
                        type = DataType.findType(javaType);
                        log.debug((Object)("Return type of UDF: " + DataType.findTypeName(type)));
                        log.debug((Object)("EvalFuncSpec: funcSpec: " + funcSpec));
                        break;
                    }
                    default: {
                        throw new ParseException("Received an unknown function type: " + funcType);
                    }
                }
            } else {
                throw new ParseException("Could not instantiate function: " + funcName);
            }
            LOUserFunc userFunc = new LOUserFunc(lp, new OperatorKey(this.scope, this.getNextId()), funcSpec, type);
            lp.add(userFunc);
            log.debug((Object)("EvalFuncSpec: Added operator " + userFunc.getClass().getName() + " " + userFunc + " to logical plan " + lp));
            for (ExpressionOperator exprOp : args) {
                lp.connect(exprOp, userFunc);
                log.debug((Object)("EvalFuncSpec: Connected operator " + exprOp.getClass().getName() + " " + exprOp + " to " + userFunc + " logical plan " + lp));
            }
            log.trace((Object)"Exiting EvalFuncSpec");
            LOUserFunc i$ = userFunc;
            return i$;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final FuncSpec NonEvalFuncSpec(byte funcType) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(58);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        String functionName = null;
        FuncSpec funcSpec = null;
        String funcNameAlias = null;
        String functionArgs = null;
        Object func = null;
        log.trace((Object)"Entering NonEvalFuncSpec");
        try {
            if (this.jj_2_23(1)) {
                if (null == this.pigContext.getFuncSpecFromAlias(this.getToken((int)1).image)) {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                funcNameAlias = this.QualifiedFunction();
                func = this.pigContext.instantiateFuncFromAlias(funcNameAlias);
                try {
                    FunctionType.tryCasting(func, funcType);
                }
                catch (Exception e) {
                    ParseException pe = new ParseException(e.getMessage());
                    pe.initCause(e);
                    throw pe;
                }
            } else {
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 76: {
                        functionName = this.QualifiedFunction();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 87: {
                                this.jj_consume_token(87);
                                functionArgs = this.FunctionArgs();
                                this.jj_consume_token(88);
                                break block4;
                            }
                        }
                        this.jj_la1[113] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[114] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if (null != func) {
                functionName = func.getClass().getName();
                funcSpec = null != funcNameAlias ? this.pigContext.getFuncSpecFromAlias(funcNameAlias) : new FuncSpec(functionName);
            } else if (functionName != null) {
                funcSpec = new FuncSpec(functionName + (functionArgs == null ? "()" : "(" + functionArgs + ")"));
            } else {
                throw new ParseException("Could not instantiate function: " + funcNameAlias);
            }
            switch (funcType) {
                case 4: 
                case 8: 
                case 16: 
                case 32: 
                case 64: {
                    func = PigContext.instantiateFuncFromSpec(funcSpec);
                    try {
                        FunctionType.tryCasting(func, funcType);
                        break;
                    }
                    catch (Exception e) {
                        ParseException pe = new ParseException(e.getMessage());
                        pe.initCause(e);
                        throw pe;
                    }
                }
                default: {
                    throw new ParseException("Received an unknown function type: " + funcType);
                }
            }
            log.trace((Object)"Exiting NonEvalFuncSpec");
            FuncSpec e = funcSpec;
            return e;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final List<ExpressionOperator> EvalArgs(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(59);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        ArrayList<ExpressionOperator> specList = new ArrayList<ExpressionOperator>();
        log.trace((Object)"Entering EvalArgs");
        try {
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: 
                case 36: 
                case 55: 
                case 76: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 85: 
                case 87: 
                case 99: 
                case 103: 
                case 109: {
                    ExpressionOperator item = this.EvalArgsItem(over, specs, lp, input);
                    specList.add(item);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 90: {
                                break;
                            }
                            default: {
                                this.jj_la1[115] = this.jj_gen;
                                break block2;
                            }
                        }
                        this.jj_consume_token(90);
                        item = this.EvalArgsItem(over, specs, lp, input);
                        specList.add(item);
                    }
                }
                default: {
                    this.jj_la1[116] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting EvalArgs");
            ArrayList<ExpressionOperator> arrayList = specList;
            return arrayList;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator EvalArgsItem(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator input) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(60);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering EvalArgsItem");
        try {
            ExpressionOperator project;
            ExpressionOperator item;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: 
                case 55: 
                case 76: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 85: 
                case 87: 
                case 99: 
                case 103: 
                case 109: {
                    item = this.InfixExpr(over, specs, lp, input);
                    break;
                }
                case 33: {
                    this.jj_consume_token(33);
                    project = new LOProject(lp, new OperatorKey(this.scope, this.getNextId()), input, -1);
                    ((LOProject)project).setStar(true);
                    item = project;
                    lp.add(project);
                    if (input instanceof ExpressionOperator) {
                        lp.add(input);
                        lp.connect(input, project);
                    }
                    log.debug((Object)("EvalArgsItem: Added operator " + project.getClass().getName() + " " + project + " to logical plan " + lp));
                    break;
                }
                default: {
                    this.jj_la1[117] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting EvalArgsItem");
            project = item;
            return project;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final byte Type() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(61);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering Type");
        try {
            byte type;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: {
                    type = this.BasicType();
                    break;
                }
                case 51: 
                case 52: 
                case 53: {
                    type = this.CompositeType();
                    break;
                }
                default: {
                    this.jj_la1[118] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting Type");
            byte by = type;
            return by;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte CompositeType() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(62);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering CompositeType");
        Token t = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 53: {
                    t = this.jj_consume_token(53);
                    break;
                }
                case 51: {
                    t = this.jj_consume_token(51);
                    break;
                }
                case 52: {
                    t = this.jj_consume_token(52);
                    break;
                }
                default: {
                    this.jj_la1[119] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.debug((Object)("t: " + t + " type: " + nameToTypeMap.get(t.image.toUpperCase())));
            byte type = nameToTypeMap.get(t.image.toUpperCase());
            log.trace((Object)"Exiting CompositeType");
            byte by = type;
            return by;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte BasicType() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(63);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering BasicType");
        Token t = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 45: {
                    t = this.jj_consume_token(45);
                    break;
                }
                case 46: {
                    t = this.jj_consume_token(46);
                    break;
                }
                case 47: {
                    t = this.jj_consume_token(47);
                    break;
                }
                case 48: {
                    t = this.jj_consume_token(48);
                    break;
                }
                case 49: {
                    t = this.jj_consume_token(49);
                    break;
                }
                case 50: {
                    t = this.jj_consume_token(50);
                    break;
                }
                default: {
                    this.jj_la1[120] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            String typeName = t.image;
            log.debug((Object)(" nameToTypeMap: " + nameToTypeMap));
            log.debug((Object)("t: " + t + " type: " + nameToTypeMap.get(typeName.toUpperCase())));
            if (typeName.equalsIgnoreCase("int")) {
                typeName = "integer";
            }
            byte type = nameToTypeMap.get(typeName.toUpperCase());
            log.trace((Object)"Exiting BasicType");
            byte by = type;
            return by;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final Schema.FieldSchema FieldSchema() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(64);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Object item = null;
        Schema.FieldSchema fs = null;
        log.trace((Object)"Entering FieldSchema");
        try {
            if (this.jj_2_24(Integer.MAX_VALUE)) {
                fs = this.SchemaTuple();
            } else if (this.jj_2_25(Integer.MAX_VALUE)) {
                fs = this.SchemaBag();
            } else if (this.jj_2_26(Integer.MAX_VALUE)) {
                fs = this.SchemaMap();
            } else if (this.jj_2_27(Integer.MAX_VALUE)) {
                fs = this.AtomSchema();
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting FieldSchema");
            Schema.FieldSchema fieldSchema = fs;
            return fieldSchema;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final Schema.FieldSchema AtomSchema() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(65);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Token t1 = null;
        byte type = 1;
        log.trace((Object)"Entering AtomSchema");
        try {
            Schema.FieldSchema fs;
            t1 = this.jj_consume_token(76);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 108: {
                    this.jj_consume_token(108);
                    type = this.BasicType();
                    break;
                }
                default: {
                    this.jj_la1[121] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if (null != t1) {
                log.debug((Object)("AtomSchema: " + t1.image));
                fs = new Schema.FieldSchema(t1.image, type);
            } else {
                fs = new Schema.FieldSchema(null, type);
            }
            log.trace((Object)"Exiting AtomSchema");
            Schema.FieldSchema fieldSchema = fs;
            return fieldSchema;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Schema.FieldSchema SchemaMap() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(66);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Token t1 = null;
        log.trace((Object)"Entering SchemaMap");
        try {
            Schema.FieldSchema fs;
            t1 = this.jj_consume_token(76);
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 108: {
                    if (this.jj_2_28(2)) {
                        this.jj_consume_token(108);
                        this.jj_consume_token(53);
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 108: {
                            this.jj_consume_token(108);
                            break block1;
                        }
                    }
                    this.jj_la1[122] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[123] = this.jj_gen;
                }
            }
            this.jj_consume_token(109);
            this.jj_consume_token(110);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if (null != t1) {
                log.debug((Object)("MAP alias " + t1.image));
                fs = new Schema.FieldSchema(t1.image, 100);
            } else {
                fs = new Schema.FieldSchema(null, 100);
            }
            log.trace((Object)"Exiting SchemaMap");
            Schema.FieldSchema fieldSchema = fs;
            return fieldSchema;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final Schema.FieldSchema SchemaTuple() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(67);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Token t1 = null;
        log.trace((Object)"Entering SchemaTuple");
        try {
            Schema.FieldSchema fs;
            t1 = this.jj_consume_token(76);
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 108: {
                    if (this.jj_2_29(2)) {
                        this.jj_consume_token(108);
                        this.jj_consume_token(52);
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 108: {
                            this.jj_consume_token(108);
                            break block2;
                        }
                    }
                    this.jj_la1[124] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[125] = this.jj_gen;
                }
            }
            this.jj_consume_token(87);
            Schema s = this.TupleSchema();
            this.jj_consume_token(88);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if (null != t1) {
                log.debug((Object)("TUPLE alias " + t1.image));
                fs = new Schema.FieldSchema(t1.image, s, 110);
            } else {
                fs = new Schema.FieldSchema(null, s, 110);
            }
            log.trace((Object)"Exiting SchemaTuple");
            Schema.FieldSchema fieldSchema = fs;
            return fieldSchema;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final Schema.FieldSchema SchemaBag() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(68);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Token t1 = null;
        log.trace((Object)"Entering SchemaBag");
        try {
            Schema.FieldSchema fs;
            t1 = this.jj_consume_token(76);
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 108: {
                    if (this.jj_2_30(2)) {
                        this.jj_consume_token(108);
                        this.jj_consume_token(51);
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 108: {
                            this.jj_consume_token(108);
                            break block2;
                        }
                    }
                    this.jj_la1[126] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[127] = this.jj_gen;
                }
            }
            this.jj_consume_token(99);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 76: {
                    fs = this.SchemaTuple();
                    break;
                }
                default: {
                    this.jj_la1[128] = this.jj_gen;
                    fs = new Schema.FieldSchema(null, new Schema());
                }
            }
            this.jj_consume_token(100);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            Schema s = new Schema(fs);
            s.setTwoLevelAccessRequired(true);
            if (null != t1) {
                log.debug((Object)("BAG alias " + t1.image));
                fs = new Schema.FieldSchema(t1.image, s, 120);
            } else {
                fs = new Schema.FieldSchema(null, s, 120);
            }
            log.trace((Object)"Exiting SchemaBag");
            Schema.FieldSchema fieldSchema = fs;
            return fieldSchema;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final Schema TupleSchema() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(69);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Object item = null;
        Schema list = new Schema();
        Schema.FieldSchema fs = null;
        log.trace((Object)"Entering TupleSchema");
        try {
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 76: {
                    fs = this.FieldSchema();
                    log.debug((Object)("Adding " + fs.alias + " to the list: " + list));
                    list.add(fs);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 90: {
                                break;
                            }
                            default: {
                                this.jj_la1[129] = this.jj_gen;
                                break block2;
                            }
                        }
                        this.jj_consume_token(90);
                        fs = this.FieldSchema();
                        log.debug((Object)("Adding " + fs.alias + " to the list: " + list));
                        list.add(fs);
                    }
                }
                default: {
                    this.jj_la1[130] = this.jj_gen;
                    list = null;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.debug((Object)("Printing list in TupleSchema" + list));
            log.trace((Object)"Exiting TupleSchema");
            Schema schema = list;
            return schema;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final Schema.FieldSchema TypeFieldSchema() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(70);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Object item = null;
        Schema.FieldSchema fs = null;
        log.trace((Object)"Entering TypeFieldSchema");
        try {
            if (this.jj_2_31(Integer.MAX_VALUE)) {
                fs = this.TypeSchemaTuple();
            } else if (this.jj_2_32(Integer.MAX_VALUE)) {
                fs = this.TypeSchemaBag();
            } else if (this.jj_2_33(Integer.MAX_VALUE)) {
                fs = this.TypeSchemaMap();
            } else if (this.jj_2_34(Integer.MAX_VALUE)) {
                fs = this.TypeAtomSchema();
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting TypeFieldSchema");
            Schema.FieldSchema fieldSchema = fs;
            return fieldSchema;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final Schema.FieldSchema TypeAtomSchema() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(71);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        byte type = 50;
        log.trace((Object)"Entering TypeAtomSchema");
        try {
            type = this.BasicType();
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if (type == 50) {
                int errCode = 1051;
                String msg = "Cannot cast to bytearray";
                FrontendException fee = new FrontendException(msg, errCode, 2);
                ParseException pe = new ParseException(msg);
                pe.initCause(fee);
                throw pe;
            }
            Schema.FieldSchema fs = new Schema.FieldSchema(null, type);
            log.trace((Object)"Exiting TypeAtomSchema");
            Schema.FieldSchema errCode = fs;
            return errCode;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Schema.FieldSchema TypeSchemaMap() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(72);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Object t1 = null;
        log.trace((Object)"Entering TypeSchemaMap");
        try {
            Schema.FieldSchema fs;
            this.jj_consume_token(53);
            this.jj_consume_token(109);
            this.jj_consume_token(110);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if (null != t1) {
                log.debug((Object)("MAP alias " + t1.image));
                fs = new Schema.FieldSchema(t1.image, 100);
            } else {
                fs = new Schema.FieldSchema(null, 100);
            }
            log.trace((Object)"Exiting TypeSchemaMap");
            Schema.FieldSchema fieldSchema = fs;
            return fieldSchema;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final Schema.FieldSchema TypeSchemaTuple() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(73);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Object t1 = null;
        log.trace((Object)"Entering TypeSchemaTuple");
        try {
            Schema.FieldSchema fs;
            this.jj_consume_token(52);
            this.jj_consume_token(87);
            Schema s = this.TypeTupleSchema();
            this.jj_consume_token(88);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if (null != t1) {
                log.debug((Object)("TUPLE alias " + t1.image));
                fs = new Schema.FieldSchema(t1.image, s, 110);
            } else {
                fs = new Schema.FieldSchema(null, s, 110);
            }
            log.trace((Object)"Exiting TypeSchemaTuple");
            Schema.FieldSchema fieldSchema = fs;
            return fieldSchema;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final Schema.FieldSchema TypeSchemaBag() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(74);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Object t1 = null;
        log.trace((Object)"Entering TypeSchemaBag");
        try {
            Schema.FieldSchema fs;
            this.jj_consume_token(51);
            this.jj_consume_token(99);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 52: {
                    fs = this.TypeSchemaTuple();
                    break;
                }
                default: {
                    this.jj_la1[131] = this.jj_gen;
                    fs = new Schema.FieldSchema(null, new Schema());
                }
            }
            this.jj_consume_token(100);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            Schema s = new Schema(fs);
            s.setTwoLevelAccessRequired(true);
            if (null != t1) {
                log.debug((Object)("BAG alias " + t1.image));
                fs = new Schema.FieldSchema(t1.image, s, 120);
            } else {
                fs = new Schema.FieldSchema(null, s, 120);
            }
            log.trace((Object)"Exiting TypeSchemaBag");
            Schema.FieldSchema fieldSchema = fs;
            return fieldSchema;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final Schema TypeTupleSchema() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(75);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Object item = null;
        Schema list = new Schema();
        Schema.FieldSchema fs = null;
        log.trace((Object)"Entering TypeTupleSchema");
        try {
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    fs = this.TypeFieldSchema();
                    log.debug((Object)("Adding " + fs.alias + " to the list: " + list));
                    list.add(fs);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 90: {
                                break;
                            }
                            default: {
                                this.jj_la1[132] = this.jj_gen;
                                break block2;
                            }
                        }
                        this.jj_consume_token(90);
                        fs = this.TypeFieldSchema();
                        log.debug((Object)("Adding " + fs.alias + " to the list: " + list));
                        list.add(fs);
                    }
                }
                default: {
                    this.jj_la1[133] = this.jj_gen;
                    list = null;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.debug((Object)("Printing list in TypeTupleSchema: " + list));
            log.trace((Object)"Exiting TypeTupleSchema");
            Schema schema = list;
            return schema;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final String EvalClass(byte classType) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(76);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering EvalClass");
        try {
            String className = this.QualifiedFunction();
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            Class cs = PigContext.resolveClassName(className);
            try {
                ClassType.checkClassType(cs, classType);
            }
            catch (ExecException e) {
                ParseException pe = new ParseException("Class " + className + " not found");
                pe.initCause(e);
                throw pe;
            }
            catch (Exception e) {
                ParseException pe = new ParseException(e.getMessage());
                pe.initCause(e);
                throw pe;
            }
            log.trace((Object)"Exiting EvalClass");
            String e = className;
            return e;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void ClassName() throws ParseException {
        block8: {
            this.jj_consume_token(76);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 101: 
                    case 111: {
                        break;
                    }
                    default: {
                        this.jj_la1[134] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 101: {
                        this.jj_consume_token(101);
                        this.jj_consume_token(76);
                        continue block7;
                    }
                    case 111: {
                        this.jj_consume_token(111);
                        this.jj_consume_token(76);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[135] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final String QualifiedFunction() throws ParseException {
        StringBuffer s;
        block8: {
            s = new StringBuffer();
            log.trace((Object)"Entering QualifiedFunction");
            Token t1 = this.jj_consume_token(76);
            s.append(t1.image);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 101: 
                    case 111: {
                        break;
                    }
                    default: {
                        this.jj_la1[136] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 101: {
                        this.jj_consume_token(101);
                        t1 = this.IdentifierOrReserved();
                        s.append("." + t1.image);
                        continue block7;
                    }
                    case 111: {
                        this.jj_consume_token(111);
                        t1 = this.IdentifierOrReserved();
                        s.append("$" + t1.image);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[137] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        log.debug((Object)("QualifiedFunction: " + s.toString()));
        log.trace((Object)"Exiting QualifiedFunction");
        return s.toString();
    }

    public final ExpressionOperator BracketedSimpleProj(Schema over, LogicalPlan lp, LogicalOperator eOp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(78);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        ExpressionOperator spec = null;
        log.trace((Object)"Entering BracketedSimpleProj");
        log.debug((Object)("eOp: " + eOp));
        this.bracketed = true;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: 
                case 76: 
                case 85: {
                    spec = this.ColOrSpec(over, null, lp, eOp);
                    break;
                }
                case 87: {
                    this.jj_consume_token(87);
                    spec = this.SimpleProj(over, lp, eOp);
                    this.jj_consume_token(88);
                    break;
                }
                default: {
                    this.jj_la1[138] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting BracketedSimpleProj");
            this.bracketed = false;
            ExpressionOperator expressionOperator = spec;
            return expressionOperator;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator SimpleProj(Schema over, LogicalPlan lp, LogicalOperator eOp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(79);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        ArrayList<Integer> colList = new ArrayList<Integer>();
        log.trace((Object)"Entering SimpleProj");
        try {
            int i = this.ColNameOrNum(over);
            colList.add(i);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 90: {
                        break;
                    }
                    default: {
                        this.jj_la1[139] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(90);
                i = this.ColNameOrNum(over);
                colList.add(i);
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            LOProject project = new LOProject(lp, new OperatorKey(this.scope, this.getNextId()), eOp, colList);
            lp.add(project);
            log.debug((Object)("SimpleProj: Added operator " + project.getClass().getName() + " " + project + " to logical plan " + lp));
            if (eOp instanceof ExpressionOperator) {
                lp.add(eOp);
                lp.connect(eOp, project);
            }
            log.trace((Object)"Exiting SimpleProj");
            LOProject lOProject = project;
            return lOProject;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final DataBag Bag() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(80);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        int type = 50;
        BagFactory bagFactory = BagFactory.getInstance();
        DataBag bag = bagFactory.newDefaultBag();
        Tuple t = null;
        log.trace((Object)"Entering bag");
        try {
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    this.jj_consume_token(87);
                    t = this.Tuple();
                    bag.add(t);
                    this.jj_consume_token(88);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 90: {
                                break;
                            }
                            default: {
                                this.jj_la1[140] = this.jj_gen;
                                break block2;
                            }
                        }
                        this.jj_consume_token(90);
                        this.jj_consume_token(87);
                        t = this.Tuple();
                        bag.add(t);
                        this.jj_consume_token(88);
                    }
                }
                default: {
                    this.jj_la1[141] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting bag");
            DataBag dataBag = bag;
            return dataBag;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final Tuple Tuple() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(81);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        int type = 50;
        Object obj = null;
        TupleFactory tupleFactory = TupleFactory.getInstance();
        ArrayList<Object> objList = new ArrayList<Object>();
        log.trace((Object)"Entering Tuple");
        try {
            Tuple tuple;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 55: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 87: 
                case 99: 
                case 109: {
                    obj = this.Datum();
                    log.debug((Object)("Adding " + obj + " to the list: " + objList));
                    objList.add(obj);
                    while (this.jj_2_35(2)) {
                        this.jj_consume_token(90);
                        obj = this.Datum();
                        log.debug((Object)("Adding " + obj + " to the list: " + objList));
                        objList.add(obj);
                    }
                    tuple = tupleFactory.newTuple(objList);
                    break;
                }
                default: {
                    this.jj_la1[142] = this.jj_gen;
                    tuple = tupleFactory.newTuple(0);
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting Tuple");
            Tuple tuple2 = tuple;
            return tuple2;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final Map<String, Object> Map() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(82);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        HashMap<String, Object> keyValues = new HashMap<String, Object>();
        log.trace((Object)"Entering Map");
        try {
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 55: 
                case 82: {
                    this.KeyValuePair(keyValues);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 90: {
                                break;
                            }
                            default: {
                                this.jj_la1[143] = this.jj_gen;
                                break block2;
                            }
                        }
                        this.jj_consume_token(90);
                        this.KeyValuePair(keyValues);
                    }
                }
                default: {
                    this.jj_la1[144] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting Map");
            HashMap<String, Object> hashMap = keyValues;
            return hashMap;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void KeyValuePair(Map<String, Object> keyValues) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(83);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        String key = null;
        Object value = null;
        log.trace((Object)"Entering KeyValuePair");
        try {
            key = this.StringDatum();
            this.jj_consume_token(106);
            value = this.Datum();
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if (key == null) {
                throw new ParseException("key in a map cannot be null (provided input has '" + key + "#" + value + "')");
            }
            keyValues.put(key, value);
            log.trace((Object)"Exiting KeyValuePair");
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String StringDatum() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(84);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        String s = null;
        log.trace((Object)"Entering String");
        try {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 82: {
                    t = this.jj_consume_token(82);
                    s = QueryParser.unquote(t.image);
                    break;
                }
                case 55: {
                    t = this.jj_consume_token(55);
                    s = null;
                    break;
                }
                default: {
                    this.jj_la1[145] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)("Exiting String with " + t.image));
            String string = s;
            return string;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object AtomDatum() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(85);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Object obj = null;
        log.trace((Object)"Entering AtomDatum");
        try {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 78: {
                    t = this.jj_consume_token(78);
                    obj = new Integer(Integer.parseInt(t.image));
                    break;
                }
                case 79: {
                    t = this.jj_consume_token(79);
                    String num = t.image.substring(0, t.image.length() - 1);
                    obj = new Long(Long.parseLong(num));
                    break;
                }
                case 81: {
                    t = this.jj_consume_token(81);
                    obj = new Float(Float.parseFloat(t.image));
                    break;
                }
                case 80: {
                    t = this.jj_consume_token(80);
                    obj = new Double(Double.parseDouble(t.image));
                    break;
                }
                case 82: {
                    t = this.jj_consume_token(82);
                    obj = QueryParser.unquote(t.image);
                    break;
                }
                case 55: {
                    t = this.jj_consume_token(55);
                    obj = null;
                    break;
                }
                default: {
                    this.jj_la1[146] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.debug((Object)("Number: " + t.image + " obj type: " + DataType.findTypeName(DataType.findType(obj))));
            log.trace((Object)"Exiting AtomDatum");
            Object object = obj;
            return object;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final Object Datum() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(86);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Object obj = null;
        log.trace((Object)"Entering Datum");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 109: {
                    this.jj_consume_token(109);
                    obj = this.Map();
                    this.jj_consume_token(110);
                    break;
                }
                case 99: {
                    this.jj_consume_token(99);
                    obj = this.Bag();
                    this.jj_consume_token(100);
                    break;
                }
                case 87: {
                    this.jj_consume_token(87);
                    obj = this.Tuple();
                    this.jj_consume_token(88);
                    break;
                }
                case 55: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: {
                    obj = this.AtomDatum();
                    break;
                }
                default: {
                    this.jj_la1[147] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting Datum");
            Object object = obj;
            return object;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator Const(LogicalPlan lp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(87);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Object obj = null;
        byte type = 50;
        log.trace((Object)"Entering Const");
        try {
            if (this.jj_2_36(Integer.MAX_VALUE)) {
                obj = this.AtomDatum();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 55: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 87: 
                    case 99: 
                    case 109: {
                        obj = this.Datum();
                        break;
                    }
                    default: {
                        this.jj_la1[148] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            LOConst lConst = new LOConst(lp, new OperatorKey(this.scope, this.getNextId()), obj);
            type = DataType.findType(obj);
            log.debug((Object)("type: " + DataType.findTypeName(type)));
            lConst.setType(type);
            lp.add(lConst);
            log.debug((Object)("Const: Added operator " + lConst.getClass().getName() + " " + lConst + " to logical plan " + lp));
            log.trace((Object)"Exiting Const");
            LOConst lOConst = lConst;
            return lOConst;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final ExpressionOperator ColOrSpec(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator eOp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(88);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering ColOrSpec");
        try {
            ExpressionOperator spec;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 85: {
                    spec = this.DollarVar(over, specs, lp, eOp);
                    break;
                }
                case 36: 
                case 76: {
                    spec = this.AliasFieldOrSpec(over, specs, lp, eOp);
                    break;
                }
                default: {
                    this.jj_la1[149] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            log.trace((Object)"Exiting ColOrSpec");
            ExpressionOperator expressionOperator = spec;
            return expressionOperator;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExpressionOperator DollarVar(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator eOp) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(89);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        log.trace((Object)"Entering DollarVar");
        Token t1 = this.jj_consume_token(85);
        this.jjtree.closeNodeScope((Node)jjtn000, true);
        jjtc000 = false;
        int colNum = QueryParser.undollar(t1.image);
        log.debug((Object)("Token: " + t1.image));
        if (null != over && colNum >= over.size()) {
            throw new ParseException("Out of bound access. Trying to access non-existent column: " + colNum + ". Schema " + over + " has " + over.size() + " column(s).");
        }
        if (this.bracketed && eOp instanceof LOUserFunc && ((LOUserFunc)eOp).getImplicitReferencedOperator() != null) {
            try {
                ExpressionOperator expressionOperator = this.attachColPosToReadScalar(lp, (ExpressionOperator)eOp, colNum, over);
                return expressionOperator;
            }
            catch (Exception e) {
                throw new ParseException("Invalid field in scalar" + e);
            }
        }
        LOProject project = new LOProject(lp, new OperatorKey(this.scope, this.getNextId()), eOp, QueryParser.undollar(t1.image));
        try {
            log.debug((Object)("eOp: " + eOp.getClass().getName() + " " + eOp));
            lp.add(project);
            log.debug((Object)("DollarVar: Added operator " + project.getClass().getName() + " " + project + " to logical plan " + lp));
            if (eOp instanceof ExpressionOperator && this.bracketed) {
                lp.add(eOp);
                lp.connect(eOp, project);
            }
        }
        catch (Exception planException) {
            ParseException pe = new ParseException(planException.getMessage());
            pe.initCause(planException);
            throw pe;
        }
        log.trace((Object)"Exiting DollarVar");
        LOProject lOProject = project;
        return lOProject;
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExpressionOperator AliasFieldOrSpec(Schema over, Map<String, LogicalOperator> specs, LogicalPlan lp, LogicalOperator eOp) throws ParseException {
        ExpressionOperator item;
        boolean jjtc000;
        SimpleNode jjtn000;
        block31: {
            int i;
            Token t1;
            block32: {
                block33: {
                    jjtn000 = new SimpleNode(90);
                    jjtc000 = true;
                    this.jjtree.openNodeScope(jjtn000);
                    LogicalPlan projectInputPlan = new LogicalPlan();
                    log.trace((Object)"Entering AliasFieldOrSpec");
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 36: {
                            t1 = this.jj_consume_token(36);
                            break;
                        }
                        case 76: {
                            t1 = this.jj_consume_token(76);
                            break;
                        }
                        default: {
                            this.jj_la1[150] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    log.debug((Object)("Token: " + t1.image));
                    if (null != eOp) {
                        log.debug((Object)("eOp: " + eOp.getClass().getName()));
                    }
                    item = null;
                    if (specs != null) {
                        log.debug((Object)"specs != null");
                        LogicalOperator op = specs.get(t1.image);
                        if (null != op) {
                            log.debug((Object)("Alias: " + op.getAlias()));
                            if (op instanceof ExpressionOperator && this.insideGenerate()) {
                                item = (ExpressionOperator)op;
                            } else {
                                item = new LOProject(lp, new OperatorKey(this.scope, this.getNextId()), op, -1);
                                ((LOProject)item).setStar(true);
                                ((LOProject)item).setSendEmptyBagOnEOP(true);
                                log.debug((Object)"Set star to true");
                                item.setAlias(t1.image);
                            }
                            if (this.insideGenerate()) {
                                log.debug((Object)"AliasFieldOrSpec: Inside generate");
                                this.addGenerateInput(op);
                            }
                            try {
                                lp.add(item);
                                log.debug((Object)("AliasFieldOrSpec: Added operator " + item.getClass().getName() + " " + item + " to logical plan " + lp));
                                if (op instanceof ExpressionOperator && !this.insideGenerate()) {
                                    lp.add(op);
                                    lp.connect(op, item);
                                }
                            }
                            catch (Exception planException) {
                                ParseException pe = new ParseException(planException.getMessage());
                                pe.initCause(planException);
                                throw pe;
                            }
                        }
                    }
                    if (item != null) break block31;
                    log.debug((Object)"item == null");
                    if (null == over) {
                        log.debug((Object)"over is null");
                    }
                    try {
                        if (over != null && (i = over.getPosition(t1.image)) != -1) break block32;
                        LogicalOperator aliasOp = this.getOp(t1.image);
                        if (this.bracketed || aliasOp == null) break block33;
                        this.scalarFound = true;
                        Schema scalarSchema = aliasOp.getSchema();
                        log.debug((Object)("Scalar alias: " + t1.image + " found"));
                        item = new LOUserFunc(lp, new OperatorKey(this.scope, this.getNextId()), new FuncSpec(ReadScalars.class.getName()), 55);
                        ((LOUserFunc)item).setImplicitReferencedOperator(aliasOp);
                        lp.add(item);
                        log.trace((Object)"Exiting AliasFieldOrSpec");
                        ExpressionOperator expressionOperator = item;
                        return expressionOperator;
                    }
                    catch (FrontendException fee) {
                        ParseException pe = new ParseException(fee.getMessage());
                        pe.initCause(fee);
                        throw pe;
                    }
                }
                log.debug((Object)("Invalid alias: " + t1.image + " in " + over));
                if (null != over) {
                    log.debug((Object)"Printing out the aliases in the schema");
                    over.printAliases();
                }
                throw new ParseException("Invalid alias: " + t1.image + " in " + over);
            }
            log.debug((Object)("Position of " + t1.image + " = " + i));
            if (null != over) {
                log.debug((Object)"Printing out the aliases in the schema");
                over.printAliases();
            }
            if (this.bracketed && eOp instanceof LOUserFunc && ((LOUserFunc)eOp).getImplicitReferencedOperator() != null) {
                try {
                    ExpressionOperator fee = this.attachColPosToReadScalar(lp, (ExpressionOperator)eOp, i, over);
                    return fee;
                }
                catch (Exception e) {
                    throw new ParseException("Invalid field in scalar" + e);
                }
            }
            item = new LOProject(lp, new OperatorKey(this.scope, this.getNextId()), eOp, i);
            item.setAlias(t1.image);
            try {
                lp.add(item);
                log.debug((Object)("AliasFieldOrSpec: Added operator " + item.getClass().getName() + " " + item + " to logical plan " + lp));
                if (eOp instanceof ExpressionOperator && this.bracketed) {
                    lp.add(eOp);
                    lp.connect(eOp, item);
                }
            }
            catch (Exception planException) {
                ParseException parseException = new ParseException(planException.getMessage());
                parseException.initCause(planException);
                throw parseException;
            }
        }
        log.trace((Object)"Exiting AliasFieldOrSpec");
        ExpressionOperator expressionOperator = item;
        return expressionOperator;
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    private boolean jj_3R_128() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_126() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_149()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_150()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_127() {
        return this.jj_3R_35();
    }

    private boolean jj_3R_105() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_127()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_128()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_129()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_146() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(10)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(11)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(12)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(13)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(14)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(15)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(16)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(17)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(18)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(19)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(20)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(21)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(22)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(23)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(24)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(25)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(26)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(27)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(28)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(29)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(30)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(31)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(34)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(35)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(36)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(37)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(38)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(39)) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_scan_token(40)) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_scan_token(41)) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_scan_token(42)) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_scan_token(43)) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_scan_token(44)) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_scan_token(45)) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_scan_token(46)) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_scan_token(47)) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_scan_token(48)) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_scan_token(49)) {
                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                    if (this.jj_scan_token(50)) {
                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                        if (this.jj_scan_token(51)) {
                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                            if (this.jj_scan_token(52)) {
                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                if (this.jj_scan_token(53)) {
                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                    if (this.jj_scan_token(54)) {
                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                        if (this.jj_scan_token(55)) {
                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                            if (this.jj_scan_token(56)) {
                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                if (this.jj_scan_token(57)) {
                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                    if (this.jj_scan_token(58)) {
                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                        if (this.jj_scan_token(59)) {
                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                            if (this.jj_scan_token(60)) {
                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                if (this.jj_scan_token(61)) {
                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                    if (this.jj_scan_token(62)) {
                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                        if (this.jj_scan_token(63)) {
                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                            if (this.jj_scan_token(64)) {
                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                if (this.jj_scan_token(65)) {
                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                    if (this.jj_scan_token(66)) {
                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                        if (this.jj_scan_token(67)) {
                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                            if (this.jj_scan_token(68)) {
                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                if (this.jj_scan_token(69)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(70)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(71)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(76)) {
                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_104() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_35()) {
            return true;
        }
        if (this.jj_scan_token(88)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_126()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_113() {
        return false;
    }

    private boolean jj_3R_138() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        return this.jj_3R_39();
    }

    private boolean jj_3R_61() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_104()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_105()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_83() {
        return false;
    }

    private boolean jj_3R_55() {
        return this.jj_scan_token(87);
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        return this.jj_3R_32();
    }

    private boolean jj_3R_54() {
        return this.jj_3R_95();
    }

    private boolean jj_3R_32() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_54()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_3()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_55()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_112() {
        Token xsp;
        if (this.jj_3R_39()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_138());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_42() {
        return false;
    }

    private boolean jj_3R_81() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_112()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_113()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_175() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        return this.jj_3R_33();
    }

    private boolean jj_3_23() {
        this.jj_lookingAhead = true;
        this.jj_semLA = null != this.pigContext.getFuncSpecFromAlias(this.getToken((int)1).image);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_42()) {
            return true;
        }
        return this.jj_3R_43();
    }

    private boolean jj_3R_62() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        return this.jj_3R_61();
    }

    private boolean jj_3R_82() {
        return this.jj_3R_48();
    }

    private boolean jj_3R_37() {
        Token xsp;
        if (this.jj_3R_61()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_62());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_49() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_scan_token(99)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_82()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_83()) {
                return true;
            }
        }
        return this.jj_scan_token(100);
    }

    private boolean jj_3R_158() {
        if (this.jj_3R_35()) {
            return true;
        }
        if (this.jj_scan_token(54)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_175()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(55);
    }

    private boolean jj_3R_48() {
        if (this.jj_scan_token(52)) {
            return true;
        }
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_81()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_164() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(36)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(76)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_159() {
        if (this.jj_scan_token(39)) {
            return true;
        }
        return this.jj_3R_118();
    }

    private boolean jj_3_10() {
        return this.jj_3R_36();
    }

    private boolean jj_3R_36() {
        if (this.jj_3R_43()) {
            return true;
        }
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_60()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_50() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        if (this.jj_scan_token(109)) {
            return true;
        }
        return this.jj_scan_token(110);
    }

    private boolean jj_3_18() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_144() {
        return this.jj_3R_159();
    }

    private boolean jj_3R_143() {
        return this.jj_3R_158();
    }

    private boolean jj_3R_142() {
        return this.jj_3R_36();
    }

    private boolean jj_3R_78() {
        return false;
    }

    private boolean jj_3_9() {
        if (this.jj_3R_35()) {
            return true;
        }
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_141() {
        if (this.jj_3R_35()) {
            return true;
        }
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_scan_token(82);
    }

    private boolean jj_3R_51() {
        return this.jj_3R_84();
    }

    private boolean jj_3R_163() {
        return this.jj_scan_token(85);
    }

    private boolean jj_3_34() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_134() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        if (this.jj_scan_token(107)) {
            return true;
        }
        if (this.jj_3R_35()) {
            return true;
        }
        if (this.jj_scan_token(108)) {
            return true;
        }
        if (this.jj_3R_35()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3_33() {
        return this.jj_3R_50();
    }

    private boolean jj_3_32() {
        return this.jj_3R_49();
    }

    private boolean jj_3R_77() {
        return this.jj_3R_44();
    }

    private boolean jj_3_31() {
        return this.jj_3R_48();
    }

    private boolean jj_3_17() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_70() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_69() {
        return this.jj_3R_50();
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        return this.jj_scan_token(86);
    }

    private boolean jj_3R_68() {
        return this.jj_3R_49();
    }

    private boolean jj_3R_67() {
        return this.jj_3R_48();
    }

    private boolean jj_3R_39() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_67()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_68()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_69()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_70()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_152() {
        return this.jj_3R_164();
    }

    private boolean jj_3R_151() {
        return this.jj_3R_163();
    }

    private boolean jj_3R_133() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_151()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_152()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        if (this.jj_scan_token(86)) {
            return true;
        }
        return this.jj_scan_token(76);
    }

    private boolean jj_3R_57() {
        return false;
    }

    private boolean jj_3R_137() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        return this.jj_3R_96();
    }

    private boolean jj_3R_132() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3_36() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_136() {
        if (this.jj_scan_token(106)) {
            return true;
        }
        return this.jj_3R_154();
    }

    private boolean jj_3R_56() {
        Token xsp;
        if (this.jj_3R_96()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_137());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_57()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_30() {
        if (this.jj_scan_token(108)) {
            return true;
        }
        return this.jj_scan_token(51);
    }

    private boolean jj_3R_76() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(108)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_74() {
        return this.jj_3R_52();
    }

    private boolean jj_3R_73() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_131() {
        return this.jj_scan_token(76);
    }

    private boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_73()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_74()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_130() {
        return this.jj_scan_token(85);
    }

    private boolean jj_3R_106() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_130()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_131()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_132()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_21() {
        return this.jj_3R_36();
    }

    private boolean jj_3R_111() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_135()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_136()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_135() {
        if (this.jj_scan_token(101)) {
            return true;
        }
        return this.jj_3R_153();
    }

    private boolean jj_3R_110() {
        return this.jj_3R_134();
    }

    private boolean jj_3R_109() {
        return this.jj_3R_133();
    }

    private boolean jj_3R_88() {
        return this.jj_3R_53();
    }

    private boolean jj_3_29() {
        if (this.jj_scan_token(108)) {
            return true;
        }
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_75() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(108)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_87() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_157()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_108() {
        return this.jj_3R_36();
    }

    private boolean jj_3R_86() {
        if (this.jj_scan_token(99)) {
            return true;
        }
        if (this.jj_3R_156()) {
            return true;
        }
        return this.jj_scan_token(100);
    }

    private boolean jj_3R_85() {
        if (this.jj_scan_token(109)) {
            return true;
        }
        if (this.jj_3R_155()) {
            return true;
        }
        return this.jj_scan_token(110);
    }

    private boolean jj_3R_45() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_76()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(99)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_77()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_78()) {
                return true;
            }
        }
        return this.jj_scan_token(100);
    }

    private boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_85()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_86()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_87()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_88()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_22() {
        return this.jj_3R_41();
    }

    private boolean jj_3_8() {
        if (this.jj_3R_35()) {
            return true;
        }
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_72() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_108()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_109()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_110()) {
                    return true;
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_111());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_40() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_71()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_72()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_16() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_71() {
        return this.jj_3R_41();
    }

    private boolean jj_3R_93() {
        return this.jj_scan_token(82);
    }

    private boolean jj_3R_140() {
        if (this.jj_3R_35()) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_3R_35();
    }

    private boolean jj_3R_92() {
        return this.jj_scan_token(80);
    }

    private boolean jj_3_28() {
        if (this.jj_scan_token(108)) {
            return true;
        }
        return this.jj_scan_token(53);
    }

    private boolean jj_3R_79() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_28()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(108)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_91() {
        return this.jj_scan_token(81);
    }

    private boolean jj_3R_139() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_94() {
        return this.jj_scan_token(55);
    }

    private boolean jj_3R_118() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_139()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_140()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_141()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_142()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_143()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_144()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_44() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_75()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_33()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_90() {
        return this.jj_scan_token(79);
    }

    private boolean jj_3R_89() {
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_53() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_89()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_90()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_91()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_92()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_93()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_94()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_176() {
        if (this.jj_scan_token(103)) {
            return true;
        }
        return this.jj_3R_120();
    }

    private boolean jj_3_20() {
        return this.jj_3R_40();
    }

    private boolean jj_3R_80() {
        if (this.jj_scan_token(108)) {
            return true;
        }
        return this.jj_3R_84();
    }

    private boolean jj_3R_119() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        return this.jj_3R_118();
    }

    private boolean jj_3R_46() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_79()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(109)) {
            return true;
        }
        return this.jj_scan_token(110);
    }

    private boolean jj_3R_168() {
        return this.jj_scan_token(55);
    }

    private boolean jj_3R_167() {
        return this.jj_scan_token(82);
    }

    private boolean jj_3R_107() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        return this.jj_3R_106();
    }

    private boolean jj_3R_162() {
        return this.jj_3R_176();
    }

    private boolean jj_3R_154() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_167()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_168()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_179() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        return this.jj_3R_178();
    }

    private boolean jj_3R_161() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_35()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_160() {
        return this.jj_3R_40();
    }

    private boolean jj_3R_145() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_160()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_161()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_162()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        return this.jj_3R_33();
    }

    private boolean jj_3R_97() {
        Token xsp;
        if (this.jj_3R_118()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_119());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_15() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_178() {
        if (this.jj_3R_154()) {
            return true;
        }
        if (this.jj_scan_token(106)) {
            return true;
        }
        return this.jj_3R_52();
    }

    private boolean jj_3R_47() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_80()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_170() {
        return false;
    }

    private boolean jj_3_27() {
        return this.jj_3R_47();
    }

    private boolean jj_3_26() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_98() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        return this.jj_3R_97();
    }

    private boolean jj_3_25() {
        return this.jj_3R_45();
    }

    private boolean jj_3_24() {
        return this.jj_3R_44();
    }

    private boolean jj_3R_174() {
        return false;
    }

    private boolean jj_3R_169() {
        Token xsp;
        if (this.jj_3R_178()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_179());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_155() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_169()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_170()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_35() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        return this.jj_3R_52();
    }

    private boolean jj_3R_117() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_116() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_115() {
        return this.jj_3R_45();
    }

    private boolean jj_3R_58() {
        Token xsp;
        if (this.jj_3R_97()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_98());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_114() {
        return this.jj_3R_44();
    }

    private boolean jj_3R_96() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_114()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_115()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_116()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_117()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_19() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_39()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_180() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_157()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_120() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_145();
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        return this.jj_3R_33();
    }

    private boolean jj_3R_173() {
        Token xsp;
        if (this.jj_3R_52()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_35());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_34() {
        return this.jj_3R_58();
    }

    private boolean jj_3_12() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_37()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_157() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_173()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_174()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_66() {
        Token xsp;
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_106()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_107());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_65() {
        return this.jj_3R_106();
    }

    private boolean jj_3R_121() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(33)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(104)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(105)) {
                    return true;
                }
            }
        }
        return this.jj_3R_120();
    }

    private boolean jj_3R_64() {
        return this.jj_scan_token(85);
    }

    private boolean jj_3R_84() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(45)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(46)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(47)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(48)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(49)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(50)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_172() {
        return false;
    }

    private boolean jj_3R_99() {
        Token xsp;
        if (this.jj_3R_120()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_121());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_171() {
        Token xsp;
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_157()) {
            return true;
        }
        if (this.jj_scan_token(88)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_180());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_156() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_171()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_172()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_95() {
        return this.jj_scan_token(76);
    }

    private boolean jj_3R_181() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        return this.jj_3R_106();
    }

    private boolean jj_3R_63() {
        return this.jj_scan_token(76);
    }

    private boolean jj_3R_177() {
        Token xsp;
        if (this.jj_3R_106()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_181());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_63()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_64()) {
                return true;
            }
        }
        if (this.jj_scan_token(101)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_65()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_66()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_100() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(102)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(103)) {
                return true;
            }
        }
        return this.jj_3R_99();
    }

    private boolean jj_3R_166() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_177()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_165() {
        return this.jj_3R_133();
    }

    private boolean jj_3R_153() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_165()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_166()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_148() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_147() {
        return this.jj_3R_35();
    }

    private boolean jj_3R_59() {
        Token xsp;
        if (this.jj_3R_99()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_100());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_124() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_147()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_148()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_11() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_37()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3_14() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_150() {
        return this.jj_3R_96();
    }

    private boolean jj_3R_35() {
        return this.jj_3R_59();
    }

    private boolean jj_3_13() {
        return this.jj_3R_36();
    }

    private boolean jj_3R_103() {
        return false;
    }

    private boolean jj_3R_123() {
        if (this.jj_scan_token(111)) {
            return true;
        }
        return this.jj_3R_146();
    }

    private boolean jj_3R_125() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        return this.jj_3R_124();
    }

    private boolean jj_3R_101() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_122()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_123()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_122() {
        if (this.jj_scan_token(101)) {
            return true;
        }
        return this.jj_3R_146();
    }

    private boolean jj_3R_102() {
        Token xsp;
        if (this.jj_3R_124()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_125());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_60() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_102()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_103()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_43() {
        Token xsp;
        if (this.jj_scan_token(76)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_101());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_129() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_3R_96();
    }

    private boolean jj_3R_149() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_33()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x8000000, 8305664, 0, 0x8000000, 4111360, 0, 0, -512, 0, 0x8000000, 262144, 0, 0, 0x8000000, 4111360, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0x16000000, -1073741824, -1073741824, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0x20000000, 0, 0, 0, 0x20000000, 0, 0, 233472, 0, 0, 0, 0, 98304, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0x8000000, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0xD000010, 0, 0, 0xD000010, 0, 0, -4, 0, 0, 16, 8, 0, 0, 0xD000010, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 32, 0x800090, 128, 0, 0, 0, 8, 0, 8389138, 0, 8389138, 0, 0, 0, 0, 6144, 6144, 18, 0, 6144, 6144, 6144, 6144, 16, 16, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, -268435456, -268435456, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0x800010, 0, 0, 16, 0x800010, 0, 0x800010, 0, 6144, 6144, 18, 0, 0x800010, 0x800010, 0, 0, 0, 8388626, 0, 8389138, 0, 0, 2, 2, 0, 16, 0, 0, 16, 0, 0, 0, 8388626, 8388626, 4186112, 0x380000, 516096, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x100000, 0, 4186112, 0, 0, 0, 0, 16, 0, 0, 0, 0x800000, 0, 0x800000, 0x800000, 0x800000, 0x800000, 0x800000, 16, 16};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0x801018, 0x4000000, 0, 0x801018, 4096, 0x800000, 4351, 4096, 0, 0, 0, 4096, 0, 24, 0, 0, 0x4000000, 262144, 786432, 0x4000000, 786432, 786432, 0x800000, 4096, 0, 0x100000, 49152, 0, 0, 10997760, 0, 0x4000000, 939786240, 0, 0, 0x4000000, 10997760, 0x4000000, 10997760, 0, 0, 0, 0x4000000, 0, 0, 0xA01000, 0, 0, 0, 0, 0, 0xA01000, 0x201000, 0x4000000, 0, 0, 0, 0, 224, 224, 0x4000000, -1073741824, 0, -536608768, 0, 0, 0, 0x4000000, 0x101000, 1, 1, 0x101000, 0x4000000, 262144, 0, 0x4000000, 0, 262150, 8, 262144, 0, 4096, 0, 10997768, 0x201000, 0x4000000, 0xA01000, 10997760, 0, 10997760, 0x4000000, 0, 0, 0xA01000, 0, 10997760, 10997760, 0x4000000, 0x801000, 0, 10997760, 0, 10997760, 0, 0, 0, 0, 0x800000, 0xA01000, 0, 0, 0xA01000, 0x800000, 4096, 0x4000000, 10997760, 10997760, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4096, 0x4000000, 4096, 0, 0x4000000, 0, 0, 0, 0, 0, 0xA01000, 0x4000000, 0x4000000, 0x800000, 8896512, 0x4000000, 262144, 262144, 507904, 8896512, 8896512, 0x201000, 4096};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8328, 0, 0, 0, 0, 0, 0, 8328, 0, 8328, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8328, 0, 0, 0, 8200, 0, 8200, 0, 0, 0, 0, 0, 8200, 8200, 0, 0, 0, 8328, 0, 8328, 192, 192, 768, 768, 128, 0, 1056, 1056, 0, 0, 0, 0, 8328, 8328, 0, 0, 0, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 0, 0, 0, 0, 0, 0, 32800, 32800, 32800, 32800, 0, 0, 0, 0, 8200, 0, 0, 0, 0, 8200, 8200, 0, 0};
    }

    public QueryParser(InputStream stream) {
        this(stream, null);
    }

    public QueryParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new QueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 151; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (i = 0; i < 151; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public QueryParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new QueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 151; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (i = 0; i < 151; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public QueryParser(QueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 151; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(QueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (i = 0; i < 151; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jj_lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[112];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 151; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 112; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 36; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        QueryParser.jj_la1_init_0();
        QueryParser.jj_la1_init_1();
        QueryParser.jj_la1_init_2();
        QueryParser.jj_la1_init_3();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    public class CogroupInput {
        public LogicalOperator op;
        public ArrayList<LogicalPlan> plans;
        public boolean isInner;
    }
}

