/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan.optimizer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.impl.plan.optimizer.Rule;
import org.apache.pig.impl.plan.optimizer.RuleMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlanOptimizer<O extends Operator, P extends OperatorPlan<O>> {
    protected List<Rule<O, P>> mRules = new ArrayList<Rule<O, P>>();
    protected P mPlan;
    protected int mMaxIterations;

    protected PlanOptimizer(P plan) {
        this(plan, 500);
    }

    protected PlanOptimizer(P plan, int iterations) {
        this.mPlan = plan;
        this.mMaxIterations = iterations < 0 ? 1000 : iterations;
    }

    public int optimize() throws OptimizerException {
        boolean sawMatch = false;
        int numIterations = 0;
        do {
            sawMatch = false;
            Iterator<Rule<O, P>> i$ = this.mRules.iterator();
            while (i$.hasNext()) {
                RuleMatcher<O, P> matcher = new RuleMatcher<O, P>();
                Rule<O, P> rule = i$.next();
                if (!matcher.match(rule)) continue;
                List matches = matcher.getAllMatches();
                for (List match : matches) {
                    if (rule.getTransformer().check(match)) {
                        sawMatch = true;
                        rule.getTransformer().transform(match);
                    }
                    rule.getTransformer().reset();
                }
            }
        } while (sawMatch && ++numIterations < this.mMaxIterations);
        return numIterations;
    }
}

