/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.expression;

import java.util.List;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.ColumnExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class ProjectExpression
extends ColumnExpression {
    private int input;
    private int col;
    private LogicalRelationalOperator attachedRelationalOp;

    public ProjectExpression(OperatorPlan plan, int inputNum, int colNum, LogicalRelationalOperator attachedRelationalOp) {
        super("Project", plan);
        this.input = inputNum;
        this.col = colNum;
        plan.add(this);
        this.attachedRelationalOp = attachedRelationalOp;
    }

    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalExpressionVisitor)) {
            throw new FrontendException("Expected LogicalExpressionVisitor", 2222);
        }
        ((LogicalExpressionVisitor)v).visit(this);
    }

    public int getInputNum() {
        return this.input;
    }

    public void setInputNum(int inputNum) {
        this.input = inputNum;
    }

    public int getColNum() {
        return this.col;
    }

    public void setColNum(int colNum) {
        this.col = colNum;
    }

    public boolean isProjectStar() {
        return this.col < 0;
    }

    public LogicalSchema.LogicalFieldSchema getFieldSchema() throws FrontendException {
        if (this.fieldSchema != null) {
            return this.fieldSchema;
        }
        LogicalRelationalOperator referent = this.findReferent();
        LogicalSchema schema = referent.getSchema();
        if (this.attachedRelationalOp instanceof LOGenerate && this.plan.getSuccessors(this) == null) {
            if (!(this.findReferent() instanceof LOInnerLoad) || ((LOInnerLoad)this.findReferent()).sourceIsBag()) {
                String alias = this.findReferent().getAlias();
                List<LOInnerLoad> innerLoads = LOForEach.findReacheableInnerLoadFromBoundaryProject(this);
                if (innerLoads.get((int)0).getProjection().getFieldSchema().schema != null && innerLoads.get((int)0).getProjection().getFieldSchema().schema.isTwoLevelAccessRequired()) {
                    LogicalSchema.LogicalFieldSchema originalTupleFieldSchema = innerLoads.get((int)0).getProjection().getFieldSchema().schema.getField(0);
                    LogicalSchema.LogicalFieldSchema newTupleFieldSchema = new LogicalSchema.LogicalFieldSchema(originalTupleFieldSchema.alias, schema, 110);
                    newTupleFieldSchema.uid = originalTupleFieldSchema.uid;
                    LogicalSchema newTupleSchema = new LogicalSchema();
                    newTupleSchema.setTwoLevelAccessRequired(true);
                    newTupleSchema.addField(newTupleFieldSchema);
                    this.fieldSchema = new LogicalSchema.LogicalFieldSchema(alias, newTupleSchema, 120);
                } else {
                    this.fieldSchema = new LogicalSchema.LogicalFieldSchema(alias, schema, 120);
                }
                this.fieldSchema.uid = innerLoads.get((int)0).getProjection().getFieldSchema().uid;
            } else if (this.findReferent().getSchema() != null) {
                this.fieldSchema = this.findReferent().getSchema().getField(0);
            }
            if (this.fieldSchema != null) {
                this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
            }
        } else if (schema == null) {
            this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, null, 50);
            this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
        } else {
            int index = -1;
            if (!this.isProjectStar() && this.uidOnlyFieldSchema != null) {
                long uid = this.uidOnlyFieldSchema.uid;
                for (int i = 0; i < schema.size(); ++i) {
                    LogicalSchema.LogicalFieldSchema fs = schema.getField(i);
                    if (fs.uid != uid) continue;
                    index = i;
                }
            }
            if (index == -1) {
                index = this.col;
            }
            if (!this.isProjectStar()) {
                this.fieldSchema = schema != null && schema.size() > index ? schema.getField(index) : new LogicalSchema.LogicalFieldSchema(null, null, 50);
                this.uidOnlyFieldSchema = this.fieldSchema.cloneUid();
            } else {
                LogicalSchema newTupleSchema = null;
                if (schema != null) {
                    newTupleSchema = schema.deepCopy();
                }
                this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, newTupleSchema, 110);
                this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
            }
        }
        return this.fieldSchema;
    }

    public LogicalRelationalOperator findReferent() throws FrontendException {
        List<Operator> preds = this.attachedRelationalOp.getPlan().getPredecessors(this.attachedRelationalOp);
        if (preds == null || this.input >= preds.size()) {
            throw new FrontendException("Projection with nothing to reference!", 2225);
        }
        LogicalRelationalOperator pred = (LogicalRelationalOperator)preds.get(this.input);
        if (pred == null) {
            throw new FrontendException("Cannot fine reference for " + this, 2226);
        }
        return pred;
    }

    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof ProjectExpression) {
            ProjectExpression po = (ProjectExpression)other;
            return po.input == this.input && po.col == this.col;
        }
        return false;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        if (this.fieldSchema != null && this.fieldSchema.alias != null) {
            msg.append(this.fieldSchema.alias + ":");
        }
        msg.append("(Name: " + this.name + " Type: ");
        if (this.fieldSchema != null) {
            msg.append(DataType.findTypeName(this.fieldSchema.type));
        } else {
            msg.append("null");
        }
        msg.append(" Uid: ");
        if (this.fieldSchema != null) {
            msg.append(this.fieldSchema.uid);
        } else {
            msg.append("null");
        }
        msg.append(" Input: " + this.input + " Column: ");
        if (this.isProjectStar()) {
            msg.append("(*)");
        } else {
            msg.append(this.col);
        }
        msg.append(")");
        return msg.toString();
    }

    public LogicalRelationalOperator getAttachedRelationalOp() {
        return this.attachedRelationalOp;
    }

    public void setAttachedRelationalOp(LogicalRelationalOperator attachedRelationalOp) {
        this.attachedRelationalOp = attachedRelationalOp;
    }

    public byte getType() throws FrontendException {
        if (this.getFieldSchema() == null) {
            if (this.attachedRelationalOp instanceof LOGenerate && this.findReferent() instanceof LOInnerLoad && ((LOInnerLoad)this.findReferent()).getProjection().getColNum() == -1) {
                return 110;
            }
            return 50;
        }
        return super.getType();
    }

    public LogicalExpression deepCopy(LogicalExpressionPlan lgExpPlan) throws FrontendException {
        ProjectExpression copy = new ProjectExpression(lgExpPlan, this.getInputNum(), this.getColNum(), this.getAttachedRelationalOp());
        return copy;
    }
}

