/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.expression;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.Util;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserFuncExpression
extends LogicalExpression {
    private FuncSpec mFuncSpec;
    private Operator implicitReferencedOperator = null;
    private EvalFunc<?> ef = null;

    public UserFuncExpression(OperatorPlan plan, FuncSpec funcSpec) {
        super("UserFunc", plan);
        this.mFuncSpec = funcSpec;
        plan.add(this);
    }

    public FuncSpec getFuncSpec() {
        return this.mFuncSpec;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalExpressionVisitor)) {
            throw new FrontendException("Expected LogicalExpressionVisitor", 2222);
        }
        ((LogicalExpressionVisitor)v).visit(this);
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (other instanceof UserFuncExpression) {
            UserFuncExpression exp = (UserFuncExpression)other;
            return this.mFuncSpec.equals(exp.mFuncSpec);
        }
        return false;
    }

    public List<LogicalExpression> getArguments() throws FrontendException {
        List<Operator> successors = null;
        ArrayList<LogicalExpression> args = new ArrayList<LogicalExpression>();
        successors = this.plan.getSuccessors(this);
        if (successors == null) {
            return args;
        }
        for (Operator lo : successors) {
            args.add((LogicalExpression)lo);
        }
        return args;
    }

    public void setFuncSpec(FuncSpec funcSpec) {
        this.mFuncSpec = funcSpec;
    }

    @Override
    public LogicalSchema.LogicalFieldSchema getFieldSchema() throws FrontendException {
        Schema udfSchema;
        if (this.fieldSchema != null) {
            return this.fieldSchema;
        }
        if (this.implicitReferencedOperator != null && this.mFuncSpec.getClassName().equals("org.apache.pig.impl.builtin.ReadScalars")) {
            List<Operator> args = this.plan.getSuccessors(this);
            if (args != null && args.size() > 0) {
                int pos = (Integer)((ConstantExpression)args.get(0)).getValue();
                LogicalRelationalOperator inp = (LogicalRelationalOperator)this.implicitReferencedOperator;
                if (inp.getSchema() != null) {
                    LogicalSchema.LogicalFieldSchema inpFs = inp.getSchema().getField(pos);
                    this.fieldSchema = new LogicalSchema.LogicalFieldSchema(inpFs);
                } else {
                    this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, null, 50);
                }
                return this.fieldSchema;
            }
            return null;
        }
        LogicalSchema inputSchema = new LogicalSchema();
        List<Operator> succs = this.plan.getSuccessors(this);
        if (succs != null) {
            for (Operator lo : succs) {
                if (((LogicalExpression)lo).getFieldSchema() == null) {
                    inputSchema = null;
                    break;
                }
                inputSchema.addField(((LogicalExpression)lo).getFieldSchema());
            }
        }
        if (this.ef == null) {
            this.ef = (EvalFunc)PigContext.instantiateFuncFromSpec(this.mFuncSpec);
        }
        if ((udfSchema = this.ef.outputSchema(Util.translateSchema(inputSchema))) != null) {
            Schema.FieldSchema fs = udfSchema.size() == 0 ? new Schema.FieldSchema(null, null, DataType.findType(this.ef.getReturnType())) : (udfSchema.size() == 1 ? new Schema.FieldSchema(udfSchema.getField(0)) : new Schema.FieldSchema(null, udfSchema, 110));
            this.fieldSchema = Util.translateFieldSchema(fs);
        } else {
            this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, null, DataType.findType(this.ef.getReturnType()));
        }
        this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
        return this.fieldSchema;
    }

    public Operator getImplicitReferencedOperator() {
        return this.implicitReferencedOperator;
    }

    public void setImplicitReferencedOperator(Operator implicitReferencedOperator) {
        this.implicitReferencedOperator = implicitReferencedOperator;
    }

    @Override
    public LogicalExpression deepCopy(LogicalExpressionPlan lgExpPlan) throws FrontendException {
        UserFuncExpression copy = null;
        try {
            copy = new UserFuncExpression(lgExpPlan, this.getFuncSpec().clone());
            copy.setImplicitReferencedOperator(this.getImplicitReferencedOperator());
            List<Operator> inputs = this.plan.getSuccessors(this);
            if (inputs != null) {
                for (Operator op : inputs) {
                    LogicalExpression input = (LogicalExpression)op;
                    LogicalExpression inputCopy = input.deepCopy(lgExpPlan);
                    lgExpPlan.add(inputCopy);
                    lgExpPlan.connect(copy, inputCopy);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return copy;
    }

    @Override
    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("(Name: " + this.name + "(" + this.getFuncSpec() + ")" + " Type: ");
        if (this.fieldSchema != null) {
            msg.append(DataType.findTypeName(this.fieldSchema.type));
        } else {
            msg.append("null");
        }
        msg.append(" Uid: ");
        if (this.fieldSchema != null) {
            msg.append(this.fieldSchema.uid);
        } else {
            msg.append("null");
        }
        msg.append(")");
        return msg.toString();
    }
}

