/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.util.IdentityHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquivalenceClasses {
    public static Collection<IdentityHashSet<Tuple>> getEquivalenceClasses(LogicalOperator op, Map<LogicalOperator, DataBag> derivedData) throws ExecException {
        if (op instanceof LOCogroup) {
            return EquivalenceClasses.getEquivalenceClasses((LOCogroup)op, derivedData);
        }
        if (op instanceof LOForEach) {
            return EquivalenceClasses.getEquivalenceClasses((LOForEach)op, derivedData);
        }
        if (op instanceof LOFilter) {
            return EquivalenceClasses.getEquivalenceClasses((LOFilter)op, derivedData);
        }
        if (op instanceof LOSort) {
            return EquivalenceClasses.getEquivalenceClasses((LOSort)op, derivedData);
        }
        if (op instanceof LOSplit) {
            return EquivalenceClasses.getEquivalenceClasses((LOSplit)op, derivedData);
        }
        if (op instanceof LOUnion) {
            return EquivalenceClasses.getEquivalenceClasses((LOUnion)op, derivedData);
        }
        if (op instanceof LOLoad) {
            return EquivalenceClasses.getEquivalenceClasses((LOLoad)op, derivedData);
        }
        throw new RuntimeException("Unrecognized logical operator.");
    }

    static Collection<IdentityHashSet<Tuple>> getEquivalenceClasses(LOLoad op, Map<LogicalOperator, DataBag> derivedData) {
        LinkedList<IdentityHashSet<Tuple>> equivClasses = new LinkedList<IdentityHashSet<Tuple>>();
        IdentityHashSet<Tuple> input = new IdentityHashSet<Tuple>();
        equivClasses.add(input);
        DataBag output = derivedData.get(op);
        for (Tuple t : output) {
            input.add(t);
        }
        return equivClasses;
    }

    static Collection<IdentityHashSet<Tuple>> getEquivalenceClasses(LOCogroup op, Map<LogicalOperator, DataBag> derivedData) throws ExecException {
        LinkedList<IdentityHashSet<Tuple>> equivClasses = new LinkedList<IdentityHashSet<Tuple>>();
        IdentityHashSet<Tuple> acceptableGroups = new IdentityHashSet<Tuple>();
        equivClasses.add(acceptableGroups);
        for (Tuple t : derivedData.get(op)) {
            boolean isAcceptable;
            if (t.size() == 2) {
                isAcceptable = ((DataBag)t.get(1)).size() >= 2L;
            } else {
                isAcceptable = true;
                for (int field = 1; field < t.size(); ++field) {
                    DataBag bag = (DataBag)t.get(field);
                    if (bag.size() != 0L) continue;
                    isAcceptable = false;
                    break;
                }
            }
            if (!isAcceptable) continue;
            acceptableGroups.add(t);
        }
        return equivClasses;
    }

    static Collection<IdentityHashSet<Tuple>> getEquivalenceClasses(LOForEach op, Map<LogicalOperator, DataBag> derivedData) {
        LinkedList<IdentityHashSet<Tuple>> equivClasses = new LinkedList<IdentityHashSet<Tuple>>();
        IdentityHashSet<Tuple> equivClass = new IdentityHashSet<Tuple>();
        equivClasses.add(equivClass);
        Iterator<Tuple> it = derivedData.get(op).iterator();
        while (it.hasNext()) {
            equivClass.add(it.next());
        }
        return equivClasses;
    }

    static Collection<IdentityHashSet<Tuple>> getEquivalenceClasses(LOFilter op, Map<LogicalOperator, DataBag> derivedData) {
        LinkedList<IdentityHashSet<Tuple>> equivClasses = new LinkedList<IdentityHashSet<Tuple>>();
        IdentityHashSet<Tuple> pass = new IdentityHashSet<Tuple>();
        IdentityHashSet<Tuple> fail = new IdentityHashSet<Tuple>();
        Iterator<Tuple> it = derivedData.get(op).iterator();
        while (it.hasNext()) {
            pass.add(it.next());
        }
        LogicalOperator input = op.getInput();
        for (Tuple t : derivedData.get(input)) {
            if (pass.contains(t)) continue;
            fail.add(t);
        }
        equivClasses.add(pass);
        equivClasses.add(fail);
        return equivClasses;
    }

    static Collection<IdentityHashSet<Tuple>> getEquivalenceClasses(LOSort op, Map<LogicalOperator, DataBag> derivedData) {
        IdentityHashSet temp = new IdentityHashSet();
        LinkedList<IdentityHashSet<Tuple>> output = new LinkedList<IdentityHashSet<Tuple>>();
        output.add(temp);
        return output;
    }

    static Collection<IdentityHashSet<Tuple>> getEquivalenceClasses(LOSplit op, Map<LogicalOperator, DataBag> derivedData) {
        throw new RuntimeException("LOSplit not supported yet in example generator.");
    }

    static Collection<IdentityHashSet<Tuple>> getEquivalenceClasses(LOUnion op, Map<LogicalOperator, DataBag> derivedData) {
        LinkedList<IdentityHashSet<Tuple>> equivClasses = new LinkedList<IdentityHashSet<Tuple>>();
        for (LogicalOperator input : op.getInputs()) {
            IdentityHashSet<Tuple> equivClass = new IdentityHashSet<Tuple>();
            Iterator<Tuple> it = derivedData.get(input).iterator();
            while (it.hasNext()) {
                equivClass.add(it.next());
            }
            equivClasses.add(equivClass);
        }
        return equivClasses;
    }
}

