/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.PlanSetter;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.validators.LogicalPlanValidationExecutor;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.AugmentBaseDataVisitor;
import org.apache.pig.pen.DerivedDataVisitor;
import org.apache.pig.pen.LineageTrimmingVisitor;
import org.apache.pig.pen.LocalLogToPhyTranslationVisitor;
import org.apache.pig.pen.util.DisplayExamples;
import org.apache.pig.pen.util.FunctionalLogicalOptimizer;
import org.apache.pig.pen.util.LineageTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleGenerator {
    LogicalPlan plan;
    Map<LOLoad, DataBag> baseData;
    PigContext pigContext;
    Map<LogicalOperator, PhysicalOperator> LogToPhyMap;
    PhysicalPlan physPlan;
    Log log = LogFactory.getLog(this.getClass());
    private int MAX_RECORDS = 10000;

    public ExampleGenerator(LogicalPlan plan, PigContext hadoopPigContext) {
        this.plan = plan;
        this.pigContext = hadoopPigContext;
        try {
            this.pigContext.connect();
        }
        catch (ExecException e) {
            this.log.error((Object)("Error connecting to the cluster " + e.getLocalizedMessage()));
        }
    }

    public void setMaxRecords(int max) {
        this.MAX_RECORDS = max;
    }

    public Map<LogicalOperator, DataBag> getExamples() {
        this.compilePlan(this.plan);
        List<LogicalOperator> loads = this.plan.getRoots();
        try {
            this.readBaseData(loads);
        }
        catch (ExecException e) {
            this.log.error((Object)("Error reading data. " + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
        catch (FrontendException e) {
            this.log.error((Object)("Error reading data. " + e.getMessage()));
        }
        DerivedDataVisitor derivedData = null;
        try {
            LineageTrimmingVisitor trimmer = new LineageTrimmingVisitor(this.plan, this.baseData, this.LogToPhyMap, this.physPlan, this.pigContext);
            trimmer.visit();
            derivedData = new DerivedDataVisitor(this.plan, null, this.baseData, trimmer.LogToPhyMap, this.physPlan);
            derivedData.visit();
            AugmentBaseDataVisitor augment = new AugmentBaseDataVisitor(this.plan, this.baseData, derivedData.derivedData);
            augment.visit();
            this.baseData = augment.getNewBaseData();
            trimmer = new LineageTrimmingVisitor(this.plan, this.baseData, derivedData.LogToPhyMap, this.physPlan, this.pigContext);
            trimmer.visit();
            derivedData = new DerivedDataVisitor(this.plan, null, this.baseData, trimmer.LogToPhyMap, this.physPlan);
            derivedData.visit();
        }
        catch (VisitorException e) {
            this.log.error((Object)("Visitor exception while creating example data " + e.getMessage()));
        }
        System.out.println(DisplayExamples.printTabular(this.plan, derivedData.derivedData));
        return derivedData.derivedData;
    }

    private void readBaseData(List<LogicalOperator> loads) throws ExecException, FrontendException {
        this.baseData = new HashMap<LOLoad, DataBag>();
        for (LogicalOperator op : loads) {
            Schema schema = op.getSchema();
            if (schema == null) {
                throw new ExecException("Example Generator requires a schema. Please provide a schema while loading data.");
            }
            DataBag opBaseData = BagFactory.getInstance().newDefaultBag();
            POLoad poLoad = (POLoad)this.LogToPhyMap.get(op);
            poLoad.setLineageTracer(new LineageTracer());
            Tuple t = null;
            int count = 0;
            Result res = poLoad.getNext(t);
            while (res.returnStatus != 3 && count < this.MAX_RECORDS) {
                if (res.returnStatus != 1) {
                    if (res.returnStatus == 2) {
                        this.log.error((Object)"Error reading Tuple");
                    } else {
                        opBaseData.add((Tuple)res.result);
                        ++count;
                    }
                }
                res = poLoad.getNext(t);
            }
            this.baseData.put((LOLoad)op, opBaseData);
            poLoad.setLineageTracer(null);
        }
    }

    private void compilePlan(LogicalPlan plan) {
        plan = this.refineLogicalPlan(plan);
        LocalLogToPhyTranslationVisitor visitor = new LocalLogToPhyTranslationVisitor(plan);
        visitor.setPigContext(this.pigContext);
        try {
            visitor.visit();
        }
        catch (VisitorException e) {
            e.printStackTrace();
            this.log.error((Object)"Error visiting the logical plan in ExampleGenerator");
        }
        this.physPlan = visitor.getPhysicalPlan();
        this.LogToPhyMap = visitor.getLogToPhyMap();
    }

    private LogicalPlan refineLogicalPlan(LogicalPlan plan) {
        PlanSetter ps = new PlanSetter(plan);
        try {
            ps.visit();
        }
        catch (VisitorException e) {
            e.printStackTrace();
        }
        CompilationMessageCollector collector = new CompilationMessageCollector();
        FrontendException caught = null;
        try {
            boolean isBeforeOptimizer = true;
            LogicalPlanValidationExecutor validator = new LogicalPlanValidationExecutor(plan, this.pigContext, isBeforeOptimizer);
            validator.validate(plan, collector);
            FunctionalLogicalOptimizer optimizer = new FunctionalLogicalOptimizer(plan);
            optimizer.optimize();
            isBeforeOptimizer = false;
            validator = new LogicalPlanValidationExecutor(plan, this.pigContext, isBeforeOptimizer);
            validator.validate(plan, collector);
        }
        catch (FrontendException fe) {
            caught = fe;
        }
        return plan;
    }
}

