/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen.physicalOperators;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.SortedDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.util.ExampleTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POCogroup
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    Tuple[] data = null;
    transient Iterator<Tuple>[] its = null;
    boolean[] inner;

    public POCogroup(OperatorKey k) {
        super(k);
    }

    public POCogroup(OperatorKey k, int rp) {
        super(k, rp);
    }

    public POCogroup(OperatorKey k, List<PhysicalOperator> inp) {
        super(k, inp);
    }

    public POCogroup(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    public void setInner(boolean[] inner) {
        this.inner = inner;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitPenCogroup(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "POCogroup" + ": POCogroup" + "[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        int i;
        if (this.its == null) {
            this.accumulateData();
        }
        boolean done = true;
        Result res = new Result();
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            done &= this.data[i2] == null;
        }
        if (done) {
            res.returnStatus = (byte)3;
            this.its = null;
            return res;
        }
        Tuple smallestTuple = this.getSmallest(this.data);
        groupComparator comp = new groupComparator();
        int size = this.data.length;
        Tuple output = TupleFactory.getInstance().newTuple(size + 1);
        output.set(0, smallestTuple.get(1));
        for (int i3 = 1; i3 < size + 1; ++i3) {
            output.set(i3, BagFactory.getInstance().newDefaultBag());
        }
        ExampleTuple tOut = null;
        if (this.lineageTracer != null) {
            tOut = new ExampleTuple(output);
            this.lineageTracer.insert(tOut);
        }
        boolean loop = true;
        while (loop) {
            loop = false;
            for (i = 0; i < size; ++i) {
                if (this.data[i] == null || comp.compare(this.data[i], smallestTuple) != 0) continue;
                loop = true;
                DataBag bag = (DataBag)output.get(i + 1);
                Tuple temp = (Tuple)this.data[i].get(2);
                if (this.lineageTracer != null) {
                    if (((ExampleTuple)temp).synthetic) {
                        tOut.synthetic = true;
                    }
                    this.lineageTracer.union(temp, tOut);
                }
                bag.add(temp);
                this.data[i] = this.its[i].hasNext() ? this.its[i].next() : null;
            }
        }
        res.result = this.lineageTracer != null ? tOut : output;
        res.returnStatus = 0;
        for (i = 0; i < size; ++i) {
            if (this.inner == null || !this.inner[i] || ((DataBag)output.get(i + 1)).size() != 0L) continue;
            res.returnStatus = 1;
            break;
        }
        return res;
    }

    private void accumulateData() throws ExecException {
        int size = this.inputs.size();
        this.its = new Iterator[size];
        this.data = new Tuple[size];
        for (int i = 0; i < size; ++i) {
            SortedDataBag bag = new SortedDataBag(new groupComparator());
            Result input = ((PhysicalOperator)this.inputs.get(i)).getNext(dummyTuple);
            while (input.returnStatus != 3) {
                if (input.returnStatus == 2) {
                    throw new ExecException("Error accumulating output at local Cogroup operator");
                }
                if (input.returnStatus != 1) {
                    bag.add((Tuple)input.result);
                }
                input = ((PhysicalOperator)this.inputs.get(i)).getNext(dummyTuple);
            }
            this.its[i] = bag.iterator();
            this.data[i] = this.its[i].next();
        }
    }

    private Tuple getSmallest(Tuple[] data) {
        Tuple t = null;
        groupComparator comp = new groupComparator();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == null) continue;
            if (t == null) {
                t = data[i];
                continue;
            }
            if (comp.compare(t, data[i]) <= 0) continue;
            t = data[i];
        }
        return t;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class groupComparator
    implements Comparator<Tuple> {
        private groupComparator() {
        }

        @Override
        public int compare(Tuple o1, Tuple o2) {
            Object t1 = null;
            Object t2 = null;
            try {
                t1 = o1.get(1);
                t2 = o2.get(1);
                if (t1 == t2 && t1 == null) {
                    byte firstInputIndex = (Byte)o1.get(0);
                    byte secondInputIndex = (Byte)o2.get(0);
                    return firstInputIndex - secondInputIndex;
                }
            }
            catch (ExecException e) {
                throw new RuntimeException("Error comparing tuples");
            }
            int result = DataType.compare(t1, t2);
            if (result == 0 && t1 instanceof Tuple && t2 instanceof Tuple) {
                try {
                    byte firstInputIndex = (Byte)o1.get(0);
                    byte secondInputIndex = (Byte)o2.get(0);
                    for (int i = 0; i < ((Tuple)t1).size(); ++i) {
                        if (((Tuple)t1).get(i) != null) continue;
                        return firstInputIndex - secondInputIndex;
                    }
                }
                catch (ExecException e) {
                    throw new RuntimeException("Error comparing tuple fields", e);
                }
            }
            return result;
        }
    }
}

