/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen.physicalOperators;

import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSplit
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    DataBag data = BagFactory.getInstance().newDefaultBag();
    boolean processingDone = false;

    public POSplit(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    public POSplit(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POSplit(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public POSplit(OperatorKey k) {
        this(k, -1, null);
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        if (!this.processingDone) {
            Result input = ((PhysicalOperator)this.inputs.get(0)).getNext(dummyTuple);
            while (input.returnStatus != 3) {
                if (input.returnStatus == 2) {
                    throw new ExecException("Error accumulating output at local Split operator");
                }
                if (input.returnStatus != 1) {
                    this.data.add((Tuple)input.result);
                }
                input = ((PhysicalOperator)this.inputs.get(0)).getNext(dummyTuple);
            }
            this.processingDone = true;
        }
        Result res = new Result();
        res.returnStatus = 0;
        res.result = this.data.iterator();
        return res;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitPenSplit(this);
    }

    @Override
    public String name() {
        return "Split - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return true;
    }
}

