/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanVisitor;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreOrderDepthFirstWalker<O extends Operator, P extends OperatorPlan<O>>
extends PlanWalker<O, P> {
    public PreOrderDepthFirstWalker(P plan) {
        super(plan);
    }

    @Override
    public void walk(PlanVisitor<O, P> visitor) throws VisitorException {
        List leaves = this.mPlan.getLeaves();
        HashSet seen = new HashSet();
        this.depthFirst(null, leaves, seen, visitor);
    }

    @Override
    public PlanWalker<O, P> spawnChildWalker(P plan) {
        return new DepthFirstWalker(plan);
    }

    private void depthFirst(O node, Collection<O> predecessors, Set<O> seen, PlanVisitor<O, P> visitor) throws VisitorException {
        if (predecessors == null) {
            return;
        }
        for (Operator pred : predecessors) {
            if (!seen.add(pred)) continue;
            pred.visit(visitor);
            Collection<Operator> newPredecessors = Utils.mergeCollection(this.mPlan.getPredecessors(pred), this.mPlan.getSoftLinkPredecessors(pred));
            this.depthFirst(pred, newPredecessors, seen, visitor);
        }
    }
}

