/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class HMsg
implements Writable {
    public static final HMsg[] STOP_REGIONSERVER_ARRAY = new HMsg[]{new HMsg(Type.STOP_REGIONSERVER)};
    public static final HMsg[] EMPTY_HMSG_ARRAY = new HMsg[0];
    private Type type = null;
    private HRegionInfo info = null;
    private byte[] message = null;
    private HRegionInfo daughterA = null;
    private HRegionInfo daughterB = null;

    public HMsg() {
        this(null);
    }

    public HMsg(Type type) {
        this(type, new HRegionInfo(), null);
    }

    public HMsg(Type type, HRegionInfo hri) {
        this(type, hri, null);
    }

    public HMsg(Type type, HRegionInfo hri, byte[] msg) {
        this(type, hri, null, null, msg);
    }

    public HMsg(Type type, HRegionInfo hri, HRegionInfo daughterA, HRegionInfo daughterB, byte[] msg) {
        this.type = type;
        if (hri == null) {
            throw new NullPointerException("Region cannot be null");
        }
        this.info = hri;
        this.message = msg;
        this.daughterA = daughterA;
        this.daughterB = daughterB;
    }

    public HRegionInfo getRegionInfo() {
        return this.info;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isType(Type other) {
        return this.type.equals((Object)other);
    }

    public byte[] getMessage() {
        return this.message;
    }

    public HRegionInfo getDaughterA() {
        return this.daughterA;
    }

    public HRegionInfo getDaughterB() {
        return this.daughterB;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.toString());
        if (this.info != null && this.info.getRegionName().length > 0) {
            sb.append(": ");
            sb.append(this.info.getRegionNameAsString());
        }
        if (this.message != null && this.message.length > 0) {
            sb.append(": " + Bytes.toString(this.message));
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HMsg that = (HMsg)obj;
        return this.type.equals((Object)that.type) && this.info != null ? this.info.equals((Object)that.info) : that.info == null;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        if (this.info != null) {
            result ^= this.info.hashCode();
        }
        return result;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.type.ordinal());
        this.info.write(out);
        if (this.message == null || this.message.length == 0) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Bytes.writeByteArray(out, this.message);
        }
        if (this.type.equals((Object)Type.REGION_SPLIT)) {
            this.daughterA.write(out);
            this.daughterB.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int ordinal = in.readInt();
        this.type = Type.values()[ordinal];
        this.info.readFields(in);
        boolean hasMessage = in.readBoolean();
        if (hasMessage) {
            this.message = Bytes.readByteArray(in);
        }
        if (this.type.equals((Object)Type.REGION_SPLIT)) {
            this.daughterA = new HRegionInfo();
            this.daughterB = new HRegionInfo();
            this.daughterA.readFields(in);
            this.daughterB.readFields(in);
        }
    }

    public static enum Type {
        STOP_REGIONSERVER,
        REGION_SPLIT,
        TESTING_BLOCK_REGIONSERVER;

    }
}

