/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MetaNodeTracker;
import org.apache.hadoop.hbase.zookeeper.RootRegionTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;

public class CatalogTracker {
    private static final Log LOG = LogFactory.getLog(CatalogTracker.class);
    private final Configuration conf;
    private final HConnection connection;
    private final ZooKeeperWatcher zookeeper;
    private final RootRegionTracker rootRegionTracker;
    private final MetaNodeTracker metaNodeTracker;
    private final AtomicBoolean metaAvailable = new AtomicBoolean(false);
    private HServerAddress metaLocation;
    private final int defaultTimeout;
    private boolean stopped = false;
    private boolean instantiatedzkw = false;
    private HConnection abortable;
    public static final byte[] ROOT_REGION = HRegionInfo.ROOT_REGIONINFO.getRegionName();
    public static final byte[] META_REGION = HRegionInfo.FIRST_META_REGIONINFO.getRegionName();

    public CatalogTracker(Configuration conf) throws IOException {
        this(null, conf, null);
    }

    public CatalogTracker(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) throws IOException {
        this(zk, conf, abortable, 0);
    }

    public CatalogTracker(ZooKeeperWatcher zk, Configuration conf, Abortable abortable, int defaultTimeout) throws IOException {
        this(zk, conf, HConnectionManager.getConnection(conf), abortable, defaultTimeout);
    }

    CatalogTracker(ZooKeeperWatcher zk, Configuration conf, HConnection connection, Abortable abortable, int defaultTimeout) throws IOException {
        this.conf = conf;
        this.connection = connection;
        if (zk == null) {
            this.zookeeper = new ZooKeeperWatcher(conf, "catalogtracker-on-" + connection.toString(), abortable);
            this.instantiatedzkw = true;
        } else {
            this.zookeeper = zk;
        }
        if (abortable == null) {
            this.abortable = this.connection;
        }
        Abortable throwableAborter = new Abortable(){

            @Override
            public void abort(String why, Throwable e) {
                throw new RuntimeException(why, e);
            }
        };
        this.rootRegionTracker = new RootRegionTracker(this.zookeeper, throwableAborter);
        this.metaNodeTracker = new MetaNodeTracker(this.zookeeper, this, throwableAborter);
        this.defaultTimeout = defaultTimeout;
    }

    public void start() throws IOException, InterruptedException {
        try {
            this.rootRegionTracker.start();
            this.metaNodeTracker.start();
            LOG.debug((Object)("Starting catalog tracker " + this));
        }
        catch (RuntimeException e) {
            Throwable t = e.getCause();
            this.abortable.abort(e.getMessage(), t);
            throw new IOException("Attempt to start root/meta tracker failed.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.stopped) {
            LOG.debug((Object)("Stopping catalog tracker " + this));
            this.stopped = true;
            this.rootRegionTracker.stop();
            this.metaNodeTracker.stop();
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Attempt to close catalog tracker's connection failed.", (Throwable)e);
            }
            if (this.instantiatedzkw) {
                this.zookeeper.close();
            }
            AtomicBoolean atomicBoolean = this.metaAvailable;
            synchronized (atomicBoolean) {
                this.metaAvailable.notifyAll();
            }
        }
    }

    public HServerAddress getRootLocation() throws InterruptedException {
        return this.rootRegionTracker.getRootRegionLocation();
    }

    public HServerAddress getMetaLocation() {
        return this.metaLocation;
    }

    public void waitForRoot() throws InterruptedException {
        this.rootRegionTracker.blockUntilAvailable();
    }

    HServerAddress waitForRoot(long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException {
        HServerAddress address = this.rootRegionTracker.waitRootRegionLocation(timeout);
        if (address == null) {
            throw new NotAllMetaRegionsOnlineException("Timed out; " + timeout + "ms");
        }
        return address;
    }

    public HRegionInterface waitForRootServerConnection(long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException, IOException {
        return this.getCachedConnection(this.waitForRoot(timeout));
    }

    public HRegionInterface waitForRootServerConnectionDefault() throws NotAllMetaRegionsOnlineException, IOException {
        try {
            return this.getCachedConnection(this.waitForRoot(this.defaultTimeout));
        }
        catch (InterruptedException e) {
            throw new NotAllMetaRegionsOnlineException("Interrupted");
        }
    }

    private HRegionInterface getRootServerConnection() throws IOException, InterruptedException {
        HServerAddress address = this.rootRegionTracker.getRootRegionLocation();
        if (address == null) {
            return null;
        }
        return this.getCachedConnection(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HRegionInterface getMetaServerConnection(boolean refresh) throws IOException, InterruptedException {
        AtomicBoolean atomicBoolean = this.metaAvailable;
        synchronized (atomicBoolean) {
            HRegionInterface rootConnection;
            if (this.metaAvailable.get()) {
                HRegionInterface current = this.getCachedConnection(this.metaLocation);
                if (!refresh) {
                    return current;
                }
                if (this.verifyRegionLocation(current, this.metaLocation, META_REGION)) {
                    return current;
                }
                this.resetMetaLocation();
            }
            if ((rootConnection = this.getRootServerConnection()) == null) {
                return null;
            }
            HServerAddress newLocation = MetaReader.readMetaLocation(rootConnection);
            if (newLocation == null) {
                return null;
            }
            HRegionInterface newConnection = this.getCachedConnection(newLocation);
            if (this.verifyRegionLocation(newConnection, this.metaLocation, META_REGION)) {
                this.setMetaLocation(newLocation);
                return newConnection;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMeta() throws InterruptedException {
        AtomicBoolean atomicBoolean = this.metaAvailable;
        synchronized (atomicBoolean) {
            while (!this.stopped && !this.metaAvailable.get()) {
                this.metaAvailable.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HServerAddress waitForMeta(long timeout) throws InterruptedException, IOException, NotAllMetaRegionsOnlineException {
        long stop = System.currentTimeMillis() + timeout;
        AtomicBoolean atomicBoolean = this.metaAvailable;
        synchronized (atomicBoolean) {
            while (!(this.stopped || this.metaAvailable.get() || timeout != 0L && System.currentTimeMillis() >= stop)) {
                if (this.getMetaServerConnection(true) != null) {
                    return this.metaLocation;
                }
                this.metaAvailable.wait(timeout == 0L ? 50L : timeout);
            }
            if (this.getMetaServerConnection(true) == null) {
                throw new NotAllMetaRegionsOnlineException("Timed out (" + timeout + "ms)");
            }
            return this.metaLocation;
        }
    }

    public HRegionInterface waitForMetaServerConnection(long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException, IOException {
        return this.getCachedConnection(this.waitForMeta(timeout));
    }

    public HRegionInterface waitForMetaServerConnectionDefault() throws NotAllMetaRegionsOnlineException, IOException {
        try {
            return this.getCachedConnection(this.waitForMeta(this.defaultTimeout));
        }
        catch (InterruptedException e) {
            throw new NotAllMetaRegionsOnlineException("Interrupted");
        }
    }

    private void resetMetaLocation() {
        LOG.info((Object)"Current cached META location is not valid, resetting");
        this.metaAvailable.set(false);
    }

    private void setMetaLocation(HServerAddress metaLocation) {
        this.metaAvailable.set(true);
        this.metaLocation = metaLocation;
        this.metaAvailable.notifyAll();
    }

    private HRegionInterface getCachedConnection(HServerAddress address) throws IOException {
        HRegionInterface protocol;
        block7: {
            protocol = null;
            try {
                protocol = this.connection.getHRegionConnection(address, false);
            }
            catch (RetriesExhaustedException e) {
                if (e.getCause() == null || !(e.getCause() instanceof ConnectException)) {
                    throw e;
                }
            }
            catch (SocketTimeoutException e) {
                LOG.debug((Object)("Timed out connecting to " + address));
            }
            catch (NoRouteToHostException e) {
                LOG.debug((Object)("Connecting to " + address), (Throwable)e);
            }
            catch (SocketException e) {
                LOG.debug((Object)("Exception connecting to " + address));
            }
            catch (IOException ioe) {
                Throwable cause = ioe.getCause();
                if (cause != null && cause instanceof EOFException || cause != null && cause.getMessage() != null && cause.getMessage().toLowerCase().contains("connection reset")) break block7;
                throw ioe;
            }
        }
        return protocol;
    }

    private boolean verifyRegionLocation(HRegionInterface metaServer, HServerAddress address, byte[] regionName) throws IOException {
        if (metaServer == null) {
            LOG.info((Object)"Passed metaserver is null");
            return false;
        }
        Throwable t = null;
        try {
            return metaServer.getRegionInfo(regionName) != null;
        }
        catch (ConnectException e) {
            t = e;
        }
        catch (RemoteException e) {
            IOException ioe = e.unwrapRemoteException();
            t = ioe;
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            t = cause != null && cause instanceof EOFException ? cause : (cause != null && cause.getMessage() != null && cause.getMessage().contains("Connection reset") ? cause : e);
        }
        LOG.info((Object)("Failed verification of " + Bytes.toStringBinary(regionName) + " at address=" + address + "; " + t));
        return false;
    }

    public boolean verifyRootRegionLocation(long timeout) throws InterruptedException, IOException {
        HRegionInterface connection = null;
        try {
            connection = this.waitForRootServerConnection(timeout);
        }
        catch (NotAllMetaRegionsOnlineException e) {
        }
        catch (ServerNotRunningException e) {
        }
        catch (IOException e) {
            throw e;
        }
        return connection == null ? false : this.verifyRegionLocation(connection, this.rootRegionTracker.getRootRegionLocation(), HRegionInfo.ROOT_REGIONINFO.getRegionName());
    }

    public boolean verifyMetaRegionLocation(long timeout) throws InterruptedException, IOException {
        return this.getMetaServerConnection(true) != null;
    }

    MetaNodeTracker getMetaNodeTracker() {
        return this.metaNodeTracker;
    }

    public HConnection getConnection() {
        return this.connection;
    }
}

