/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.ipc.RemoteException;

public class MetaReader {
    public static final byte[] META_REGION_PREFIX;

    private static HRegionInterface getCatalogRegionInterface(CatalogTracker ct, byte[] tableName) throws NotAllMetaRegionsOnlineException, IOException {
        return Bytes.equals(HConstants.META_TABLE_NAME, tableName) ? ct.waitForRootServerConnectionDefault() : ct.waitForMetaServerConnectionDefault();
    }

    private static byte[] getCatalogRegionNameForTable(byte[] tableName) {
        return Bytes.equals(HConstants.META_TABLE_NAME, tableName) ? HRegionInfo.ROOT_REGIONINFO.getRegionName() : HRegionInfo.FIRST_META_REGIONINFO.getRegionName();
    }

    private static byte[] getCatalogRegionNameForRegion(byte[] regionName) {
        return MetaReader.isMetaRegion(regionName) ? HRegionInfo.ROOT_REGIONINFO.getRegionName() : HRegionInfo.FIRST_META_REGIONINFO.getRegionName();
    }

    private static boolean isMetaRegion(byte[] regionName) {
        if (regionName.length < META_REGION_PREFIX.length + 2) {
            return false;
        }
        return Bytes.compareTo(regionName, 0, META_REGION_PREFIX.length, META_REGION_PREFIX, 0, META_REGION_PREFIX.length) == 0;
    }

    public static Map<HRegionInfo, HServerAddress> fullScan(CatalogTracker catalogTracker) throws IOException {
        return MetaReader.fullScan(catalogTracker, new TreeSet<String>());
    }

    public static Map<HRegionInfo, HServerAddress> fullScan(CatalogTracker catalogTracker, Set<String> disabledTables) throws IOException {
        return MetaReader.fullScan(catalogTracker, disabledTables, false);
    }

    public static Map<HRegionInfo, HServerAddress> fullScan(CatalogTracker catalogTracker, final Set<String> disabledTables, final boolean excludeOfflinedSplitParents) throws IOException {
        final TreeMap<HRegionInfo, HServerAddress> regions = new TreeMap<HRegionInfo, HServerAddress>();
        Visitor v = new Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                Pair<HRegionInfo, HServerAddress> region = MetaReader.metaRowToRegionPair(r);
                if (region == null) {
                    return true;
                }
                HRegionInfo hri = region.getFirst();
                if (disabledTables.contains(hri.getTableDesc().getNameAsString())) {
                    return true;
                }
                if (excludeOfflinedSplitParents && hri.isSplitParent()) {
                    return true;
                }
                regions.put(hri, region.getSecond());
                return true;
            }
        };
        MetaReader.fullScan(catalogTracker, v);
        return regions;
    }

    public static List<Result> fullScanOfResults(CatalogTracker catalogTracker) throws IOException {
        final ArrayList<Result> regions = new ArrayList<Result>();
        Visitor v = new Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                regions.add(r);
                return true;
            }
        };
        MetaReader.fullScan(catalogTracker, v);
        return regions;
    }

    public static void fullScan(CatalogTracker catalogTracker, Visitor visitor) throws IOException {
        MetaReader.fullScan(catalogTracker, visitor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fullScan(CatalogTracker catalogTracker, Visitor visitor, byte[] startrow) throws IOException {
        HRegionInterface metaServer = catalogTracker.waitForMetaServerConnectionDefault();
        Scan scan = new Scan();
        if (startrow != null) {
            scan.setStartRow(startrow);
        }
        scan.addFamily(HConstants.CATALOG_FAMILY);
        long scannerid = metaServer.openScanner(HRegionInfo.FIRST_META_REGIONINFO.getRegionName(), scan);
        try {
            Result data;
            while ((data = metaServer.next(scannerid)) != null && (data.isEmpty() || visitor.visit(data))) {
            }
        }
        finally {
            metaServer.close(scannerid);
        }
    }

    public static HServerAddress readMetaLocation(HRegionInterface metaServer) throws IOException {
        return MetaReader.readLocation(metaServer, CatalogTracker.ROOT_REGION, CatalogTracker.META_REGION);
    }

    public static HServerAddress readRegionLocation(CatalogTracker catalogTracker, byte[] regionName) throws IOException {
        if (MetaReader.isMetaRegion(regionName)) {
            throw new IllegalArgumentException("See readMetaLocation");
        }
        return MetaReader.readLocation(catalogTracker.waitForMetaServerConnectionDefault(), CatalogTracker.META_REGION, regionName);
    }

    private static HServerAddress readLocation(HRegionInterface metaServer, byte[] catalogRegionName, byte[] regionName) throws IOException {
        Result r;
        block7: {
            r = null;
            try {
                r = metaServer.get(catalogRegionName, new Get(regionName).addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER));
            }
            catch (SocketTimeoutException e) {
            }
            catch (SocketException e) {
            }
            catch (RemoteException re) {
                IOException ioe = re.unwrapRemoteException();
                if (!(ioe instanceof NotServingRegionException) && !ioe.getMessage().contains("Server not running")) {
                    throw re;
                }
            }
            catch (IOException e) {
                if (e.getCause() != null && e.getCause() instanceof IOException && e.getCause().getMessage() != null && e.getCause().getMessage().contains("Connection reset by peer")) break block7;
                throw e;
            }
        }
        if (r == null || r.isEmpty()) {
            return null;
        }
        byte[] value = r.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
        return new HServerAddress(Bytes.toString(value));
    }

    public static Pair<HRegionInfo, HServerAddress> getRegion(CatalogTracker catalogTracker, byte[] regionName) throws IOException {
        Get get2 = new Get(regionName);
        get2.addFamily(HConstants.CATALOG_FAMILY);
        byte[] meta = MetaReader.getCatalogRegionNameForRegion(regionName);
        Result r = catalogTracker.waitForMetaServerConnectionDefault().get(meta, get2);
        if (r == null || r.isEmpty()) {
            return null;
        }
        return MetaReader.metaRowToRegionPair(r);
    }

    public static Pair<HRegionInfo, HServerAddress> metaRowToRegionPair(Result data) throws IOException {
        byte[] bytes = data.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        if (bytes == null) {
            return null;
        }
        HRegionInfo info = Writables.getHRegionInfo(bytes);
        byte[] value = data.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
        if (value != null && value.length > 0) {
            HServerAddress server = new HServerAddress(Bytes.toString(value));
            return new Pair<HRegionInfo, HServerAddress>(info, server);
        }
        return new Pair<HRegionInfo, Object>(info, null);
    }

    public static Pair<HRegionInfo, HServerInfo> metaRowToRegionPairWithInfo(Result data) throws IOException {
        byte[] bytes = data.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        if (bytes == null) {
            return null;
        }
        HRegionInfo info = Writables.getHRegionInfo(bytes);
        byte[] value = data.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
        if (value != null && value.length > 0) {
            long startCode = Bytes.toLong(data.getValue(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER));
            HServerAddress server = new HServerAddress(Bytes.toString(value));
            HServerInfo hsi = new HServerInfo(server, startCode, 0, server.getHostname());
            return new Pair<HRegionInfo, HServerInfo>(info, hsi);
        }
        return new Pair<HRegionInfo, Object>(info, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(CatalogTracker catalogTracker, String tableName) throws IOException {
        if (tableName.equals(HTableDescriptor.ROOT_TABLEDESC.getNameAsString()) || tableName.equals(HTableDescriptor.META_TABLEDESC.getNameAsString())) {
            return true;
        }
        HRegionInterface metaServer = catalogTracker.waitForMetaServerConnectionDefault();
        Scan scan = MetaReader.getScanForTableName(Bytes.toBytes(tableName));
        scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        long scannerid = metaServer.openScanner(HRegionInfo.FIRST_META_REGIONINFO.getRegionName(), scan);
        try {
            Result data = metaServer.next(scannerid);
            if (data != null && data.size() > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            metaServer.close(scannerid);
        }
    }

    public static List<HRegionInfo> getTableRegions(CatalogTracker catalogTracker, byte[] tableName) throws IOException {
        return MetaReader.getTableRegions(catalogTracker, tableName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HRegionInfo> getTableRegions(CatalogTracker catalogTracker, byte[] tableName, boolean excludeOfflinedSplitParents) throws IOException {
        if (Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME)) {
            ArrayList<HRegionInfo> list = new ArrayList<HRegionInfo>();
            list.add(HRegionInfo.ROOT_REGIONINFO);
            return list;
        }
        if (Bytes.equals(tableName, HConstants.META_TABLE_NAME)) {
            ArrayList<HRegionInfo> list = new ArrayList<HRegionInfo>();
            list.add(HRegionInfo.FIRST_META_REGIONINFO);
            return list;
        }
        HRegionInterface metaServer = MetaReader.getCatalogRegionInterface(catalogTracker, tableName);
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        Scan scan = MetaReader.getScanForTableName(tableName);
        scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        long scannerid = metaServer.openScanner(MetaReader.getCatalogRegionNameForTable(tableName), scan);
        try {
            Result data;
            while ((data = metaServer.next(scannerid)) != null) {
                if (data == null || data.size() <= 0) continue;
                HRegionInfo info = Writables.getHRegionInfo(data.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                if (excludeOfflinedSplitParents && info.isSplitParent()) continue;
                regions.add(info);
            }
            ArrayList<HRegionInfo> arrayList = regions;
            return arrayList;
        }
        finally {
            metaServer.close(scannerid);
        }
    }

    public static Scan getScanForTableName(byte[] tableName) {
        String strName = Bytes.toString(tableName);
        byte[] startKey = Bytes.toBytes(strName + ",,");
        byte[] stopKey = Bytes.toBytes(strName + " ,,");
        Scan scan = new Scan(startKey);
        scan.setStopRow(stopKey);
        return scan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<HRegionInfo, HServerAddress>> getTableRegionsAndLocations(CatalogTracker catalogTracker, String tableName) throws IOException, InterruptedException {
        byte[] tableNameBytes = Bytes.toBytes(tableName);
        if (Bytes.equals(tableNameBytes, HConstants.ROOT_TABLE_NAME)) {
            HServerAddress hsa = catalogTracker.getRootLocation();
            ArrayList<Pair<HRegionInfo, HServerAddress>> list = new ArrayList<Pair<HRegionInfo, HServerAddress>>();
            list.add(new Pair<HRegionInfo, HServerAddress>(HRegionInfo.ROOT_REGIONINFO, hsa));
            return list;
        }
        HRegionInterface metaServer = MetaReader.getCatalogRegionInterface(catalogTracker, tableNameBytes);
        ArrayList<Pair<HRegionInfo, HServerAddress>> regions = new ArrayList<Pair<HRegionInfo, HServerAddress>>();
        Scan scan = MetaReader.getScanForTableName(tableNameBytes);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        long scannerid = metaServer.openScanner(MetaReader.getCatalogRegionNameForTable(tableNameBytes), scan);
        try {
            Result data;
            while ((data = metaServer.next(scannerid)) != null) {
                Pair<HRegionInfo, HServerAddress> region;
                if (data == null || data.size() <= 0 || (region = MetaReader.metaRowToRegionPair(data)) == null) continue;
                regions.add(region);
            }
            ArrayList<Pair<HRegionInfo, HServerAddress>> arrayList = regions;
            return arrayList;
        }
        finally {
            metaServer.close(scannerid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableMap<HRegionInfo, Result> getServerUserRegions(CatalogTracker catalogTracker, HServerInfo hsi) throws IOException {
        HRegionInterface metaServer = catalogTracker.waitForMetaServerConnectionDefault();
        TreeMap<HRegionInfo, Result> hris = new TreeMap<HRegionInfo, Result>();
        Scan scan = new Scan();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        long scannerid = metaServer.openScanner(HRegionInfo.FIRST_META_REGIONINFO.getRegionName(), scan);
        try {
            Result result;
            while ((result = metaServer.next(scannerid)) != null) {
                Pair<HRegionInfo, HServerInfo> pair;
                if (result == null || result.size() <= 0 || (pair = MetaReader.metaRowToRegionPairWithInfo(result)) == null || pair.getSecond() == null || !pair.getSecond().equals(hsi)) continue;
                hris.put(pair.getFirst(), result);
            }
            TreeMap<HRegionInfo, Result> treeMap = hris;
            return treeMap;
        }
        finally {
            metaServer.close(scannerid);
        }
    }

    static {
        int len = HRegionInfo.FIRST_META_REGIONINFO.getRegionName().length - 2;
        META_REGION_PREFIX = new byte[len];
        System.arraycopy(HRegionInfo.FIRST_META_REGIONINFO.getRegionName(), 0, META_REGION_PREFIX, 0, len);
    }

    public static interface Visitor {
        public boolean visit(Result var1) throws IOException;
    }
}

