/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.StringUtils;

public class HBaseAdmin
implements Abortable,
Closeable {
    private final Log LOG = LogFactory.getLog((String)this.getClass().getName());
    private HConnection connection;
    private volatile Configuration conf;
    private final long pause;
    private final int numRetries;
    private final int retryLongerMultiplier;

    public HBaseAdmin(Configuration c) throws MasterNotRunningException, ZooKeeperConnectionException {
        int tries;
        this.conf = HBaseConfiguration.create(c);
        this.connection = HConnectionManager.getConnection(this.conf);
        this.pause = this.conf.getLong("hbase.client.pause", 1000L);
        this.numRetries = this.conf.getInt("hbase.client.retries.number", 10);
        this.retryLongerMultiplier = this.conf.getInt("hbase.client.retries.longer.multiplier", 10);
        for (tries = 0; tries < this.numRetries; ++tries) {
            try {
                this.connection.getMaster();
                break;
            }
            catch (MasterNotRunningException mnre) {
                HConnectionManager.deleteStaleConnection(this.connection);
                this.connection = HConnectionManager.getConnection(this.conf);
            }
            catch (UndeclaredThrowableException ute) {
                HConnectionManager.deleteStaleConnection(this.connection);
                this.connection = HConnectionManager.getConnection(this.conf);
            }
            try {
                Thread.sleep(ConnectionUtils.getPauseTime(this.pause, tries));
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                HConnectionManager.deleteStaleConnection(this.connection);
                throw new MasterNotRunningException("Interrupted");
            }
        }
        if (tries >= this.numRetries) {
            HConnectionManager.deleteStaleConnection(this.connection);
            throw new MasterNotRunningException("Retried " + this.numRetries + " times");
        }
    }

    private synchronized CatalogTracker getCatalogTracker() throws ZooKeeperConnectionException, IOException {
        CatalogTracker ct = null;
        try {
            ct = new CatalogTracker(this.conf);
            ct.start();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted", e);
        }
        return ct;
    }

    private void cleanupCatalogTracker(CatalogTracker ct) {
        ct.stop();
    }

    @Override
    public void abort(String why, Throwable e) {
        throw new RuntimeException(why, e);
    }

    public HConnection getConnection() {
        return this.connection;
    }

    public HMasterInterface getMaster() throws MasterNotRunningException, ZooKeeperConnectionException {
        return this.connection.getMaster();
    }

    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        return this.connection.isMasterRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(String tableName) throws IOException {
        boolean b = false;
        CatalogTracker ct = this.getCatalogTracker();
        try {
            b = MetaReader.tableExists(ct, tableName);
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
        return b;
    }

    public boolean tableExists(byte[] tableName) throws IOException {
        return this.tableExists(Bytes.toString(tableName));
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.connection.listTables();
    }

    public HTableDescriptor getTableDescriptor(byte[] tableName) throws IOException {
        return this.connection.getHTableDescriptor(tableName);
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        HTableDescriptor.isLegalTableName(desc.getName());
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo(startKey, endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        byte[][] splitKeys = Bytes.split(startKey, endKey, numRegions - 3);
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    public void createTable(final HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        HTableDescriptor.isLegalTableName(desc.getName());
        try {
            this.createTableAsync(desc, splitKeys);
        }
        catch (SocketTimeoutException ste) {
            this.LOG.warn((Object)("Creating " + desc.getNameAsString() + " took too long"), (Throwable)ste);
        }
        int numRegs = splitKeys == null ? 1 : splitKeys.length + 1;
        int prevRegCount = 0;
        for (int tries = 0; tries < this.numRetries; ++tries) {
            final AtomicInteger actualRegCount = new AtomicInteger(0);
            MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){

                @Override
                public boolean processRow(Result rowResult) throws IOException {
                    HRegionInfo info = Writables.getHRegionInfoOrNull(rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                    if (null == info) {
                        return true;
                    }
                    if (!Bytes.equals(info.getTableDesc().getName(), desc.getName())) {
                        return false;
                    }
                    String hostAndPort = null;
                    byte[] value = rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                    if (value != null && value.length > 0) {
                        hostAndPort = Bytes.toString(value);
                    }
                    if (!info.isOffline() && !info.isSplit() && hostAndPort != null) {
                        actualRegCount.incrementAndGet();
                    }
                    return true;
                }
            };
            MetaScanner.metaScan(this.conf, visitor, desc.getName());
            if (actualRegCount.get() != numRegs) {
                if (tries == this.numRetries - 1) {
                    throw new RegionOfflineException("Only " + actualRegCount.get() + " of " + numRegs + " regions are online; retries exhausted.");
                }
                try {
                    Thread.sleep(ConnectionUtils.getPauseTime(this.pause, tries));
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("Interrupted when opening regions; " + actualRegCount.get() + " of " + numRegs + " regions processed so far");
                }
                if (actualRegCount.get() <= prevRegCount) continue;
                prevRegCount = actualRegCount.get();
                tries = -1;
                continue;
            }
            return;
        }
    }

    public void createTableAsync(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        HTableDescriptor.isLegalTableName(desc.getName());
        if (splitKeys != null && splitKeys.length > 1) {
            Arrays.sort(splitKeys, Bytes.BYTES_COMPARATOR);
            byte[] lastKey = null;
            for (byte[] splitKey : splitKeys) {
                if (lastKey != null && Bytes.equals(splitKey, lastKey)) {
                    throw new IllegalArgumentException("All split keys must be unique, found duplicate: " + Bytes.toStringBinary(splitKey) + ", " + Bytes.toStringBinary(lastKey));
                }
                lastKey = splitKey;
            }
        }
        try {
            this.getMaster().createTable(desc, splitKeys);
        }
        catch (RemoteException e) {
            throw e.unwrapRemoteException();
        }
    }

    public void deleteTable(String tableName) throws IOException {
        this.deleteTable(Bytes.toBytes(tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTable(byte[] tableName) throws IOException {
        this.isMasterRunning();
        HTableDescriptor.isLegalTableName(tableName);
        HRegionLocation firstMetaServer = this.getFirstMetaServerForTable(tableName);
        try {
            this.getMaster().deleteTable(tableName);
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
        HRegionInterface server = this.connection.getHRegionConnection(firstMetaServer.getServerAddress());
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier; ++tries) {
            long scannerId = -1L;
            try {
                Scan scan = MetaReader.getScanForTableName(tableName);
                scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                scannerId = server.openScanner(firstMetaServer.getRegionInfo().getRegionName(), scan);
                Result values = server.next(scannerId);
                if (values == null) {
                    break;
                }
            }
            catch (IOException ex) {
                if (tries == this.numRetries - 1) {
                    if (ex instanceof RemoteException) {
                        ex = RemoteExceptionHandler.decodeRemoteException((RemoteException)((Object)ex));
                    }
                    throw ex;
                }
            }
            finally {
                if (scannerId != -1L) {
                    try {
                        server.close(scannerId);
                    }
                    catch (Exception ex) {
                        this.LOG.warn((Object)ex);
                    }
                }
            }
            try {
                Thread.sleep(ConnectionUtils.getPauseTime(this.pause, tries));
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.connection.clearRegionCache(tableName);
        this.LOG.info((Object)("Deleted " + Bytes.toString(tableName)));
    }

    public void enableTable(String tableName) throws IOException {
        this.enableTable(Bytes.toBytes(tableName));
    }

    public void enableTable(byte[] tableName) throws IOException {
        this.enableTableAsync(tableName);
        boolean enabled = false;
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier && !(enabled = this.isTableEnabled(tableName)); ++tries) {
            long sleep = ConnectionUtils.getPauseTime(this.pause, tries);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Sleeping= " + sleep + "ms, waiting for all regions to be " + "enabled in " + Bytes.toString(tableName)));
            }
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted", e);
            }
        }
        if (!enabled) {
            throw new IOException("Unable to enable table " + Bytes.toString(tableName));
        }
        this.LOG.info((Object)("Enabled table " + Bytes.toString(tableName)));
    }

    public void enableTableAsync(String tableName) throws IOException {
        this.enableTableAsync(Bytes.toBytes(tableName));
    }

    public void enableTableAsync(byte[] tableName) throws IOException {
        this.isMasterRunning();
        try {
            this.getMaster().enableTable(tableName);
        }
        catch (RemoteException e) {
            throw e.unwrapRemoteException();
        }
        this.LOG.info((Object)("Started enable of " + Bytes.toString(tableName)));
    }

    public void disableTableAsync(String tableName) throws IOException {
        this.disableTableAsync(Bytes.toBytes(tableName));
    }

    public void disableTableAsync(byte[] tableName) throws IOException {
        this.isMasterRunning();
        try {
            this.getMaster().disableTable(tableName);
        }
        catch (RemoteException e) {
            throw e.unwrapRemoteException();
        }
        this.LOG.info((Object)("Started disable of " + Bytes.toString(tableName)));
    }

    public void disableTable(String tableName) throws IOException {
        this.disableTable(Bytes.toBytes(tableName));
    }

    public void disableTable(byte[] tableName) throws IOException {
        this.disableTableAsync(tableName);
        boolean disabled = false;
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier && !(disabled = this.isTableDisabled(tableName)); ++tries) {
            long sleep = ConnectionUtils.getPauseTime(this.pause, tries);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Sleeping= " + sleep + "ms, waiting for all regions to be " + "disabled in " + Bytes.toString(tableName)));
            }
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted", e);
            }
        }
        if (!disabled) {
            throw new RegionException("Retries exhausted, it took too long to wait for the table " + Bytes.toString(tableName) + " to be disabled.");
        }
        this.LOG.info((Object)("Disabled " + Bytes.toString(tableName)));
    }

    public boolean isTableEnabled(String tableName) throws IOException {
        return this.isTableEnabled(Bytes.toBytes(tableName));
    }

    public boolean isTableEnabled(byte[] tableName) throws IOException {
        return this.connection.isTableEnabled(tableName);
    }

    public boolean isTableDisabled(String tableName) throws IOException {
        return this.isTableDisabled(Bytes.toBytes(tableName));
    }

    public boolean isTableDisabled(byte[] tableName) throws IOException {
        return this.connection.isTableDisabled(tableName);
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.connection.isTableAvailable(tableName);
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        return this.connection.isTableAvailable(Bytes.toBytes(tableName));
    }

    public void addColumn(String tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(Bytes.toBytes(tableName), column);
    }

    public void addColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        HTableDescriptor.isLegalTableName(tableName);
        try {
            this.getMaster().addColumn(tableName, column);
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public void deleteColumn(String tableName, String columnName) throws IOException {
        this.deleteColumn(Bytes.toBytes(tableName), Bytes.toBytes(columnName));
    }

    public void deleteColumn(byte[] tableName, byte[] columnName) throws IOException {
        try {
            this.getMaster().deleteColumn(tableName, columnName);
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public void modifyColumn(String tableName, String columnName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(tableName, descriptor);
    }

    public void modifyColumn(String tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(Bytes.toBytes(tableName), descriptor);
    }

    public void modifyColumn(byte[] tableName, byte[] columnName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(tableName, descriptor);
    }

    public void modifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        try {
            this.getMaster().modifyColumn(tableName, descriptor);
        }
        catch (RemoteException re) {
            throw RemoteExceptionHandler.decodeRemoteException(re);
        }
    }

    public void closeRegion(String regionname, String hostAndPort) throws IOException {
        this.closeRegion(Bytes.toBytes(regionname), hostAndPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRegion(byte[] regionname, String hostAndPort) throws IOException {
        CatalogTracker ct = this.getCatalogTracker();
        try {
            if (hostAndPort != null) {
                HServerAddress hsa = new HServerAddress(hostAndPort);
                Pair<HRegionInfo, HServerAddress> pair = MetaReader.getRegion(ct, regionname);
                if (pair == null || pair.getSecond() == null) {
                    this.LOG.info((Object)("No server in .META. for " + Bytes.toString(regionname) + "; pair=" + pair));
                } else {
                    this.closeRegion(hsa, pair.getFirst());
                }
            } else {
                Pair<HRegionInfo, HServerAddress> pair = MetaReader.getRegion(ct, regionname);
                if (pair == null || pair.getSecond() == null) {
                    this.LOG.info((Object)("No server in .META. for " + Bytes.toStringBinary(regionname) + "; pair=" + pair));
                } else {
                    this.closeRegion(pair.getSecond(), pair.getFirst());
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException {
        byte[] encodedRegionNameInBytes = Bytes.toBytes(encodedRegionName);
        if (null == serverName || "".equals(serverName.trim())) {
            throw new IllegalArgumentException("The servername cannot be null or empty.");
        }
        HServerAddress hsa = new HServerAddress(serverName);
        HRegionInterface rs = this.connection.getHRegionConnection(hsa, true);
        boolean regionClosed = rs.closeRegion(encodedRegionNameInBytes, false);
        if (!regionClosed) {
            this.LOG.error((Object)("Not able to close the region " + encodedRegionName + "."));
        }
        return regionClosed;
    }

    public void closeRegion(HServerAddress hsa, HRegionInfo hri) throws IOException {
        HRegionInterface rs = this.connection.getHRegionConnection(hsa);
        rs.closeRegion(hri, false);
    }

    public void flush(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.flush(Bytes.toBytes(tableNameOrRegionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        CatalogTracker ct = this.getCatalogTracker();
        boolean isRegionName = this.isRegionName(tableNameOrRegionName, ct);
        try {
            if (isRegionName) {
                Pair<HRegionInfo, HServerAddress> pair = MetaReader.getRegion(ct, tableNameOrRegionName);
                if (pair == null || pair.getSecond() == null) {
                    this.LOG.info((Object)("No server in .META. for " + Bytes.toStringBinary(tableNameOrRegionName) + "; pair=" + pair));
                } else {
                    this.flush(pair.getSecond(), pair.getFirst());
                }
            } else {
                String tableName = this.tableNameString(tableNameOrRegionName, ct);
                List<Pair<HRegionInfo, HServerAddress>> pairs = MetaReader.getTableRegionsAndLocations(ct, tableName);
                for (Pair<HRegionInfo, HServerAddress> pair : pairs) {
                    if (pair.getFirst().isOffline() || pair.getSecond() == null) continue;
                    try {
                        this.flush(pair.getSecond(), pair.getFirst());
                    }
                    catch (NotServingRegionException e) {
                        if (!this.LOG.isDebugEnabled()) continue;
                        this.LOG.debug((Object)("Trying to flush " + (Object)((Object)pair.getFirst()) + ": " + StringUtils.stringifyException((Throwable)e)));
                    }
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void flush(HServerAddress hsa, HRegionInfo hri) throws IOException {
        HRegionInterface rs = this.connection.getHRegionConnection(hsa);
        rs.flushRegion(hri);
    }

    public void compact(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.compact(Bytes.toBytes(tableNameOrRegionName));
    }

    public void compact(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, false);
    }

    public void majorCompact(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.majorCompact(Bytes.toBytes(tableNameOrRegionName));
    }

    public void majorCompact(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact(byte[] tableNameOrRegionName, boolean major) throws IOException, InterruptedException {
        CatalogTracker ct = this.getCatalogTracker();
        try {
            if (this.isRegionName(tableNameOrRegionName, ct)) {
                Pair<HRegionInfo, HServerAddress> pair = MetaReader.getRegion(ct, tableNameOrRegionName);
                if (pair == null || pair.getSecond() == null) {
                    this.LOG.info((Object)("No server in .META. for " + Bytes.toStringBinary(tableNameOrRegionName) + "; pair=" + pair));
                } else {
                    this.compact(pair.getSecond(), pair.getFirst(), major);
                }
            } else {
                String tableName = this.tableNameString(tableNameOrRegionName, ct);
                List<Pair<HRegionInfo, HServerAddress>> pairs = MetaReader.getTableRegionsAndLocations(ct, tableName);
                for (Pair<HRegionInfo, HServerAddress> pair : pairs) {
                    if (pair.getFirst().isOffline() || pair.getSecond() == null) continue;
                    try {
                        this.compact(pair.getSecond(), pair.getFirst(), major);
                    }
                    catch (NotServingRegionException e) {
                        if (!this.LOG.isDebugEnabled()) continue;
                        this.LOG.debug((Object)("Trying to" + (major ? " major" : "") + " compact " + (Object)((Object)pair.getFirst()) + ": " + StringUtils.stringifyException((Throwable)e)));
                    }
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void compact(HServerAddress hsa, HRegionInfo hri, boolean major) throws IOException {
        HRegionInterface rs = this.connection.getHRegionConnection(hsa);
        rs.compactRegion(hri, major);
    }

    public void move(byte[] encodedRegionName, byte[] destServerName) throws UnknownRegionException, MasterNotRunningException, ZooKeeperConnectionException {
        this.getMaster().move(encodedRegionName, destServerName);
    }

    public void assign(byte[] regionName, boolean force) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this.getMaster().assign(regionName, force);
    }

    public void unassign(byte[] regionName, boolean force) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this.getMaster().unassign(regionName, force);
    }

    public boolean balanceSwitch(boolean b) throws MasterNotRunningException, ZooKeeperConnectionException {
        return this.getMaster().balanceSwitch(b);
    }

    public boolean balancer() throws MasterNotRunningException, ZooKeeperConnectionException {
        return this.getMaster().balance();
    }

    public void split(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.split(Bytes.toBytes(tableNameOrRegionName));
    }

    public void split(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.split(tableNameOrRegionName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split(byte[] tableNameOrRegionName, byte[] splitPoint) throws IOException, InterruptedException {
        CatalogTracker ct = this.getCatalogTracker();
        try {
            if (this.isRegionName(tableNameOrRegionName, ct)) {
                Pair<HRegionInfo, HServerAddress> pair = MetaReader.getRegion(ct, tableNameOrRegionName);
                if (pair == null || pair.getSecond() == null) {
                    this.LOG.info((Object)("No server in .META. for " + Bytes.toStringBinary(tableNameOrRegionName) + "; pair=" + pair));
                } else {
                    this.split(pair.getSecond(), pair.getFirst(), splitPoint);
                }
            } else {
                String tableName = this.tableNameString(tableNameOrRegionName, ct);
                List<Pair<HRegionInfo, HServerAddress>> pairs = MetaReader.getTableRegionsAndLocations(ct, tableName);
                for (Pair<HRegionInfo, HServerAddress> pair : pairs) {
                    HRegionInfo r;
                    if (pair.getSecond() == null || (r = pair.getFirst()).isSplitParent() || splitPoint != null && !r.containsRow(splitPoint)) continue;
                    this.split(pair.getSecond(), pair.getFirst(), splitPoint);
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void split(HServerAddress hsa, HRegionInfo hri, byte[] splitPoint) throws IOException {
        HRegionInterface rs = this.connection.getHRegionConnection(hsa);
        rs.splitRegion(hri, splitPoint);
    }

    public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        try {
            this.getMaster().modifyTable(tableName, htd);
        }
        catch (RemoteException re) {
            throw RemoteExceptionHandler.decodeRemoteException(re);
        }
    }

    private boolean isRegionName(byte[] tableNameOrRegionName, CatalogTracker ct) throws IOException {
        if (tableNameOrRegionName == null) {
            throw new IllegalArgumentException("Pass a table name or region name");
        }
        return MetaReader.getRegion(ct, tableNameOrRegionName) != null;
    }

    private String tableNameString(byte[] tableNameBytes, CatalogTracker ct) throws IOException {
        String tableNameString = Bytes.toString(tableNameBytes);
        if (!MetaReader.tableExists(ct, tableNameString)) {
            throw new TableNotFoundException(tableNameString);
        }
        return tableNameString;
    }

    public synchronized void shutdown() throws IOException {
        this.isMasterRunning();
        try {
            this.getMaster().shutdown();
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public synchronized void stopMaster() throws IOException {
        this.isMasterRunning();
        try {
            this.getMaster().stopMaster();
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public synchronized void stopRegionServer(HServerAddress hsa) throws IOException {
        HRegionInterface rs = this.connection.getHRegionConnection(hsa);
        rs.stop("Called by admin client " + this.connection.toString());
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return this.getMaster().getClusterStatus();
    }

    private HRegionLocation getFirstMetaServerForTable(byte[] tableName) throws IOException {
        return this.connection.locateRegion(HConstants.META_TABLE_NAME, HRegionInfo.createRegionName(tableName, null, "99999999999999", false));
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public static void checkHBaseAvailable(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException {
        Configuration copyOfConf = HBaseConfiguration.create(conf);
        copyOfConf.setInt("hbase.client.retries.number", 1);
        HBaseAdmin admin = new HBaseAdmin(copyOfConf);
        HConnectionManager.deleteConnection(admin.getConfiguration(), false);
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

