/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterAddressTracker;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.ClosedConnectionException;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.client.UnmodifyableHTableDescriptor;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.SoftValueSortedMap;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.RootRegionTracker;
import org.apache.hadoop.hbase.zookeeper.ZKTable;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.KeeperException;

public class HConnectionManager {
    private static final Map<HConnectionKey, HConnectionImplementation> HBASE_INSTANCES;
    public static final int MAX_CACHED_HBASE_INSTANCES;
    static final Log LOG;

    protected HConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HConnection getConnection(Configuration conf) throws ZooKeeperConnectionException {
        HConnectionKey connectionKey = new HConnectionKey(conf);
        Map<HConnectionKey, HConnectionImplementation> map = HBASE_INSTANCES;
        synchronized (map) {
            HConnectionImplementation connection = HBASE_INSTANCES.get(connectionKey);
            if (connection == null) {
                connection = new HConnectionImplementation(conf);
                HBASE_INSTANCES.put(connectionKey, connection);
            }
            connection.incCount();
            return connection;
        }
    }

    public static void deleteConnection(Configuration conf, boolean stopProxy) {
        HConnectionManager.deleteConnection(new HConnectionKey(conf), stopProxy, false);
    }

    public static void deleteStaleConnection(HConnection connection) {
        HConnectionManager.deleteConnection(connection, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllConnections(boolean stopProxy) {
        Map<HConnectionKey, HConnectionImplementation> map = HBASE_INSTANCES;
        synchronized (map) {
            HashSet<HConnectionKey> connectionKeys = new HashSet<HConnectionKey>();
            connectionKeys.addAll(HBASE_INSTANCES.keySet());
            for (HConnectionKey connectionKey : connectionKeys) {
                HConnectionManager.deleteConnection(connectionKey, stopProxy, false);
            }
            HBASE_INSTANCES.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteConnection(HConnection connection, boolean stopProxy, boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = HBASE_INSTANCES;
        synchronized (map) {
            for (Map.Entry<HConnectionKey, HConnectionImplementation> connectionEntry : HBASE_INSTANCES.entrySet()) {
                if (connectionEntry.getValue() != connection) continue;
                HConnectionManager.deleteConnection(connectionEntry.getKey(), stopProxy, staleConnection);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteConnection(HConnectionKey connectionKey, boolean stopProxy, boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = HBASE_INSTANCES;
        synchronized (map) {
            HConnectionImplementation connection = HBASE_INSTANCES.get(connectionKey);
            if (connection != null) {
                connection.decCount();
                if (connection.isZeroReference() || staleConnection) {
                    HBASE_INSTANCES.remove(connectionKey);
                    connection.close(stopProxy);
                } else if (stopProxy) {
                    connection.stopProxyOnClose(stopProxy);
                }
            }
        }
    }

    static int getCachedRegionCount(Configuration conf, final byte[] tableName) throws IOException {
        return HConnectionManager.execute(new HConnectable<Integer>(conf){

            @Override
            public Integer connect(HConnection connection) {
                return ((HConnectionImplementation)connection).getNumberOfCachedRegionLocations(tableName);
            }
        });
    }

    static boolean isRegionCached(Configuration conf, final byte[] tableName, final byte[] row) throws IOException {
        return HConnectionManager.execute(new HConnectable<Boolean>(conf){

            @Override
            public Boolean connect(HConnection connection) {
                return ((HConnectionImplementation)connection).isRegionCached(tableName, row);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(HConnectable<T> connectable) throws IOException {
        if (connectable == null || connectable.conf == null) {
            return null;
        }
        Configuration conf = connectable.conf;
        HConnection connection = HConnectionManager.getConnection(conf);
        boolean connectSucceeded = false;
        try {
            T returnValue = connectable.connect(connection);
            connectSucceeded = true;
            T t = returnValue;
            return t;
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception e) {
                if (connectSucceeded) {
                    throw new IOException("The connection to " + connection + " could not be deleted.", e);
                }
                LOG.warn((Object)"Masking close error as the connectable block threw one itself.");
            }
        }
    }

    static {
        MAX_CACHED_HBASE_INSTANCES = HBaseConfiguration.create().getInt("hbase.zookeeper.property.maxClientCnxns", 30) + 1;
        HBASE_INSTANCES = new LinkedHashMap<HConnectionKey, HConnectionImplementation>((int)((float)MAX_CACHED_HBASE_INSTANCES / 0.75f) + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<HConnectionKey, HConnectionImplementation> eldest) {
                return this.size() > MAX_CACHED_HBASE_INSTANCES;
            }
        };
        LOG = LogFactory.getLog(HConnectionManager.class);
    }

    static class HConnectionImplementation
    implements HConnection,
    Closeable {
        static final Log LOG = LogFactory.getLog(HConnectionImplementation.class);
        private final Class<? extends HRegionInterface> serverInterfaceClass;
        private final long pause;
        private final int numRetries;
        private final int maxRPCAttempts;
        private final int rpcTimeout;
        private final int prefetchRegionLimit;
        private final Object masterLock = new Object();
        private volatile boolean closed;
        private volatile HMasterInterface master;
        private volatile boolean masterChecked;
        private volatile boolean isResettingZKTrackers;
        private ZooKeeperWatcher zooKeeper;
        private MasterAddressTracker masterAddressTracker;
        private RootRegionTracker rootRegionTracker;
        private final Object metaRegionLock = new Object();
        private final Object userRegionLock = new Object();
        private final Configuration conf;
        private final Map<String, HRegionInterface> servers = new ConcurrentHashMap<String, HRegionInterface>();
        private final ConcurrentHashMap<String, String> connectionLock = new ConcurrentHashMap();
        private final Map<Integer, SortedMap<byte[], HRegionLocation>> cachedRegionLocations = new HashMap<Integer, SortedMap<byte[], HRegionLocation>>();
        private final Set<Integer> regionCachePrefetchDisabledTables = new CopyOnWriteArraySet<Integer>();
        private boolean stopProxy;
        private int refCount;

        public HConnectionImplementation(Configuration conf) throws ZooKeeperConnectionException {
            this.conf = conf;
            String serverClassName = conf.get("hbase.regionserver.class", HConstants.DEFAULT_REGION_SERVER_CLASS);
            this.closed = false;
            try {
                this.serverInterfaceClass = Class.forName(serverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Unable to find region server interface " + serverClassName, e);
            }
            this.pause = conf.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
            this.numRetries = conf.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
            this.maxRPCAttempts = conf.getInt(HConstants.HBASE_CLIENT_RPC_MAXATTEMPTS, HConstants.DEFAULT_HBASE_CLIENT_RPC_MAXATTEMPTS);
            this.rpcTimeout = conf.getInt(HConstants.HBASE_RPC_TIMEOUT_KEY, HConstants.DEFAULT_HBASE_RPC_TIMEOUT);
            this.prefetchRegionLimit = conf.getInt(HConstants.HBASE_CLIENT_PREFETCH_LIMIT, HConstants.DEFAULT_HBASE_CLIENT_PREFETCH_LIMIT);
            this.setupZookeeperTrackers();
            this.master = null;
            this.masterChecked = false;
            this.isResettingZKTrackers = false;
        }

        private boolean setupZookeeperTrackers() throws ZooKeeperConnectionException {
            this.zooKeeper = this.getZooKeeperWatcher();
            this.masterAddressTracker = new MasterAddressTracker(this.zooKeeper, this);
            this.rootRegionTracker = new RootRegionTracker(this.zooKeeper, this);
            if (!this.masterAddressTracker.start()) {
                this.zooKeeper.close();
                this.masterAddressTracker.stop();
                this.masterAddressTracker = null;
                this.zooKeeper = null;
                return false;
            }
            if (!this.rootRegionTracker.start()) {
                this.zooKeeper.close();
                this.masterAddressTracker.stop();
                this.rootRegionTracker.stop();
                this.masterAddressTracker = null;
                this.rootRegionTracker = null;
                this.zooKeeper = null;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void resetZooKeeperTrackersWithRetries() throws ZooKeeperConnectionException {
            LOG.info((Object)"Trying to reconnect to zookeeper.");
            this.isResettingZKTrackers = true;
            try {
                if (this.masterAddressTracker != null) {
                    this.masterAddressTracker.stop();
                    this.masterAddressTracker = null;
                }
                if (this.rootRegionTracker != null) {
                    this.rootRegionTracker.stop();
                    this.rootRegionTracker = null;
                }
                if (this.zooKeeper != null) {
                    this.zooKeeper.close();
                    this.zooKeeper = null;
                }
                for (int tries = 0; tries < this.numRetries; ++tries) {
                    block11: {
                        try {
                            if (!this.setupZookeeperTrackers()) break block11;
                            break;
                        }
                        catch (ZooKeeperConnectionException zkce) {
                            if (tries + 1 < this.numRetries) break block11;
                            throw zkce;
                        }
                    }
                    LOG.info((Object)("Tried to reconnect to zookeeper but failed,  already tried " + tries + " times."));
                    try {
                        Thread.sleep(ConnectionUtils.getPauseTime(this.pause, tries));
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            finally {
                this.isResettingZKTrackers = false;
            }
        }

        @Override
        public Configuration getConfiguration() {
            return this.conf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HMasterInterface getMaster() throws MasterNotRunningException, ZooKeeperConnectionException {
            if (this.master != null && this.master.isMasterRunning()) {
                return this.master;
            }
            HServerAddress masterLocation = null;
            Object object = this.masterLock;
            synchronized (object) {
                for (int tries = 0; !this.closed && !this.masterChecked && this.master == null && tries < this.numRetries; ++tries) {
                    try {
                        masterLocation = this.masterAddressTracker.getMasterAddress();
                        if (masterLocation == null) {
                            LOG.info((Object)"ZooKeeper available but no active master location found");
                            throw new MasterNotRunningException();
                        }
                        HMasterInterface tryMaster = (HMasterInterface)HBaseRPC.getProxy(HMasterInterface.class, 27L, masterLocation.getInetSocketAddress(), this.conf, this.rpcTimeout);
                        if (tryMaster.isMasterRunning()) {
                            this.master = tryMaster;
                            this.masterLock.notifyAll();
                            break;
                        }
                    }
                    catch (IOException e) {
                        if (tries == this.numRetries - 1) {
                            LOG.info((Object)("getMaster attempt " + tries + " of " + this.numRetries + " failed; no more retrying."), (Throwable)e);
                            break;
                        }
                        LOG.info((Object)("getMaster attempt " + tries + " of " + this.numRetries + " failed; retrying after sleep of " + ConnectionUtils.getPauseTime(this.pause, tries)), (Throwable)e);
                    }
                    try {
                        this.masterLock.wait(ConnectionUtils.getPauseTime(this.pause, tries));
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Thread was interrupted while trying to connect to master.");
                    }
                }
                this.masterChecked = true;
            }
            if (this.master == null) {
                if (masterLocation == null) {
                    throw new MasterNotRunningException();
                }
                throw new MasterNotRunningException(masterLocation.toString());
            }
            return this.master;
        }

        @Override
        public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
            boolean isRunning;
            if (this.master == null) {
                this.getMaster();
            }
            if (isRunning = this.master.isMasterRunning()) {
                return true;
            }
            throw new MasterNotRunningException();
        }

        @Override
        public HRegionLocation getRegionLocation(byte[] name, byte[] row, boolean reload) throws IOException {
            return reload ? this.relocateRegion(name, row) : this.locateRegion(name, row);
        }

        @Override
        public HTableDescriptor[] listTables() throws IOException {
            final TreeSet uniqueTables = new TreeSet();
            MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){

                @Override
                public boolean processRow(Result result) throws IOException {
                    try {
                        byte[] value = result.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                        HRegionInfo info = null;
                        if (value != null) {
                            info = Writables.getHRegionInfo(value);
                        }
                        if (info != null && info.getStartKey().length == 0) {
                            uniqueTables.add(info.getTableDesc());
                        }
                        return true;
                    }
                    catch (RuntimeException e) {
                        LOG.error((Object)("Result=" + result));
                        throw e;
                    }
                }
            };
            MetaScanner.metaScan(this.conf, visitor);
            return uniqueTables.toArray(new HTableDescriptor[uniqueTables.size()]);
        }

        @Override
        public boolean isTableEnabled(byte[] tableName) throws IOException {
            return this.testTableOnlineState(tableName, true);
        }

        @Override
        public boolean isTableDisabled(byte[] tableName) throws IOException {
            return this.testTableOnlineState(tableName, false);
        }

        @Override
        public boolean isTableAvailable(final byte[] tableName) throws IOException {
            final AtomicBoolean available = new AtomicBoolean(true);
            final AtomicInteger regionCount = new AtomicInteger(0);
            MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){

                @Override
                public boolean processRow(Result row) throws IOException {
                    byte[] value = row.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                    HRegionInfo info = Writables.getHRegionInfoOrNull(value);
                    if (info != null && Bytes.equals(tableName, info.getTableDesc().getName())) {
                        value = row.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                        if (value == null) {
                            available.set(false);
                            return false;
                        }
                        regionCount.incrementAndGet();
                    }
                    return true;
                }
            };
            MetaScanner.metaScan(this.conf, visitor);
            return available.get() && regionCount.get() > 0;
        }

        private boolean testTableOnlineState(byte[] tableName, boolean online) throws IOException {
            if (Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME)) {
                return online;
            }
            String tableNameStr = Bytes.toString(tableName);
            try {
                if (online) {
                    return ZKTable.isEnabledTable(this.zooKeeper, tableNameStr);
                }
                return ZKTable.isDisabledTable(this.zooKeeper, tableNameStr);
            }
            catch (KeeperException e) {
                throw new IOException("Enable/Disable failed", e);
            }
        }

        @Override
        public HTableDescriptor getHTableDescriptor(byte[] tableName) throws IOException {
            if (Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME)) {
                return new UnmodifyableHTableDescriptor(HTableDescriptor.ROOT_TABLEDESC);
            }
            if (Bytes.equals(tableName, HConstants.META_TABLE_NAME)) {
                return HTableDescriptor.META_TABLEDESC;
            }
            HTableDescriptorFinder finder = new HTableDescriptorFinder(tableName);
            MetaScanner.metaScan(this.conf, finder, tableName);
            HTableDescriptor result = finder.getResult();
            if (result == null) {
                throw new TableNotFoundException(Bytes.toString(tableName));
            }
            return result;
        }

        @Override
        public HRegionLocation locateRegion(byte[] regionName) throws IOException {
            return null;
        }

        @Override
        public List<HRegionLocation> locateRegions(byte[] tableName) throws IOException {
            return null;
        }

        @Override
        public HRegionLocation locateRegion(byte[] tableName, byte[] row) throws IOException {
            return this.locateRegion(tableName, row, true);
        }

        @Override
        public HRegionLocation relocateRegion(byte[] tableName, byte[] row) throws IOException {
            return this.locateRegion(tableName, row, false);
        }

        private HRegionLocation locateRegion(byte[] tableName, byte[] row, boolean useCache) throws IOException {
            if (this.closed) {
                throw new ClosedConnectionException(this.toString() + " closed");
            }
            if (tableName == null || tableName.length == 0) {
                throw new IllegalArgumentException("table name cannot be null or zero length");
            }
            if (Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME)) {
                try {
                    HServerAddress hsa = this.rootRegionTracker.waitRootRegionLocation(this.rpcTimeout);
                    LOG.debug((Object)("Lookedup root region location, connection=" + this + "; hsa=" + hsa));
                    if (hsa == null) {
                        return null;
                    }
                    return new HRegionLocation(HRegionInfo.ROOT_REGIONINFO, hsa);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            if (Bytes.equals(tableName, HConstants.META_TABLE_NAME)) {
                return this.locateRegionInMeta(HConstants.ROOT_TABLE_NAME, tableName, row, useCache, this.metaRegionLock);
            }
            return this.locateRegionInMeta(HConstants.META_TABLE_NAME, tableName, row, useCache, this.userRegionLock);
        }

        private void prefetchRegionCache(final byte[] tableName, byte[] row) {
            MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){

                @Override
                public boolean processRow(Result result) throws IOException {
                    try {
                        byte[] value = result.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                        HRegionInfo regionInfo = null;
                        if (value != null) {
                            regionInfo = Writables.getHRegionInfo(value);
                            if (!Bytes.equals(regionInfo.getTableDesc().getName(), tableName)) {
                                return false;
                            }
                            if (regionInfo.isOffline()) {
                                return true;
                            }
                            value = result.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                            if (value == null) {
                                return true;
                            }
                            String serverAddress = Bytes.toString(value);
                            HRegionLocation loc = new HRegionLocation(regionInfo, new HServerAddress(serverAddress));
                            HConnectionImplementation.this.cacheLocation(tableName, loc);
                        }
                        return true;
                    }
                    catch (RuntimeException e) {
                        throw new IOException(e);
                    }
                }
            };
            try {
                MetaScanner.metaScan(this.conf, visitor, tableName, row, this.prefetchRegionLimit);
            }
            catch (IOException e) {
                LOG.warn((Object)"Encountered problems when prefetch META table: ", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HRegionLocation locateRegionInMeta(byte[] parentTable, byte[] tableName, byte[] row, boolean useCache, Object regionLockObject) throws IOException {
            HRegionLocation location;
            if (useCache && (location = this.getCachedLocation(tableName, row)) != null) {
                return location;
            }
            byte[] metaKey = HRegionInfo.createRegionName(tableName, row, "99999999999999", false);
            int tries = 0;
            while (true) {
                block27: {
                    if (tries >= this.numRetries) {
                        throw new NoServerForRegionException("Unable to find region for " + Bytes.toStringBinary(row) + " after " + this.numRetries + " tries.");
                    }
                    HRegionLocation metaLocation = null;
                    try {
                        metaLocation = this.locateRegion(parentTable, metaKey);
                        if (metaLocation == null) break block27;
                        HRegionInterface server = this.getHRegionConnection(metaLocation.getServerAddress());
                        Result regionInfoRow = null;
                        Object object = regionLockObject;
                        synchronized (object) {
                            if (Bytes.equals(parentTable, HConstants.META_TABLE_NAME) && this.getRegionCachePrefetch(tableName)) {
                                this.prefetchRegionCache(tableName, row);
                            }
                            if (useCache) {
                                location = this.getCachedLocation(tableName, row);
                                if (location != null) {
                                    return location;
                                }
                            } else {
                                this.deleteCachedLocation(tableName, row);
                            }
                            regionInfoRow = server.getClosestRowBefore(metaLocation.getRegionInfo().getRegionName(), metaKey, HConstants.CATALOG_FAMILY);
                        }
                        if (regionInfoRow == null) {
                            throw new TableNotFoundException(Bytes.toString(tableName));
                        }
                        byte[] value = regionInfoRow.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                        if (value == null || value.length == 0) {
                            throw new IOException("HRegionInfo was null or empty in " + Bytes.toString(parentTable) + ", row=" + regionInfoRow);
                        }
                        HRegionInfo regionInfo = (HRegionInfo)Writables.getWritable(value, (Writable)new HRegionInfo());
                        if (!Bytes.equals(regionInfo.getTableDesc().getName(), tableName)) {
                            throw new TableNotFoundException("Table '" + Bytes.toString(tableName) + "' was not found.");
                        }
                        if (regionInfo.isSplit()) {
                            throw new RegionOfflineException("the only available region for the required row is a split parent, the daughters should be online soon: " + regionInfo.getRegionNameAsString());
                        }
                        if (regionInfo.isOffline()) {
                            throw new RegionOfflineException("the region is offline, could be caused by a disable table call: " + regionInfo.getRegionNameAsString());
                        }
                        value = regionInfoRow.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                        String serverAddress = "";
                        if (value != null) {
                            serverAddress = Bytes.toString(value);
                        }
                        if (serverAddress.equals("")) {
                            throw new NoServerForRegionException("No server address listed in " + Bytes.toString(parentTable) + " for region " + regionInfo.getRegionNameAsString());
                        }
                        location = new HRegionLocation(regionInfo, new HServerAddress(serverAddress));
                        this.cacheLocation(tableName, location);
                        return location;
                    }
                    catch (TableNotFoundException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        if (e instanceof RemoteException) {
                            e = RemoteExceptionHandler.decodeRemoteException((RemoteException)((Object)e));
                        }
                        if (tries < this.numRetries - 1) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("locateRegionInMeta parentTable=" + Bytes.toString(parentTable) + ", metaLocation=" + (metaLocation == null ? "null" : metaLocation) + ", attempt=" + tries + " of " + this.numRetries + " failed; retrying after sleep of " + ConnectionUtils.getPauseTime(this.pause, tries) + " because: " + e.getMessage()));
                            }
                        } else {
                            throw e;
                        }
                        if (!(e instanceof RegionOfflineException) && !(e instanceof NoServerForRegionException)) {
                            this.relocateRegion(parentTable, metaKey);
                        }
                        try {
                            Thread.sleep(ConnectionUtils.getPauseTime(this.pause, tries));
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                            throw new IOException("Giving up trying to location region in meta: thread is interrupted.");
                        }
                    }
                }
                ++tries;
            }
        }

        HRegionLocation getCachedLocation(byte[] tableName, byte[] row) {
            SortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
            if (tableLocations.isEmpty()) {
                return null;
            }
            HRegionLocation rl = (HRegionLocation)tableLocations.get(row);
            if (rl != null) {
                return rl;
            }
            SortedMap<byte[], HRegionLocation> matchingRegions = tableLocations.headMap(row);
            if (!matchingRegions.isEmpty()) {
                byte[] endKey;
                HRegionLocation possibleRegion = null;
                try {
                    possibleRegion = (HRegionLocation)matchingRegions.get(matchingRegions.lastKey());
                }
                catch (NoSuchElementException nsee) {
                    LOG.warn((Object)"checkReferences() might have removed the key", (Throwable)nsee);
                }
                if (possibleRegion != null && (Bytes.equals(endKey = possibleRegion.getRegionInfo().getEndKey(), HConstants.EMPTY_END_ROW) || KeyValue.getRowComparator(tableName).compareRows(endKey, 0, endKey.length, row, 0, row.length) > 0)) {
                    return possibleRegion;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void deleteCachedLocation(byte[] tableName, byte[] row) {
            Map<Integer, SortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                HRegionLocation rl;
                SortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
                if (!tableLocations.isEmpty() && (rl = this.getCachedLocation(tableName, row)) != null) {
                    tableLocations.remove(rl.getRegionInfo().getStartKey());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Removed " + rl.getRegionInfo().getRegionNameAsString() + " for tableName=" + Bytes.toString(tableName) + " from cache " + "because of " + Bytes.toStringBinary(row)));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SortedMap<byte[], HRegionLocation> getTableLocations(byte[] tableName) {
            SortedMap<byte[], HRegionLocation> result;
            Integer key = Bytes.mapKey(tableName);
            Map<Integer, SortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                result = this.cachedRegionLocations.get(key);
                if (result == null) {
                    result = new SoftValueSortedMap<byte[], HRegionLocation>(Bytes.BYTES_COMPARATOR);
                    this.cachedRegionLocations.put(key, result);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearRegionCache() {
            Map<Integer, SortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                this.cachedRegionLocations.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearRegionCache(byte[] tableName) {
            Map<Integer, SortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                this.cachedRegionLocations.remove(Bytes.mapKey(tableName));
            }
        }

        private void cacheLocation(byte[] tableName, HRegionLocation location) {
            byte[] startKey = location.getRegionInfo().getStartKey();
            SortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
            if (tableLocations.put(startKey, location) == null) {
                LOG.debug((Object)("Cached location for " + location.getRegionInfo().getRegionNameAsString() + " is " + location.getServerAddress()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HRegionInterface getHRegionConnection(HServerAddress regionServer, boolean getMaster) throws IOException {
            String rsName;
            HRegionInterface server;
            if (getMaster) {
                this.getMaster();
            }
            if ((server = this.servers.get(rsName = regionServer.toString())) == null) {
                this.connectionLock.putIfAbsent(rsName, rsName);
                String string = this.connectionLock.get(rsName);
                synchronized (string) {
                    server = this.servers.get(rsName);
                    if (server == null) {
                        try {
                            server = (HRegionInterface)HBaseRPC.waitForProxy(this.serverInterfaceClass, 27L, regionServer.getInetSocketAddress(), this.conf, this.maxRPCAttempts, this.rpcTimeout, this.rpcTimeout);
                            this.servers.put(rsName, server);
                        }
                        catch (RemoteException e) {
                            LOG.warn((Object)"RemoteException connecting to RS", (Throwable)e);
                            throw RemoteExceptionHandler.decodeRemoteException(e);
                        }
                    }
                }
            }
            return server;
        }

        @Override
        public HRegionInterface getHRegionConnection(HServerAddress regionServer) throws IOException {
            return this.getHRegionConnection(regionServer, false);
        }

        @Override
        public synchronized ZooKeeperWatcher getZooKeeperWatcher() throws ZooKeeperConnectionException {
            if (this.zooKeeper == null) {
                try {
                    this.zooKeeper = new ZooKeeperWatcher(this.conf, "hconnection", this);
                }
                catch (ZooKeeperConnectionException zce) {
                    throw zce;
                }
                catch (IOException e) {
                    throw new ZooKeeperConnectionException("An error is preventing HBase from connecting to ZooKeeper", e);
                }
            }
            return this.zooKeeper;
        }

        @Override
        public <T> T getRegionServerWithRetries(ServerCallable<T> callable) throws IOException, RuntimeException {
            if (this.closed) {
                throw new ClosedConnectionException(this.toString() + " closed");
            }
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            for (int tries = 0; tries < this.numRetries; ++tries) {
                try {
                    callable.instantiateServer(tries != 0);
                    return (T)callable.call();
                }
                catch (Throwable t) {
                    t = this.translateException(t);
                    exceptions.add(t);
                    if (tries == this.numRetries - 1) {
                        throw new RetriesExhaustedException(callable.getServerName(), callable.getRegionName(), callable.getRow(), tries, exceptions);
                    }
                    try {
                        Thread.sleep(ConnectionUtils.getPauseTime(this.pause, tries));
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException("Giving up trying to get region server: thread is interrupted.");
                    }
                }
            }
            return null;
        }

        @Override
        public <T> T getRegionServerWithoutRetries(ServerCallable<T> callable) throws IOException, RuntimeException {
            if (this.closed) {
                throw new ClosedConnectionException(this.toString() + " closed");
            }
            try {
                callable.instantiateServer(false);
                return (T)callable.call();
            }
            catch (Throwable t) {
                Throwable t2 = this.translateException(t);
                if (t2 instanceof IOException) {
                    throw (IOException)t2;
                }
                throw new RuntimeException(t2);
            }
        }

        private Callable<MultiResponse> createCallable(final HServerAddress address, final MultiAction multi, final byte[] tableName) {
            final HConnectionImplementation connection = this;
            return new Callable<MultiResponse>(){

                @Override
                public MultiResponse call() throws IOException {
                    return HConnectionImplementation.this.getRegionServerWithoutRetries(new ServerCallable<MultiResponse>(connection, tableName, null){

                        @Override
                        public MultiResponse call() throws IOException {
                            return this.server.multi(multi);
                        }

                        @Override
                        public void instantiateServer(boolean reload) throws IOException {
                            this.server = this.connection.getHRegionConnection(address);
                        }
                    });
                }
            };
        }

        @Override
        public void processBatch(List<Row> list, byte[] tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
            int i;
            if (results.length != list.size()) {
                throw new IllegalArgumentException("argument results must be the same size as argument list");
            }
            if (list.size() == 0) {
                return;
            }
            HServerAddress[] lastServers = new HServerAddress[results.length];
            ArrayList<Row> workingList = new ArrayList<Row>(list);
            boolean retry = true;
            Throwable singleRowCause = null;
            for (int tries = 0; tries < this.numRetries && retry; ++tries) {
                HServerAddress address;
                if (tries >= 1) {
                    long sleepTime = ConnectionUtils.getPauseTime(this.pause, tries);
                    LOG.debug((Object)("Retry " + tries + ", sleep for " + sleepTime + "ms!"));
                    Thread.sleep(sleepTime);
                }
                HashMap<HServerAddress, MultiAction> actionsByServer = new HashMap<HServerAddress, MultiAction>();
                for (int i2 = 0; i2 < workingList.size(); ++i2) {
                    Row row = (Row)workingList.get(i2);
                    if (row == null) continue;
                    HRegionLocation loc = this.locateRegion(tableName, row.getRow(), true);
                    address = loc.getServerAddress();
                    byte[] regionName = loc.getRegionInfo().getRegionName();
                    MultiAction actions = (MultiAction)actionsByServer.get(address);
                    if (actions == null) {
                        actions = new MultiAction();
                        actionsByServer.put(address, actions);
                    }
                    Action action = new Action(regionName, row, i2);
                    lastServers[i2] = address;
                    actions.add(regionName, action);
                }
                HashMap futures = new HashMap(actionsByServer.size());
                for (Map.Entry e : actionsByServer.entrySet()) {
                    futures.put(e.getKey(), pool.submit(this.createCallable((HServerAddress)e.getKey(), (MultiAction)e.getValue(), tableName)));
                }
                for (Map.Entry responsePerServer : futures.entrySet()) {
                    address = (HServerAddress)responsePerServer.getKey();
                    try {
                        Future future = (Future)responsePerServer.getValue();
                        MultiResponse resp = (MultiResponse)future.get();
                        if (resp == null) {
                            LOG.debug((Object)("Failed all for server: " + address + ", removing from cache"));
                            continue;
                        }
                        for (Map.Entry<byte[], List<Pair<Integer, Object>>> e : resp.getResults().entrySet()) {
                            byte[] regionName = e.getKey();
                            List<Pair<Integer, Object>> regionResults = e.getValue();
                            for (Pair<Integer, Object> regionResult : regionResults) {
                                if (regionResult == null) {
                                    LOG.debug((Object)("Failures for region: " + Bytes.toStringBinary(regionName) + ", removing from cache"));
                                    continue;
                                }
                                results[regionResult.getFirst().intValue()] = regionResult.getSecond();
                            }
                        }
                    }
                    catch (ExecutionException e) {
                        LOG.debug((Object)("Failed all from " + address), (Throwable)e);
                    }
                }
                retry = false;
                workingList.clear();
                for (i = 0; i < results.length; ++i) {
                    if (results[i] == null || results[i] instanceof Throwable && !(results[i] instanceof DoNotRetryIOException)) {
                        retry = true;
                        Row row = list.get(i);
                        workingList.add(row);
                        this.deleteCachedLocation(tableName, row.getRow());
                        continue;
                    }
                    workingList.add(null);
                }
            }
            if (retry && singleRowCause != null) {
                throw new IOException(singleRowCause);
            }
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            ArrayList<Row> actions = new ArrayList<Row>();
            ArrayList<HServerAddress> addresses = new ArrayList<HServerAddress>();
            for (i = 0; i < results.length; ++i) {
                if (results[i] != null && !(results[i] instanceof Throwable)) continue;
                exceptions.add((Throwable)results[i]);
                actions.add(list.get(i));
                addresses.add(lastServers[i]);
            }
            if (!exceptions.isEmpty()) {
                throw new RetriesExhaustedWithDetailsException(exceptions, actions, addresses);
            }
        }

        @Override
        public void processBatchOfPuts(List<Put> list, byte[] tableName, ExecutorService pool) throws IOException {
            Object[] results = new Object[list.size()];
            try {
                this.processBatch(list, tableName, pool, results);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            finally {
                for (int i = results.length - 1; i >= 0; --i) {
                    if (!(results[i] instanceof Result)) continue;
                    list.remove(i);
                }
            }
        }

        private Throwable translateException(Throwable t) throws IOException {
            if (t instanceof UndeclaredThrowableException) {
                t = t.getCause();
            }
            if (t instanceof RemoteException) {
                t = RemoteExceptionHandler.decodeRemoteException((RemoteException)t);
            }
            if (t instanceof DoNotRetryIOException) {
                throw (DoNotRetryIOException)t;
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getNumberOfCachedRegionLocations(byte[] tableName) {
            Integer key = Bytes.mapKey(tableName);
            Map<Integer, SortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                Map tableLocs = this.cachedRegionLocations.get(key);
                if (tableLocs == null) {
                    return 0;
                }
                return tableLocs.values().size();
            }
        }

        boolean isRegionCached(byte[] tableName, byte[] row) {
            HRegionLocation location = this.getCachedLocation(tableName, row);
            return location != null;
        }

        @Override
        public void setRegionCachePrefetch(byte[] tableName, boolean enable) {
            if (!enable) {
                this.regionCachePrefetchDisabledTables.add(Bytes.mapKey(tableName));
            } else {
                this.regionCachePrefetchDisabledTables.remove(Bytes.mapKey(tableName));
            }
        }

        @Override
        public boolean getRegionCachePrefetch(byte[] tableName) {
            return !this.regionCachePrefetchDisabledTables.contains(Bytes.mapKey(tableName));
        }

        @Override
        public void prewarmRegionCache(byte[] tableName, Map<HRegionInfo, HServerAddress> regions) {
            for (Map.Entry<HRegionInfo, HServerAddress> e : regions.entrySet()) {
                this.cacheLocation(tableName, new HRegionLocation(e.getKey(), e.getValue()));
            }
        }

        @Override
        public void abort(String msg, Throwable t) {
            if (t instanceof KeeperException.SessionExpiredException || t instanceof KeeperException.ConnectionLossException) {
                if (this.isResettingZKTrackers) {
                    return;
                }
                try {
                    LOG.info((Object)"This client just lost it's session with ZooKeeper, trying to reconnect.");
                    this.resetZooKeeperTrackersWithRetries();
                    LOG.info((Object)"Reconnected successfully. This disconnect could have been caused by a network partition or a long-running GC pause, either way it's recommended that you verify your environment.");
                    return;
                }
                catch (ZooKeeperConnectionException e) {
                    LOG.error((Object)"Could not reconnect to ZooKeeper after session expiration, aborting");
                    t = e;
                }
            }
            if (t != null) {
                LOG.fatal((Object)msg, t);
            } else {
                LOG.fatal((Object)msg);
            }
            HConnectionManager.deleteStaleConnection(this);
        }

        public void stopProxyOnClose(boolean stopProxy) {
            this.stopProxy = stopProxy;
        }

        void incCount() {
            ++this.refCount;
        }

        void decCount() {
            if (this.refCount > 0) {
                --this.refCount;
            }
        }

        boolean isZeroReference() {
            return this.refCount == 0;
        }

        void close(boolean stopProxy) {
            if (this.closed) {
                return;
            }
            if (this.master != null) {
                if (stopProxy) {
                    HBaseRPC.stopProxy(this.master);
                }
                this.master = null;
                this.masterChecked = false;
            }
            if (stopProxy) {
                for (HRegionInterface i : this.servers.values()) {
                    HBaseRPC.stopProxy(i);
                }
            }
            this.servers.clear();
            if (this.zooKeeper != null) {
                LOG.info((Object)("Closed zookeeper sessionid=0x" + Long.toHexString(this.zooKeeper.getZooKeeper().getSessionId())));
                this.zooKeeper.close();
                this.zooKeeper = null;
            }
            this.closed = true;
        }

        @Override
        public void close() {
            HConnectionManager.deleteConnection(this, this.stopProxy, false);
            LOG.debug((Object)("The connection to " + this.zooKeeper + " has been closed."));
        }

        protected void finalize() throws Throwable {
            this.refCount = 1;
            this.close();
            LOG.debug((Object)("The connection to " + this.zooKeeper + " was closed by the finalize method."));
        }

        private static class HTableDescriptorFinder
        implements MetaScanner.MetaScannerVisitor {
            byte[] tableName;
            HTableDescriptor result;

            protected HTableDescriptorFinder(byte[] tableName) {
                this.tableName = tableName;
            }

            @Override
            public boolean processRow(Result rowResult) throws IOException {
                HRegionInfo info = Writables.getHRegionInfoOrNull(rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                if (info == null) {
                    return true;
                }
                HTableDescriptor desc = info.getTableDesc();
                if (Bytes.compareTo(desc.getName(), this.tableName) == 0) {
                    this.result = desc;
                    return false;
                }
                return true;
            }

            HTableDescriptor getResult() {
                return this.result;
            }
        }
    }

    static class HConnectionKey {
        public static String[] CONNECTION_PROPERTIES = new String[]{"hbase.zookeeper.quorum", "zookeeper.znode.parent", "hbase.zookeeper.property.clientPort", "hbase.zookeeper.recoverable.waittime", HConstants.HBASE_CLIENT_PAUSE, HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.HBASE_CLIENT_RPC_MAXATTEMPTS, HConstants.HBASE_RPC_TIMEOUT_KEY, HConstants.HBASE_CLIENT_PREFETCH_LIMIT, HConstants.HBASE_META_SCANNER_CACHING, HConstants.HBASE_CLIENT_INSTANCE_ID};
        private Map<String, String> properties;

        public HConnectionKey(Configuration conf) {
            HashMap<String, String> m = new HashMap<String, String>();
            if (conf != null) {
                if (conf.getBoolean(HConstants.HBASE_CONNECTION_PER_CONFIG, false)) {
                    m.put(HConstants.HBASE_CLIENT_INSTANCE_ID, String.valueOf(System.identityHashCode(conf)));
                } else {
                    for (String property : CONNECTION_PROPERTIES) {
                        String value = conf.get(property);
                        if (value == null) continue;
                        m.put(property, value);
                    }
                }
            }
            this.properties = Collections.unmodifiableMap(m);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            for (String property : CONNECTION_PROPERTIES) {
                String value = this.properties.get(property);
                if (value == null) continue;
                result = 31 * result + value.hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HConnectionKey that = (HConnectionKey)obj;
            if (this.properties == null) {
                if (that.properties != null) {
                    return false;
                }
            } else {
                if (that.properties == null) {
                    return false;
                }
                for (String property : CONNECTION_PROPERTIES) {
                    String thatValue;
                    String thisValue = this.properties.get(property);
                    if (thisValue == (thatValue = that.properties.get(property)) || thisValue != null && thisValue.equals(thatValue)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static abstract class HConnectable<T> {
        public Configuration conf;

        public HConnectable(Configuration conf) {
            this.conf = conf;
        }

        public abstract T connect(HConnection var1) throws IOException;
    }
}

