/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public final class MultiAction
implements Writable {
    public Map<byte[], List<Action>> actions = new TreeMap<byte[], List<Action>>(Bytes.BYTES_COMPARATOR);

    public int size() {
        int size = 0;
        for (List<Action> l : this.actions.values()) {
            size += l.size();
        }
        return size;
    }

    public void add(byte[] regionName, Action a) {
        List<Action> rsActions = this.actions.get(regionName);
        if (rsActions == null) {
            rsActions = new ArrayList<Action>();
            this.actions.put(regionName, rsActions);
        }
        rsActions.add(a);
    }

    public Set<byte[]> getRegions() {
        return this.actions.keySet();
    }

    public List<Action> allActions() {
        ArrayList<Action> res = new ArrayList<Action>();
        for (List<Action> lst : this.actions.values()) {
            res.addAll(lst);
        }
        return res;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.actions.size());
        for (Map.Entry<byte[], List<Action>> e : this.actions.entrySet()) {
            Bytes.writeByteArray(out, e.getKey());
            List<Action> lst = e.getValue();
            out.writeInt(lst.size());
            for (Action a : lst) {
                HbaseObjectWritable.writeObject(out, a, Action.class, null);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.actions.clear();
        int mapSize = in.readInt();
        for (int i = 0; i < mapSize; ++i) {
            byte[] key = Bytes.readByteArray(in);
            int listSize = in.readInt();
            ArrayList<Action> lst = new ArrayList<Action>(listSize);
            for (int j = 0; j < listSize; ++j) {
                lst.add((Action)HbaseObjectWritable.readObject(in, null));
            }
            this.actions.put(key, lst);
        }
    }
}

