/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;

public class RetriesExhaustedWithDetailsException
extends RetriesExhaustedException {
    List<Throwable> exceptions;
    List<Row> actions;
    List<HServerAddress> addresses;

    public RetriesExhaustedWithDetailsException(List<Throwable> exceptions, List<Row> actions, List<HServerAddress> addresses) {
        super("Failed " + exceptions.size() + " action" + RetriesExhaustedWithDetailsException.pluralize(exceptions) + ": " + RetriesExhaustedWithDetailsException.getDesc(exceptions, actions, addresses));
        this.exceptions = exceptions;
        this.actions = actions;
        this.addresses = addresses;
    }

    public List<Throwable> getCauses() {
        return this.exceptions;
    }

    public int getNumExceptions() {
        return this.exceptions.size();
    }

    public Throwable getCause(int i) {
        return this.exceptions.get(i);
    }

    public Row getRow(int i) {
        return this.actions.get(i);
    }

    public HServerAddress getAddress(int i) {
        return this.addresses.get(i);
    }

    public boolean mayHaveClusterIssues() {
        boolean res = false;
        for (Throwable t : this.exceptions) {
            if (t instanceof DoNotRetryIOException) continue;
            res = true;
        }
        return res;
    }

    public static String pluralize(Collection<?> c) {
        return RetriesExhaustedWithDetailsException.pluralize(c.size());
    }

    public static String pluralize(int c) {
        return c > 1 ? "s" : "";
    }

    public static String getDesc(List<Throwable> exceptions, List<Row> actions, List<HServerAddress> addresses) {
        String s = RetriesExhaustedWithDetailsException.getDesc(RetriesExhaustedWithDetailsException.classifyExs(exceptions));
        s = s + "servers with issues: ";
        HashSet<HServerAddress> uniqAddr = new HashSet<HServerAddress>();
        uniqAddr.addAll(addresses);
        for (HServerAddress addr : uniqAddr) {
            s = s + addr + ", ";
        }
        return s;
    }

    public static Map<String, Integer> classifyExs(List<Throwable> ths) {
        HashMap<String, Integer> cls = new HashMap<String, Integer>();
        for (Throwable t : ths) {
            if (t == null) continue;
            String name = "";
            name = t instanceof NoSuchColumnFamilyException ? t.getMessage() : t.getClass().getSimpleName();
            Integer i = (Integer)cls.get(name);
            if (i == null) {
                i = 0;
            }
            i = i + 1;
            cls.put(name, i);
        }
        return cls;
    }

    public static String getDesc(Map<String, Integer> classificaton) {
        String s = "";
        for (Map.Entry<String, Integer> e : classificaton.entrySet()) {
            s = s + e.getKey() + ": " + e.getValue() + " time" + RetriesExhaustedWithDetailsException.pluralize(e.getValue()) + ", ";
        }
        return s;
    }
}

