/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Bytes;

public class PrefixFilter
extends FilterBase {
    protected byte[] prefix = null;
    protected boolean passedPrefix = false;

    public PrefixFilter(byte[] prefix) {
        this.prefix = prefix;
    }

    public PrefixFilter() {
    }

    public byte[] getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        if (buffer == null || this.prefix == null) {
            return true;
        }
        if (length < this.prefix.length) {
            return true;
        }
        int cmp = Bytes.compareTo(buffer, offset, this.prefix.length, this.prefix, 0, this.prefix.length);
        if (cmp > 0) {
            this.passedPrefix = true;
        }
        return cmp != 0;
    }

    @Override
    public boolean filterAllRemaining() {
        return this.passedPrefix;
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.prefix);
    }

    public void readFields(DataInput in) throws IOException {
        this.prefix = Bytes.readByteArray(in);
    }
}

