/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HMsg;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiPut;
import org.apache.hadoop.hbase.client.MultiPutResponse;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.HbaseMapWritable;
import org.apache.hadoop.hbase.io.WritableWithSize;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;

public class HbaseObjectWritable
implements Writable,
WritableWithSize,
Configurable {
    protected static final Log LOG;
    static final Map<Byte, Class<?>> CODE_TO_CLASS;
    static final Map<Class<?>, Byte> CLASS_TO_CODE;
    private static final byte NOT_ENCODED = 0;
    private Class<?> declaredClass;
    private Object instance;
    private Configuration conf;

    public HbaseObjectWritable() {
    }

    public HbaseObjectWritable(Object instance) {
        this.set(instance);
    }

    public HbaseObjectWritable(Class<?> declaredClass, Object instance) {
        this.declaredClass = declaredClass;
        this.instance = instance;
    }

    public Object get() {
        return this.instance;
    }

    public Class<?> getDeclaredClass() {
        return this.declaredClass;
    }

    public void set(Object instance) {
        this.declaredClass = instance.getClass();
        this.instance = instance;
    }

    public String toString() {
        return "OW[class=" + this.declaredClass + ",value=" + this.instance + "]";
    }

    public void readFields(DataInput in) throws IOException {
        HbaseObjectWritable.readObject(in, this, this.conf);
    }

    public void write(DataOutput out) throws IOException {
        HbaseObjectWritable.writeObject(out, this.instance, this.declaredClass, this.conf);
    }

    @Override
    public long getWritableSize() {
        return HbaseObjectWritable.getWritableSize(this.instance, this.declaredClass, this.conf);
    }

    static void writeClassCode(DataOutput out, Class<?> c) throws IOException {
        Byte code = CLASS_TO_CODE.get(c);
        if (code == null) {
            if (List.class.isAssignableFrom(c)) {
                code = CLASS_TO_CODE.get(List.class);
            } else if (Writable.class.isAssignableFrom(c)) {
                code = CLASS_TO_CODE.get(Writable.class);
            } else if (Serializable.class.isAssignableFrom(c)) {
                code = CLASS_TO_CODE.get(Serializable.class);
            }
        }
        if (code == null) {
            StackTraceElement[] els;
            LOG.error((Object)("Unsupported type " + c));
            for (StackTraceElement elem : els = new Exception().getStackTrace()) {
                LOG.error((Object)elem.getMethodName());
            }
            throw new UnsupportedOperationException("No code for unexpected " + c);
        }
        out.writeByte(code.byteValue());
    }

    public static long getWritableSize(Object instance, Class declaredClass, Configuration conf) {
        long size = 1L;
        if (instance == null) {
            return 0L;
        }
        if (declaredClass.isArray() && declaredClass.equals(Result[].class)) {
            return size + Result.getWriteArraySize((Result[])instance);
        }
        if (declaredClass.equals(Result.class)) {
            Result r = (Result)instance;
            return r.getWritableSize() + size + 1L;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(DataOutput out, Object instance, Class declaredClass, Configuration conf) throws IOException {
        Object instanceObj = instance;
        Class<Writable> declClass = declaredClass;
        if (instanceObj == null) {
            instanceObj = new NullInstance(declClass, conf);
            declClass = Writable.class;
        }
        HbaseObjectWritable.writeClassCode(out, declClass);
        if (declClass.isArray()) {
            if (declClass.equals(byte[].class)) {
                Bytes.writeByteArray(out, (byte[])instanceObj);
            } else if (declClass.equals(Result[].class)) {
                Result.writeArray(out, (Result[])instanceObj);
            } else {
                int length = Array.getLength(instanceObj);
                out.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    HbaseObjectWritable.writeObject(out, Array.get(instanceObj, i), declClass.getComponentType(), conf);
                }
            }
        } else if (List.class.isAssignableFrom(declClass)) {
            List list = (List)instanceObj;
            int length = list.size();
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                HbaseObjectWritable.writeObject(out, list.get(i), list.get(i).getClass(), conf);
            }
        } else if (declClass == String.class) {
            Text.writeString((DataOutput)out, (String)((String)instanceObj));
        } else if (declClass.isPrimitive()) {
            if (declClass == Boolean.TYPE) {
                out.writeBoolean((Boolean)instanceObj);
            } else if (declClass == Character.TYPE) {
                out.writeChar(((Character)instanceObj).charValue());
            } else if (declClass == Byte.TYPE) {
                out.writeByte(((Byte)instanceObj).byteValue());
            } else if (declClass == Short.TYPE) {
                out.writeShort(((Short)instanceObj).shortValue());
            } else if (declClass == Integer.TYPE) {
                out.writeInt((Integer)instanceObj);
            } else if (declClass == Long.TYPE) {
                out.writeLong((Long)instanceObj);
            } else if (declClass == Float.TYPE) {
                out.writeFloat(((Float)instanceObj).floatValue());
            } else if (declClass == Double.TYPE) {
                out.writeDouble((Double)instanceObj);
            } else if (declClass != Void.TYPE) {
                throw new IllegalArgumentException("Not a primitive: " + declClass);
            }
        } else if (declClass.isEnum()) {
            Text.writeString((DataOutput)out, (String)((Enum)instanceObj).name());
        } else if (Writable.class.isAssignableFrom(declClass)) {
            Class<?> c = instanceObj.getClass();
            Byte code = CLASS_TO_CODE.get(c);
            if (code == null) {
                out.writeByte(0);
                Text.writeString((DataOutput)out, (String)c.getName());
            } else {
                HbaseObjectWritable.writeClassCode(out, c);
            }
            ((Writable)instanceObj).write(out);
        } else if (Serializable.class.isAssignableFrom(declClass)) {
            Class<?> c = instanceObj.getClass();
            Byte code = CLASS_TO_CODE.get(c);
            if (code == null) {
                out.writeByte(0);
                Text.writeString((DataOutput)out, (String)c.getName());
            } else {
                HbaseObjectWritable.writeClassCode(out, c);
            }
            ByteArrayOutputStream bos = null;
            ObjectOutputStream oos = null;
            try {
                bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(bos);
                oos.writeObject(instanceObj);
                byte[] value = bos.toByteArray();
                out.writeInt(value.length);
                out.write(value);
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
                if (oos != null) {
                    oos.close();
                }
            }
        } else {
            throw new IOException("Can't write: " + instanceObj + " as " + declClass);
        }
    }

    public static Object readObject(DataInput in, Configuration conf) throws IOException {
        return HbaseObjectWritable.readObject(in, null, conf);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object readObject(DataInput in, HbaseObjectWritable objectWritable, Configuration conf) throws IOException {
        void var4_23;
        Class<?> declaredClass = CODE_TO_CLASS.get(in.readByte());
        if (declaredClass.isPrimitive()) {
            if (declaredClass == Boolean.TYPE) {
                Boolean bl = in.readBoolean();
            } else if (declaredClass == Character.TYPE) {
                Character c = Character.valueOf(in.readChar());
            } else if (declaredClass == Byte.TYPE) {
                Byte by = in.readByte();
            } else if (declaredClass == Short.TYPE) {
                Short s = in.readShort();
            } else if (declaredClass == Integer.TYPE) {
                Integer n = in.readInt();
            } else if (declaredClass == Long.TYPE) {
                Long l = in.readLong();
            } else if (declaredClass == Float.TYPE) {
                Float f = Float.valueOf(in.readFloat());
            } else if (declaredClass == Double.TYPE) {
                Double d = in.readDouble();
            } else {
                if (declaredClass != Void.TYPE) throw new IllegalArgumentException("Not a primitive: " + declaredClass);
                Object var4_12 = null;
            }
        } else if (declaredClass.isArray()) {
            if (declaredClass.equals(byte[].class)) {
                byte[] byArray = Bytes.readByteArray(in);
            } else if (declaredClass.equals(Result[].class)) {
                Result[] resultArray = Result.readArray(in);
            } else {
                int length = in.readInt();
                Object object = Array.newInstance(declaredClass.getComponentType(), length);
                for (int i = 0; i < length; ++i) {
                    Array.set(object, i, HbaseObjectWritable.readObject(in, conf));
                }
            }
        } else if (List.class.isAssignableFrom(declaredClass)) {
            int length = in.readInt();
            ArrayList<Object> arrayList = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                arrayList.add(HbaseObjectWritable.readObject(in, conf));
            }
        } else if (declaredClass == String.class) {
            String string = Text.readString((DataInput)in);
        } else if (declaredClass.isEnum()) {
            Object obj = Enum.valueOf(declaredClass, Text.readString((DataInput)in));
        } else {
            Class instanceClass = null;
            Byte b = in.readByte();
            if (b == 0) {
                String className = Text.readString((DataInput)in);
                try {
                    instanceClass = HbaseObjectWritable.getClassByName(conf, className);
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)("Can't find class " + className), (Throwable)e);
                    throw new IOException("Can't find class " + className, e);
                }
            } else {
                instanceClass = CODE_TO_CLASS.get(b);
            }
            if (Writable.class.isAssignableFrom(instanceClass)) {
                Writable writable = WritableFactories.newInstance((Class)instanceClass, (Configuration)conf);
                try {
                    writable.readFields(in);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error in readFields", (Throwable)e);
                    throw new IOException("Error in readFields", e);
                }
                Writable writable2 = writable;
                if (instanceClass == NullInstance.class) {
                    declaredClass = ((NullInstance)writable2).declaredClass;
                    Object var4_20 = null;
                }
            } else {
                int length = in.readInt();
                byte[] objectBytes = new byte[length];
                in.readFully(objectBytes);
                ByteArrayInputStream bis = null;
                ObjectInputStream ois = null;
                try {
                    bis = new ByteArrayInputStream(objectBytes);
                    ois = new ObjectInputStream(bis);
                    Object object = ois.readObject();
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)"Class not found when attempting to deserialize object", (Throwable)e);
                    throw new IOException("Class not found when attempting to deserialize object", e);
                }
                finally {
                    if (bis != null) {
                        bis.close();
                    }
                    if (ois != null) {
                        ois.close();
                    }
                }
            }
        }
        if (objectWritable == null) return var4_23;
        objectWritable.declaredClass = declaredClass;
        objectWritable.instance = var4_23;
        return var4_23;
    }

    private static Class getClassByName(Configuration conf, String className) throws ClassNotFoundException {
        if (conf != null) {
            return conf.getClassByName(className);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = HbaseObjectWritable.class.getClassLoader();
        }
        return Class.forName(className, true, cl);
    }

    private static void addToMap(Class<?> clazz, byte code) {
        CLASS_TO_CODE.put(clazz, code);
        CODE_TO_CLASS.put(code, clazz);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    static {
        byte code;
        LOG = LogFactory.getLog(HbaseObjectWritable.class);
        CODE_TO_CLASS = new HashMap();
        CLASS_TO_CODE = new HashMap();
        byte by = code = 1;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Boolean.TYPE, by);
        byte by2 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Byte.TYPE, by2);
        byte by3 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Character.TYPE, by3);
        byte by4 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Short.TYPE, by4);
        byte by5 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Integer.TYPE, by5);
        byte by6 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Long.TYPE, by6);
        byte by7 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Float.TYPE, by7);
        byte by8 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Double.TYPE, by8);
        byte by9 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Void.TYPE, by9);
        byte by10 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(String.class, by10);
        byte by11 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(byte[].class, by11);
        byte by12 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(byte[][].class, by12);
        byte by13 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Text.class, by13);
        byte by14 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Writable.class, by14);
        byte by15 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Writable[].class, by15);
        byte by16 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HbaseMapWritable.class, by16);
        byte by17 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(NullInstance.class, by17);
        byte by18 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HColumnDescriptor.class, by18);
        byte by19 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HConstants.Modify.class, by19);
        byte by20 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HMsg.class, by20);
        byte by21 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HMsg[].class, by21);
        byte by22 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HRegion.class, by22);
        byte by23 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HRegion[].class, by23);
        byte by24 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HRegionInfo.class, by24);
        byte by25 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HRegionInfo[].class, by25);
        byte by26 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HServerAddress.class, by26);
        byte by27 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HServerInfo.class, by27);
        byte by28 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HTableDescriptor.class, by28);
        byte by29 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(MapWritable.class, by29);
        byte by30 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(ClusterStatus.class, by30);
        byte by31 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Delete.class, by31);
        byte by32 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Get.class, by32);
        byte by33 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(KeyValue.class, by33);
        byte by34 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(KeyValue[].class, by34);
        byte by35 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Put.class, by35);
        byte by36 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Put[].class, by36);
        byte by37 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Result.class, by37);
        byte by38 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Result[].class, by38);
        byte by39 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Scan.class, by39);
        byte by40 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(WhileMatchFilter.class, by40);
        byte by41 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(PrefixFilter.class, by41);
        byte by42 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(PageFilter.class, by42);
        byte by43 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(InclusiveStopFilter.class, by43);
        byte by44 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(ColumnCountGetFilter.class, by44);
        byte by45 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(SingleColumnValueFilter.class, by45);
        byte by46 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(SingleColumnValueExcludeFilter.class, by46);
        byte by47 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(BinaryComparator.class, by47);
        byte by48 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(CompareFilter.class, by48);
        byte by49 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(RowFilter.class, by49);
        byte by50 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(ValueFilter.class, by50);
        byte by51 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(QualifierFilter.class, by51);
        byte by52 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(SkipFilter.class, by52);
        byte by53 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(WritableByteArrayComparable.class, by53);
        byte by54 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(FirstKeyOnlyFilter.class, by54);
        byte by55 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(DependentColumnFilter.class, by55);
        byte by56 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Delete[].class, by56);
        byte by57 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(MultiPut.class, by57);
        byte by58 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(MultiPutResponse.class, by58);
        byte by59 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HLog.Entry.class, by59);
        byte by60 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HLog.Entry[].class, by60);
        byte by61 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HLogKey.class, by61);
        byte by62 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(List.class, by62);
        byte by63 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(NavigableSet.class, by63);
        byte by64 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(ColumnPrefixFilter.class, by64);
        byte by65 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Row.class, by65);
        byte by66 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Action.class, by66);
        byte by67 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(MultiAction.class, by67);
        byte by68 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(MultiResponse.class, by68);
        byte by69 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Increment.class, by69);
        byte by70 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(KeyOnlyFilter.class, by70);
        byte by71 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Serializable.class, by71);
    }

    private static class NullInstance
    extends Configured
    implements Writable {
        Class<?> declaredClass;

        public NullInstance() {
            super(null);
        }

        public NullInstance(Class<?> declaredClass, Configuration conf) {
            super(conf);
            this.declaredClass = declaredClass;
        }

        public void readFields(DataInput in) throws IOException {
            this.declaredClass = CODE_TO_CLASS.get(in.readByte());
        }

        public void write(DataOutput out) throws IOException {
            HbaseObjectWritable.writeClassCode(out, this.declaredClass);
        }
    }
}

