/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class RowCounter {
    static final String NAME = "rowcounter";

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        Job job = new Job(conf, "rowcounter_" + tableName);
        job.setJarByClass(RowCounter.class);
        StringBuilder sb = new StringBuilder();
        boolean columnoffset = true;
        for (int i = 1; i < args.length; ++i) {
            if (i > 1) {
                sb.append(" ");
            }
            sb.append(args[i]);
        }
        Scan scan = new Scan();
        scan.setFilter(new FirstKeyOnlyFilter());
        if (sb.length() > 0) {
            for (String columnName : sb.toString().split(" ")) {
                String[] fields = columnName.split(":");
                if (fields.length == 1) {
                    scan.addFamily(Bytes.toBytes(fields[0]));
                    continue;
                }
                scan.addColumn(Bytes.toBytes(fields[0]), Bytes.toBytes(fields[1]));
            }
        }
        job.setOutputFormatClass(NullOutputFormat.class);
        TableMapReduceUtil.initTableMapperJob(tableName, scan, RowCounterMapper.class, ImmutableBytesWritable.class, Result.class, job);
        job.setNumReduceTasks(0);
        return job;
    }

    public static void main(String[] args) throws Exception {
        Job job;
        Configuration conf = HBaseConfiguration.create();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 1) {
            System.err.println("ERROR: Wrong number of parameters: " + args.length);
            System.err.println("Usage: RowCounter <tablename> [<column1> <column2>...]");
            System.exit(-1);
        }
        System.exit((job = RowCounter.createSubmittableJob(conf, otherArgs)).waitForCompletion(true) ? 0 : 1);
    }

    static class RowCounterMapper
    extends TableMapper<ImmutableBytesWritable, Result> {
        RowCounterMapper() {
        }

        public void map(ImmutableBytesWritable row, Result values, Mapper.Context context) throws IOException {
            context.getCounter((Enum)Counters.ROWS).increment(1L);
        }

        public static enum Counters {
            ROWS;

        }
    }
}

