/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.handler.TotesHRegionInfo;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.zookeeper.KeeperException;

public class OpenedRegionHandler
extends EventHandler
implements TotesHRegionInfo {
    private static final Log LOG = LogFactory.getLog(OpenedRegionHandler.class);
    private final AssignmentManager assignmentManager;
    private final HRegionInfo regionInfo;
    private final HServerInfo serverInfo;
    private final OpenedPriority priority;
    private final int expectedVersion;

    public OpenedRegionHandler(Server server, AssignmentManager assignmentManager, HRegionInfo regionInfo, HServerInfo serverInfo, int expectedVersion) {
        super(server, EventHandler.EventType.RS_ZK_REGION_OPENED);
        this.assignmentManager = assignmentManager;
        this.regionInfo = regionInfo;
        this.serverInfo = serverInfo;
        this.expectedVersion = expectedVersion;
        this.priority = regionInfo.isRootRegion() ? OpenedPriority.ROOT : (regionInfo.isMetaRegion() ? OpenedPriority.META : OpenedPriority.USER);
    }

    @Override
    public int getPriority() {
        return this.priority.getValue();
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        return this.regionInfo;
    }

    @Override
    public void process() {
        AssignmentManager.RegionState regionState = this.assignmentManager.isRegionInTransition(this.regionInfo);
        if (regionState != null && regionState.getState().equals((Object)AssignmentManager.RegionState.State.OPEN)) {
            if (this.deleteOpenedNode(this.expectedVersion)) {
                this.assignmentManager.regionOnline(this.regionInfo, this.serverInfo);
                this.debugLog(this.regionInfo, "The master has opened the region " + this.regionInfo.getRegionNameAsString() + " that was online on " + this.serverInfo.toString());
            } else {
                LOG.error((Object)("The znode of region " + this.regionInfo.getRegionNameAsString() + " could not be deleted."));
            }
        } else {
            LOG.warn((Object)("Skipping the onlining of " + this.regionInfo.getRegionNameAsString() + " because regions is NOT in RIT -- presuming this is because it SPLIT"));
        }
        if (this.assignmentManager.getZKTable().isDisablingOrDisabledTable(this.regionInfo.getTableDesc().getNameAsString())) {
            this.debugLog(this.regionInfo, "Opened region " + this.regionInfo.getRegionNameAsString() + " but " + "this table is disabled, triggering close of region");
            this.assignmentManager.unassign(this.regionInfo);
        }
    }

    private boolean deleteOpenedNode(int expectedVersion) {
        this.debugLog(this.regionInfo, "Handling OPENED event for " + this.regionInfo.getRegionNameAsString() + " from " + this.serverInfo.toString() + "; deleting unassigned node");
        try {
            return ZKAssign.deleteNode(this.server.getZooKeeper(), this.regionInfo.getEncodedName(), EventHandler.EventType.RS_ZK_REGION_OPENED, expectedVersion);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.warn((Object)("The znode of the region " + this.regionInfo.getRegionNameAsString() + " would have already been deleted"));
            return false;
        }
        catch (KeeperException e) {
            this.server.abort("Error deleting OPENED node in ZK (" + this.regionInfo.getRegionNameAsString() + ")", e);
            return false;
        }
    }

    private void debugLog(HRegionInfo region, String string) {
        if (region.isMetaTable() || region.isRootRegion()) {
            LOG.info((Object)string);
        } else {
            LOG.debug((Object)string);
        }
    }

    private static enum OpenedPriority {
        ROOT(1),
        META(2),
        USER(3);

        private final int value;

        private OpenedPriority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

