/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.NavigableSet;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.ColumnCount;
import org.apache.hadoop.hbase.regionserver.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.ExplicitColumnTracker;
import org.apache.hadoop.hbase.regionserver.ScanDeleteTracker;
import org.apache.hadoop.hbase.regionserver.ScanWildcardColumnTracker;
import org.apache.hadoop.hbase.util.Bytes;

public class ScanQueryMatcher {
    private boolean stickyNextRow;
    private byte[] stopRow;
    protected TimeRange tr;
    protected Filter filter;
    protected DeleteTracker deletes;
    protected boolean retainDeletesInOutput;
    protected ColumnTracker columns;
    protected KeyValue startKey;
    protected long oldestStamp;
    KeyValue.KeyComparator rowComparator;
    protected byte[] row;

    public ScanQueryMatcher(Scan scan, byte[] family, NavigableSet<byte[]> columns, long ttl, KeyValue.KeyComparator rowComparator, int maxVersions, boolean retainDeletesInOutput) {
        this.tr = scan.getTimeRange();
        this.oldestStamp = System.currentTimeMillis() - ttl;
        this.rowComparator = rowComparator;
        this.deletes = new ScanDeleteTracker();
        this.stopRow = scan.getStopRow();
        this.startKey = KeyValue.createFirstOnRow(scan.getStartRow());
        this.filter = scan.getFilter();
        this.retainDeletesInOutput = retainDeletesInOutput;
        this.columns = columns == null || columns.size() == 0 ? new ScanWildcardColumnTracker(maxVersions) : new ExplicitColumnTracker(columns, maxVersions);
    }

    public ScanQueryMatcher(Scan scan, byte[] family, NavigableSet<byte[]> columns, long ttl, KeyValue.KeyComparator rowComparator, int maxVersions) {
        this(scan, family, columns, ttl, rowComparator, maxVersions, false);
    }

    public MatchCode match(KeyValue kv) {
        MatchCode colChecker;
        short rowLength;
        int ret;
        int offset;
        if (this.filter != null && this.filter.filterAllRemaining()) {
            return MatchCode.DONE_SCAN;
        }
        byte[] bytes = kv.getBuffer();
        int initialOffset = offset = kv.getOffset();
        int keyLength = Bytes.toInt(bytes, offset, 4);
        offset += 8;
        if ((ret = this.rowComparator.compareRows(this.row, 0, this.row.length, bytes, offset += 2, rowLength = Bytes.toShort(bytes, offset, 2))) <= -1) {
            return MatchCode.DONE;
        }
        if (ret >= 1) {
            return MatchCode.SEEK_NEXT_ROW;
        }
        if (this.stickyNextRow) {
            return MatchCode.SEEK_NEXT_ROW;
        }
        if (this.columns.done()) {
            this.stickyNextRow = true;
            return MatchCode.SEEK_NEXT_ROW;
        }
        byte familyLength = bytes[offset += rowLength];
        int qualLength = keyLength + 8 - ((offset += familyLength + 1) - initialOffset) - 9;
        long timestamp = kv.getTimestamp();
        if (this.isExpired(timestamp)) {
            return this.getNextRowOrNextColumn(bytes, offset, qualLength);
        }
        byte type = kv.getType();
        if (this.isDelete(type)) {
            if (this.tr.withinOrAfterTimeRange(timestamp)) {
                this.deletes.add(bytes, offset, qualLength, timestamp, type);
            }
            if (this.retainDeletesInOutput) {
                return MatchCode.INCLUDE;
            }
            return MatchCode.SKIP;
        }
        if (!this.deletes.isEmpty() && this.deletes.isDeleted(bytes, offset, qualLength, timestamp)) {
            return MatchCode.SKIP;
        }
        int timestampComparison = this.tr.compare(timestamp);
        if (timestampComparison >= 1) {
            return MatchCode.SKIP;
        }
        if (timestampComparison <= -1) {
            return this.getNextRowOrNextColumn(bytes, offset, qualLength);
        }
        if (this.filter != null) {
            Filter.ReturnCode filterResponse = this.filter.filterKeyValue(kv);
            if (filterResponse == Filter.ReturnCode.SKIP) {
                return MatchCode.SKIP;
            }
            if (filterResponse == Filter.ReturnCode.NEXT_COL) {
                return this.getNextRowOrNextColumn(bytes, offset, qualLength);
            }
            if (filterResponse == Filter.ReturnCode.NEXT_ROW) {
                this.stickyNextRow = true;
                return MatchCode.SEEK_NEXT_ROW;
            }
            if (filterResponse == Filter.ReturnCode.SEEK_NEXT_USING_HINT) {
                return MatchCode.SEEK_NEXT_USING_HINT;
            }
        }
        if ((colChecker = this.columns.checkColumn(bytes, offset, qualLength, timestamp)) == MatchCode.SEEK_NEXT_ROW) {
            this.stickyNextRow = true;
        }
        return colChecker;
    }

    public MatchCode getNextRowOrNextColumn(byte[] bytes, int offset, int qualLength) {
        if (this.columns instanceof ExplicitColumnTracker) {
            ((ExplicitColumnTracker)this.columns).doneWithColumn(bytes, offset, qualLength);
            if (this.columns.getColumnHint() == null) {
                return MatchCode.SEEK_NEXT_ROW;
            }
            return MatchCode.SEEK_NEXT_COL;
        }
        return MatchCode.SEEK_NEXT_COL;
    }

    public boolean moreRowsMayExistAfter(KeyValue kv) {
        return Bytes.equals(this.stopRow, HConstants.EMPTY_END_ROW) || this.rowComparator.compareRows(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), this.stopRow, 0, this.stopRow.length) < 0;
    }

    public void setRow(byte[] row) {
        this.row = row;
        this.reset();
    }

    public void reset() {
        this.deletes.reset();
        this.columns.reset();
        this.stickyNextRow = false;
    }

    protected boolean isDelete(byte type) {
        return type != KeyValue.Type.Put.getCode();
    }

    protected boolean isExpired(long timestamp) {
        return timestamp < this.oldestStamp;
    }

    public KeyValue getStartKey() {
        return this.startKey;
    }

    public KeyValue getNextKeyHint(KeyValue kv) {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getNextKeyHint(kv);
    }

    public KeyValue getKeyForNextColumn(KeyValue kv) {
        ColumnCount nextColumn = this.columns.getColumnHint();
        if (nextColumn == null) {
            return KeyValue.createLastOnRow(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength(), kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength());
        }
        return KeyValue.createFirstOnRow(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength(), nextColumn.getBuffer(), nextColumn.getOffset(), nextColumn.getLength());
    }

    public KeyValue getKeyForNextRow(KeyValue kv) {
        return KeyValue.createLastOnRow(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), null, 0, 0, null, 0, 0);
    }

    public static enum MatchCode {
        INCLUDE,
        SKIP,
        NEXT,
        DONE,
        SEEK_NEXT_ROW,
        SEEK_NEXT_COL,
        DONE_SCAN,
        SEEK_NEXT_USING_HINT;

    }
}

