/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class TimeRangeTracker
implements Writable {
    long minimumTimestamp = -1L;
    long maximumTimestamp = -1L;

    public TimeRangeTracker() {
    }

    public TimeRangeTracker(TimeRangeTracker trt) {
        this.minimumTimestamp = trt.getMinimumTimestamp();
        this.maximumTimestamp = trt.getMaximumTimestamp();
    }

    public TimeRangeTracker(long minimumTimestamp, long maximumTimestamp) {
        this.minimumTimestamp = minimumTimestamp;
        this.maximumTimestamp = maximumTimestamp;
    }

    public void includeTimestamp(KeyValue kv) {
        this.includeTimestamp(kv.getTimestamp());
        if (kv.isDeleteColumnOrFamily()) {
            this.includeTimestamp(0L);
        }
    }

    public void includeTimestamp(byte[] key) {
        this.includeTimestamp(Bytes.toLong(key, key.length - 9));
        byte type = key[key.length - 1];
        if (type == KeyValue.Type.DeleteColumn.getCode() || type == KeyValue.Type.DeleteFamily.getCode()) {
            this.includeTimestamp(0L);
        }
    }

    private void includeTimestamp(long timestamp) {
        if (this.maximumTimestamp == -1L) {
            this.minimumTimestamp = timestamp;
            this.maximumTimestamp = timestamp;
        } else if (this.minimumTimestamp > timestamp) {
            this.minimumTimestamp = timestamp;
        } else if (this.maximumTimestamp < timestamp) {
            this.maximumTimestamp = timestamp;
        }
    }

    public boolean includesTimeRange(TimeRange tr) {
        return this.minimumTimestamp < tr.getMax() && this.maximumTimestamp >= tr.getMin();
    }

    public long getMinimumTimestamp() {
        return this.minimumTimestamp;
    }

    public long getMaximumTimestamp() {
        return this.maximumTimestamp;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.minimumTimestamp);
        out.writeLong(this.maximumTimestamp);
    }

    public void readFields(DataInput in) throws IOException {
        this.minimumTimestamp = in.readLong();
        this.maximumTimestamp = in.readLong();
    }
}

