/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;

public class SequenceFileLogWriter
implements HLog.Writer {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private SequenceFile.Writer writer;
    private FSDataOutputStream writer_out;
    private Method syncFs;
    private Method hflush;
    private Class<? extends HLogKey> keyClass;

    public SequenceFileLogWriter() {
    }

    public SequenceFileLogWriter(Class<? extends HLogKey> keyClass) {
        this.keyClass = keyClass;
    }

    @Override
    public void init(FileSystem fs, Path path, Configuration conf) throws IOException {
        if (null == this.keyClass) {
            this.keyClass = HLog.getKeyClass(conf);
        }
        try {
            this.writer = (SequenceFile.Writer)SequenceFile.class.getMethod("createWriter", FileSystem.class, Configuration.class, Path.class, Class.class, Class.class, Integer.TYPE, Short.TYPE, Long.TYPE, Boolean.TYPE, SequenceFile.CompressionType.class, CompressionCodec.class, SequenceFile.Metadata.class).invoke(null, fs, conf, path, HLog.getKeyClass(conf), WALEdit.class, new Integer(fs.getConf().getInt("io.file.buffer.size", 4096)), new Short((short)conf.getInt("hbase.regionserver.hlog.replication", (int)fs.getDefaultReplication())), new Long(conf.getLong("hbase.regionserver.hlog.blocksize", fs.getDefaultBlockSize())), new Boolean(false), SequenceFile.CompressionType.NONE, new DefaultCodec(), new SequenceFile.Metadata());
        }
        catch (InvocationTargetException ite) {
            throw new IOException(ite.getCause());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.writer == null) {
            this.LOG.debug((Object)"new createWriter -- HADOOP-6840 -- not available");
            this.writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path, HLog.getKeyClass(conf), WALEdit.class, (int)fs.getConf().getInt("io.file.buffer.size", 4096), (short)((short)conf.getInt("hbase.regionserver.hlog.replication", (int)fs.getDefaultReplication())), (long)conf.getLong("hbase.regionserver.hlog.blocksize", fs.getDefaultBlockSize()), (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE, (CompressionCodec)new DefaultCodec(), null, (SequenceFile.Metadata)new SequenceFile.Metadata());
        } else {
            this.LOG.debug((Object)"using new createWriter -- HADOOP-6840");
        }
        this.writer_out = this.getSequenceFilePrivateFSDataOutputStreamAccessible();
        this.syncFs = this.getSyncFs();
        this.hflush = this.getHFlush();
        String msg = "Path=" + path + ", syncFs=" + (this.syncFs != null) + ", hflush=" + (this.hflush != null);
        if (this.syncFs != null || this.hflush != null) {
            this.LOG.debug((Object)msg);
        } else {
            this.LOG.warn((Object)("No sync support! " + msg));
        }
    }

    private Method getSyncFs() throws IOException {
        Method m = null;
        try {
            m = this.writer.getClass().getMethod("syncFs", new Class[0]);
        }
        catch (SecurityException e) {
            throw new IOException("Failed test for syncfs", e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return m;
    }

    private Method getHFlush() throws IOException {
        Method m = null;
        try {
            Class<?> c = this.getWriterFSDataOutputStream().getClass();
            m = c.getMethod("hflush", new Class[0]);
        }
        catch (SecurityException e) {
            throw new IOException("Failed test for hflush", e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return m;
    }

    private FSDataOutputStream getSequenceFilePrivateFSDataOutputStreamAccessible() throws IOException {
        FSDataOutputStream out = null;
        Field[] fields = this.writer.getClass().getDeclaredFields();
        String fieldName = "out";
        for (int i = 0; i < fields.length; ++i) {
            if (!"out".equals(fields[i].getName())) continue;
            try {
                fields[i].setAccessible(true);
                out = (FSDataOutputStream)fields[i].get(this.writer);
                break;
            }
            catch (IllegalAccessException ex) {
                throw new IOException("Accessing out", ex);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        return out;
    }

    @Override
    public void append(HLog.Entry entry) throws IOException {
        this.writer.append((Writable)entry.getKey(), (Writable)entry.getEdit());
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void sync() throws IOException {
        if (this.syncFs != null) {
            try {
                this.syncFs.invoke((Object)this.writer, HLog.NO_ARGS);
            }
            catch (Exception e) {
                throw new IOException("Reflection", e);
            }
        }
    }

    @Override
    public long getLength() throws IOException {
        return this.writer.getLength();
    }

    public FSDataOutputStream getWriterFSDataOutputStream() {
        return this.writer_out;
    }
}

