/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.ResultGenerator;
import org.apache.hadoop.hbase.rest.RowSpec;
import org.apache.hadoop.hbase.rest.model.ScannerModel;
import org.apache.hadoop.util.StringUtils;

public class ScannerResultGenerator
extends ResultGenerator {
    private static final Log LOG = LogFactory.getLog(ScannerResultGenerator.class);
    private String id;
    private Iterator<KeyValue> rowI;
    private KeyValue cache;
    private ResultScanner scanner;
    private Result cached;

    public static Filter buildFilterFromModel(ScannerModel model) throws Exception {
        String filter = model.getFilter();
        if (filter == null || filter.length() == 0) {
            return null;
        }
        return ScannerResultGenerator.buildFilter(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScannerResultGenerator(String tableName, RowSpec rowspec, Filter filter) throws IllegalArgumentException, IOException {
        HTablePool pool = RESTServlet.getInstance().getTablePool();
        HTableInterface table = pool.getTable(tableName);
        try {
            Scan scan = rowspec.hasEndRow() ? new Scan(rowspec.getStartRow(), rowspec.getEndRow()) : new Scan(rowspec.getStartRow());
            if (rowspec.hasColumns()) {
                byte[][] columns;
                for (byte[] column : columns = rowspec.getColumns()) {
                    byte[][] split = KeyValue.parseColumn(column);
                    if (split.length > 1 && split[1] != null && split[1].length != 0) {
                        scan.addColumn(split[0], split[1]);
                        continue;
                    }
                    scan.addFamily(split[0]);
                }
            } else {
                for (HColumnDescriptor family : table.getTableDescriptor().getFamilies()) {
                    scan.addFamily(family.getName());
                }
            }
            scan.setTimeRange(rowspec.getStartTime(), rowspec.getEndTime());
            scan.setMaxVersions(rowspec.getMaxVersions());
            if (filter != null) {
                scan.setFilter(filter);
            }
            scan.setCacheBlocks(false);
            this.scanner = table.getScanner(scan);
            this.cached = null;
            this.id = Long.toString(System.currentTimeMillis()) + Integer.toHexString(this.scanner.hashCode());
        }
        finally {
            pool.putTable(table);
        }
    }

    public String getID() {
        return this.id;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        if (this.cache != null) {
            return true;
        }
        if (this.rowI != null && this.rowI.hasNext()) {
            return true;
        }
        if (this.cached != null) {
            return true;
        }
        try {
            Result result = this.scanner.next();
            if (result != null && !result.isEmpty()) {
                this.cached = result;
            }
        }
        catch (UnknownScannerException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
        }
        return this.cached != null;
    }

    @Override
    public KeyValue next() {
        boolean loop;
        if (this.cache != null) {
            KeyValue kv = this.cache;
            this.cache = null;
            return kv;
        }
        do {
            loop = false;
            if (this.rowI != null) {
                if (this.rowI.hasNext()) {
                    return this.rowI.next();
                }
                this.rowI = null;
            }
            if (this.cached != null) {
                this.rowI = this.cached.list().iterator();
                loop = true;
                this.cached = null;
                continue;
            }
            Result result = null;
            try {
                result = this.scanner.next();
            }
            catch (UnknownScannerException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            }
            if (result == null || result.isEmpty()) continue;
            this.rowI = result.list().iterator();
            loop = true;
        } while (loop);
        return null;
    }

    @Override
    public void putBack(KeyValue kv) {
        this.cache = kv;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }
}

