/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import com.google.protobuf.ByteString;
import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.api.json.JSONMarshaller;
import com.sun.jersey.api.json.JSONUnmarshaller;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hadoop.hbase.rest.protobuf.generated.ScannerMessage;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;

@XmlRootElement(name="Scanner")
public class ScannerModel
implements ProtobufMessageHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] startRow = HConstants.EMPTY_START_ROW;
    private byte[] endRow = HConstants.EMPTY_END_ROW;
    private List<byte[]> columns = new ArrayList<byte[]>();
    private int batch = Integer.MAX_VALUE;
    private long startTime = 0L;
    private long endTime = Long.MAX_VALUE;
    private String filter = null;
    private int maxVersions = Integer.MAX_VALUE;
    private static final byte[] COLUMN_DIVIDER = Bytes.toBytes(":");

    public static Filter buildFilter(String s) throws Exception {
        JSONJAXBContext context = new JSONJAXBContext(JSONConfiguration.natural().build(), new Class[]{FilterModel.class});
        JSONUnmarshaller unmarshaller = context.createJSONUnmarshaller();
        FilterModel model = (FilterModel)unmarshaller.unmarshalFromJSON((Reader)new StringReader(s), FilterModel.class);
        return model.build();
    }

    public static String stringifyFilter(Filter filter) throws Exception {
        JSONJAXBContext context = new JSONJAXBContext(JSONConfiguration.natural().build(), new Class[]{FilterModel.class});
        JSONMarshaller marshaller = context.createJSONMarshaller();
        StringWriter writer = new StringWriter();
        marshaller.marshallToJSON((Object)new FilterModel(filter), (Writer)writer);
        return writer.toString();
    }

    public static ScannerModel fromScan(Scan scan) throws Exception {
        Filter filter;
        int maxVersions;
        ScannerModel model = new ScannerModel();
        model.setStartRow(scan.getStartRow());
        model.setEndRow(scan.getStopRow());
        Map<byte[], NavigableSet<byte[]>> families = scan.getFamilyMap();
        if (families != null) {
            for (Map.Entry<byte[], NavigableSet<byte[]>> entry : families.entrySet()) {
                if (entry.getValue() != null) {
                    for (byte[] qualifier : entry.getValue()) {
                        model.addColumn(Bytes.add(entry.getKey(), COLUMN_DIVIDER, qualifier));
                    }
                    continue;
                }
                model.addColumn(entry.getKey());
            }
        }
        model.setStartTime(scan.getTimeRange().getMin());
        model.setEndTime(scan.getTimeRange().getMax());
        int caching = scan.getCaching();
        if (caching > 0) {
            model.setBatch(caching);
        }
        if ((maxVersions = scan.getMaxVersions()) > 0) {
            model.setMaxVersions(maxVersions);
        }
        if ((filter = scan.getFilter()) != null) {
            model.setFilter(ScannerModel.stringifyFilter(filter));
        }
        return model;
    }

    public ScannerModel() {
    }

    public ScannerModel(byte[] startRow, byte[] endRow, List<byte[]> columns, int batch, long endTime, int maxVersions, String filter) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.columns = columns;
        this.batch = batch;
        this.endTime = endTime;
        this.maxVersions = maxVersions;
        this.filter = filter;
    }

    public ScannerModel(byte[] startRow, byte[] endRow, List<byte[]> columns, int batch, long startTime, long endTime, String filter) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.columns = columns;
        this.batch = batch;
        this.startTime = startTime;
        this.endTime = endTime;
        this.filter = filter;
    }

    public void addColumn(byte[] column) {
        this.columns.add(column);
    }

    public boolean hasStartRow() {
        return !Bytes.equals(this.startRow, HConstants.EMPTY_START_ROW);
    }

    @XmlAttribute
    public byte[] getStartRow() {
        return this.startRow;
    }

    public boolean hasEndRow() {
        return !Bytes.equals(this.endRow, HConstants.EMPTY_END_ROW);
    }

    @XmlAttribute
    public byte[] getEndRow() {
        return this.endRow;
    }

    @XmlElement(name="column")
    public List<byte[]> getColumns() {
        return this.columns;
    }

    @XmlAttribute
    public int getBatch() {
        return this.batch;
    }

    @XmlAttribute
    public long getStartTime() {
        return this.startTime;
    }

    @XmlAttribute
    public long getEndTime() {
        return this.endTime;
    }

    @XmlAttribute
    public int getMaxVersions() {
        return this.maxVersions;
    }

    @XmlElement
    public String getFilter() {
        return this.filter;
    }

    public void setStartRow(byte[] startRow) {
        this.startRow = startRow;
    }

    public void setEndRow(byte[] endRow) {
        this.endRow = endRow;
    }

    public void setColumns(List<byte[]> columns) {
        this.columns = columns;
    }

    public void setBatch(int batch) {
        this.batch = batch;
    }

    public void setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public byte[] createProtobufOutput() {
        ScannerMessage.Scanner.Builder builder = ScannerMessage.Scanner.newBuilder();
        if (!Bytes.equals(this.startRow, HConstants.EMPTY_START_ROW)) {
            builder.setStartRow(ByteString.copyFrom((byte[])this.startRow));
        }
        if (!Bytes.equals(this.endRow, HConstants.EMPTY_START_ROW)) {
            builder.setEndRow(ByteString.copyFrom((byte[])this.endRow));
        }
        for (byte[] column : this.columns) {
            builder.addColumns(ByteString.copyFrom((byte[])column));
        }
        builder.setBatch(this.batch);
        if (this.startTime != 0L) {
            builder.setStartTime(this.startTime);
        }
        if (this.endTime != 0L) {
            builder.setEndTime(this.endTime);
        }
        builder.setBatch(this.getBatch());
        builder.setMaxVersions(this.maxVersions);
        if (this.filter != null) {
            builder.setFilter(this.filter);
        }
        return builder.build().toByteArray();
    }

    @Override
    public ProtobufMessageHandler getObjectFromMessage(byte[] message) throws IOException {
        ScannerMessage.Scanner.Builder builder = ScannerMessage.Scanner.newBuilder();
        builder.mergeFrom(message);
        if (builder.hasStartRow()) {
            this.startRow = builder.getStartRow().toByteArray();
        }
        if (builder.hasEndRow()) {
            this.endRow = builder.getEndRow().toByteArray();
        }
        for (ByteString column : builder.getColumnsList()) {
            this.addColumn(column.toByteArray());
        }
        if (builder.hasBatch()) {
            this.batch = builder.getBatch();
        }
        if (builder.hasStartTime()) {
            this.startTime = builder.getStartTime();
        }
        if (builder.hasEndTime()) {
            this.endTime = builder.getEndTime();
        }
        if (builder.hasMaxVersions()) {
            this.maxVersions = builder.getMaxVersions();
        }
        if (builder.hasFilter()) {
            this.filter = builder.getFilter();
        }
        return this;
    }

    @XmlRootElement
    static class FilterModel {
        @XmlAttribute
        public String type;
        @XmlAttribute
        public String op;
        @XmlElement
        WritableByteArrayComparableModel comparator;
        @XmlAttribute
        public String value;
        @XmlElement
        public List<FilterModel> filters;
        @XmlAttribute
        public Integer limit;
        @XmlAttribute
        public Integer offset;
        @XmlAttribute
        public String family;
        @XmlAttribute
        public String qualifier;
        @XmlAttribute
        public Boolean ifMissing;
        @XmlAttribute
        public Boolean latestVersion;
        @XmlAttribute
        public Boolean dropDependentColumn;
        @XmlElement
        public List<String> prefixes;
        @XmlElement
        public List<Long> timestamps;

        public FilterModel() {
        }

        public FilterModel(Filter filter) {
            String typeName = filter.getClass().getSimpleName();
            FilterType type = FilterType.valueOf(typeName);
            this.type = typeName;
            switch (type) {
                case ColumnCountGetFilter: {
                    this.limit = ((ColumnCountGetFilter)filter).getLimit();
                    break;
                }
                case ColumnPaginationFilter: {
                    this.limit = ((ColumnPaginationFilter)filter).getLimit();
                    this.offset = ((ColumnPaginationFilter)filter).getOffset();
                    break;
                }
                case ColumnPrefixFilter: {
                    this.value = Base64.encodeBytes(((ColumnPrefixFilter)filter).getPrefix());
                    break;
                }
                case DependentColumnFilter: {
                    DependentColumnFilter dcf = (DependentColumnFilter)filter;
                    this.family = Base64.encodeBytes(dcf.getFamily());
                    byte[] qualifier = dcf.getQualifier();
                    if (qualifier != null) {
                        this.qualifier = Base64.encodeBytes(qualifier);
                    }
                    this.op = dcf.getOperator().toString();
                    this.comparator = new WritableByteArrayComparableModel(dcf.getComparator());
                    this.dropDependentColumn = dcf.dropDependentColumn();
                    break;
                }
                case FilterList: {
                    this.op = ((FilterList)filter).getOperator().toString();
                    this.filters = new ArrayList<FilterModel>();
                    for (Filter child : ((FilterList)filter).getFilters()) {
                        this.filters.add(new FilterModel(child));
                    }
                    break;
                }
                case FirstKeyOnlyFilter: 
                case KeyOnlyFilter: {
                    break;
                }
                case InclusiveStopFilter: {
                    this.value = Base64.encodeBytes(((InclusiveStopFilter)filter).getStopRowKey());
                    break;
                }
                case PageFilter: {
                    this.value = Long.toString(((PageFilter)filter).getPageSize());
                    break;
                }
                case PrefixFilter: {
                    this.value = Base64.encodeBytes(((PrefixFilter)filter).getPrefix());
                    break;
                }
                case FamilyFilter: 
                case QualifierFilter: 
                case RowFilter: 
                case ValueFilter: {
                    this.op = ((CompareFilter)filter).getOperator().toString();
                    this.comparator = new WritableByteArrayComparableModel(((CompareFilter)filter).getComparator());
                    break;
                }
                case SingleColumnValueExcludeFilter: 
                case SingleColumnValueFilter: {
                    SingleColumnValueFilter scvf = (SingleColumnValueFilter)filter;
                    this.family = Base64.encodeBytes(scvf.getFamily());
                    byte[] qualifier = scvf.getQualifier();
                    if (qualifier != null) {
                        this.qualifier = Base64.encodeBytes(qualifier);
                    }
                    this.op = scvf.getOperator().toString();
                    this.comparator = new WritableByteArrayComparableModel(scvf.getComparator());
                    if (scvf.getFilterIfMissing()) {
                        this.ifMissing = true;
                    }
                    if (!scvf.getLatestVersionOnly()) break;
                    this.latestVersion = true;
                    break;
                }
                case SkipFilter: {
                    this.filters = new ArrayList<FilterModel>();
                    this.filters.add(new FilterModel(((SkipFilter)filter).getFilter()));
                    break;
                }
                case TimestampsFilter: {
                    this.timestamps = ((TimestampsFilter)filter).getTimestamps();
                    break;
                }
                case WhileMatchFilter: {
                    this.filters = new ArrayList<FilterModel>();
                    this.filters.add(new FilterModel(((WhileMatchFilter)filter).getFilter()));
                    break;
                }
                default: {
                    throw new RuntimeException("unhandled filter type " + (Object)((Object)type));
                }
            }
        }

        public Filter build() {
            Filter filter;
            switch (FilterType.valueOf(this.type)) {
                case ColumnCountGetFilter: {
                    filter = new ColumnCountGetFilter(this.limit);
                    break;
                }
                case ColumnPaginationFilter: {
                    filter = new ColumnPaginationFilter(this.limit, this.offset);
                    break;
                }
                case ColumnPrefixFilter: {
                    filter = new ColumnPrefixFilter(Base64.decode(this.value));
                    break;
                }
                case DependentColumnFilter: {
                    filter = new DependentColumnFilter(Base64.decode(this.family), this.qualifier != null ? Base64.decode(this.qualifier) : null, this.dropDependentColumn, CompareFilter.CompareOp.valueOf(this.op), this.comparator.build());
                    break;
                }
                case FamilyFilter: {
                    filter = new FamilyFilter(CompareFilter.CompareOp.valueOf(this.op), this.comparator.build());
                    break;
                }
                case FilterList: {
                    ArrayList<Filter> list = new ArrayList<Filter>();
                    for (FilterModel model : this.filters) {
                        list.add(model.build());
                    }
                    filter = new FilterList(FilterList.Operator.valueOf(this.op), list);
                    break;
                }
                case FirstKeyOnlyFilter: {
                    filter = new FirstKeyOnlyFilter();
                    break;
                }
                case InclusiveStopFilter: {
                    filter = new InclusiveStopFilter(Base64.decode(this.value));
                    break;
                }
                case KeyOnlyFilter: {
                    filter = new KeyOnlyFilter();
                    break;
                }
                case PageFilter: {
                    filter = new PageFilter(Long.valueOf(this.value));
                    break;
                }
                case PrefixFilter: {
                    filter = new PrefixFilter(Base64.decode(this.value));
                    break;
                }
                case QualifierFilter: {
                    filter = new QualifierFilter(CompareFilter.CompareOp.valueOf(this.op), this.comparator.build());
                    break;
                }
                case RowFilter: {
                    filter = new RowFilter(CompareFilter.CompareOp.valueOf(this.op), this.comparator.build());
                    break;
                }
                case SingleColumnValueFilter: {
                    filter = new SingleColumnValueFilter(Base64.decode(this.family), this.qualifier != null ? Base64.decode(this.qualifier) : null, CompareFilter.CompareOp.valueOf(this.op), this.comparator.build());
                    if (this.ifMissing != null) {
                        ((SingleColumnValueFilter)filter).setFilterIfMissing(this.ifMissing);
                    }
                    if (this.latestVersion == null) break;
                    ((SingleColumnValueFilter)filter).setLatestVersionOnly(this.latestVersion);
                    break;
                }
                case SingleColumnValueExcludeFilter: {
                    filter = new SingleColumnValueExcludeFilter(Base64.decode(this.family), this.qualifier != null ? Base64.decode(this.qualifier) : null, CompareFilter.CompareOp.valueOf(this.op), this.comparator.build());
                    if (this.ifMissing != null) {
                        ((SingleColumnValueExcludeFilter)filter).setFilterIfMissing(this.ifMissing);
                    }
                    if (this.latestVersion == null) break;
                    ((SingleColumnValueExcludeFilter)filter).setLatestVersionOnly(this.latestVersion);
                    break;
                }
                case SkipFilter: {
                    filter = new SkipFilter(this.filters.get(0).build());
                    break;
                }
                case TimestampsFilter: {
                    filter = new TimestampsFilter(this.timestamps);
                    break;
                }
                case ValueFilter: {
                    filter = new ValueFilter(CompareFilter.CompareOp.valueOf(this.op), this.comparator.build());
                    break;
                }
                case WhileMatchFilter: {
                    filter = new WhileMatchFilter(this.filters.get(0).build());
                    break;
                }
                default: {
                    throw new RuntimeException("unhandled filter type: " + this.type);
                }
            }
            return filter;
        }

        static enum FilterType {
            ColumnCountGetFilter,
            ColumnPaginationFilter,
            ColumnPrefixFilter,
            DependentColumnFilter,
            FamilyFilter,
            FilterList,
            FirstKeyOnlyFilter,
            InclusiveStopFilter,
            KeyOnlyFilter,
            PageFilter,
            PrefixFilter,
            QualifierFilter,
            RowFilter,
            SingleColumnValueExcludeFilter,
            SingleColumnValueFilter,
            SkipFilter,
            TimestampsFilter,
            ValueFilter,
            WhileMatchFilter;

        }

        @XmlRootElement
        static class WritableByteArrayComparableModel {
            @XmlAttribute
            public String type;
            @XmlAttribute
            public String value;
            @XmlAttribute
            public String op;

            public WritableByteArrayComparableModel() {
            }

            public WritableByteArrayComparableModel(WritableByteArrayComparable comparator) {
                String typeName = comparator.getClass().getSimpleName();
                ComparatorType type = ComparatorType.valueOf(typeName);
                this.type = typeName;
                switch (type) {
                    case BinaryComparator: 
                    case BinaryPrefixComparator: {
                        this.value = Base64.encodeBytes(comparator.getValue());
                        break;
                    }
                    case RegexStringComparator: 
                    case SubstringComparator: {
                        this.value = Bytes.toString(comparator.getValue());
                        break;
                    }
                    default: {
                        throw new RuntimeException("unhandled filter type: " + (Object)((Object)type));
                    }
                }
            }

            public WritableByteArrayComparable build() {
                WritableByteArrayComparable comparator;
                switch (ComparatorType.valueOf(this.type)) {
                    case BinaryComparator: {
                        comparator = new BinaryComparator(Base64.decode(this.value));
                        break;
                    }
                    case BinaryPrefixComparator: {
                        comparator = new BinaryPrefixComparator(Base64.decode(this.value));
                        break;
                    }
                    case RegexStringComparator: {
                        comparator = new RegexStringComparator(this.value);
                        break;
                    }
                    case SubstringComparator: {
                        comparator = new SubstringComparator(this.value);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unhandled comparator type: " + this.type);
                    }
                }
                return comparator;
            }

            static enum ComparatorType {
                BinaryComparator,
                BinaryPrefixComparator,
                RegexStringComparator,
                SubstringComparator;

            }
        }
    }
}

