/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsckRepair;
import org.apache.hadoop.hbase.util.KeyRange;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.RegionSplitCalculator;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.util.hbck.TableIntegrityErrorHandler;
import org.apache.hadoop.hbase.util.hbck.TableIntegrityErrorHandlerImpl;
import org.apache.hadoop.hbase.zookeeper.ZKTable;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.apache.zookeeper.KeeperException;

public class HBaseFsck {
    public static final long DEFAULT_TIME_LAG = 60000L;
    public static final long DEFAULT_SLEEP_BEFORE_RERUN = 10000L;
    private static final int MAX_NUM_THREADS = 50;
    private static final long THREADS_KEEP_ALIVE_SECONDS = 60L;
    private static boolean rsSupportsOffline = true;
    private static final int DEFAULT_OVERLAPS_TO_SIDELINE = 2;
    private static final int DEFAULT_MAX_MERGE = 5;
    private static final Log LOG = LogFactory.getLog((String)HBaseFsck.class.getName());
    private Configuration conf;
    private ClusterStatus status;
    private HBaseAdmin admin;
    private HTable meta;
    private ThreadPoolExecutor executor;
    private long hbckStartMillis = System.currentTimeMillis();
    private static boolean details = false;
    private long timelag = 60000L;
    private boolean fixAssignments = false;
    private boolean fixMeta = false;
    private boolean fixHdfsHoles = false;
    private boolean fixHdfsOverlaps = false;
    private boolean fixHdfsOrphans = false;
    private boolean fixVersionFile = false;
    private List<byte[]> tablesToFix = new ArrayList<byte[]>();
    private int maxMerge = 5;
    private int maxOverlapsToSideline = 2;
    private boolean sidelineBigOverlaps = false;
    private boolean fixTableDesc = false;
    private boolean rerun = false;
    private static boolean summary = false;
    private boolean checkMetaOnly = false;
    private ErrorReporter errors = new PrintingErrorReporter();
    private boolean multiTableDescFound = false;
    int fixes = 0;
    private TreeMap<String, HbckInfo> regionInfoMap = new TreeMap();
    private TreeSet<byte[]> disabledTables = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
    private Set<Result> emptyRegionInfoQualifiers = new HashSet<Result>();
    private SortedMap<String, TableInfo> tablesInfo = new ConcurrentSkipListMap<String, TableInfo>();
    private List<HbckInfo> orphanHdfsDirs = Collections.synchronizedList(new ArrayList());
    static final Comparator<HbckInfo> cmp = new Comparator<HbckInfo>(){

        @Override
        public int compare(HbckInfo l, HbckInfo r) {
            if (l == r) {
                return 0;
            }
            int tableCompare = RegionSplitCalculator.BYTES_COMPARATOR.compare(l.getTableName(), r.getTableName());
            if (tableCompare != 0) {
                return tableCompare;
            }
            int startComparison = RegionSplitCalculator.BYTES_COMPARATOR.compare(l.getStartKey(), r.getStartKey());
            if (startComparison != 0) {
                return startComparison;
            }
            byte[] endKey = r.getEndKey();
            endKey = endKey.length == 0 ? null : endKey;
            byte[] endKey2 = l.getEndKey();
            int endComparison = RegionSplitCalculator.BYTES_COMPARATOR.compare(endKey2 = endKey2.length == 0 ? null : endKey2, endKey);
            if (endComparison != 0) {
                return endComparison;
            }
            if (l.hdfsEntry == null && r.hdfsEntry == null) {
                return 0;
            }
            if (l.hdfsEntry == null && r.hdfsEntry != null) {
                return 1;
            }
            if (r.hdfsEntry == null) {
                return -1;
            }
            return (int)(((HbckInfo)l).hdfsEntry.hri.getRegionId() - ((HbckInfo)r).hdfsEntry.hri.getRegionId());
        }
    };

    public HBaseFsck(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this.conf = conf;
        int numThreads = conf.getInt("hbasefsck.numthreads", 50);
        this.executor = new ThreadPoolExecutor(1, numThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public void connect() throws IOException {
        this.admin = new HBaseAdmin(this.conf);
        this.meta = new HTable(this.conf, HConstants.META_TABLE_NAME);
        this.status = this.admin.getMaster().getClusterStatus();
    }

    private void loadDeployedRegions() throws IOException, InterruptedException {
        Collection<HServerInfo> regionServers = this.status.getServerInfo();
        this.errors.print("Number of live region servers: " + regionServers.size());
        if (details) {
            for (HServerInfo rsinfo : regionServers) {
                this.errors.print("  " + rsinfo.getServerName());
            }
        }
        Collection<String> deadRegionServers = this.status.getDeadServerNames();
        this.errors.print("Number of dead region servers: " + deadRegionServers.size());
        if (details) {
            for (String name : deadRegionServers) {
                this.errors.print("  " + name);
            }
        }
        this.loadRegionDeployments(regionServers);
    }

    private void clearState() {
        this.fixes = 0;
        this.regionInfoMap.clear();
        this.emptyRegionInfoQualifiers.clear();
        this.disabledTables.clear();
        this.errors.clear();
        this.tablesInfo.clear();
        this.orphanHdfsDirs.clear();
        this.multiTableDescFound = false;
    }

    public void offlineHdfsIntegrityRepair() throws IOException, InterruptedException {
        if (this.shouldFixHdfsOrphans() || this.shouldFixHdfsHoles() || this.shouldFixHdfsOverlaps()) {
            LOG.info((Object)"Loading HDFS regioninfos");
            int maxIterations = this.conf.getInt("hbase.hbck.integrityrepair.iterations.max", 3);
            int curIter = 0;
            do {
                this.clearState();
                this.restoreHdfsIntegrity();
            } while (this.fixes > 0 && ++curIter <= maxIterations);
            if (curIter > 2) {
                if (curIter == maxIterations) {
                    LOG.warn((Object)("Exiting integrity repairs after max " + curIter + " iterations.  Tables integrity may not be fully repaired!"));
                } else {
                    LOG.info((Object)("Successfully exiting integrity repairs after " + curIter + " iterations"));
                }
            }
        }
    }

    public int onlineConsistencyRepair() throws IOException, KeeperException, InterruptedException {
        this.clearState();
        LOG.info((Object)"Loading regionsinfo from the .META. table");
        boolean success = this.loadMetaEntries();
        if (!success) {
            return -1;
        }
        if (!this.checkMetaRegion()) {
            this.errors.reportError("Meta is in transition.  Failing this iteration...");
            return -2;
        }
        if (!this.checkMetaOnly) {
            this.reportTablesInFlux();
        }
        this.loadDeployedRegions();
        this.loadHdfsRegionDirs();
        this.loadHdfsRegionInfos();
        this.reportEmptyMetaCells();
        this.loadDisabledTables();
        this.checkAndFixConsistency();
        this.checkIntegrity();
        return this.errors.getErrorList().size();
    }

    public int onlineHbck() throws IOException, KeeperException, InterruptedException {
        this.errors.print("Version: " + this.status.getHBaseVersion());
        this.offlineHdfsIntegrityRepair();
        boolean oldBalancer = this.admin.balanceSwitch(false);
        this.onlineConsistencyRepair();
        this.admin.balanceSwitch(oldBalancer);
        this.printTableSummary(this.tablesInfo);
        return this.errors.summarize();
    }

    private void adoptHdfsOrphans(Collection<HbckInfo> orphanHdfsDirs) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        for (HbckInfo hi : orphanHdfsDirs) {
            LOG.info((Object)("Attempting to handle orphan hdfs dir: " + hi.getHdfsRegionDir()));
            this.adoptHdfsOrphan(fs, hi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adoptHdfsOrphan(FileSystem fs, HbckInfo hi) throws IOException {
        Path p = hi.getHdfsRegionDir();
        FileStatus[] dirs = fs.listStatus(p);
        if (dirs == null) {
            LOG.warn((Object)("Attempt to adopt ophan hdfs region skipped becuase no files present in " + p + ". This dir could probably be deleted."));
            return;
        }
        String tableName = Bytes.toString(hi.getTableName());
        TableInfo tableInfo = (TableInfo)this.tablesInfo.get(tableName);
        Preconditions.checkNotNull((Object)("Table " + tableName + "' not present!"), (Object)tableInfo);
        HTableDescriptor template = tableInfo.getHTD();
        Pair<byte[], byte[]> orphanRegionRange = null;
        for (FileStatus cf : dirs) {
            FileStatus[] hfiles;
            String cfName = cf.getPath().getName();
            if (cfName.startsWith(".") || cfName.equals("splitlog")) continue;
            for (FileStatus hfile : hfiles = fs.listStatus(cf.getPath())) {
                byte[] end;
                byte[] start;
                HFile.Reader hf = null;
                try {
                    hf = new HFile.Reader(fs, hfile.getPath(), null, false);
                    hf.loadFileInfo();
                    KeyValue startKv = KeyValue.createKeyValueFromKey(hf.getFirstKey());
                    start = startKv.getRow();
                    KeyValue endKv = KeyValue.createKeyValueFromKey(hf.getLastKey());
                    end = endKv.getRow();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Problem reading orphan file " + hfile + ", skipping"));
                    continue;
                }
                catch (NullPointerException ioe) {
                    LOG.warn((Object)("Orphan file " + hfile + " is possibly corrupted HFile, skipping"));
                    continue;
                }
                finally {
                    if (hf != null) {
                        hf.close();
                    }
                }
                if (orphanRegionRange == null) {
                    orphanRegionRange = new Pair<byte[], byte[]>(start, end);
                    continue;
                }
                if (Bytes.compareTo((byte[])orphanRegionRange.getFirst(), start) > 0) {
                    orphanRegionRange.setFirst(start);
                }
                if (Bytes.compareTo(orphanRegionRange.getSecond(), end) >= 0) continue;
                orphanRegionRange.setSecond(end);
            }
        }
        if (orphanRegionRange == null) {
            LOG.warn((Object)("No data in dir " + p + ", sidelining data"));
            ++this.fixes;
            this.sidelineRegionDir(fs, hi);
            return;
        }
        LOG.info((Object)("Min max keys are : [" + Bytes.toString((byte[])orphanRegionRange.getFirst()) + ", " + Bytes.toString((byte[])orphanRegionRange.getSecond()) + ")"));
        HRegionInfo hri = new HRegionInfo(template, (byte[])orphanRegionRange.getFirst(), (byte[])orphanRegionRange.getSecond());
        LOG.info((Object)("Creating new region : " + (Object)((Object)hri)));
        HRegion region = HBaseFsckRepair.createHDFSRegionDir(this.conf, hri);
        Path target = region.getRegionDir();
        this.mergeRegionDirs(target, hi);
        ++this.fixes;
    }

    private int restoreHdfsIntegrity() throws IOException, InterruptedException {
        LOG.info((Object)"Loading HBase regioninfo from HDFS...");
        this.loadHdfsRegionDirs();
        int errs = this.errors.getErrorList().size();
        this.loadHdfsRegionInfos();
        this.checkHdfsIntegrity(false, false);
        if (this.errors.getErrorList().size() == errs) {
            LOG.info((Object)"No integrity errors.  We are done with this phase. Glorious.");
            return 0;
        }
        if (this.shouldFixHdfsOrphans() && this.orphanHdfsDirs.size() > 0) {
            this.adoptHdfsOrphans(this.orphanHdfsDirs);
        }
        if (this.shouldFixHdfsHoles()) {
            this.clearState();
            this.loadHdfsRegionDirs();
            this.loadHdfsRegionInfos();
            this.checkHdfsIntegrity(this.shouldFixHdfsHoles(), false);
        }
        if (this.shouldFixHdfsOverlaps()) {
            this.clearState();
            this.loadHdfsRegionDirs();
            this.loadHdfsRegionInfos();
            this.checkHdfsIntegrity(false, this.shouldFixHdfsOverlaps());
        }
        return this.errors.getErrorList().size();
    }

    private void reportEmptyMetaCells() {
        this.errors.print("Number of empty REGIONINFO_QUALIFIER rows in .META.: " + this.emptyRegionInfoQualifiers.size());
        if (details) {
            for (Result r : this.emptyRegionInfoQualifiers) {
                this.errors.print("  " + r);
            }
        }
    }

    private void reportTablesInFlux() {
        AtomicInteger numSkipped = new AtomicInteger(0);
        HTableDescriptor[] allTables = this.getTables(numSkipped);
        this.errors.print("Number of Tables: " + allTables.length);
        if (details) {
            if (numSkipped.get() > 0) {
                this.errors.detail("Number of Tables in flux: " + numSkipped.get());
            }
            for (HTableDescriptor td : allTables) {
                String tableName = td.getNameAsString();
                this.errors.detail("  Table: " + tableName + "\t" + (td.isReadOnly() ? "ro" : "rw") + "\t" + (td.isRootRegion() ? "ROOT" : (td.isMetaRegion() ? "META" : "    ")) + "\t" + " families: " + td.getFamilies().size());
            }
        }
    }

    public ErrorReporter getErrors() {
        return this.errors;
    }

    private void loadHdfsRegioninfo(HbckInfo hbi) throws IOException {
        Path regionDir = hbi.getHdfsRegionDir();
        if (regionDir == null) {
            LOG.warn((Object)("No HDFS region dir found: " + hbi + " meta=" + (Object)((Object)hbi.metaEntry)));
            return;
        }
        if (((HbckInfo)hbi).hdfsEntry.hri != null) {
            return;
        }
        Path regioninfo = new Path(regionDir, ".regioninfo");
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FSDataInputStream in = fs.open(regioninfo);
        HRegionInfo hri = new HRegionInfo();
        hri.readFields((DataInput)in);
        in.close();
        LOG.debug((Object)("HRegionInfo read: " + hri.toString()));
        ((HbckInfo)hbi).hdfsEntry.hri = hri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedMap<String, TableInfo> loadHdfsRegionInfos() throws IOException, InterruptedException {
        this.tablesInfo.clear();
        Collection<HbckInfo> hbckInfos = this.regionInfoMap.values();
        WorkItemHdfsRegionInfo[] hbis = new WorkItemHdfsRegionInfo[hbckInfos.size()];
        int num = 0;
        for (HbckInfo hbckInfo : hbckInfos) {
            hbis[num] = new WorkItemHdfsRegionInfo(hbckInfo, this, this.errors);
            this.executor.execute(hbis[num]);
            ++num;
        }
        for (int i = 0; i < num; ++i) {
            WorkItemHdfsRegionInfo workItemHdfsRegionInfo;
            WorkItemHdfsRegionInfo workItemHdfsRegionInfo2 = workItemHdfsRegionInfo = hbis[i];
            synchronized (workItemHdfsRegionInfo2) {
                while (!workItemHdfsRegionInfo.isDone()) {
                    workItemHdfsRegionInfo.wait();
                }
                continue;
            }
        }
        for (HbckInfo hbckInfo : hbckInfos) {
            if (hbckInfo.getHdfsHRI() == null) continue;
            String tableName = Bytes.toString(hbckInfo.getTableName());
            if (tableName == null) {
                LOG.warn((Object)("tableName was null for: " + hbckInfo));
                continue;
            }
            TableInfo modTInfo = (TableInfo)this.tablesInfo.get(tableName);
            if (modTInfo == null) {
                modTInfo = new TableInfo(tableName);
            }
            modTInfo.addRegionInfo(hbckInfo);
            this.tablesInfo.put(tableName, modTInfo);
        }
        return this.tablesInfo;
    }

    private HRegion createNewRootAndMeta() throws IOException {
        Path rootdir = new Path(this.conf.get("hbase.rootdir"));
        Configuration c = this.conf;
        HRegionInfo rootHRI = new HRegionInfo(HRegionInfo.ROOT_REGIONINFO);
        MasterFileSystem.setInfoFamilyCaching(rootHRI, false);
        HRegionInfo metaHRI = new HRegionInfo(HRegionInfo.FIRST_META_REGIONINFO);
        MasterFileSystem.setInfoFamilyCaching(metaHRI, false);
        HRegion root = HRegion.createHRegion(rootHRI, rootdir, c);
        HRegion meta = HRegion.createHRegion(metaHRI, rootdir, c);
        MasterFileSystem.setInfoFamilyCaching(rootHRI, true);
        MasterFileSystem.setInfoFamilyCaching(metaHRI, true);
        HRegion.addRegionToMETA(root, meta);
        root.close();
        root.getLog().closeAndDelete();
        return meta;
    }

    private ArrayList<Put> generatePuts(SortedMap<String, TableInfo> tablesInfo) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        boolean hasProblems = false;
        for (Map.Entry<String, TableInfo> e : tablesInfo.entrySet()) {
            String name = e.getKey();
            if (Bytes.compareTo(Bytes.toBytes(name), HConstants.ROOT_TABLE_NAME) == 0 || Bytes.compareTo(Bytes.toBytes(name), HConstants.META_TABLE_NAME) == 0) continue;
            TableInfo ti = e.getValue();
            for (Map.Entry spl : ti.sc.getStarts().asMap().entrySet()) {
                Collection his = (Collection)spl.getValue();
                int sz = his.size();
                if (sz != 1) {
                    LOG.error((Object)("Split starting at " + Bytes.toStringBinary((byte[])spl.getKey()) + " had " + sz + " regions instead of exactly 1."));
                    hasProblems = true;
                    continue;
                }
                HbckInfo hi = (HbckInfo)his.iterator().next();
                HRegionInfo hri = hi.getHdfsHRI();
                Put p = new Put(hri.getRegionName());
                p.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
                puts.add(p);
            }
        }
        return hasProblems ? null : puts;
    }

    private void suggestFixes(SortedMap<String, TableInfo> tablesInfo) throws IOException {
        Iterator<TableInfo> i$ = tablesInfo.values().iterator();
        while (i$.hasNext()) {
            TableInfo tInfo;
            TableInfo tableInfo = tInfo = i$.next();
            tableInfo.getClass();
            TableInfo.IntegrityFixSuggester handler = tableInfo.new TableInfo.IntegrityFixSuggester(tInfo, this.errors);
            tInfo.checkRegionChain(handler);
        }
    }

    public boolean rebuildMeta() throws IOException, InterruptedException {
        LOG.info((Object)"Loading HBase regioninfo from HDFS...");
        this.loadHdfsRegionDirs();
        int errs = this.errors.getErrorList().size();
        this.tablesInfo = this.loadHdfsRegionInfos();
        this.checkHdfsIntegrity(false, false);
        if (this.errors.getErrorList().size() != errs) {
            int errCount;
            do {
                this.fixes = 0;
                this.suggestFixes(this.tablesInfo);
                this.errors.clear();
                this.loadHdfsRegionInfos();
                this.checkHdfsIntegrity(this.shouldFixHdfsHoles(), this.shouldFixHdfsOverlaps());
                errCount = this.errors.getErrorList().size();
            } while (this.fixes != 0);
            if (errCount > 0) {
                return false;
            }
        }
        LOG.info((Object)"HDFS regioninfo's seems good.  Sidelining old .META.");
        this.sidelineOldRootAndMeta();
        LOG.info((Object)"Creating new .META.");
        HRegion meta = this.createNewRootAndMeta();
        ArrayList<Put> puts = this.generatePuts(this.tablesInfo);
        if (puts == null) {
            LOG.fatal((Object)"Problem encountered when creating new .META. entries.  You may need to restore the previously sidelined -ROOT- and .META.");
            return false;
        }
        meta.put(puts.toArray(new Put[0]));
        meta.close();
        meta.getLog().closeAndDelete();
        LOG.info((Object)"Success! .META. table rebuilt.");
        return true;
    }

    private SortedMap<String, TableInfo> checkHdfsIntegrity(boolean fixHoles, boolean fixOverlaps) throws IOException {
        LOG.info((Object)"Checking HBase region split map from HDFS data...");
        for (TableInfo tInfo : this.tablesInfo.values()) {
            TableInfo.IntegrityFixSuggester handler;
            if (fixHoles || fixOverlaps) {
                if (this.shouldFixTable(Bytes.toBytes(tInfo.getName()))) {
                    TableInfo tableInfo = tInfo;
                    tableInfo.getClass();
                    handler = tableInfo.new TableInfo.HDFSIntegrityFixer(tInfo, this.errors, this.conf, fixHoles, fixOverlaps);
                } else {
                    LOG.info((Object)("Table " + tInfo.getName() + " is not in the include table " + "list.  Just suggesting fixes."));
                    TableInfo tableInfo = tInfo;
                    tableInfo.getClass();
                    handler = tableInfo.new TableInfo.IntegrityFixSuggester(tInfo, this.errors);
                }
            } else {
                TableInfo tableInfo = tInfo;
                tableInfo.getClass();
                handler = tableInfo.new TableInfo.IntegrityFixSuggester(tInfo, this.errors);
            }
            if (tInfo.checkRegionChain(handler)) continue;
            this.errors.report("Found inconsistency in table " + tInfo.getName());
        }
        return this.tablesInfo;
    }

    private Path getSidelineDir() throws IOException {
        Path hbaseDir = FSUtils.getRootDir(this.conf);
        Path hbckDir = new Path(hbaseDir.getParent(), "hbck");
        Path backupDir = new Path(hbckDir, hbaseDir.getName() + "-" + this.hbckStartMillis);
        return backupDir;
    }

    Path sidelineRegionDir(FileSystem fs, HbckInfo hi) throws IOException {
        String tableName = Bytes.toString(hi.getTableName());
        Path regionDir = hi.getHdfsRegionDir();
        if (!fs.exists(regionDir)) {
            LOG.warn((Object)("No previous " + regionDir + " exists.  Continuing."));
            return null;
        }
        Path sidelineTableDir = new Path(this.getSidelineDir(), tableName);
        Path sidelineRegionDir = new Path(sidelineTableDir, regionDir.getName());
        fs.mkdirs(sidelineRegionDir);
        boolean success = false;
        FileStatus[] cfs = fs.listStatus(regionDir);
        if (cfs == null) {
            LOG.info((Object)("Region dir is empty: " + regionDir));
        } else {
            for (FileStatus cf : cfs) {
                Path src = cf.getPath();
                Path dst = new Path(sidelineRegionDir, src.getName());
                if (fs.isFile(src)) {
                    success = fs.rename(src, dst);
                    if (success) continue;
                    String msg = "Unable to rename file " + src + " to " + dst;
                    LOG.error((Object)msg);
                    throw new IOException(msg);
                }
                fs.mkdirs(dst);
                LOG.info((Object)("Sidelining files from " + src + " into containing region " + dst));
                FileStatus[] hfiles = fs.listStatus(src);
                if (hfiles != null && hfiles.length > 0) {
                    for (FileStatus hfile : hfiles) {
                        success = fs.rename(hfile.getPath(), dst);
                        if (success) continue;
                        String msg = "Unable to rename file " + src + " to " + dst;
                        LOG.error((Object)msg);
                        throw new IOException(msg);
                    }
                }
                LOG.debug((Object)"Sideline directory contents:");
                this.debugLsr(sidelineRegionDir);
            }
        }
        LOG.info((Object)("Removing old region dir: " + regionDir));
        success = fs.delete(regionDir, true);
        if (!success) {
            String msg = "Unable to delete dir " + regionDir;
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
        return sidelineRegionDir;
    }

    void sidelineTable(FileSystem fs, byte[] table, Path hbaseDir, Path backupHbaseDir) throws IOException {
        String tableName = Bytes.toString(table);
        Path tableDir = new Path(hbaseDir, tableName);
        if (fs.exists(tableDir)) {
            Path backupTableDir = new Path(backupHbaseDir, tableName);
            boolean success = fs.rename(tableDir, backupTableDir);
            if (!success) {
                throw new IOException("Failed to move  " + tableName + " from " + tableDir.getName() + " to " + backupTableDir.getName());
            }
        } else {
            LOG.info((Object)("No previous " + tableName + " exists.  Continuing."));
        }
    }

    Path sidelineOldRootAndMeta() throws IOException {
        Path hbaseDir = new Path(this.conf.get("hbase.rootdir"));
        FileSystem fs = hbaseDir.getFileSystem(this.conf);
        Path backupDir = new Path(hbaseDir.getParent(), hbaseDir.getName() + "-" + this.hbckStartMillis);
        fs.mkdirs(backupDir);
        this.sidelineTable(fs, HConstants.ROOT_TABLE_NAME, hbaseDir, backupDir);
        try {
            this.sidelineTable(fs, HConstants.META_TABLE_NAME, hbaseDir, backupDir);
        }
        catch (IOException e) {
            LOG.error((Object)"Attempt to sideline meta failed, attempt to revert...", (Throwable)e);
            try {
                this.sidelineTable(fs, HConstants.ROOT_TABLE_NAME, backupDir, hbaseDir);
                LOG.warn((Object)"... revert succeed.  -ROOT- and .META. still in original state.");
            }
            catch (IOException ioe) {
                LOG.fatal((Object)("... failed to sideline root and meta and failed to restore prevoius state.  Currently in inconsistent state.  To restore try to rename -ROOT- in " + backupDir.getName() + " to " + hbaseDir.getName() + "."), (Throwable)ioe);
            }
            throw e;
        }
        return backupDir;
    }

    private void loadDisabledTables() throws ZooKeeperConnectionException, IOException {
        HConnectionManager.execute(new HConnectionManager.HConnectable<Void>(this.conf){

            @Override
            public Void connect(HConnection connection) throws IOException {
                ZooKeeperWatcher zkw = connection.getZooKeeperWatcher();
                try {
                    for (String tableName : ZKTable.getDisabledOrDisablingTables(zkw)) {
                        HBaseFsck.this.disabledTables.add(Bytes.toBytes(tableName));
                    }
                }
                catch (KeeperException ke) {
                    throw new IOException(ke);
                }
                return null;
            }
        });
    }

    private boolean isTableDisabled(HRegionInfo regionInfo) {
        return this.disabledTables.contains(regionInfo.getTableDesc().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHdfsRegionDirs() throws IOException, InterruptedException {
        FileStatus[] files;
        Path rootDir = new Path(this.conf.get("hbase.rootdir"));
        FileSystem fs = rootDir.getFileSystem(this.conf);
        ArrayList tableDirs = Lists.newArrayList();
        boolean foundVersionFile = false;
        for (FileStatus file : files = fs.listStatus(rootDir)) {
            String dirName = file.getPath().getName();
            if (dirName.equals("hbase.version")) {
                foundVersionFile = true;
                continue;
            }
            if (this.checkMetaOnly && !dirName.equals("-ROOT-") && !dirName.equals(".META.")) continue;
            tableDirs.add(file);
        }
        if (!foundVersionFile) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.NO_VERSION_FILE, "Version file does not exist in root dir " + rootDir);
            if (this.shouldFixVersionFile()) {
                LOG.info((Object)"Trying to create a new hbase.version file.");
                this.setShouldRerun();
                FSUtils.setVersion(fs, rootDir, this.conf.getInt("hbase.server.thread.wakefrequency", 10000));
            }
        }
        WorkItemHdfsDir[] dirs = new WorkItemHdfsDir[tableDirs.size()];
        int num = 0;
        for (FileStatus tableDir : tableDirs) {
            LOG.debug((Object)("Loading region dirs from " + tableDir.getPath()));
            dirs[num] = new WorkItemHdfsDir(this, fs, this.errors, tableDir);
            this.executor.execute(dirs[num]);
            ++num;
        }
        for (int i = 0; i < num; ++i) {
            WorkItemHdfsDir dir;
            WorkItemHdfsDir workItemHdfsDir = dir = dirs[i];
            synchronized (workItemHdfsDir) {
                while (!dir.isDone()) {
                    dir.wait();
                }
                continue;
            }
        }
    }

    private boolean recordRootRegion() throws IOException {
        HRegionLocation rootLocation = this.admin.getConnection().locateRegion(HConstants.ROOT_TABLE_NAME, HConstants.EMPTY_START_ROW);
        if (rootLocation == null || rootLocation.getRegionInfo() == null || rootLocation.getServerAddress() == null) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.NULL_ROOT_REGION, "Root Region or some of its attributes are null.");
            return false;
        }
        MetaEntry m = new MetaEntry(rootLocation.getRegionInfo(), rootLocation.getServerAddress(), null, System.currentTimeMillis());
        HbckInfo hbInfo = new HbckInfo(m);
        this.regionInfoMap.put(rootLocation.getRegionInfo().getEncodedName(), hbInfo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRegionDeployments(Collection<HServerInfo> regionServerList) throws IOException, InterruptedException {
        WorkItemRegion[] work = new WorkItemRegion[regionServerList.size()];
        int num = 0;
        for (HServerInfo rsinfo : regionServerList) {
            work[num] = new WorkItemRegion(this, rsinfo, this.errors, this.admin.getConnection());
            this.executor.execute(work[num]);
            ++num;
        }
        for (int i = 0; i < num; ++i) {
            WorkItemRegion workItemRegion = work[i];
            synchronized (workItemRegion) {
                while (!work[i].isDone()) {
                    work[i].wait();
                }
                continue;
            }
        }
    }

    private void checkAndFixConsistency() throws IOException, KeeperException, InterruptedException {
        for (Map.Entry<String, HbckInfo> e : this.regionInfoMap.entrySet()) {
            this.checkRegionConsistency(e.getKey(), e.getValue());
        }
        if (this.shouldFixTableDesc() && this.isMultiTableDescFound()) {
            this.setShouldRerun();
            for (Map.Entry<String, HbckInfo> e : this.regionInfoMap.entrySet()) {
                this.fixTableDescConsistency(e.getKey(), e.getValue());
            }
        }
    }

    private void deleteMetaRegion(HbckInfo hi) throws IOException {
        Delete d = new Delete(hi.metaEntry.getRegionName());
        this.meta.delete(d);
        this.meta.flushCommits();
        LOG.info((Object)("Deleted " + hi.metaEntry.getRegionNameAsString() + " from META"));
    }

    private void offline(byte[] regionName) throws IOException {
        String regionString = Bytes.toStringBinary(regionName);
        if (!rsSupportsOffline) {
            LOG.warn((Object)("Using unassign region " + regionString + " instead of using offline method, you should" + " restart HMaster after these repairs"));
            this.admin.unassign(regionName, true);
            return;
        }
        try {
            LOG.info((Object)("Offlining region " + regionString));
            this.admin.getMaster().offline(regionName);
        }
        catch (IOException ioe) {
            String notFoundMsg = "java.lang.NoSuchMethodException: org.apache.hadoop.hbase.master.HMaster.offline([B)";
            if (ioe.getMessage().contains(notFoundMsg)) {
                LOG.warn((Object)("Using unassign region " + regionString + " instead of using offline method, you should" + " restart HMaster after these repairs"));
                rsSupportsOffline = false;
                this.admin.unassign(regionName, true);
                return;
            }
            throw ioe;
        }
    }

    private void undeployRegions(HbckInfo hi) throws IOException, InterruptedException {
        for (OnlineEntry rse : hi.deployedEntries) {
            LOG.debug((Object)("Undeploy region " + (Object)((Object)rse.hri) + " from " + rse.hsa));
            try {
                HBaseFsckRepair.closeRegionSilentlyAndWait(this.admin, rse.hsa, rse.hri);
                this.offline(rse.hri.getRegionName());
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Got exception when attempting to offline region " + Bytes.toString(rse.hri.getRegionName())), (Throwable)ioe);
            }
        }
    }

    private void closeRegion(HbckInfo hi) throws IOException, InterruptedException {
        if (hi.metaEntry == null && hi.hdfsEntry == null) {
            this.undeployRegions(hi);
            return;
        }
        Get get2 = new Get(hi.getRegionName());
        get2.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        get2.addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
        Result r = this.meta.get(get2);
        byte[] value = r.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
        if (value == null) {
            this.errors.reportError("Unable to close region " + hi.getRegionNameAsString() + " because meta does not " + "have handle to reach it.");
            return;
        }
        HServerAddress hsa = new HServerAddress(Bytes.toString(value));
        byte[] hriVal = r.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        HRegionInfo hri = Writables.getHRegionInfoOrNull(hriVal);
        if (hri == null) {
            LOG.warn((Object)("Unable to close region " + hi.getRegionNameAsString() + " because META had invalid or missing " + "info" + ":" + Bytes.toString(HConstants.REGIONINFO_QUALIFIER) + " qualifier value."));
            return;
        }
        HBaseFsckRepair.closeRegionSilentlyAndWait(this.admin, hsa, hri);
    }

    private void tryAssignmentRepair(HbckInfo hbi, String msg) throws IOException, KeeperException, InterruptedException {
        if (this.shouldFixAssignments()) {
            this.errors.print(msg);
            this.undeployRegions(hbi);
            this.setShouldRerun();
            HBaseFsckRepair.fixUnassigned(this.admin, hbi.getHdfsHRI());
            HBaseFsckRepair.waitUntilAssigned(this.admin, hbi.getHdfsHRI());
        }
    }

    private void fixTableDescConsistency(String key, HbckInfo hbi) throws IOException, KeeperException, InterruptedException {
        String tableName = Bytes.toString(hbi.getTableName());
        TableInfo tableInfo = (TableInfo)this.tablesInfo.get(tableName);
        Preconditions.checkNotNull((Object)("Table " + tableName + "' not present!"), (Object)tableInfo);
        if (tableInfo.htds.size() != 1) {
            HTableDescriptor htd = tableInfo.getHTD();
            Path sidelineTableDir = new Path(this.getSidelineDir(), tableName);
            if (!htd.equals(hbi.getHdfsHRI().getTableDesc())) {
                if (hbi.deployedOn.size() > 1) {
                    LOG.warn((Object)("Region " + hbi.toString() + " is deployed on multiple region servers." + " Please fix the multiple assignments before fixing multiple table desc."));
                } else {
                    HServerAddress hsa = null;
                    if (hbi.deployedOn.size() == 1) {
                        hsa = (HServerAddress)hbi.deployedOn.get(0);
                    }
                    HBaseFsckRepair.fixTableDesc(this.admin, hsa, hbi, htd, sidelineTableDir);
                }
            }
        }
    }

    private void checkRegionConsistency(String key, HbckInfo hbi) throws IOException, KeeperException, InterruptedException {
        boolean recentlyModified;
        boolean deploymentMatchesMeta;
        String descriptiveName = hbi.toString();
        boolean inMeta = hbi.metaEntry != null;
        boolean inHdfs = hbi.getHdfsRegionDir() != null;
        boolean hasMetaAssignment = inMeta && ((HbckInfo)hbi).metaEntry.regionServer != null;
        boolean isDeployed = !hbi.deployedOn.isEmpty();
        boolean isMultiplyDeployed = hbi.deployedOn.size() > 1;
        boolean bl = deploymentMatchesMeta = hasMetaAssignment && isDeployed && !isMultiplyDeployed && ((HbckInfo)hbi).metaEntry.regionServer.equals(hbi.deployedOn.get(0));
        boolean splitParent = hbi.metaEntry == null ? false : hbi.metaEntry.isSplit() && hbi.metaEntry.isOffline();
        boolean shouldBeDeployed = inMeta && !this.isTableDisabled(hbi.metaEntry);
        boolean bl2 = recentlyModified = hbi.getHdfsRegionDir() != null && hbi.getModTime() + this.timelag > System.currentTimeMillis();
        if (hbi.containsOnlyHdfsEdits()) {
            return;
        }
        if (inMeta && inHdfs && isDeployed && deploymentMatchesMeta && shouldBeDeployed) {
            return;
        }
        if (inMeta && inHdfs && !isDeployed && splitParent) {
            LOG.warn((Object)("Region " + descriptiveName + " is a split parent in META and in HDFS"));
            return;
        }
        if (inMeta && inHdfs && !shouldBeDeployed && !isDeployed) {
            LOG.info((Object)("Region " + descriptiveName + " is in META, and in a disabled " + "tabled that is not deployed"));
            return;
        }
        if (recentlyModified) {
            LOG.warn((Object)("Region " + descriptiveName + " was recently modified -- skipping"));
            return;
        }
        if (!(inMeta || inHdfs || isDeployed)) {
            assert (false) : "Entry for region with no data";
        } else if (!inMeta && !inHdfs && isDeployed) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.NOT_IN_META_HDFS, "Region " + descriptiveName + ", key=" + key + ", not on HDFS or in META but " + "deployed on " + Joiner.on((String)", ").join((Iterable)hbi.deployedOn));
            if (this.shouldFixAssignments()) {
                this.undeployRegions(hbi);
            }
        } else if (!inMeta && inHdfs && !isDeployed) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, "Region " + descriptiveName + " on HDFS, but not listed in META " + "or deployed on any region server");
            if (this.shouldFixMeta()) {
                if (!hbi.isHdfsRegioninfoPresent()) {
                    LOG.error((Object)("Region " + (Object)((Object)hbi.getHdfsHRI()) + " could have been repaired" + " in table integrity repair phase if -fixHdfsOrphans was" + " used."));
                    return;
                }
                LOG.info((Object)("Patching .META. with .regioninfo: " + (Object)((Object)hbi.getHdfsHRI())));
                HBaseFsckRepair.fixMetaHoleOnline(this.conf, hbi.getHdfsHRI());
                this.tryAssignmentRepair(hbi, "Trying to reassign region...");
            }
        } else if (!inMeta && inHdfs && isDeployed) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.NOT_IN_META, "Region " + descriptiveName + " not in META, but deployed on " + Joiner.on((String)", ").join((Iterable)hbi.deployedOn));
            this.debugLsr(hbi.getHdfsRegionDir());
            if (this.shouldFixMeta()) {
                if (!hbi.isHdfsRegioninfoPresent()) {
                    LOG.error((Object)"This should have been repaired in table integrity repair phase");
                    return;
                }
                LOG.info((Object)("Patching .META. with with .regioninfo: " + (Object)((Object)hbi.getHdfsHRI())));
                HBaseFsckRepair.fixMetaHoleOnline(this.conf, hbi.getHdfsHRI());
                this.tryAssignmentRepair(hbi, "Trying to fix unassigned region...");
            }
        } else if (inMeta && !inHdfs && !isDeployed) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.NOT_IN_HDFS_OR_DEPLOYED, "Region " + descriptiveName + " found in META, but not in HDFS " + "or deployed on any region server.");
            if (this.shouldFixMeta()) {
                this.deleteMetaRegion(hbi);
            }
        } else if (inMeta && !inHdfs && isDeployed) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.NOT_IN_HDFS, "Region " + descriptiveName + " found in META, but not in HDFS, " + "and deployed on " + Joiner.on((String)", ").join((Iterable)hbi.deployedOn));
            if (this.shouldFixAssignments()) {
                this.errors.print("Trying to fix unassigned region...");
                this.closeRegion(hbi);
            }
            if (this.shouldFixMeta()) {
                this.deleteMetaRegion(hbi);
            }
        } else if (inMeta && inHdfs && !isDeployed && shouldBeDeployed) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.NOT_DEPLOYED, "Region " + descriptiveName + " not deployed on any region server.");
            this.tryAssignmentRepair(hbi, "Trying to fix unassigned region...");
        } else if (inMeta && inHdfs && isDeployed && !shouldBeDeployed) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.SHOULD_NOT_BE_DEPLOYED, "Region " + descriptiveName + " should not be deployed according " + "to META, but is deployed on " + Joiner.on((String)", ").join((Iterable)hbi.deployedOn));
            if (this.shouldFixAssignments()) {
                this.errors.print("Trying to close the region " + descriptiveName);
                this.setShouldRerun();
                HBaseFsckRepair.fixMultiAssignment(this.admin, hbi.metaEntry, hbi.deployedOn);
            }
        } else if (inMeta && inHdfs && isMultiplyDeployed) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.MULTI_DEPLOYED, "Region " + descriptiveName + " is listed in META on region server " + ((HbckInfo)hbi).metaEntry.regionServer + " but is multiply assigned to region servers " + Joiner.on((String)", ").join((Iterable)hbi.deployedOn));
            if (this.shouldFixAssignments()) {
                this.errors.print("Trying to fix assignment error...");
                this.setShouldRerun();
                HBaseFsckRepair.fixMultiAssignment(this.admin, hbi.metaEntry, hbi.deployedOn);
            }
        } else if (inMeta && inHdfs && isDeployed && !deploymentMatchesMeta) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.SERVER_DOES_NOT_MATCH_META, "Region " + descriptiveName + " listed in META on region server " + ((HbckInfo)hbi).metaEntry.regionServer + " but found on region server " + hbi.deployedOn.get(0));
            if (this.shouldFixAssignments()) {
                this.errors.print("Trying to fix assignment error...");
                this.setShouldRerun();
                HBaseFsckRepair.fixMultiAssignment(this.admin, hbi.metaEntry, hbi.deployedOn);
                HBaseFsckRepair.waitUntilAssigned(this.admin, hbi.getHdfsHRI());
            }
        } else {
            this.errors.reportError(ErrorReporter.ERROR_CODE.UNKNOWN, "Region " + descriptiveName + " is in an unforeseen state:" + " inMeta=" + inMeta + " inHdfs=" + inHdfs + " isDeployed=" + isDeployed + " isMultiplyDeployed=" + isMultiplyDeployed + " deploymentMatchesMeta=" + deploymentMatchesMeta + " shouldBeDeployed=" + shouldBeDeployed);
        }
    }

    SortedMap<String, TableInfo> checkIntegrity() throws IOException {
        this.tablesInfo = new TreeMap<String, TableInfo>();
        ArrayList<HbckInfo> noHDFSRegionInfos = new ArrayList<HbckInfo>();
        LOG.debug((Object)("There are " + this.regionInfoMap.size() + " region info entries"));
        for (HbckInfo hbi : this.regionInfoMap.values()) {
            if (hbi.metaEntry == null) {
                noHDFSRegionInfos.add(hbi);
                Path p = hbi.getHdfsRegionDir();
                if (p != null) continue;
                this.errors.report("No regioninfo in Meta or HDFS. " + hbi);
                continue;
            }
            if (((HbckInfo)hbi).metaEntry.regionServer == null) {
                this.errors.detail("Skipping region because no region server: " + hbi);
                continue;
            }
            if (hbi.metaEntry.isOffline()) {
                this.errors.detail("Skipping region because it is offline: " + hbi);
                continue;
            }
            if (hbi.containsOnlyHdfsEdits()) {
                this.errors.detail("Skipping region because it only contains edits" + hbi);
                continue;
            }
            if (hbi.deployedOn.size() == 0) continue;
            String tableName = hbi.metaEntry.getTableDesc().getNameAsString();
            TableInfo modTInfo = (TableInfo)this.tablesInfo.get(tableName);
            if (modTInfo == null) {
                modTInfo = new TableInfo(tableName);
            }
            for (HServerAddress server : hbi.deployedOn) {
                modTInfo.addServer(server);
            }
            modTInfo.addRegionInfo(hbi);
            this.tablesInfo.put(tableName, modTInfo);
        }
        Iterator<Object> i$ = this.tablesInfo.values().iterator();
        while (i$.hasNext()) {
            TableInfo tInfo;
            TableInfo tableInfo = tInfo = (TableInfo)i$.next();
            tableInfo.getClass();
            TableInfo.IntegrityFixSuggester handler = tableInfo.new TableInfo.IntegrityFixSuggester(tInfo, this.errors);
            if (tInfo.checkRegionChain(handler)) continue;
            this.errors.report("Found inconsistency in table " + tInfo.getName());
        }
        return this.tablesInfo;
    }

    public int mergeRegionDirs(Path targetRegionDir, HbckInfo contained) throws IOException {
        int fileMoves = 0;
        LOG.debug((Object)"Contained region dir after close and pause");
        this.debugLsr(contained.getHdfsRegionDir());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileStatus[] dirs = fs.listStatus(contained.getHdfsRegionDir());
        if (dirs == null) {
            if (!fs.exists(contained.getHdfsRegionDir())) {
                LOG.warn((Object)("HDFS region dir " + contained.getHdfsRegionDir() + " already sidelined."));
            } else {
                this.sidelineRegionDir(fs, contained);
            }
            return fileMoves;
        }
        for (FileStatus cf : dirs) {
            Path src = cf.getPath();
            Path dst = new Path(targetRegionDir, src.getName());
            if (src.getName().equals(".regioninfo") || src.getName().equals(".oldlogs")) continue;
            LOG.info((Object)("Moving files from " + src + " into containing region " + dst));
            for (FileStatus hfile : fs.listStatus(src)) {
                boolean success = fs.rename(hfile.getPath(), dst);
                if (!success) continue;
                ++fileMoves;
            }
            LOG.debug((Object)"Sideline directory contents:");
            this.debugLsr(targetRegionDir);
        }
        this.sidelineRegionDir(fs, contained);
        LOG.info((Object)("Sidelined region dir " + contained.getHdfsRegionDir() + " into " + this.getSidelineDir()));
        this.debugLsr(contained.getHdfsRegionDir());
        return fileMoves;
    }

    public void dumpOverlapProblems(Multimap<byte[], HbckInfo> regions) {
        for (byte[] k : regions.keySet()) {
            System.out.print(Bytes.toStringBinary(k) + ":\n");
            for (HbckInfo r : regions.get((Object)k)) {
                System.out.print("[ " + r.toString() + ", " + Bytes.toStringBinary(r.getEndKey()) + "]\n");
            }
            System.out.println("----");
        }
    }

    public void dumpSidelinedRegions(Map<Path, HbckInfo> regions) {
        for (Path k : regions.keySet()) {
            System.out.println("To be bulk loaded sidelined region dir: " + k.toString());
        }
    }

    public Multimap<byte[], HbckInfo> getOverlapGroups(String table) {
        TableInfo ti = (TableInfo)this.tablesInfo.get(table);
        return ti.overlapGroups;
    }

    HTableDescriptor[] getTables(AtomicInteger numSkipped) {
        TreeSet<HTableDescriptor> uniqueTables = new TreeSet<HTableDescriptor>();
        long now = System.currentTimeMillis();
        for (HbckInfo hbi : this.regionInfoMap.values()) {
            MetaEntry info = hbi.metaEntry;
            if (info == null || info.getStartKey().length != 0 || info.isMetaRegion()) continue;
            if (info.modTime + this.timelag < now) {
                uniqueTables.add(info.getTableDesc());
                continue;
            }
            numSkipped.incrementAndGet();
        }
        return uniqueTables.toArray(new HTableDescriptor[uniqueTables.size()]);
    }

    private synchronized HbckInfo getOrCreateInfo(String name) {
        HbckInfo hbi = this.regionInfoMap.get(name);
        if (hbi == null) {
            hbi = new HbckInfo(null);
            this.regionInfoMap.put(name, hbi);
        }
        return hbi;
    }

    boolean checkMetaRegion() throws IOException, KeeperException, InterruptedException {
        ArrayList metaRegions = Lists.newArrayList();
        for (HbckInfo value : this.regionInfoMap.values()) {
            if (!value.metaEntry.isMetaTable()) continue;
            metaRegions.add(value);
        }
        if (metaRegions.size() != 1) {
            HRegionLocation rootLocation = this.admin.getConnection().locateRegion(HConstants.ROOT_TABLE_NAME, HConstants.EMPTY_START_ROW);
            HbckInfo root = this.regionInfoMap.get(rootLocation.getRegionInfo().getEncodedName());
            if (metaRegions.size() == 0) {
                this.errors.reportError(ErrorReporter.ERROR_CODE.NO_META_REGION, ".META. is not found on any region.");
                if (this.shouldFixAssignments()) {
                    this.errors.print("Trying to fix a problem with .META...");
                    this.setShouldRerun();
                    HBaseFsckRepair.fixUnassigned(this.admin, root.metaEntry);
                    HBaseFsckRepair.waitUntilAssigned(this.admin, root.getHdfsHRI());
                }
            } else if (metaRegions.size() > 1) {
                this.errors.reportError(ErrorReporter.ERROR_CODE.MULTI_META_REGION, ".META. is found on more than one region.");
                if (this.shouldFixAssignments()) {
                    this.errors.print("Trying to fix a problem with .META...");
                    this.setShouldRerun();
                    ArrayList deployedOn = Lists.newArrayList();
                    for (HbckInfo mRegion : metaRegions) {
                        deployedOn.add(((HbckInfo)mRegion).metaEntry.regionServer);
                    }
                    HBaseFsckRepair.fixMultiAssignment(this.admin, root.metaEntry, deployedOn);
                }
            }
            return false;
        }
        return true;
    }

    boolean loadMetaEntries() throws IOException {
        if (!this.recordRootRegion()) {
            this.errors.reportError("Fatal error: unable to get root region location. Exiting...");
            return false;
        }
        MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){
            int countRecord = 1;
            final Comparator<KeyValue> comp = new Comparator<KeyValue>(){

                @Override
                public int compare(KeyValue k1, KeyValue k2) {
                    return (int)(k1.getTimestamp() - k2.getTimestamp());
                }
            };

            @Override
            public boolean processRow(Result result) throws IOException {
                try {
                    long ts = Collections.max(result.list(), this.comp).getTimestamp();
                    byte[] value = result.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                    if (value == null || value.length == 0) {
                        HBaseFsck.this.emptyRegionInfoQualifiers.add(result);
                        return true;
                    }
                    HRegionInfo info = Writables.getHRegionInfo(value);
                    HServerAddress server = null;
                    byte[] startCode = null;
                    value = result.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                    if (value != null && value.length > 0) {
                        String address = Bytes.toString(value);
                        server = new HServerAddress(address);
                    }
                    if ((value = result.getValue(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER)) != null) {
                        startCode = value;
                    }
                    MetaEntry m = new MetaEntry(info, server, startCode, ts);
                    HbckInfo hbInfo = new HbckInfo(m);
                    HbckInfo previous = HBaseFsck.this.regionInfoMap.put(info.getEncodedName(), hbInfo);
                    if (previous != null) {
                        throw new IOException("Two entries in META are same " + previous);
                    }
                    if (this.countRecord % 100 == 0) {
                        HBaseFsck.this.errors.progress();
                    }
                    ++this.countRecord;
                    return true;
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("Result=" + result));
                    throw e;
                }
            }
        };
        MetaScanner.metaScan(this.conf, visitor, null, null, Integer.MAX_VALUE, HConstants.ROOT_TABLE_NAME);
        if (!this.checkMetaOnly) {
            MetaScanner.metaScan(this.conf, visitor);
        }
        this.errors.print("");
        return true;
    }

    private void printTableSummary(SortedMap<String, TableInfo> tablesInfo) {
        System.out.println("Summary:");
        if (this.isMultiTableDescFound()) {
            System.out.println("  Multiple table descriptors were found.\n    You can ignore it if your cluster is working fine.\n    To fix it, please re-run hbck with option -fixTableDesc\n");
        }
        for (TableInfo tInfo : tablesInfo.values()) {
            if (this.errors.tableHasErrors(tInfo)) {
                System.out.println("Table " + tInfo.getName() + " is inconsistent.");
            } else {
                System.out.println("  " + tInfo.getName() + " is okay.");
            }
            System.out.println("    Number of regions: " + tInfo.getNumRegions());
            System.out.print("    Deployed on: ");
            for (HServerAddress server : tInfo.deployedOn) {
                System.out.print(" " + server.toString());
            }
            System.out.println();
        }
    }

    public void setDisplayFullReport() {
        details = true;
    }

    void setSummary() {
        summary = true;
    }

    void setCheckMetaOnly() {
        this.checkMetaOnly = true;
    }

    void setShouldRerun() {
        this.rerun = true;
    }

    boolean shouldRerun() {
        return this.rerun;
    }

    public void setFixAssignments(boolean shouldFix) {
        this.fixAssignments = shouldFix;
    }

    boolean shouldFixAssignments() {
        return this.fixAssignments;
    }

    public void setFixMeta(boolean shouldFix) {
        this.fixMeta = shouldFix;
    }

    boolean shouldFixMeta() {
        return this.fixMeta;
    }

    public void setFixHdfsHoles(boolean shouldFix) {
        this.fixHdfsHoles = shouldFix;
    }

    boolean shouldFixHdfsHoles() {
        return this.fixHdfsHoles;
    }

    public void setFixHdfsOverlaps(boolean shouldFix) {
        this.fixHdfsOverlaps = shouldFix;
    }

    boolean shouldFixHdfsOverlaps() {
        return this.fixHdfsOverlaps;
    }

    public void setFixHdfsOrphans(boolean shouldFix) {
        this.fixHdfsOrphans = shouldFix;
    }

    boolean shouldFixHdfsOrphans() {
        return this.fixHdfsOrphans;
    }

    public void setFixVersionFile(boolean shouldFix) {
        this.fixVersionFile = shouldFix;
    }

    public boolean shouldFixVersionFile() {
        return this.fixVersionFile;
    }

    public void setSidelineBigOverlaps(boolean sbo) {
        this.sidelineBigOverlaps = sbo;
    }

    public boolean shouldSidelineBigOverlaps() {
        return this.sidelineBigOverlaps;
    }

    public void setFixTableDesc(boolean ftd) {
        this.fixTableDesc = ftd;
    }

    public boolean shouldFixTableDesc() {
        return this.fixTableDesc;
    }

    public void setMultiTableDescFound(boolean multiTableDesc) {
        this.multiTableDescFound = multiTableDesc;
    }

    public boolean isMultiTableDescFound() {
        return this.multiTableDescFound;
    }

    public void setMaxMerge(int mm) {
        this.maxMerge = mm;
    }

    public int getMaxMerge() {
        return this.maxMerge;
    }

    public void setMaxOverlapsToSideline(int mo) {
        this.maxOverlapsToSideline = mo;
    }

    public int getMaxOverlapsToSideline() {
        return this.maxOverlapsToSideline;
    }

    boolean shouldFixTable(byte[] table) {
        if (this.tablesToFix.size() == 0) {
            return true;
        }
        for (byte[] t : this.tablesToFix) {
            if (!Bytes.equals(t, table)) continue;
            return true;
        }
        return false;
    }

    void includeTable(byte[] table) {
        this.tablesToFix.add(table);
    }

    public void setTimeLag(long seconds) {
        this.timelag = seconds * 1000L;
    }

    protected static void printUsageAndExit() {
        System.err.println("Usage: fsck [opts] {only tables}");
        System.err.println(" where [opts] are:");
        System.err.println("   -details Display full report of all regions.");
        System.err.println("   -timelag {timeInSeconds}  Process only regions that  have not experienced any metadata updates in the last  {{timeInSeconds} seconds.");
        System.err.println("   -sleepBeforeRerun {timeInSeconds} Sleep this many seconds before checking if the fix worked if run with -fix");
        System.err.println("   -summary Print only summary of the tables and status.");
        System.err.println("   -metaonly Only check the state of ROOT and META tables.");
        System.err.println("  Repair options: (expert features, use with caution!)");
        System.err.println("   -fix              Try to fix region assignments.  This is for backwards compatiblity");
        System.err.println("   -fixAssignments   Try to fix region assignments.  Replaces the old -fix");
        System.err.println("   -fixMeta          Try to fix meta problems.  This assumes HDFS region info is good.");
        System.err.println("   -fixHdfsHoles     Try to fix region holes in hdfs.");
        System.err.println("   -fixHdfsOrphans   Try to fix region dirs with no .regioninfo file in hdfs");
        System.err.println("   -fixHdfsOverlaps  Try to fix region overlaps in hdfs.");
        System.err.println("   -fixVersionFile   Try to fix missing hbase.version file in hdfs.");
        System.err.println("   -maxMerge <n>     When fixing region overlaps, allow at most <n> regions to merge. (n=5 by default)");
        System.err.println("   -sidelineBigOverlaps  When fixing region overlaps, allow to sideline big overlaps");
        System.err.println("   -maxOverlapsToSideline <n>  When fixing region overlaps, allow at most <n> regions to sideline per group. (n=2 by default)");
        System.err.println("");
        System.err.println("   -repair           Shortcut for -fixAssignments -fixMeta -fixHdfsHoles -fixHdfsOrphans -fixHdfsOverlaps -fixVersionFile -sidelineBigOverlaps");
        System.err.println("   -repairHoles      Shortcut for -fixAssignments -fixMeta -fixHdfsHoles -fixHdfsOrphans");
        System.err.println("   -fixTableDesc     Try to fix table descriptor inconsistency");
        Runtime.getRuntime().exit(-2);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("fs.defaultFS", conf.get("hbase.rootdir"));
        HBaseFsck fsck = new HBaseFsck(conf);
        long sleepBeforeRerun = 10000L;
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            if (cmd.equals("-details")) {
                fsck.setDisplayFullReport();
                continue;
            }
            if (cmd.equals("-timelag")) {
                if (i == args.length - 1) {
                    System.err.println("HBaseFsck: -timelag needs a value.");
                    HBaseFsck.printUsageAndExit();
                }
                try {
                    long timelag = Long.parseLong(args[i + 1]);
                    fsck.setTimeLag(timelag);
                }
                catch (NumberFormatException e) {
                    System.err.println("-timelag needs a numeric value.");
                    HBaseFsck.printUsageAndExit();
                }
                ++i;
                continue;
            }
            if (cmd.equals("-sleepBeforeRerun")) {
                if (i == args.length - 1) {
                    System.err.println("HBaseFsck: -sleepBeforeRerun needs a value.");
                    HBaseFsck.printUsageAndExit();
                }
                try {
                    sleepBeforeRerun = Long.parseLong(args[i + 1]);
                }
                catch (NumberFormatException e) {
                    System.err.println("-sleepBeforeRerun needs a numeric value.");
                    HBaseFsck.printUsageAndExit();
                }
                ++i;
                continue;
            }
            if (cmd.equals("-fix")) {
                System.err.println("This option is deprecated, please use -fixAssignments instead.");
                fsck.setFixAssignments(true);
                continue;
            }
            if (cmd.equals("-fixAssignments")) {
                fsck.setFixAssignments(true);
                continue;
            }
            if (cmd.equals("-fixMeta")) {
                fsck.setFixMeta(true);
                continue;
            }
            if (cmd.equals("-fixHdfsHoles")) {
                fsck.setFixHdfsHoles(true);
                continue;
            }
            if (cmd.equals("-fixHdfsOrphans")) {
                fsck.setFixHdfsOrphans(true);
                continue;
            }
            if (cmd.equals("-fixHdfsOverlaps")) {
                fsck.setFixHdfsOverlaps(true);
                continue;
            }
            if (cmd.equals("-fixVersionFile")) {
                fsck.setFixVersionFile(true);
                continue;
            }
            if (cmd.equals("-sidelineBigOverlaps")) {
                fsck.setSidelineBigOverlaps(true);
                continue;
            }
            if (cmd.equals("-fixTableDesc")) {
                fsck.setFixTableDesc(true);
                continue;
            }
            if (cmd.equals("-repair")) {
                fsck.setFixHdfsHoles(true);
                fsck.setFixHdfsOrphans(true);
                fsck.setFixMeta(true);
                fsck.setFixAssignments(true);
                fsck.setFixHdfsOverlaps(true);
                fsck.setFixVersionFile(true);
                fsck.setSidelineBigOverlaps(true);
                continue;
            }
            if (cmd.equals("-repairHoles")) {
                fsck.setFixHdfsHoles(true);
                fsck.setFixHdfsOrphans(false);
                fsck.setFixMeta(true);
                fsck.setFixAssignments(true);
                fsck.setFixHdfsOverlaps(false);
                fsck.setSidelineBigOverlaps(false);
                continue;
            }
            if (cmd.equals("-maxOverlapsToSideline")) {
                if (i == args.length - 1) {
                    System.err.println("-maxOverlapsToSideline needs a numeric value argument.");
                    HBaseFsck.printUsageAndExit();
                }
                try {
                    int maxOverlapsToSideline = Integer.parseInt(args[i + 1]);
                    fsck.setMaxOverlapsToSideline(maxOverlapsToSideline);
                }
                catch (NumberFormatException e) {
                    System.err.println("-maxOverlapsToSideline needs a numeric value argument.");
                    HBaseFsck.printUsageAndExit();
                }
                ++i;
                continue;
            }
            if (cmd.equals("-maxMerge")) {
                if (i == args.length - 1) {
                    System.err.println("-maxMerge needs a numeric value argument.");
                    HBaseFsck.printUsageAndExit();
                }
                try {
                    int maxMerge = Integer.parseInt(args[i + 1]);
                    fsck.setMaxMerge(maxMerge);
                }
                catch (NumberFormatException e) {
                    System.err.println("-maxMerge needs a numeric value argument.");
                    HBaseFsck.printUsageAndExit();
                }
                ++i;
                continue;
            }
            if (cmd.equals("-summary")) {
                fsck.setSummary();
                continue;
            }
            if (cmd.equals("-metaonly")) {
                fsck.setCheckMetaOnly();
                continue;
            }
            byte[] table = Bytes.toBytes(cmd);
            fsck.includeTable(table);
            System.out.println("Allow fixes for table: " + cmd);
        }
        fsck.connect();
        int code = fsck.onlineHbck();
        if (fsck.shouldRerun()) {
            try {
                LOG.info((Object)("Sleeping " + sleepBeforeRerun + "ms before re-checking after fix..."));
                Thread.sleep(sleepBeforeRerun);
            }
            catch (InterruptedException ie) {
                Runtime.getRuntime().exit(code);
            }
            fsck.setFixAssignments(false);
            fsck.setFixMeta(false);
            fsck.setFixHdfsHoles(false);
            fsck.setFixHdfsOverlaps(false);
            fsck.setFixHdfsOrphans(false);
            fsck.setFixVersionFile(false);
            fsck.errors.resetErrors();
            code = fsck.onlineHbck();
        }
        Runtime.getRuntime().exit(code);
    }

    void debugLsr(Path p) throws IOException {
        HBaseFsck.debugLsr(this.conf, p);
    }

    public static void debugLsr(Configuration conf, Path p) throws IOException {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!fs.exists(p)) {
            return;
        }
        System.out.println(p);
        if (fs.isFile(p)) {
            return;
        }
        if (fs.getFileStatus(p).isDir()) {
            FileStatus[] fss;
            for (FileStatus status : fss = fs.listStatus(p)) {
                HBaseFsck.debugLsr(conf, status.getPath());
            }
        }
    }

    static class WorkItemHdfsRegionInfo
    implements Runnable {
        private HbckInfo hbi;
        private HBaseFsck hbck;
        private ErrorReporter errors;
        private boolean done;

        WorkItemHdfsRegionInfo(HbckInfo hbi, HBaseFsck hbck, ErrorReporter errors) {
            this.hbi = hbi;
            this.hbck = hbck;
            this.errors = errors;
            this.done = false;
        }

        synchronized boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            block8: {
                try {
                    if (this.hbi.getHdfsHRI() != null) break block8;
                    try {
                        this.hbck.loadHdfsRegioninfo(this.hbi);
                    }
                    catch (IOException ioe) {
                        String msg = "Orphan region in HDFS: Unable to load .regioninfo from table " + Bytes.toString(this.hbi.getTableName()) + " in hdfs dir " + this.hbi.getHdfsRegionDir() + "!  It may be an invalid format or version file.  Treating as " + "an orphaned regiondir.";
                        this.errors.reportError(ErrorReporter.ERROR_CODE.ORPHAN_HDFS_REGION, msg);
                        try {
                            this.hbck.debugLsr(this.hbi.getHdfsRegionDir());
                        }
                        catch (IOException ioe2) {
                            LOG.error((Object)("Unable to read directory " + this.hbi.getHdfsRegionDir()), (Throwable)ioe2);
                            this.done = true;
                            this.notifyAll();
                            return;
                        }
                        this.hbck.orphanHdfsDirs.add(this.hbi);
                        this.done = true;
                        this.notifyAll();
                        return;
                    }
                }
                finally {
                    this.done = true;
                    this.notifyAll();
                }
            }
        }
    }

    static class WorkItemHdfsDir
    implements Runnable {
        private HBaseFsck hbck;
        private FileStatus tableDir;
        private ErrorReporter errors;
        private FileSystem fs;
        private boolean done;

        WorkItemHdfsDir(HBaseFsck hbck, FileSystem fs, ErrorReporter errors, FileStatus status) {
            this.hbck = hbck;
            this.fs = fs;
            this.tableDir = status;
            this.errors = errors;
            this.done = false;
        }

        synchronized boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            try {
                FileStatus[] regionDirs;
                String tableName = this.tableDir.getPath().getName();
                if (tableName.startsWith(".") && !tableName.equals(Bytes.toString(HConstants.META_TABLE_NAME))) {
                    return;
                }
                for (FileStatus regionDir : regionDirs = this.fs.listStatus(this.tableDir.getPath())) {
                    String encodedName = regionDir.getPath().getName();
                    if (!encodedName.toLowerCase().matches("[0-9a-f]+")) continue;
                    LOG.debug((Object)("Loading region info from hdfs:" + regionDir.getPath()));
                    HbckInfo hbi = this.hbck.getOrCreateInfo(encodedName);
                    HdfsEntry he = new HdfsEntry();
                    HbckInfo hbckInfo = hbi;
                    synchronized (hbckInfo) {
                        if (hbi.getHdfsRegionDir() != null) {
                            this.errors.print("Directory " + encodedName + " duplicate??" + hbi.getHdfsRegionDir());
                        }
                        he.hdfsRegionDir = regionDir.getPath();
                        he.hdfsRegionDirModTime = regionDir.getModificationTime();
                        Path regioninfoFile = new Path(he.hdfsRegionDir, ".regioninfo");
                        he.hdfsRegioninfoFilePresent = this.fs.exists(regioninfoFile);
                        he.hdfsOnlyEdits = true;
                        FileStatus[] subDirs = this.fs.listStatus(regionDir.getPath());
                        Path ePath = HLog.getRegionDirRecoveredEditsDir(regionDir.getPath());
                        for (FileStatus subDir : subDirs) {
                            String sdName = subDir.getPath().getName();
                            if (sdName.startsWith(".") || sdName.equals(ePath.getName())) continue;
                            he.hdfsOnlyEdits = false;
                            break;
                        }
                        hbi.hdfsEntry = he;
                    }
                }
            }
            catch (IOException e) {
                this.errors.reportError(ErrorReporter.ERROR_CODE.RS_CONNECT_FAILURE, "Table Directory: " + this.tableDir.getPath().getName() + " Unable to fetch region information. " + e);
            }
            finally {
                this.done = true;
                this.notifyAll();
            }
        }
    }

    static class WorkItemRegion
    implements Runnable {
        private HBaseFsck hbck;
        private HServerInfo rsinfo;
        private ErrorReporter errors;
        private HConnection connection;
        private boolean done;

        WorkItemRegion(HBaseFsck hbck, HServerInfo info, ErrorReporter errors, HConnection connection) {
            this.hbck = hbck;
            this.rsinfo = info;
            this.errors = errors;
            this.connection = connection;
            this.done = false;
        }

        synchronized boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            this.errors.progress();
            try {
                HRegionInterface server = this.connection.getHRegionConnection(this.rsinfo.getServerAddress());
                List<HRegionInfo> regions = server.getOnlineRegions();
                if (this.hbck.checkMetaOnly) {
                    regions = this.filterOnlyMetaRegions(regions);
                }
                if (details) {
                    this.errors.detail("RegionServer: " + this.rsinfo.getServerName() + " number of regions: " + regions.size());
                    for (HRegionInfo rinfo : regions) {
                        this.errors.detail("  " + rinfo.getRegionNameAsString() + " id: " + rinfo.getRegionId() + " encoded_name: " + rinfo.getEncodedName() + " start: " + Bytes.toStringBinary(rinfo.getStartKey()) + " end: " + Bytes.toStringBinary(rinfo.getEndKey()));
                    }
                }
                for (HRegionInfo r : regions) {
                    HbckInfo hbi = this.hbck.getOrCreateInfo(r.getEncodedName());
                    hbi.addServer(r, this.rsinfo.getServerAddress());
                }
            }
            catch (IOException e) {
                this.errors.reportError(ErrorReporter.ERROR_CODE.RS_CONNECT_FAILURE, "RegionServer: " + this.rsinfo.getServerName() + " Unable to fetch region information. " + e);
            }
            finally {
                this.done = true;
                this.notifyAll();
            }
        }

        private List<HRegionInfo> filterOnlyMetaRegions(List<HRegionInfo> regions) {
            ArrayList ret = Lists.newArrayList();
            for (HRegionInfo hri : regions) {
                if (!hri.isMetaRegion() && !hri.isRootRegion()) continue;
                ret.add(hri);
            }
            return ret;
        }
    }

    private static class PrintingErrorReporter
    implements ErrorReporter {
        public int errorCount = 0;
        private int showProgress;
        Set<TableInfo> errorTables = new HashSet<TableInfo>();
        private ArrayList<ErrorReporter.ERROR_CODE> errorList = new ArrayList();

        private PrintingErrorReporter() {
        }

        @Override
        public void clear() {
            this.errorTables.clear();
            this.errorList.clear();
            this.errorCount = 0;
        }

        @Override
        public synchronized void reportError(ErrorReporter.ERROR_CODE errorCode, String message) {
            this.errorList.add(errorCode);
            if (!summary) {
                System.out.println("ERROR: " + message);
            }
            ++this.errorCount;
            this.showProgress = 0;
        }

        @Override
        public synchronized void reportError(ErrorReporter.ERROR_CODE errorCode, String message, TableInfo table, HbckInfo info) {
            this.errorTables.add(table);
            String reference = "(region " + info.getRegionNameAsString() + ")";
            this.reportError(errorCode, reference + " " + message);
        }

        @Override
        public synchronized void reportError(ErrorReporter.ERROR_CODE errorCode, String message, TableInfo table, HbckInfo info1, HbckInfo info2) {
            this.errorTables.add(table);
            String reference = "(regions " + info1.getRegionNameAsString() + " and " + info2.getRegionNameAsString() + ")";
            this.reportError(errorCode, reference + " " + message);
        }

        @Override
        public synchronized void reportError(String message) {
            this.reportError(ErrorReporter.ERROR_CODE.UNKNOWN, message);
        }

        @Override
        public synchronized void report(String message) {
            if (!summary) {
                System.out.println("ERROR: " + message);
            }
            this.showProgress = 0;
        }

        @Override
        public synchronized int summarize() {
            System.out.println(Integer.toString(this.errorCount) + " inconsistencies detected.");
            if (this.errorCount == 0) {
                System.out.println("Status: OK");
                return 0;
            }
            System.out.println("Status: INCONSISTENT");
            return -1;
        }

        @Override
        public ArrayList<ErrorReporter.ERROR_CODE> getErrorList() {
            return this.errorList;
        }

        @Override
        public synchronized void print(String message) {
            if (!summary) {
                System.out.println(message);
            }
        }

        @Override
        public boolean tableHasErrors(TableInfo table) {
            return this.errorTables.contains(table);
        }

        @Override
        public void resetErrors() {
            this.errorCount = 0;
        }

        @Override
        public synchronized void detail(String message) {
            if (details) {
                System.out.println(message);
            }
            this.showProgress = 0;
        }

        @Override
        public synchronized void progress() {
            if (this.showProgress++ == 10) {
                if (!summary) {
                    System.out.print(".");
                }
                this.showProgress = 0;
            }
        }
    }

    public static interface ErrorReporter {
        public void clear();

        public void report(String var1);

        public void reportError(String var1);

        public void reportError(ERROR_CODE var1, String var2);

        public void reportError(ERROR_CODE var1, String var2, TableInfo var3, HbckInfo var4);

        public void reportError(ERROR_CODE var1, String var2, TableInfo var3, HbckInfo var4, HbckInfo var5);

        public int summarize();

        public void detail(String var1);

        public ArrayList<ERROR_CODE> getErrorList();

        public void progress();

        public void print(String var1);

        public void resetErrors();

        public boolean tableHasErrors(TableInfo var1);

        public static enum ERROR_CODE {
            UNKNOWN,
            NO_META_REGION,
            NULL_ROOT_REGION,
            NO_VERSION_FILE,
            NOT_IN_META_HDFS,
            NOT_IN_META,
            NOT_IN_META_OR_DEPLOYED,
            NOT_IN_HDFS_OR_DEPLOYED,
            NOT_IN_HDFS,
            SERVER_DOES_NOT_MATCH_META,
            NOT_DEPLOYED,
            MULTI_DEPLOYED,
            SHOULD_NOT_BE_DEPLOYED,
            MULTI_META_REGION,
            RS_CONNECT_FAILURE,
            FIRST_REGION_STARTKEY_NOT_EMPTY,
            DUPE_STARTKEYS,
            HOLE_IN_REGION_CHAIN,
            OVERLAP_IN_REGION_CHAIN,
            REGION_CYCLE,
            DEGENERATE_REGION,
            ORPHAN_HDFS_REGION;

        }
    }

    public static class HbckInfo
    implements KeyRange {
        private MetaEntry metaEntry = null;
        private HdfsEntry hdfsEntry = null;
        private List<OnlineEntry> deployedEntries = Lists.newArrayList();
        private List<HServerAddress> deployedOn = Lists.newArrayList();

        HbckInfo(HdfsEntry hdfsEntry, MetaEntry metaEntry) {
            this.hdfsEntry = hdfsEntry;
            this.metaEntry = metaEntry;
        }

        HbckInfo(MetaEntry metaEntry) {
            this.metaEntry = metaEntry;
        }

        synchronized void addServer(HRegionInfo hri, HServerAddress server) {
            OnlineEntry rse = new OnlineEntry();
            rse.hri = hri;
            rse.hsa = server;
            this.deployedEntries.add(rse);
            this.deployedOn.add(server);
        }

        public synchronized String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ meta => ");
            sb.append(this.metaEntry != null ? this.metaEntry.getRegionNameAsString() : "null");
            sb.append(", hdfs => " + this.getHdfsRegionDir());
            sb.append(", deployed => " + Joiner.on((String)", ").join(this.deployedEntries));
            sb.append(" }");
            return sb.toString();
        }

        @Override
        public byte[] getStartKey() {
            if (this.metaEntry != null) {
                return this.metaEntry.getStartKey();
            }
            if (this.hdfsEntry != null) {
                return this.hdfsEntry.hri.getStartKey();
            }
            LOG.error((Object)("Entry " + this + " has no meta or hdfs region start key."));
            return null;
        }

        @Override
        public byte[] getEndKey() {
            if (this.metaEntry != null) {
                return this.metaEntry.getEndKey();
            }
            if (this.hdfsEntry != null) {
                return this.hdfsEntry.hri.getEndKey();
            }
            LOG.error((Object)("Entry " + this + " has no meta or hdfs region start key."));
            return null;
        }

        public byte[] getTableName() {
            if (this.metaEntry != null) {
                return this.metaEntry.getTableName();
            }
            if (this.hdfsEntry != null) {
                Path tableDir = this.hdfsEntry.hdfsRegionDir.getParent();
                return Bytes.toBytes(tableDir.getName());
            }
            return null;
        }

        public String getRegionNameAsString() {
            if (this.metaEntry != null) {
                return this.metaEntry.getRegionNameAsString();
            }
            if (this.hdfsEntry != null) {
                return this.hdfsEntry.hri.getRegionNameAsString();
            }
            return null;
        }

        public byte[] getRegionName() {
            if (this.metaEntry != null) {
                return this.metaEntry.getRegionName();
            }
            if (this.hdfsEntry != null) {
                return this.hdfsEntry.hri.getRegionName();
            }
            return null;
        }

        Path getHdfsRegionDir() {
            if (this.hdfsEntry == null) {
                return null;
            }
            return this.hdfsEntry.hdfsRegionDir;
        }

        boolean containsOnlyHdfsEdits() {
            if (this.hdfsEntry == null) {
                return false;
            }
            return this.hdfsEntry.hdfsOnlyEdits;
        }

        boolean isHdfsRegioninfoPresent() {
            if (this.hdfsEntry == null) {
                return false;
            }
            return this.hdfsEntry.hdfsRegioninfoFilePresent;
        }

        long getModTime() {
            if (this.hdfsEntry == null) {
                return 0L;
            }
            return this.hdfsEntry.hdfsRegionDirModTime;
        }

        HRegionInfo getHdfsHRI() {
            if (this.hdfsEntry == null) {
                return null;
            }
            return this.hdfsEntry.hri;
        }
    }

    static class OnlineEntry {
        HRegionInfo hri;
        HServerAddress hsa;

        OnlineEntry() {
        }

        public String toString() {
            return this.hsa.toString() + ";" + this.hri.getRegionNameAsString();
        }
    }

    static class HdfsEntry {
        HRegionInfo hri;
        Path hdfsRegionDir = null;
        long hdfsRegionDirModTime = 0L;
        boolean hdfsRegioninfoFilePresent = false;
        boolean hdfsOnlyEdits = false;

        public HdfsEntry() {
        }

        public HdfsEntry(HRegionInfo hri) {
            this.hri = hri;
        }
    }

    static class MetaEntry
    extends HRegionInfo {
        HServerAddress regionServer;
        long modTime;

        public MetaEntry(HRegionInfo rinfo, HServerAddress regionServer, byte[] startCode, long modTime) {
            super(rinfo);
            this.regionServer = regionServer;
            this.modTime = modTime;
        }

        @Override
        public boolean equals(Object o) {
            boolean superEq = super.equals(o);
            if (!superEq) {
                return superEq;
            }
            MetaEntry me = (MetaEntry)((Object)o);
            if (!this.regionServer.equals(me.regionServer)) {
                return false;
            }
            return this.modTime == me.modTime;
        }
    }

    public class TableInfo {
        String tableName;
        TreeSet<HServerAddress> deployedOn;
        HTableDescriptor htdFromAdmin;
        final List<HbckInfo> backwards = new ArrayList<HbckInfo>();
        final Map<Path, HbckInfo> sidelinedRegions = new HashMap<Path, HbckInfo>();
        final RegionSplitCalculator<HbckInfo> sc = new RegionSplitCalculator<HbckInfo>(cmp);
        final Set<HTableDescriptor> htds = new HashSet<HTableDescriptor>();
        final Multimap<byte[], HbckInfo> overlapGroups = TreeMultimap.create(RegionSplitCalculator.BYTES_COMPARATOR, cmp);

        TableInfo(String name) {
            this.tableName = name;
            this.deployedOn = new TreeSet();
        }

        private void trackHTD(HbckInfo hir) {
            if (hir.getHdfsHRI() == null) {
                if (Bytes.equals(HConstants.META_TABLE_NAME, hir.getTableName()) || Bytes.equals(HConstants.ROOT_TABLE_NAME, hir.getTableName())) {
                    return;
                }
                LOG.warn((Object)("No HDFS HRI for region " + hir + ".  Skipping... "));
                return;
            }
            HTableDescriptor htd = hir.getHdfsHRI().getTableDesc();
            boolean added = this.htds.add(htd);
            if (added) {
                if (this.htds.size() > 1) {
                    LOG.warn((Object)("Multiple table descriptors found for table '" + Bytes.toString(hir.getTableName()) + "' regions: " + this.htds));
                    HBaseFsck.this.setMultiTableDescFound(true);
                } else {
                    LOG.info((Object)("Added a table descriptor found in table '" + Bytes.toString(hir.getTableName()) + "' regions: " + htd));
                }
            }
        }

        private HTableDescriptor getHTD() throws IOException {
            if (this.htds.size() != 1) {
                if (this.htdFromAdmin == null) {
                    LOG.warn((Object)("None/Multiple table descriptors found for table '" + this.tableName + "' regions: " + this.htds));
                    this.htdFromAdmin = HBaseFsck.this.admin.getTableDescriptor(Bytes.toBytes(this.tableName));
                    LOG.warn((Object)("Use this one from meta instead" + this.htdFromAdmin));
                }
                return this.htdFromAdmin;
            }
            return (HTableDescriptor)this.htds.toArray()[0];
        }

        public void addRegionInfo(HbckInfo hir) {
            this.trackHTD(hir);
            if (Bytes.equals(hir.getEndKey(), HConstants.EMPTY_END_ROW)) {
                this.sc.add(hir);
                return;
            }
            if (Bytes.compareTo(hir.getStartKey(), hir.getEndKey()) > 0) {
                HBaseFsck.this.errors.reportError(ErrorReporter.ERROR_CODE.REGION_CYCLE, String.format("The endkey for this region comes before the startkey, startkey=%s, endkey=%s", Bytes.toStringBinary(hir.getStartKey()), Bytes.toStringBinary(hir.getEndKey())), this, hir);
                this.backwards.add(hir);
                return;
            }
            this.sc.add(hir);
        }

        public void addServer(HServerAddress server) {
            this.deployedOn.add(server);
        }

        public String getName() {
            return this.tableName;
        }

        public int getNumRegions() {
            return this.sc.getStarts().size() + this.backwards.size();
        }

        public boolean checkRegionChain(TableIntegrityErrorHandler handler) throws IOException {
            int originalErrorsCount = HBaseFsck.this.errors.getErrorList().size();
            Multimap<byte[], HbckInfo> regions = this.sc.calcCoverage();
            TreeSet<byte[]> splits = this.sc.getSplits();
            byte[] prevKey = null;
            byte[] problemKey = null;
            for (byte[] key : splits) {
                Collection ranges = regions.get((Object)key);
                if (prevKey == null && !Bytes.equals(key, HConstants.EMPTY_BYTE_ARRAY)) {
                    for (HbckInfo rng : ranges) {
                        handler.handleRegionStartKeyNotEmpty(rng);
                    }
                }
                for (HbckInfo rng : ranges) {
                    byte[] endKey = rng.getEndKey();
                    byte[] byArray = endKey = endKey.length == 0 ? null : endKey;
                    if (!Bytes.equals(rng.getStartKey(), endKey)) continue;
                    handler.handleDegenerateRegion(rng);
                }
                if (ranges.size() == 1) {
                    if (problemKey != null) {
                        LOG.warn((Object)("reached end of problem group: " + Bytes.toStringBinary(key)));
                    }
                    problemKey = null;
                } else if (ranges.size() > 1) {
                    if (problemKey == null) {
                        LOG.warn((Object)("Naming new problem group: " + Bytes.toStringBinary(key)));
                        problemKey = key;
                    }
                    this.overlapGroups.putAll(problemKey, (Iterable)ranges);
                    ArrayList subRange = new ArrayList(ranges);
                    for (HbckInfo r1 : ranges) {
                        subRange.remove(r1);
                        for (HbckInfo r2 : subRange) {
                            if (Bytes.compareTo(r1.getStartKey(), r2.getStartKey()) == 0) {
                                handler.handleDuplicateStartKeys(r1, r2);
                                continue;
                            }
                            handler.handleOverlapInRegionChain(r1, r2);
                        }
                    }
                } else if (ranges.size() == 0) {
                    if (problemKey != null) {
                        LOG.warn((Object)("reached end of problem group: " + Bytes.toStringBinary(key)));
                    }
                    problemKey = null;
                    byte[] holeStopKey = this.sc.getSplits().higher(key);
                    if (holeStopKey != null) {
                        handler.handleHoleInRegionChain(key, holeStopKey);
                    }
                }
                prevKey = key;
            }
            for (Collection overlap : this.overlapGroups.asMap().values()) {
                handler.handleOverlapGroup(overlap);
            }
            if (details) {
                System.out.println("---- Table '" + this.tableName + "': region split map");
                this.dump(splits, regions);
                System.out.println("---- Table '" + this.tableName + "': overlap groups");
                HBaseFsck.this.dumpOverlapProblems(this.overlapGroups);
                System.out.println("There are " + this.overlapGroups.keySet().size() + " overlap groups with " + this.overlapGroups.size() + " overlapping regions");
            }
            if (!this.sidelinedRegions.isEmpty()) {
                LOG.warn((Object)"Sidelined big overlapped regions, please bulk load them!");
                System.out.println("---- Table '" + this.tableName + "': sidelined big overlapped regions");
                HBaseFsck.this.dumpSidelinedRegions(this.sidelinedRegions);
            }
            return HBaseFsck.this.errors.getErrorList().size() == originalErrorsCount;
        }

        void dump(SortedSet<byte[]> splits, Multimap<byte[], HbckInfo> regions) {
            for (byte[] k : splits) {
                System.out.print(Bytes.toStringBinary(k) + ":\t");
                for (HbckInfo r : regions.get((Object)k)) {
                    System.out.print("[ " + r.toString() + ", " + Bytes.toStringBinary(r.getEndKey()) + "]\t");
                }
                System.out.println();
            }
        }

        private class HDFSIntegrityFixer
        extends IntegrityFixSuggester {
            Configuration conf;
            boolean fixOverlaps;

            HDFSIntegrityFixer(TableInfo ti, ErrorReporter errors, Configuration conf, boolean fixHoles, boolean fixOverlaps) {
                super(ti, errors);
                this.fixOverlaps = true;
                this.conf = conf;
                this.fixOverlaps = fixOverlaps;
            }

            @Override
            public void handleRegionStartKeyNotEmpty(HbckInfo next) throws IOException {
                this.errors.reportError(ErrorReporter.ERROR_CODE.FIRST_REGION_STARTKEY_NOT_EMPTY, "First region should start with an empty key.  Creating a new region and regioninfo in HDFS to plug the hole.", this.getTableInfo(), next);
                HTableDescriptor htd = this.getTableInfo().getHTD();
                HRegionInfo newRegion = new HRegionInfo(htd, HConstants.EMPTY_START_ROW, next.getStartKey());
                HRegion region = HBaseFsckRepair.createHDFSRegionDir(this.conf, newRegion);
                LOG.info((Object)("Table region start key was not empty.  Created new empty region: " + (Object)((Object)newRegion) + " " + region));
                ++HBaseFsck.this.fixes;
            }

            @Override
            public void handleHoleInRegionChain(byte[] holeStartKey, byte[] holeStopKey) throws IOException {
                this.errors.reportError(ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN, "There is a hole in the region chain between " + Bytes.toStringBinary(holeStartKey) + " and " + Bytes.toStringBinary(holeStopKey) + ".  Creating a new regioninfo and region " + "dir in hdfs to plug the hole.");
                HTableDescriptor htd = this.getTableInfo().getHTD();
                HRegionInfo newRegion = new HRegionInfo(htd, holeStartKey, holeStopKey);
                HRegion region = HBaseFsckRepair.createHDFSRegionDir(this.conf, newRegion);
                LOG.info((Object)("Plugged hold by creating new empty region: " + (Object)((Object)newRegion) + " " + region));
                ++HBaseFsck.this.fixes;
            }

            @Override
            public void handleOverlapGroup(Collection<HbckInfo> overlap) throws IOException {
                Preconditions.checkNotNull(overlap);
                Preconditions.checkArgument((overlap.size() > 0 ? 1 : 0) != 0);
                if (!this.fixOverlaps) {
                    LOG.warn((Object)"Not attempting to repair overlaps.");
                    return;
                }
                if (overlap.size() > HBaseFsck.this.maxMerge) {
                    LOG.warn((Object)("Overlap group has " + overlap.size() + " overlapping " + "regions which is greater than " + HBaseFsck.this.maxMerge + ", the max number of regions to merge"));
                    if (HBaseFsck.this.sidelineBigOverlaps) {
                        this.sidelineBigOverlaps(overlap);
                    }
                    return;
                }
                this.mergeOverlaps(overlap);
            }

            void mergeOverlaps(Collection<HbckInfo> overlap) throws IOException {
                LOG.info((Object)("== Merging regions into one region: " + Joiner.on((String)",").join(overlap)));
                Pair<byte[], byte[]> range = null;
                for (HbckInfo hi : overlap) {
                    if (range == null) {
                        range = new Pair<byte[], byte[]>(hi.getStartKey(), hi.getEndKey());
                    } else {
                        if (RegionSplitCalculator.BYTES_COMPARATOR.compare(hi.getStartKey(), (byte[])range.getFirst()) < 0) {
                            range.setFirst(hi.getStartKey());
                        }
                        if (RegionSplitCalculator.BYTES_COMPARATOR.compare(hi.getEndKey(), range.getSecond()) > 0) {
                            range.setSecond(hi.getEndKey());
                        }
                    }
                    LOG.debug((Object)("Closing region before moving data around: " + hi));
                    LOG.debug((Object)"Contained region dir before close");
                    HBaseFsck.this.debugLsr(hi.getHdfsRegionDir());
                    try {
                        HBaseFsck.this.closeRegion(hi);
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("Was unable to close region " + hi.getRegionNameAsString() + ".  Just continuing... "));
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)("Was unable to close region " + hi.getRegionNameAsString() + ".  Just continuing... "));
                    }
                    try {
                        LOG.info((Object)("Offlining region: " + hi));
                        HBaseFsck.this.offline(hi.getRegionName());
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("Unable to offline region from master: " + hi), (Throwable)ioe);
                    }
                }
                HTableDescriptor htd = this.getTableInfo().getHTD();
                HRegionInfo newRegion = new HRegionInfo(htd, (byte[])range.getFirst(), (byte[])range.getSecond());
                HRegion region = HBaseFsckRepair.createHDFSRegionDir(this.conf, newRegion);
                LOG.info((Object)("Created new empty container region: " + (Object)((Object)newRegion) + " to contain regions: " + Joiner.on((String)",").join(overlap)));
                HBaseFsck.this.debugLsr(region.getRegionDir());
                boolean didFix = false;
                Path target = region.getRegionDir();
                for (HbckInfo contained : overlap) {
                    LOG.info((Object)("Merging " + contained + " into " + target));
                    int merges = HBaseFsck.this.mergeRegionDirs(target, contained);
                    if (merges <= 0) continue;
                    didFix = true;
                }
                if (didFix) {
                    ++HBaseFsck.this.fixes;
                }
            }

            void sidelineBigOverlaps(Collection<HbckInfo> bigOverlap) throws IOException {
                int overlapsToSideline = bigOverlap.size() - HBaseFsck.this.maxMerge;
                if (overlapsToSideline > HBaseFsck.this.maxOverlapsToSideline) {
                    overlapsToSideline = HBaseFsck.this.maxOverlapsToSideline;
                }
                List<HbckInfo> regionsToSideline = RegionSplitCalculator.findBigRanges(bigOverlap, overlapsToSideline);
                FileSystem fs = FileSystem.get((Configuration)this.conf);
                for (HbckInfo regionToSideline : regionsToSideline) {
                    try {
                        LOG.info((Object)("Closing region: " + regionToSideline));
                        HBaseFsck.this.closeRegion(regionToSideline);
                    }
                    catch (InterruptedException ie) {
                        LOG.warn((Object)("Was unable to close region " + regionToSideline.getRegionNameAsString() + ".  Interrupted."));
                        throw new IOException(ie);
                    }
                    LOG.info((Object)("Offlining region: " + regionToSideline));
                    HBaseFsck.this.offline(regionToSideline.getRegionName());
                    LOG.info((Object)("Before sideline big overlapped region: " + regionToSideline.toString()));
                    Path sidelineRegionDir = HBaseFsck.this.sidelineRegionDir(fs, regionToSideline);
                    if (sidelineRegionDir == null) continue;
                    TableInfo.this.sidelinedRegions.put(sidelineRegionDir, regionToSideline);
                    LOG.info((Object)("After sidelined big overlapped region: " + regionToSideline.getRegionNameAsString() + " to " + sidelineRegionDir.toString()));
                    ++HBaseFsck.this.fixes;
                }
            }
        }

        private class IntegrityFixSuggester
        extends TableIntegrityErrorHandlerImpl {
            ErrorReporter errors;

            IntegrityFixSuggester(TableInfo ti, ErrorReporter errors) {
                this.errors = errors;
                this.setTableInfo(ti);
            }

            @Override
            public void handleRegionStartKeyNotEmpty(HbckInfo hi) throws IOException {
                this.errors.reportError(ErrorReporter.ERROR_CODE.FIRST_REGION_STARTKEY_NOT_EMPTY, "First region should start with an empty key.  You need to  create a new region and regioninfo in HDFS to plug the hole.", this.getTableInfo(), hi);
            }

            @Override
            public void handleDegenerateRegion(HbckInfo hi) throws IOException {
                this.errors.reportError(ErrorReporter.ERROR_CODE.DEGENERATE_REGION, "Region has the same start and end key.", this.getTableInfo(), hi);
            }

            @Override
            public void handleDuplicateStartKeys(HbckInfo r1, HbckInfo r2) throws IOException {
                byte[] key = r1.getStartKey();
                this.errors.reportError(ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, "Multiple regions have the same startkey: " + Bytes.toStringBinary(key), this.getTableInfo(), r1);
                this.errors.reportError(ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, "Multiple regions have the same startkey: " + Bytes.toStringBinary(key), this.getTableInfo(), r2);
            }

            @Override
            public void handleOverlapInRegionChain(HbckInfo hi1, HbckInfo hi2) throws IOException {
                this.errors.reportError(ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN, "There is an overlap in the region chain.", this.getTableInfo(), hi1, hi2);
            }

            @Override
            public void handleHoleInRegionChain(byte[] holeStart, byte[] holeStop) throws IOException {
                this.errors.reportError(ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN, "There is a hole in the region chain between " + Bytes.toStringBinary(holeStart) + " and " + Bytes.toStringBinary(holeStop) + ".  You need to create a new .regioninfo and region " + "dir in hdfs to plug the hole.");
            }
        }
    }

    public static class HbckException
    extends IOException {
        private static final long serialVersionUID = 1L;
        final IOException ioe;

        public HbckException(String s, IOException ioe) {
            super(s);
            this.ioe = ioe;
        }
    }
}

