/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.ReflectionUtils;

public class Threads {
    protected static final Log LOG = LogFactory.getLog(Threads.class);

    public static Thread setDaemonThreadRunning(Thread t) {
        return Threads.setDaemonThreadRunning(t, t.getName());
    }

    public static Thread setDaemonThreadRunning(Thread t, String name) {
        return Threads.setDaemonThreadRunning(t, name, null);
    }

    public static Thread setDaemonThreadRunning(Thread t, String name, Thread.UncaughtExceptionHandler handler) {
        t.setName(name);
        if (handler != null) {
            t.setUncaughtExceptionHandler(handler);
        }
        t.setDaemon(true);
        t.start();
        return t;
    }

    public static void shutdown(Thread t) {
        Threads.shutdown(t, 0L);
    }

    public static void shutdown(Thread t, long joinwait) {
        if (t == null) {
            return;
        }
        while (t.isAlive()) {
            try {
                t.join(joinwait);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)(t.getName() + "; joinwait=" + joinwait), (Throwable)e);
            }
        }
    }

    public static void threadDumpingIsAlive(Thread t) throws InterruptedException {
        if (t == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        while (t.isAlive()) {
            Thread.sleep(1000L);
            if (System.currentTimeMillis() - startTime <= 60000L) continue;
            startTime = System.currentTimeMillis();
            ReflectionUtils.printThreadInfo((PrintWriter)new PrintWriter(System.out), (String)("Automatic Stack Trace every 60 seconds waiting on " + t.getName()));
        }
    }

    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

