/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;

public class Writables {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(Writable w) throws IOException {
        if (w == null) {
            throw new IllegalArgumentException("Writable cannot be null");
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            w.write((DataOutput)out);
            out.close();
            out = null;
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static Writable getWritable(byte[] bytes, Writable w) throws IOException {
        return Writables.getWritable(bytes, 0, bytes.length, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Writable getWritable(byte[] bytes, int offset, int length, Writable w) throws IOException {
        if (bytes == null || length <= 0) {
            throw new IllegalArgumentException("Can't build a writable with empty bytes array");
        }
        if (w == null) {
            throw new IllegalArgumentException("Writable cannot be null");
        }
        DataInputBuffer in = new DataInputBuffer();
        try {
            in.reset(bytes, offset, length);
            w.readFields((DataInput)in);
            Writable writable = w;
            return writable;
        }
        finally {
            in.close();
        }
    }

    public static HRegionInfo getHRegionInfo(byte[] bytes) throws IOException {
        return (HRegionInfo)Writables.getWritable(bytes, (Writable)new HRegionInfo());
    }

    public static HRegionInfo getHRegionInfoOrNull(byte[] bytes) throws IOException {
        return bytes == null || bytes.length <= 0 ? null : Writables.getHRegionInfo(bytes);
    }

    public static Writable copyWritable(Writable src, Writable tgt) throws IOException {
        return Writables.copyWritable(Writables.getBytes(src), tgt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Writable copyWritable(byte[] bytes, Writable tgt) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            tgt.readFields((DataInput)dis);
        }
        finally {
            dis.close();
        }
        return tgt;
    }
}

