/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;

public class ZooKeeperMainServerArg {
    public String parse(Configuration c) {
        Properties zkProps = ZKConfig.makeZKProps(c);
        String host = null;
        String clientPort = null;
        for (Map.Entry<Object, Object> entry : zkProps.entrySet()) {
            String key = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            if (key.startsWith("server.") && host == null) {
                String[] parts = value.split(":");
                host = parts[0];
            } else if (key.endsWith("clientPort")) {
                clientPort = value;
            }
            if (host == null || clientPort == null) continue;
            break;
        }
        return host != null && clientPort != null ? host + ":" + clientPort : null;
    }

    public static void main(String[] args) {
        Configuration conf = HBaseConfiguration.create();
        String hostport = new ZooKeeperMainServerArg().parse(conf);
        System.out.println(hostport == null || hostport.length() == 0 ? "" : "-server " + hostport);
    }
}

