/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.io;

import com.cloudera.sqoop.io.UnsupportedCodecException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.util.ReflectionUtils;

public final class CodecMap {
    public static final String NONE = "none";
    public static final String DEFLATE = "deflate";
    public static final String LZO = "lzo";
    public static final String LZOP = "lzop";
    private static Map<String, String> codecNames = new TreeMap<String, String>();

    private CodecMap() {
    }

    public static String getCodecClassName(String codecName) throws UnsupportedCodecException {
        if (!codecNames.containsKey(codecName)) {
            throw new UnsupportedCodecException(codecName);
        }
        return codecNames.get(codecName);
    }

    public static CompressionCodec getCodec(String codecName, Configuration conf) throws UnsupportedCodecException {
        CompressionCodec codec = CodecMap.getCodecByName(codecName, conf);
        if (codec != null) {
            return codec;
        }
        String codecClassName = null;
        try {
            codecClassName = CodecMap.getCodecClassName(codecName);
            if (null == codecClassName) {
                return null;
            }
            Class codecClass = conf.getClassByName(codecClassName);
            return (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new UnsupportedCodecException("Cannot find codec class " + codecClassName + " for codec " + codecName);
        }
    }

    private static CompressionCodec getCodecByName(String codecName, Configuration conf) {
        List codecs = CompressionCodecFactory.getCodecClasses((Configuration)conf);
        for (Class cls : codecs) {
            if (!CodecMap.codecMatches(cls, codecName)) continue;
            return (CompressionCodec)ReflectionUtils.newInstance((Class)cls, (Configuration)conf);
        }
        return null;
    }

    public static String getCodecShortNameByName(String codecName, Configuration conf) throws UnsupportedCodecException {
        if (codecNames.containsKey(codecName)) {
            return codecName;
        }
        CompressionCodec codec = CodecMap.getCodecByName(codecName, conf);
        Class<?> codecClass = null;
        if (codec != null) {
            codecClass = codec.getClass();
        }
        if (codecClass != null) {
            String simpleName = codecClass.getSimpleName();
            if (simpleName.endsWith("Codec")) {
                simpleName = simpleName.substring(0, simpleName.length() - "Codec".length());
            }
            return simpleName.toLowerCase();
        }
        throw new UnsupportedCodecException("Cannot find codec class " + codecName + " for codec " + codecName);
    }

    private static boolean codecMatches(Class<? extends CompressionCodec> cls, String codecName) {
        String prefix;
        String simpleName = cls.getSimpleName();
        if (cls.getName().equals(codecName) || simpleName.equalsIgnoreCase(codecName)) {
            return true;
        }
        return simpleName.endsWith("Codec") && (prefix = simpleName.substring(0, simpleName.length() - "Codec".length())).equalsIgnoreCase(codecName);
    }

    public static Set<String> getCodecNames() {
        return codecNames.keySet();
    }

    static {
        codecNames.put(NONE, null);
        codecNames.put(DEFLATE, "org.apache.hadoop.io.compress.DefaultCodec");
        codecNames.put(LZO, "com.hadoop.compression.lzo.LzoCodec");
        codecNames.put(LZOP, "com.hadoop.compression.lzo.LzopCodec");
        for (Class cls : CompressionCodecFactory.getCodecClasses((Configuration)new Configuration())) {
            String simpleName;
            String codecName = simpleName = cls.getSimpleName();
            if (simpleName.endsWith("Codec")) {
                codecName = simpleName.substring(0, simpleName.length() - "Codec".length());
            }
            codecNames.put(codecName.toLowerCase(), cls.getCanonicalName());
        }
    }
}

