/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.io.input.ProxyInputStream;

public class FixedLengthInputStream
extends ProxyInputStream {
    private CountingInputStream countingIn;
    private long maxBytes;

    public FixedLengthInputStream(InputStream stream, long maxLen) {
        super((InputStream)new CountingInputStream((InputStream)new CloseShieldInputStream(stream)));
        this.countingIn = (CountingInputStream)this.in;
        this.maxBytes = maxLen;
    }

    private long consumed() {
        return this.countingIn.getByteCount();
    }

    private long toLimit() {
        return this.maxBytes - this.consumed();
    }

    public int available() throws IOException {
        return (int)Math.min(this.toLimit(), (long)this.countingIn.available());
    }

    public int read() throws IOException {
        if (this.toLimit() > 0L) {
            return super.read();
        }
        return -1;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int start, int count) throws IOException {
        long limit = this.toLimit();
        if (limit == 0L) {
            return -1;
        }
        return super.read(buf, start, (int)Math.min((long)count, limit));
    }
}

