/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.io;

import com.cloudera.sqoop.io.SplittingOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SplittableBufferedWriter
extends BufferedWriter {
    public static final Log LOG = LogFactory.getLog((String)SplittableBufferedWriter.class.getName());
    private SplittingOutputStream splitOutputStream;
    private boolean alwaysFlush;

    public SplittableBufferedWriter(SplittingOutputStream splitOutputStream) {
        super(new OutputStreamWriter(splitOutputStream));
        this.splitOutputStream = splitOutputStream;
        this.alwaysFlush = false;
    }

    SplittableBufferedWriter(SplittingOutputStream splitOutputStream, boolean alwaysFlush) {
        super(new OutputStreamWriter(splitOutputStream));
        this.splitOutputStream = splitOutputStream;
        this.alwaysFlush = alwaysFlush;
    }

    @Override
    public void newLine() throws IOException {
        super.newLine();
        this.allowSplit();
    }

    public void allowSplit() throws IOException {
        if (this.alwaysFlush) {
            this.flush();
        }
        if (this.splitOutputStream.wouldSplit()) {
            LOG.debug((Object)"Starting new split");
            this.flush();
            this.splitOutputStream.allowSplit();
        }
    }
}

