/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Formatter;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;

public class SplittingOutputStream
extends OutputStream {
    public static final Log LOG = LogFactory.getLog((String)SplittingOutputStream.class.getName());
    private OutputStream writeStream;
    private CountingOutputStream countingFilterStream;
    private Configuration conf;
    private Path destDir;
    private String filePrefix;
    private long cutoffBytes;
    private CompressionCodec codec;
    private int fileNum;

    public SplittingOutputStream(Configuration conf, Path destDir, String filePrefix, long cutoff, CompressionCodec codec) throws IOException {
        this.conf = conf;
        this.destDir = destDir;
        this.filePrefix = filePrefix;
        this.cutoffBytes = cutoff;
        if (this.cutoffBytes < 0L) {
            this.cutoffBytes = 0L;
        }
        this.codec = codec;
        this.fileNum = 0;
        this.openNextFile();
    }

    private void openNextFile() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        StringBuffer sb = new StringBuffer();
        Formatter fmt = new Formatter(sb);
        fmt.format("%05d", this.fileNum++);
        String filename = this.filePrefix + fmt.toString();
        if (this.codec != null) {
            filename = filename + this.codec.getDefaultExtension();
        }
        Path destFile = new Path(this.destDir, filename);
        LOG.debug((Object)("Opening next output file: " + destFile));
        if (fs.exists(destFile)) {
            Path canonicalDest = destFile.makeQualified(fs);
            throw new IOException("Destination file " + canonicalDest + " already exists");
        }
        FSDataOutputStream fsOut = fs.create(destFile);
        this.countingFilterStream = new CountingOutputStream((OutputStream)fsOut);
        this.writeStream = this.codec != null ? this.codec.createOutputStream((OutputStream)this.countingFilterStream) : this.countingFilterStream;
    }

    public boolean wouldSplit() {
        return this.cutoffBytes > 0L && this.countingFilterStream.getByteCount() >= this.cutoffBytes;
    }

    private void checkForNextFile() throws IOException {
        if (this.wouldSplit()) {
            LOG.debug((Object)"Starting new split");
            this.writeStream.flush();
            this.writeStream.close();
            this.openNextFile();
        }
    }

    public void allowSplit() throws IOException {
        this.checkForNextFile();
    }

    @Override
    public void close() throws IOException {
        this.writeStream.close();
    }

    @Override
    public void flush() throws IOException {
        this.writeStream.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeStream.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.writeStream.write(b);
    }
}

