/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.lib;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.hadoop.io.Text;

public final class BigDecimalSerializer {
    static final BigInteger LONG_MAX_AS_BIGINT = BigInteger.valueOf(Long.MAX_VALUE);
    static final BigInteger LONG_MIN_AS_BIGINT = BigInteger.valueOf(Long.MIN_VALUE);

    private BigDecimalSerializer() {
    }

    public static void write(BigDecimal d, DataOutput out) throws IOException {
        int scale = d.scale();
        BigInteger bigIntPart = d.unscaledValue();
        boolean fastpath = bigIntPart.compareTo(LONG_MAX_AS_BIGINT) < 0 && bigIntPart.compareTo(LONG_MIN_AS_BIGINT) > 0;
        out.writeInt(scale);
        out.writeBoolean(fastpath);
        if (fastpath) {
            out.writeLong(bigIntPart.longValue());
        } else {
            Text.writeString((DataOutput)out, (String)bigIntPart.toString());
        }
    }

    public static BigDecimal readFields(DataInput in) throws IOException {
        BigInteger unscaledIntPart;
        int scale = in.readInt();
        boolean fastpath = in.readBoolean();
        if (fastpath) {
            long unscaledValue = in.readLong();
            unscaledIntPart = BigInteger.valueOf(unscaledValue);
        } else {
            String unscaledValueStr = Text.readString((DataInput)in);
            unscaledIntPart = new BigInteger(unscaledValueStr);
        }
        return new BigDecimal(unscaledIntPart, scale);
    }
}

